/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.pddxml.relaxer;

import de.dfki.pddxml.relaxer.IRNode;
import de.dfki.pddxml.relaxer.IRVisitable;
import de.dfki.pddxml.relaxer.IRVisitor;
import de.dfki.pddxml.relaxer.Predicate;
import de.dfki.pddxml.relaxer.RStack;
import de.dfki.pddxml.relaxer.UJAXP;
import de.dfki.pddxml.relaxer.URelaxer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Predicates
implements Serializable,
Cloneable,
IRVisitable,
IRNode {
    private List predicate_ = new ArrayList();
    private IRNode parentRNode_;

    public Predicates() {
    }

    public Predicates(Predicates source) {
        this.setup(source);
    }

    public Predicates(RStack stack) {
        this.setup(stack);
    }

    public Predicates(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Predicates(Element element) {
        this.setup(element);
    }

    public Predicates(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Predicates(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Predicates(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Predicates(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Predicates(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Predicates(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Predicates source) {
        this.predicate_.clear();
        int size = source.predicate_.size();
        int i = 0;
        while (i < size) {
            this.addPredicate((Predicate)source.getPredicate(i).clone());
            ++i;
        }
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.predicate_.clear();
        while (Predicate.isMatch(stack)) {
            this.addPredicate(new Predicate(stack));
        }
    }

    public Object clone() {
        return new Predicates(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("predicates");
        int size = this.predicate_.size();
        int i = 0;
        while (i < size) {
            Predicate value = (Predicate)this.predicate_.get(i);
            value.makeElement(element);
            ++i;
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final Predicate[] getPredicate() {
        Predicate[] array = new Predicate[this.predicate_.size()];
        return this.predicate_.toArray(array);
    }

    public final void setPredicate(Predicate[] predicate) {
        this.predicate_.clear();
        int i = 0;
        while (i < predicate.length) {
            this.addPredicate(predicate[i]);
            ++i;
        }
        i = 0;
        while (i < predicate.length) {
            predicate[i].rSetParentRNode(this);
            ++i;
        }
    }

    public final void setPredicate(Predicate predicate) {
        this.predicate_.clear();
        this.addPredicate(predicate);
        if (predicate != null) {
            predicate.rSetParentRNode(this);
        }
    }

    public final void addPredicate(Predicate predicate) {
        this.predicate_.add(predicate);
        if (predicate != null) {
            predicate.rSetParentRNode(this);
        }
    }

    public final void addPredicate(Predicate[] predicate) {
        int i = 0;
        while (i < predicate.length) {
            this.addPredicate(predicate[i]);
            ++i;
        }
        i = 0;
        while (i < predicate.length) {
            predicate[i].rSetParentRNode(this);
            ++i;
        }
    }

    public final int sizePredicate() {
        return this.predicate_.size();
    }

    public final Predicate getPredicate(int index) {
        return (Predicate)this.predicate_.get(index);
    }

    public final void setPredicate(int index, Predicate predicate) {
        this.predicate_.set(index, predicate);
        if (predicate != null) {
            predicate.rSetParentRNode(this);
        }
    }

    public final void addPredicate(int index, Predicate predicate) {
        this.predicate_.add(index, predicate);
        if (predicate != null) {
            predicate.rSetParentRNode(this);
        }
    }

    public final void removePredicate(int index) {
        this.predicate_.remove(index);
    }

    public final void removePredicate(Predicate predicate) {
        this.predicate_.remove(predicate);
    }

    public final void clearPredicate() {
        this.predicate_.clear();
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<predicates");
        buffer.append(">");
        int size = this.predicate_.size();
        int i = 0;
        while (i < size) {
            Predicate value = (Predicate)this.predicate_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.append("</predicates>");
    }

    public void makePddlElement(StringBuffer buffer) {
        buffer.append("(:predicates");
        int size = this.predicate_.size();
        int i = 0;
        while (i < size) {
            Predicate value = (Predicate)this.predicate_.get(i);
            value.makePddlElement(buffer);
            ++i;
        }
        buffer.append(")");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<predicates");
        buffer.write(">");
        int size = this.predicate_.size();
        int i = 0;
        while (i < size) {
            Predicate value = (Predicate)this.predicate_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.write("</predicates>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<predicates");
        buffer.print(">");
        int size = this.predicate_.size();
        int i = 0;
        while (i < size) {
            Predicate value = (Predicate)this.predicate_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.print("</predicates>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public boolean enter(IRVisitor visitor) {
        return visitor.enter(this);
    }

    @Override
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        classNodes.addAll(this.predicate_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "predicates")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        while (Predicate.isMatchHungry(target)) {
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Predicates.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Predicates.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

