/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.pddxml.relaxer;

import de.dfki.pddxml.relaxer.GoalState;
import de.dfki.pddxml.relaxer.InitState;
import de.dfki.pddxml.relaxer.PDDXMLObjects;
import de.dfki.pddxml.relaxer.RStack;
import de.dfki.pddxml.relaxer.UJAXP;
import de.dfki.pddxml.relaxer.URelaxer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Problem
implements Serializable,
Cloneable {
    private String domain_;
    private PDDXMLObjects pDDXMLObjects_;
    private InitState initState_;
    private GoalState goalState_;

    public Problem() {
        this.domain_ = "";
    }

    public Problem(Problem source) {
        this.setup(source);
    }

    public Problem(RStack stack) {
        this.setup(stack);
    }

    public Problem(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Problem(Element element) {
        this.setup(element);
    }

    public Problem(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Problem(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Problem(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Problem(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Problem(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Problem(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Problem source) {
        this.setDomain(source.getDomain());
        if (source.pDDXMLObjects_ != null) {
            this.setPDDXMLObjects((PDDXMLObjects)source.getPDDXMLObjects().clone());
        }
        if (source.initState_ != null) {
            this.setInitState((InitState)source.getInitState().clone());
        }
        if (source.goalState_ != null) {
            this.setGoalState((GoalState)source.getGoalState().clone());
        }
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.domain_ = URelaxer.getElementPropertyAsString(stack.popElement());
        this.setPDDXMLObjects(new PDDXMLObjects(stack));
        this.setInitState(new InitState(stack));
        this.setGoalState(new GoalState(stack));
    }

    public Object clone() {
        return new Problem(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("define_problem");
        URelaxer.setElementPropertyByString(element, "domain", this.domain_);
        this.pDDXMLObjects_.makeElement(element);
        this.initState_.makeElement(element);
        this.goalState_.makeElement(element);
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getDomain() {
        return this.domain_;
    }

    public final void setDomain(String domain) {
        this.domain_ = domain;
    }

    public final PDDXMLObjects getPDDXMLObjects() {
        return this.pDDXMLObjects_;
    }

    public final void setPDDXMLObjects(PDDXMLObjects pDDXMLObjects) {
        this.pDDXMLObjects_ = pDDXMLObjects;
    }

    public final InitState getInitState() {
        return this.initState_;
    }

    public final void setInitState(InitState initState) {
        this.initState_ = initState;
    }

    public final GoalState getGoalState() {
        return this.goalState_;
    }

    public final void setGoalState(GoalState goalState) {
        this.goalState_ = goalState;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public String makePddlDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makePddlElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<define_problem");
        buffer.append(">");
        buffer.append("<domain>");
        buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getDomain())));
        buffer.append("</domain>");
        this.pDDXMLObjects_.makeTextElement(buffer);
        this.initState_.makeTextElement(buffer);
        this.goalState_.makeTextElement(buffer);
        buffer.append("</define_problem>");
    }

    public void makePddlElement(StringBuffer buffer) {
        String domainName = URelaxer.escapeCharData(URelaxer.getString(this.getDomain()));
        buffer.append("(define (problem " + domainName + "_PB)");
        buffer.append("(:domain ");
        buffer.append(domainName);
        buffer.append(")");
        this.pDDXMLObjects_.makePddlElement(buffer);
        this.initState_.makePddlElement(buffer);
        this.goalState_.makePddlElement(buffer);
        buffer.append(")");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<define_problem");
        buffer.write(">");
        buffer.write("<domain>");
        buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getDomain())));
        buffer.write("</domain>");
        this.pDDXMLObjects_.makeTextElement(buffer);
        this.initState_.makeTextElement(buffer);
        this.goalState_.makeTextElement(buffer);
        buffer.write("</define_problem>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<define_problem");
        buffer.print(">");
        buffer.print("<domain>");
        buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getDomain())));
        buffer.print("</domain>");
        this.pDDXMLObjects_.makeTextElement(buffer);
        this.initState_.makeTextElement(buffer);
        this.goalState_.makeTextElement(buffer);
        buffer.print("</define_problem>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getDomainAsString() {
        return URelaxer.getString(this.getDomain());
    }

    public void setDomainByString(String string) {
        this.setDomain(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "define_problem")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child = target.popElement();
        if (child == null) {
            return false;
        }
        if (!URelaxer.isTargetElement(child, "domain")) {
            return false;
        }
        $match$ = true;
        if (!PDDXMLObjects.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        if (!InitState.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        if (!GoalState.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Problem.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Problem.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

