/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.pddxml.relaxer;

import de.dfki.pddxml.relaxer.IRNode;
import de.dfki.pddxml.relaxer.IRVisitable;
import de.dfki.pddxml.relaxer.IRVisitor;
import de.dfki.pddxml.relaxer.RStack;
import de.dfki.pddxml.relaxer.UJAXP;
import de.dfki.pddxml.relaxer.URelaxer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Requirements
implements Serializable,
Cloneable,
IRVisitable,
IRNode {
    private List req_ = new ArrayList();
    private IRNode parentRNode_;

    public Requirements() {
    }

    public Requirements(Requirements source) {
        this.setup(source);
    }

    public Requirements(RStack stack) {
        this.setup(stack);
    }

    public Requirements(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Requirements(Element element) {
        this.setup(element);
    }

    public Requirements(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Requirements(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Requirements(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Requirements(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Requirements(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Requirements(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Requirements source) {
        this.setReq(source.getReq());
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.req_ = URelaxer.getElementPropertyAsStringListByStack(stack, "req");
    }

    public Object clone() {
        return new Requirements(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("requirements");
        URelaxer.setElementPropertyByStringList(element, "req", this.req_);
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String[] getReq() {
        String[] array = new String[this.req_.size()];
        return this.req_.toArray(array);
    }

    public final void setReq(String[] req) {
        this.req_.clear();
        int i = 0;
        while (i < req.length) {
            this.addReq(req[i]);
            ++i;
        }
    }

    public final void setReq(String req) {
        this.req_.clear();
        this.addReq(req);
    }

    public final void addReq(String req) {
        this.req_.add(req);
    }

    public final void addReq(String[] req) {
        int i = 0;
        while (i < req.length) {
            this.addReq(req[i]);
            ++i;
        }
    }

    public final int sizeReq() {
        return this.req_.size();
    }

    public final String getReq(int index) {
        return (String)this.req_.get(index);
    }

    public final void setReq(int index, String req) {
        this.req_.set(index, req);
    }

    public final void addReq(int index, String req) {
        this.req_.add(index, req);
    }

    public final void removeReq(int index) {
        this.req_.remove(index);
    }

    public final void removeReq(String req) {
        this.req_.remove(req);
    }

    public final void clearReq() {
        this.req_.clear();
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<requirements");
        buffer.append(">");
        int size = this.sizeReq();
        int i = 0;
        while (i < size) {
            buffer.append("<req>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getReq(i))));
            buffer.append("</req>");
            ++i;
        }
        buffer.append("</requirements>");
    }

    public void makePddlElement(StringBuffer buffer) {
        int size = this.sizeReq();
        if (size != 0) {
            buffer.append("(:requirements :strips :conditional-effects :universal-preconditions");
            size = this.sizeReq();
            int i = 0;
            while (i < size) {
                buffer.append(" :");
                buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getReq(i))));
                ++i;
            }
            buffer.append(")");
        }
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<requirements");
        buffer.write(">");
        int size = this.sizeReq();
        int i = 0;
        while (i < size) {
            buffer.write("<req>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getReq(i))));
            buffer.write("</req>");
            ++i;
        }
        buffer.write("</requirements>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<requirements");
        buffer.print(">");
        int size = this.sizeReq();
        int i = 0;
        while (i < size) {
            buffer.print("<req>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getReq(i))));
            buffer.print("</req>");
            ++i;
        }
        buffer.print("</requirements>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String[] getReqAsString() {
        int size = this.sizeReq();
        String[] array = new String[size];
        int i = 0;
        while (i < size) {
            array[i] = URelaxer.getString(this.getReq(i));
            ++i;
        }
        return array;
    }

    public String getReqAsString(int index) {
        return URelaxer.getString(this.getReq(index));
    }

    public void setReqByString(String[] strings) {
        if (strings.length > 0) {
            String string = strings[0];
            this.setReq(string);
            int i = 1;
            while (i < strings.length) {
                string = strings[i];
                this.addReq(string);
                ++i;
            }
        }
    }

    public void setReqByString(int index, String value) {
        this.setReq(index, value);
    }

    public void addReqByString(String string) {
        this.addReq(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public boolean enter(IRVisitor visitor) {
        return visitor.enter(this);
    }

    @Override
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        Element child;
        if (!URelaxer.isTargetElement(element, "requirements")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        while ((child = target.peekElement()) != null) {
            if (!URelaxer.isTargetElement(child, "req")) break;
            target.popElement();
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Requirements.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Requirements.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

