/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.util.Locale;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.context.support.StaticMessageSource;

public class StaticApplicationContext
extends GenericApplicationContext {
    private final StaticMessageSource staticMessageSource = new StaticMessageSource();

    public StaticApplicationContext() throws BeansException {
        this((ApplicationContext)null);
    }

    public StaticApplicationContext(ApplicationContext parent) throws BeansException {
        super(parent);
        this.getBeanFactory().registerSingleton("messageSource", (Object)this.staticMessageSource);
    }

    public StaticMessageSource getStaticMessageSource() {
        return this.staticMessageSource;
    }

    public void registerSingleton(String name, Class clazz) throws BeansException {
        this.getDefaultListableBeanFactory().registerBeanDefinition(name, (BeanDefinition)new RootBeanDefinition(clazz));
    }

    public void registerSingleton(String name, Class clazz, MutablePropertyValues pvs) throws BeansException {
        this.getDefaultListableBeanFactory().registerBeanDefinition(name, (BeanDefinition)new RootBeanDefinition(clazz, pvs));
    }

    public void registerPrototype(String name, Class clazz) throws BeansException {
        this.getDefaultListableBeanFactory().registerBeanDefinition(name, (BeanDefinition)new RootBeanDefinition(clazz, false));
    }

    public void registerPrototype(String name, Class clazz, MutablePropertyValues pvs) throws BeansException {
        this.getDefaultListableBeanFactory().registerBeanDefinition(name, (BeanDefinition)new RootBeanDefinition(clazz, pvs, false));
    }

    public void addMessage(String code, Locale locale, String defaultMessage) {
        this.getStaticMessageSource().addMessage(code, locale, defaultMessage);
    }
}

