/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owls.service.Service;
import org.mindswap.utils.OutputFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLSValidator {
    boolean parseRDFFinished = false;
    List<String> serviceURIs = new ArrayList<String>();
    List<String> errors = new ArrayList<String>();
    List<String> warnings = new ArrayList<String>();
    List<String> rdfProblems = new ArrayList<String>();

    public boolean validate(String fileURI) throws Exception {
        return this.validate(fileURI, new PrintWriter(System.out));
    }

    public boolean validate(String fileURI, PrintWriter output) throws Exception {
        return this.validate(fileURI, output, false);
    }

    public boolean validate(String fileURI, PrintWriter output, boolean isHTML) throws Exception {
        return this.validate(fileURI, new OutputFormatter(output, isHTML));
    }

    public boolean validate(String fileURI, OutputFormatter out) throws Exception {
        URI uri = new URI(fileURI);
        OWLKnowledgeBase kb = OWLFactory.createKB();
        OWLOntology ont = kb.read(uri);
        ArrayList services = new ArrayList();
        out.printBold("Number of services found: ").println(String.valueOf(ont.getServices().size()));
        out.printBold("Number of valid services: ").println(String.valueOf(services.size()));
        out.println();
        this.printMesssages(out, "RDF Problems: ", this.rdfProblems.iterator());
        this.printMesssages(out, "Errors: ", this.errors.iterator());
        this.printMesssages(out, "Warnings: ", this.warnings.iterator());
        int i = 0;
        while (i < services.size()) {
            Service service = (Service)services.get(i);
            out.printBold("Service: ").printLink(service.getURI().toString());
            out.printBold("Name: ").println(service.getLabel());
            out.printBold("Description: ").println(service.getProfile().getTextDescription());
            ++i;
        }
        out.flush();
        return true;
    }

    public void printMesssages(OutputFormatter out, String header, Iterator<String> i) {
        if (i.hasNext()) {
            out.printBold(header).println();
            while (i.hasNext()) {
                String error = i.next();
                if (out.isFormatHTML()) {
                    out.print("<ul>");
                }
                if (out.isFormatHTML()) {
                    out.print("<li>");
                    out.print(this.format(error));
                    out.print("</li>");
                } else {
                    out.println(error);
                }
                if (!out.isFormatHTML()) continue;
                out.print("</ul>");
            }
            out.println();
        }
    }

    public String format(String str) {
        return str;
    }

    public String getServiceURI() {
        return this.serviceURIs.get(this.serviceURIs.size() - 1);
    }

    public void put(Map<String, List<String>> table, String key, String value) {
        List<String> list = table.get(key);
        if (list == null) {
            list = new ArrayList<String>();
            table.put(key, list);
        }
        list.add(value);
    }

    public void startService(String serviceURI) {
        this.serviceURIs.add(serviceURI);
    }

    public void finishService(String serviceURI) {
    }

    public void warning(String msg) {
        if (this.parseRDFFinished) {
            this.warnings.add(msg);
        } else {
            this.rdfProblems.add(msg);
        }
    }

    public void error(String msg) {
        if (this.parseRDFFinished) {
            this.errors.add(msg);
        } else {
            this.rdfProblems.add(msg);
        }
    }

    public void startParseRDF() {
        this.parseRDFFinished = false;
    }

    public void finishParseRDF() {
        this.parseRDFFinished = true;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            if (args.length < 1) {
                System.err.println("Not enough parameters");
            }
            if (args.length > 1) {
                System.err.println("Too many parameters");
            }
            System.err.println("usage: java OWLSValidator <serviceURI>");
            System.exit(0);
        }
        OWLSValidator validator = new OWLSValidator();
        System.out.println("Valid: " + validator.validate(args[0]));
    }
}

