/*
 * Decompiled with CFR 0.152.
 */
package examples;

import impl.owls.service.ServiceImpl;
import java.net.URI;
import org.mindswap.exceptions.ConversionException;
import org.mindswap.owl.EntityFactory;
import org.mindswap.owl.OWLConfig;
import org.mindswap.owl.OWLDataProperty;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLObject;
import org.mindswap.owl.OWLObjectConverter;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owls.grounding.Grounding;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.service.Service;
import org.mindswap.owls.vocabulary.OWLS_1_1;
import org.mindswap.utils.URIUtils;

public class ServiceExtension {
    public static final URI baseURI = URI.create("http://www.ifi.unizh.ch/ddis/ont/owl-s/ServiceExtensionTest.owl#");

    public static void main(String[] args) throws Exception {
        ServiceExtension test = new ServiceExtension();
        test.runRead();
        System.out.println("");
        test.runWrite();
    }

    public void runWrite() throws Exception {
        ExtendedServiceConverter converter = new ExtendedServiceConverter();
        OWLConfig.addConverter(Service.class, converter);
        OWLConfig.addConverter(ExtendedService.class, converter);
        OWLKnowledgeBase kb = OWLFactory.createKB();
        kb.setReasoner("Pellet");
        OWLOntology ont = kb.createOntology(null, null, true);
        Service s = ont.createService(URIUtils.createURI(baseURI, "TestService"));
        ExtendedService service = s.castTo(ExtendedService.class);
        AtomicProcess process = ont.createAtomicProcess(URIUtils.createURI(baseURI, "TestProcess"));
        Profile profile = ont.createProfile(URIUtils.createURI(baseURI, "TestProfile"));
        Grounding grounding = ont.createGrounding(URIUtils.createURI(baseURI, "TestGrounding"));
        service.setProfile(profile);
        service.setProcess(process);
        service.setGrounding(grounding);
        service.setAdditionalProperty("test");
        System.out.println("Wrote and re-read service:");
        System.out.println("Service name: " + service.getLocalName());
        System.out.println("Profile name: " + service.getProfile().getLocalName());
        System.out.println("Process name: " + service.getProcess().getLocalName());
        System.out.println("Grounding name: " + service.getGrounding().getLocalName());
        System.out.println("additional property: " + service.getAdditionalProperty());
    }

    public void runRead() throws Exception {
        OWLConfig.addConverter(Service.class, new ExtendedServiceConverter());
        OWLKnowledgeBase kb = OWLFactory.createKB();
        kb.setReasoner("Pellet");
        Service s = kb.readService("http://www.ifi.unizh.ch/ddis/ont/owl-s/ServiceExtensionTest.owl#");
        ExtendedService service = (ExtendedService)s;
        Profile profile = service.getProfile();
        Process process = service.getProcess();
        Grounding grounding = service.getGrounding();
        String additionalProperty = service.getAdditionalProperty();
        System.out.println("Read service:");
        System.out.println("Service name: " + service.getLocalName());
        System.out.println("Profile name: " + profile.getLocalName());
        System.out.println("Process name: " + process.getLocalName());
        System.out.println("Grounding name: " + grounding.getLocalName());
        System.out.println("additional property: " + additionalProperty);
    }

    public static class ExtendedService
    extends ServiceImpl {
        OWLDataProperty additionalProperty = EntityFactory.createDataProperty(URIUtils.createURI("http://www.ifi.unizh.ch/ddis/ont/owl-s/ServiceExtensionTest.owl#additionalProperty"));

        public ExtendedService(OWLIndividual ind) {
            super(ind);
        }

        public String getAdditionalProperty() {
            return this.getPropertyAsString(this.additionalProperty);
        }

        public void setAdditionalProperty(String value) {
            this.setProperty(this.additionalProperty, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExtendedServiceConverter
    implements OWLObjectConverter<Service> {
        @Override
        public boolean canCast(OWLObject object) {
            return object instanceof OWLIndividual && ((OWLIndividual)object).isType(OWLS_1_1.Service.Service);
        }

        @Override
        public Service cast(OWLObject object) {
            if (!this.canCast(object)) {
                throw new ConversionException("OWLObject " + object + " cannot be cast to Service class");
            }
            return new ExtendedService((OWLIndividual)object);
        }

        @Override
        public Service convert(OWLObject object) {
            return this.cast(object);
        }
    }
}

