/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.ExampleURIs;
import org.mindswap.owl.OWLConfig;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.profile.ServiceCategory;
import org.mindswap.owls.profile.ServiceParameter;
import org.mindswap.owls.service.Service;

public class ServiceParameterExample {
    private final OWLKnowledgeBase kb = OWLFactory.createKB();

    public static void main(String[] args) throws Exception {
        ServiceParameterExample test = new ServiceParameterExample();
        test.run();
    }

    public void run() throws Exception {
        System.out.print("Reading service...");
        long time = System.currentTimeMillis();
        this.kb.getReader().setIgnoreFailedImport(true);
        Service service = this.kb.readService(ExampleURIs.BRAVO_AIR);
        System.out.println("done, took " + (System.currentTimeMillis() - time) + "ms");
        this.printProfileInfo(service, null);
        this.printProfileInfo(service, "RDFS");
        this.printProfileInfo(service, "Pellet");
        OWLConfig.setStrictConversion(false);
        this.printProfileInfo(service, null);
    }

    public void printProfileInfo(Service s, String reasoner) {
        try {
            long time = System.currentTimeMillis();
            String name = reasoner == null ? "no" : reasoner;
            System.out.println("===================================");
            System.out.println("Results using " + name + " reasoner");
            System.out.println("Strict type checking: " + OWLConfig.getStrictConversion());
            System.out.println("===================================");
            this.kb.setReasoner(reasoner);
            Profile profile = s.getProfile();
            System.out.println("Service name: " + profile.getServiceName());
            System.out.println();
            System.out.println("Display service parameters");
            System.out.println("--------------------------");
            OWLIndividualList<ServiceParameter> params = profile.getServiceParameters();
            for (ServiceParameter param : params) {
                System.out.println("Service Parameter: ");
                System.out.println("  Name  : " + this.trimString(param.getName()));
                System.out.println("  Value : " + param.getParameter());
            }
            System.out.println();
            System.out.println("Display service categories");
            System.out.println("--------------------------");
            OWLIndividualList<ServiceCategory> categories = profile.getCategories();
            for (ServiceCategory category : categories) {
                System.out.println("Service Category: ");
                System.out.println("  Name  : " + this.trimString(category.getName()));
                System.out.println("  Code : " + this.trimString(category.getCode()));
                System.out.println("  Taxonomy : " + this.trimString(category.getTaxonomy()));
                System.out.println("  Value : " + this.trimString(category.getValue()));
            }
            System.out.println("Elapsed time to infer information: " + (System.currentTimeMillis() - time) + "ms");
        }
        catch (RuntimeException e) {
            System.out.println("The following error occurred: ");
            System.out.println(e);
        }
        System.out.println();
    }

    public String trimString(String str) {
        return str == null ? "<null>" : str.trim();
    }
}

