/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import impl.jena.OWLModelImpl;
import impl.owl.CombinedOWLConverter;
import java.net.URI;
import java.util.LinkedHashSet;
import org.mindswap.exceptions.ConversionException;
import org.mindswap.exceptions.NotImplementedException;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLConfig;
import org.mindswap.owl.OWLDataProperty;
import org.mindswap.owl.OWLDataType;
import org.mindswap.owl.OWLEntity;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLObject;
import org.mindswap.owl.OWLObjectConverter;
import org.mindswap.owl.OWLObjectProperty;
import org.mindswap.owl.OWLProperty;
import org.mindswap.owl.OWLType;

final class OWLConverters {
    OWLConverters() {
    }

    static final void registerConverters() {
        ObjectPropertyConverter objPropConverter = new ObjectPropertyConverter();
        DataPropertyConverter dataPropConverter = new DataPropertyConverter();
        LinkedHashSet pCs = new LinkedHashSet(3);
        pCs.add(objPropConverter);
        pCs.add(dataPropConverter);
        CombinedOWLConverter propConverter = new CombinedOWLConverter(OWLProperty.class, pCs);
        ClassConverter classConverter = new ClassConverter();
        DataTypeConverter dataTypeConverter = new DataTypeConverter();
        LinkedHashSet tCs = new LinkedHashSet(3);
        tCs.add(classConverter);
        tCs.add(dataTypeConverter);
        CombinedOWLConverter typeConverter = new CombinedOWLConverter(OWLType.class, tCs);
        IndividualConverter indConverter = new IndividualConverter();
        LinkedHashSet eCs = new LinkedHashSet(7);
        eCs.add(classConverter);
        eCs.add(dataTypeConverter);
        eCs.add(objPropConverter);
        eCs.add(dataPropConverter);
        eCs.add(indConverter);
        CombinedOWLConverter entityConverter = new CombinedOWLConverter(OWLEntity.class, eCs);
        OWLConfig.addConverter(OWLIndividual.class, indConverter);
        OWLConfig.addConverter(OWLObjectProperty.class, objPropConverter);
        OWLConfig.addConverter(OWLDataProperty.class, dataPropConverter);
        OWLConfig.addConverter(OWLProperty.class, propConverter);
        OWLConfig.addConverter(OWLClass.class, classConverter);
        OWLConfig.addConverter(OWLDataType.class, dataTypeConverter);
        OWLConfig.addConverter(OWLType.class, typeConverter);
        OWLConfig.addConverter(OWLEntity.class, entityConverter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ClassConverter
    implements OWLObjectConverter<OWLClass> {
        ClassConverter() {
        }

        @Override
        public boolean canCast(OWLObject object) {
            if (object instanceof OWLEntity) {
                OWLEntity entity = (OWLEntity)object;
                Resource res = (Resource)entity.getImplementation();
                return ((OWLModelImpl)((Object)entity.getKB())).getClass(res) != null || !OWLConfig.getStrictConversion();
            }
            return false;
        }

        @Override
        public OWLClass cast(OWLObject object) {
            if (!this.canCast(object)) {
                throw new ConversionException("OWLObject " + object + " cannot be converted to OWLClass");
            }
            OWLEntity entity = (OWLEntity)object;
            Resource res = (Resource)entity.getImplementation();
            return ((OWLModelImpl)((Object)entity.getKB())).wrapClass(res, null);
        }

        @Override
        public OWLClass convert(OWLObject object) {
            OWLEntity entity = (OWLEntity)object;
            URI uri = entity.getURI();
            return entity.getOntology().createClass(uri);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DataPropertyConverter
    implements OWLObjectConverter<OWLDataProperty> {
        DataPropertyConverter() {
        }

        @Override
        public boolean canCast(OWLObject object) {
            if (object instanceof OWLEntity) {
                OWLEntity entity = (OWLEntity)object;
                URI uri = entity.getURI();
                return entity.getKB().getDataProperty(uri) != null || !OWLConfig.getStrictConversion();
            }
            return false;
        }

        @Override
        public OWLDataProperty cast(OWLObject object) {
            if (!this.canCast(object)) {
                throw new ConversionException("OWLObject " + object + " cannot be converted to OWLDataProperty");
            }
            OWLEntity entity = (OWLEntity)object;
            Resource res = (Resource)entity.getImplementation();
            Property prop = (Property)res.as(Property.class);
            return ((OWLModelImpl)((Object)entity.getKB())).wrapDataProperty(prop, null);
        }

        @Override
        public OWLDataProperty convert(OWLObject object) {
            OWLEntity entity = (OWLEntity)object;
            URI uri = entity.getURI();
            return entity.getOntology().createDataProperty(uri);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DataTypeConverter
    implements OWLObjectConverter<OWLDataType> {
        DataTypeConverter() {
        }

        @Override
        public boolean canCast(OWLObject object) {
            if (object instanceof OWLEntity) {
                OWLEntity entity = (OWLEntity)object;
                URI uri = entity.getURI();
                return entity.getKB().getDataType(uri) != null;
            }
            return false;
        }

        @Override
        public OWLDataType cast(OWLObject object) {
            if (!this.canCast(object)) {
                throw new ConversionException("OWLObject " + object + " cannot be converted to OWLEntity");
            }
            OWLEntity entity = (OWLEntity)object;
            URI uri = entity.getURI();
            return entity.getKB().getDataType(uri);
        }

        @Override
        public OWLDataType convert(OWLObject object) {
            if (this.canCast(object)) {
                this.cast(object);
            }
            throw new NotImplementedException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class IndividualConverter
    implements OWLObjectConverter<OWLIndividual> {
        IndividualConverter() {
        }

        @Override
        public boolean canCast(OWLObject object) {
            return object instanceof OWLEntity;
        }

        @Override
        public OWLIndividual cast(OWLObject object) {
            if (!this.canCast(object)) {
                throw new ConversionException("OWLObject " + object + " cannot be converted to OWLIndividual");
            }
            OWLEntity entity = (OWLEntity)object;
            URI uri = entity.getURI();
            OWLIndividual ind = entity.getKB().getIndividual(uri);
            if (ind == null) {
                ind = entity.getKB().createIndividual(uri);
            }
            return ind;
        }

        @Override
        public OWLIndividual convert(OWLObject object) {
            if (this.canCast(object)) {
                return this.cast(object);
            }
            throw new NotImplementedException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ObjectPropertyConverter
    implements OWLObjectConverter<OWLObjectProperty> {
        ObjectPropertyConverter() {
        }

        @Override
        public boolean canCast(OWLObject object) {
            if (object instanceof OWLEntity) {
                OWLEntity entity = (OWLEntity)object;
                URI uri = entity.getURI();
                return entity.getKB().getObjectProperty(uri) != null || !OWLConfig.getStrictConversion();
            }
            return false;
        }

        @Override
        public OWLObjectProperty cast(OWLObject object) {
            if (!this.canCast(object)) {
                throw new ConversionException("OWLObject " + object + " cannot be converted to OWLObjectProperty");
            }
            OWLEntity entity = (OWLEntity)object;
            Resource res = (Resource)entity.getImplementation();
            Property prop = (Property)res.as(Property.class);
            return ((OWLModelImpl)((Object)entity.getKB())).wrapObjectProperty(prop, null);
        }

        @Override
        public OWLObjectProperty convert(OWLObject object) {
            OWLEntity entity = (OWLEntity)object;
            URI uri = entity.getURI();
            return entity.getOntology().createObjectProperty(uri);
        }
    }
}

