/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import com.hp.hpl.jena.rdf.model.Resource;
import impl.jena.OWLEntityImpl;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLDataProperty;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLEntity;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLObjectProperty;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLProperty;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.OWLWriter;
import org.mindswap.utils.RDFUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLIndividualImpl
extends OWLEntityImpl
implements OWLIndividual {
    public OWLIndividualImpl(OWLOntology ontology, Resource resource) {
        super(ontology, resource);
    }

    public OWLEntity inOntology(OWLOntology ont) {
        if (this.ontology.equals(ont)) {
            return this;
        }
        return new OWLIndividualImpl(this.ontology, this.resource);
    }

    @Override
    public boolean hasProperty(OWLProperty prop) {
        return this.kb.hasProperty(this, prop);
    }

    @Override
    public OWLIndividual getProperty(OWLObjectProperty prop) {
        return this.kb.getProperty((OWLIndividual)this, prop);
    }

    @Override
    public OWLIndividualList<?> getProperties(OWLObjectProperty prop) {
        return this.kb.getProperties((OWLIndividual)this, prop);
    }

    @Override
    public Map<OWLProperty, List<OWLValue>> getProperties() {
        return this.kb.getProperties(this);
    }

    @Override
    public OWLDataValue getProperty(OWLDataProperty prop) {
        return this.kb.getProperty((OWLIndividual)this, prop);
    }

    @Override
    public OWLDataValue getProperty(OWLDataProperty prop, String lang) {
        return this.kb.getProperty(this, prop, lang);
    }

    @Override
    public List<OWLDataValue> getProperties(OWLDataProperty prop) {
        return this.kb.getProperties((OWLIndividual)this, prop);
    }

    @Override
    public OWLIndividual getIncomingProperty(OWLObjectProperty prop) {
        return this.kb.getIncomingProperty(prop, this);
    }

    @Override
    public OWLIndividualList<?> getIncomingProperties(OWLObjectProperty prop) {
        return this.kb.getIncomingProperties(prop, this);
    }

    @Override
    public OWLIndividualList<?> getIncomingProperties() {
        return this.kb.getIncomingProperties(this);
    }

    @Override
    public void setProperty(OWLDataProperty prop, String value) {
        this.ontology.setProperty((OWLIndividual)this, prop, value);
    }

    @Override
    public void setProperty(OWLDataProperty prop, Object value) {
        this.ontology.setProperty((OWLIndividual)this, prop, value);
    }

    @Override
    public void setProperty(OWLDataProperty prop, OWLDataValue value) {
        this.ontology.setProperty((OWLIndividual)this, prop, value);
    }

    @Override
    public void addProperty(OWLDataProperty prop, OWLDataValue value) {
        this.ontology.addProperty((OWLIndividual)this, prop, value);
    }

    @Override
    public void addProperty(OWLDataProperty prop, String value) {
        this.ontology.addProperty((OWLIndividual)this, prop, value);
    }

    @Override
    public void addProperty(OWLDataProperty prop, Object value) {
        this.ontology.addProperty((OWLIndividual)this, prop, value);
    }

    @Override
    public void removeProperties(OWLProperty prop) {
        this.ontology.removeProperties(this, prop);
    }

    @Override
    public void removeProperty(OWLProperty theProp, OWLValue theValue) {
        this.ontology.removeProperty(this, theProp, theValue);
    }

    @Override
    public void addProperty(OWLObjectProperty prop, OWLIndividual value) {
        this.ontology.addProperty((OWLIndividual)this, prop, value);
    }

    @Override
    public void setProperty(OWLObjectProperty prop, OWLIndividual value) {
        this.ontology.setProperty((OWLIndividual)this, prop, value);
    }

    @Override
    public Set<OWLClass> getTypes() {
        return this.kb.getTypes(this);
    }

    @Override
    public boolean hasProperty(OWLProperty prop, OWLValue value) {
        return this.kb.hasProperty(this, prop, value);
    }

    @Override
    public OWLClass getType() {
        return this.kb.getType(this);
    }

    @Override
    public boolean isType(OWLClass c) {
        return this.kb.isType(this, c);
    }

    @Override
    public boolean isDataValue() {
        return false;
    }

    @Override
    public boolean isIndividual() {
        return true;
    }

    @Override
    public void addType(OWLClass c) {
        this.ontology.addType(this, c);
    }

    @Override
    public void removeTypes() {
        this.ontology.removeTypes(this);
    }

    @Override
    public String toRDF(boolean printRDFTag, boolean keepNamespaces) {
        OWLOntology closureOnt = OWLFactory.createOntology(null, false);
        this.getBnodeClosure(this, closureOnt);
        StringWriter sw = new StringWriter();
        OWLWriter writer = closureOnt.getWriter();
        boolean show = writer.isShowXmlDeclaration();
        writer.setShowXmlDeclaration(false);
        closureOnt.write(sw);
        writer.setShowXmlDeclaration(show);
        String rdf = sw.toString();
        if (printRDFTag) {
            return rdf;
        }
        return RDFUtils.removeRDFTag(rdf, keepNamespaces);
    }

    private void getBnodeClosure(OWLIndividual ind, OWLOntology closureOntology) {
        OWLClass c = ind.getOntology().getType(ind);
        if (c == null) {
            c = ind.getKB().getType(ind);
        }
        if (c != null) {
            closureOntology.addType(ind, c);
        }
        Map<OWLProperty, List<OWLValue>> props = ind.getProperties();
        for (Map.Entry<OWLProperty, List<OWLValue>> e : props.entrySet()) {
            List<OWLValue> values = e.getValue();
            for (OWLValue value : values) {
                OWLIndividual obj;
                closureOntology.addProperty(ind, e.getKey(), value);
                if (!(value instanceof OWLIndividual) || !(obj = (OWLIndividual)value).isAnon()) continue;
                this.getBnodeClosure(obj, closureOntology);
            }
        }
    }

    @Override
    public OWLOntology getSourceOntology() {
        return this.getOntology().getTranslationSource();
    }

    @Override
    public boolean isSameAs(OWLIndividual other) {
        return this.kb.isSameAs(this, other);
    }

    @Override
    public OWLIndividualList<?> getSameIndividuals() {
        return this.kb.getSameIndividuals(this);
    }

    @Override
    public boolean isDifferentFrom(OWLIndividual other) {
        return this.kb.isDifferentFrom(this, other);
    }

    @Override
    public OWLIndividualList<?> getDifferentIndividuals() {
        return this.kb.getDifferentIndividuals(this);
    }

    @Override
    public void delete() {
        this.ontology.removeIndividuals(this, false);
    }
}

