/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding0;
import com.hp.hpl.jena.sparql.expr.E_Add;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.E_GreaterThan;
import com.hp.hpl.jena.sparql.expr.E_GreaterThanOrEqual;
import com.hp.hpl.jena.sparql.expr.E_LessThan;
import com.hp.hpl.jena.sparql.expr.E_NotEquals;
import com.hp.hpl.jena.sparql.expr.E_Subtract;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.FunctionEnvBase;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementFilter;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import impl.jena.OWLDataValueImpl;
import impl.jena.OWLIndividualImpl;
import impl.owl.OWLObjectImpl;
import impl.owl.list.OWLListImpl;
import impl.owls.generic.expression.SWRLExpressionImpl;
import impl.owls.generic.list.OWLSObjListImpl;
import impl.owls.grounding.GroundingImpl;
import impl.owls.grounding.JavaAtomicGroundingImpl;
import impl.owls.grounding.UPnPAtomicGroundingImpl;
import impl.owls.grounding.UPnPMessageMapImpl;
import impl.owls.grounding.WSDLAtomicGroundingImpl;
import impl.owls.grounding.WSDLMessageMapImpl;
import impl.owls.grounding.WSDLOperationRefImpl;
import impl.owls.process.AtomicProcessImpl;
import impl.owls.process.CompositeProcessImpl;
import impl.owls.process.ResultImpl;
import impl.owls.process.ValueDataImpl;
import impl.owls.process.ValueOfImpl;
import impl.owls.process.binding.InputBindingImpl;
import impl.owls.process.binding.OutputBindingImpl;
import impl.owls.process.constructs.AnyOrderImpl;
import impl.owls.process.constructs.ChoiceImpl;
import impl.owls.process.constructs.ForEachImpl;
import impl.owls.process.constructs.IfThenElseImpl;
import impl.owls.process.constructs.PerformImpl;
import impl.owls.process.constructs.ProduceImpl;
import impl.owls.process.constructs.RepeatUntilImpl;
import impl.owls.process.constructs.RepeatWhileImpl;
import impl.owls.process.constructs.SequenceImpl;
import impl.owls.process.constructs.SplitImpl;
import impl.owls.process.constructs.SplitJoinImpl;
import impl.owls.process.parameter.InputImpl;
import impl.owls.process.parameter.LocalImpl;
import impl.owls.process.parameter.OutputImpl;
import impl.owls.profile.ProfileImpl;
import impl.owls.profile.ServiceParameterImpl;
import impl.owls.service.ServiceImpl;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.exceptions.NotImplementedException;
import org.mindswap.exceptions.UnboundVariableException;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLConfig;
import org.mindswap.owl.OWLDataProperty;
import org.mindswap.owl.OWLDataType;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLEntity;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLModel;
import org.mindswap.owl.OWLObject;
import org.mindswap.owl.OWLObjectProperty;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLProperty;
import org.mindswap.owl.OWLType;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.OWLWriter;
import org.mindswap.owl.list.ListVocabulary;
import org.mindswap.owl.list.OWLList;
import org.mindswap.owl.vocabulary.SWRLB;
import org.mindswap.owl.vocabulary.XSDDataTypes;
import org.mindswap.owls.generic.expression.Expression;
import org.mindswap.owls.generic.list.OWLSObjList;
import org.mindswap.owls.grounding.Grounding;
import org.mindswap.owls.grounding.JavaAtomicGrounding;
import org.mindswap.owls.grounding.MessageMap;
import org.mindswap.owls.grounding.UPnPAtomicGrounding;
import org.mindswap.owls.grounding.WSDLAtomicGrounding;
import org.mindswap.owls.grounding.WSDLOperationRef;
import org.mindswap.owls.process.AnyOrder;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.Binding;
import org.mindswap.owls.process.Choice;
import org.mindswap.owls.process.CompositeProcess;
import org.mindswap.owls.process.Condition;
import org.mindswap.owls.process.ControlConstruct;
import org.mindswap.owls.process.ControlConstructBag;
import org.mindswap.owls.process.ControlConstructList;
import org.mindswap.owls.process.ForEach;
import org.mindswap.owls.process.IfThenElse;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.InputBinding;
import org.mindswap.owls.process.Local;
import org.mindswap.owls.process.Output;
import org.mindswap.owls.process.OutputBinding;
import org.mindswap.owls.process.Perform;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.Produce;
import org.mindswap.owls.process.RepeatUntil;
import org.mindswap.owls.process.RepeatWhile;
import org.mindswap.owls.process.Result;
import org.mindswap.owls.process.Sequence;
import org.mindswap.owls.process.SimpleProcess;
import org.mindswap.owls.process.Split;
import org.mindswap.owls.process.SplitJoin;
import org.mindswap.owls.process.ValueData;
import org.mindswap.owls.process.ValueOf;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.profile.ServiceParameter;
import org.mindswap.owls.service.Service;
import org.mindswap.owls.vocabulary.FLAServiceOnt;
import org.mindswap.owls.vocabulary.MoreGroundings;
import org.mindswap.owls.vocabulary.OWLS_1_1;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletReasoner;
import org.mindswap.query.ABoxQuery;
import org.mindswap.query.ValueMap;
import org.mindswap.swrl.Atom;
import org.mindswap.swrl.AtomList;
import org.mindswap.swrl.BuiltinAtom;
import org.mindswap.swrl.ClassAtom;
import org.mindswap.swrl.DataPropertyAtom;
import org.mindswap.swrl.DifferentIndividualsAtom;
import org.mindswap.swrl.IndividualPropertyAtom;
import org.mindswap.swrl.SWRLIndividualObject;
import org.mindswap.swrl.SWRLObject;
import org.mindswap.swrl.SameIndividualAtom;
import org.mindswap.swrl.Variable;
import org.mindswap.utils.URIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OWLModelImpl
implements OWLModel {
    private final OntModelSpec spec;
    protected OntModel ontModel;
    protected Reasoner reasoner;
    protected OWLOntology baseOntology;
    protected OWLWriter writer;
    public static final Set<Property> SKIP_PROPS = new HashSet<Property>(Arrays.asList(ReasonerVocabulary.directSubClassOf, ReasonerVocabulary.directSubPropertyOf, ReasonerVocabulary.directRDFType));

    public OWLModelImpl(Model model) {
        OntDocumentManager docManager = new OntDocumentManager();
        docManager.setProcessImports(false);
        this.spec = new OntModelSpec(OntModelSpec.OWL_MEM);
        this.spec.setDocumentManager(docManager);
        this.ontModel = ModelFactory.createOntologyModel((OntModelSpec)this.spec, (Model)model);
    }

    public OntModel getImplementation() {
        return this.ontModel;
    }

    @Override
    public void prepare() {
        this.ontModel.prepare();
    }

    @Override
    public void classify() {
        if (this.reasoner instanceof PelletReasoner) {
            ((PelletInfGraph)this.ontModel.getGraph()).classify();
        }
    }

    @Override
    public boolean isClassified() {
        if (this.reasoner instanceof PelletReasoner) {
            return ((PelletInfGraph)this.ontModel.getGraph()).isClassified();
        }
        return true;
    }

    @Override
    public boolean isConsistent() {
        if (this.reasoner instanceof PelletReasoner) {
            return ((PelletInfGraph)this.ontModel.getGraph()).isConsistent();
        }
        return true;
    }

    public void setBaseOntology(OWLOntology ontology) {
        this.baseOntology = ontology;
    }

    @Override
    public OWLOntology getBaseOntology() {
        return this.baseOntology;
    }

    public void setReasoner(Reasoner reasoner) {
        if (reasoner == null || this.reasoner != reasoner) {
            this.reasoner = reasoner;
            this.spec.setReasoner(reasoner);
            List subGraphs = this.ontModel.getSubGraphs();
            this.ontModel = ModelFactory.createOntologyModel((OntModelSpec)this.spec, (Model)this.ontModel.getBaseModel());
            for (Graph graph : subGraphs) {
                Model wrap = ModelFactory.createModelForGraph((Graph)graph);
                this.ontModel.addSubModel(wrap, false);
            }
            this.ontModel.rebind();
        }
    }

    @Override
    public void setReasoner(String reasonerName) {
        Reasoner r = (Reasoner)OWLFactory.getReasoner(reasonerName);
        if (reasonerName != null && r == null) {
            throw new IllegalArgumentException("Reasoner named " + reasonerName + " not found!");
        }
        this.setReasoner(r);
    }

    @Override
    public void setReasoner(Object reasoner) {
        if (!(reasoner instanceof Reasoner) && reasoner != null) {
            throw new IllegalArgumentException("Jena implementation only supports reasoners that implement " + Reasoner.class);
        }
        this.setReasoner((Reasoner)reasoner);
    }

    @Override
    public Object getReasoner() {
        return this.reasoner;
    }

    @Override
    public OWLSObjList createList() {
        ListVocabulary vocabulary = OWLS_1_1.ObjList;
        OWLIndividual nil = this.createIndividual(vocabulary.nil().getURI());
        OWLSObjListImpl list = new OWLSObjListImpl(nil);
        list.setVocabulary(vocabulary);
        return list;
    }

    @Override
    public OWLSObjList createList(OWLIndividual item) {
        OWLSObjList list = this.createList();
        list = list.insert(item);
        return list;
    }

    @Override
    public OWLSObjList createList(OWLIndividualList<?> items) {
        OWLSObjList list = this.createList();
        int i = items.size();
        while (i >= 0) {
            list = list.insert((OWLValue)items.get(i));
            ++i;
        }
        return list;
    }

    @Override
    public OWLList createList(ListVocabulary vocabulary) {
        OWLIndividual nil = this.createIndividual(vocabulary.nil().getURI());
        OWLListImpl list = new OWLListImpl(nil);
        list.setVocabulary(vocabulary);
        return list;
    }

    @Override
    public OWLList createList(ListVocabulary vocabulary, OWLIndividual item) {
        OWLList list = this.createList(vocabulary);
        list = list.insert(item);
        return list;
    }

    @Override
    public OWLList createList(ListVocabulary vocabulary, OWLIndividualList<?> items) {
        OWLList list = this.createList(vocabulary);
        int i = items.size();
        while (i >= 0) {
            list = list.insert((OWLValue)items.get(i));
            ++i;
        }
        return list;
    }

    protected Resource asResource(URI uri) {
        return this.ontModel.getResource(uri.toString());
    }

    protected boolean containsResource(Resource r) {
        return this.ontModel.containsResource((RDFNode)r);
    }

    protected Property asProperty(URI uri) {
        return this.ontModel.getProperty(uri.toString());
    }

    @Override
    public OWLType getType(URI uri) {
        OWLType type = this.getDataType(uri);
        if (type == null) {
            type = this.getClass(uri);
        }
        return type;
    }

    @Override
    public OWLDataType getDataType(URI uri) {
        return XSDDataTypes.getDataType(uri);
    }

    public OWLObject getObject(URI uri) {
        OWLObject entity = this.getEntity(uri);
        if (entity == null) {
            entity = this.getDataType(uri);
        }
        return entity;
    }

    @Override
    public OWLEntity getEntity(URI uri) {
        OWLEntity entity = this.getClass(uri);
        if (entity == null) {
            entity = this.getObjectProperty(uri);
        }
        if (entity == null) {
            entity = this.getDataProperty(uri);
        }
        if (entity == null) {
            entity = this.getIndividual(uri);
        }
        return entity;
    }

    @Override
    public OWLClass getClass(URI uri) {
        return this.getClass(this.asResource(uri));
    }

    public OWLClass getClass(Resource res) {
        OWLClass c = null;
        if (res.canAs(OntClass.class)) {
            c = this.wrapClass(res, null);
        }
        return c;
    }

    @Override
    public OWLIndividual getIndividual(URI uri) {
        Individual res = this.ontModel.getIndividual(uri.toString());
        return res == null ? null : this.wrapIndividual((Resource)res, null);
    }

    @Override
    public OWLIndividualList<?> getIndividuals() {
        return this.getAllIndividuals((ExtendedIterator<? extends RDFNode>)this.ontModel.listSubjects(), null);
    }

    @Override
    public OWLProperty getProperty(URI uri) {
        OWLProperty prop = this.getObjectProperty(uri);
        if (prop == null) {
            prop = this.getDataProperty(uri);
        }
        return prop;
    }

    @Override
    public OWLObjectProperty getObjectProperty(URI uri) {
        OWLObjectProperty p = null;
        Property prop = this.asProperty(uri);
        if (this.ontModel.contains((Resource)prop, RDF.type, (RDFNode)OWL.ObjectProperty)) {
            p = this.wrapObjectProperty(prop, null);
        }
        return p;
    }

    @Override
    public OWLDataProperty getDataProperty(URI uri) {
        OWLDataProperty p = null;
        Property prop = this.asProperty(uri);
        if (this.ontModel.contains((Resource)prop, RDF.type, (RDFNode)OWL.DatatypeProperty)) {
            p = this.wrapDataProperty(prop, null);
        }
        return p;
    }

    @Override
    public boolean isSameAs(OWLIndividual ind1, OWLIndividual ind2) {
        return this.ontModel.contains((Resource)ind1.getImplementation(), OWL.sameAs, (RDFNode)((Resource)ind2.getImplementation()));
    }

    @Override
    public OWLIndividualList<?> getSameIndividuals(OWLIndividual ind) {
        return this.getAllIndividuals((ExtendedIterator<? extends RDFNode>)this.ontModel.listSubjectsWithProperty(OWL.sameAs, (RDFNode)((Resource)ind.getImplementation())), ind.getOntology());
    }

    @Override
    public boolean isDifferentFrom(OWLIndividual ind1, OWLIndividual ind2) {
        return this.ontModel.contains((Resource)ind1.getImplementation(), OWL.differentFrom, (RDFNode)((Resource)ind2.getImplementation()));
    }

    @Override
    public OWLIndividualList<?> getDifferentIndividuals(OWLIndividual ind) {
        return this.getAllIndividuals((ExtendedIterator<? extends RDFNode>)this.ontModel.listSubjectsWithProperty(OWL.differentFrom, (RDFNode)((Resource)ind.getImplementation())), ind.getOntology());
    }

    @Override
    public boolean isSubClassOf(OWLClass c1, OWLClass c2) {
        return this.ontModel.contains((Resource)c1.getImplementation(), RDFS.subClassOf, (RDFNode)((Resource)c2.getImplementation()));
    }

    @Override
    public boolean isComplement(OWLClass c1, OWLClass c2) {
        return this.ontModel.contains((Resource)c1.getImplementation(), OWL.complementOf, (RDFNode)((Resource)c2.getImplementation()));
    }

    @Override
    public boolean isDisjoint(OWLClass c1, OWLClass c2) {
        return this.ontModel.contains((Resource)c1.getImplementation(), OWL.disjointWith, (RDFNode)((Resource)c2.getImplementation()));
    }

    @Override
    public boolean isEquivalent(OWLType t1, OWLType t2) {
        if (t1.equals(t2)) {
            return true;
        }
        if (t1 instanceof OWLClass && t2 instanceof OWLClass) {
            return this.ontModel.contains((Resource)t1.getImplementation(), OWL.equivalentClass, (RDFNode)((Resource)t2.getImplementation()));
        }
        if (t1 instanceof OWLDataType && t2 instanceof OWLDataType) {
            return t1.equals(t2);
        }
        return false;
    }

    @Override
    public boolean isDisjoint(OWLType t1, OWLType t2) {
        if (t1 instanceof OWLClass && t2 instanceof OWLClass) {
            return this.isDisjoint((OWLClass)t1, (OWLClass)t2);
        }
        if (t1 instanceof OWLDataType && t2 instanceof OWLDataType) {
            return !this.isEquivalent(t1, t2);
        }
        return true;
    }

    @Override
    public Set<OWLClass> getSubClasses(OWLClass c, boolean direct) {
        Property subClassOf = direct ? ReasonerVocabulary.directSubClassOf : RDFS.subClassOf;
        return this.getAllClasses((ExtendedIterator<? extends RDFNode>)this.ontModel.listSubjectsWithProperty(subClassOf, (RDFNode)((Resource)c.getImplementation())), c.getOntology());
    }

    @Override
    public Set<OWLProperty> getSubProperties(OWLProperty p) {
        if (p instanceof OWLObjectProperty) {
            return this.getAllObjectProperties((ExtendedIterator<? extends RDFNode>)this.ontModel.listSubjectsWithProperty(RDFS.subPropertyOf, (RDFNode)((Resource)p.getImplementation())), p.getOntology());
        }
        return this.getAllDataProperties((ExtendedIterator<? extends RDFNode>)this.ontModel.listSubjectsWithProperty(RDFS.subPropertyOf, (RDFNode)((Resource)p.getImplementation())), p.getOntology());
    }

    @Override
    public Set<OWLProperty> getEquivalentProperties(OWLProperty p) {
        if (p instanceof OWLObjectProperty) {
            return this.getAllObjectProperties((ExtendedIterator<? extends RDFNode>)this.ontModel.listSubjectsWithProperty(OWL.equivalentClass, (RDFNode)((Resource)p.getImplementation())), p.getOntology());
        }
        return this.getAllDataProperties((ExtendedIterator<? extends RDFNode>)this.ontModel.listSubjectsWithProperty(OWL.equivalentClass, (RDFNode)((Resource)p.getImplementation())), p.getOntology());
    }

    @Override
    public Set<OWLProperty> getSuperProperties(OWLProperty p) {
        if (p instanceof OWLObjectProperty) {
            return this.getAllObjectProperties((ExtendedIterator<? extends RDFNode>)this.ontModel.listObjectsOfProperty((Resource)p.getImplementation(), RDFS.subPropertyOf), p.getOntology());
        }
        return this.getAllDataProperties((ExtendedIterator<? extends RDFNode>)this.ontModel.listObjectsOfProperty((Resource)p.getImplementation(), RDFS.subPropertyOf), p.getOntology());
    }

    @Override
    public Set<OWLClass> getSuperClasses(OWLClass c, boolean direct) {
        Property subClassOf = direct ? ReasonerVocabulary.directSubClassOf : RDFS.subClassOf;
        return this.getAllClasses((ExtendedIterator<? extends RDFNode>)this.ontModel.listObjectsOfProperty((Resource)c.getImplementation(), subClassOf), c.getOntology());
    }

    @Override
    public Set<OWLClass> getEquivalentClasses(OWLClass c) {
        return this.getAllClasses((ExtendedIterator<? extends RDFNode>)this.ontModel.listSubjectsWithProperty(OWL.equivalentClass, (RDFNode)((Resource)c.getImplementation())), c.getOntology());
    }

    @Override
    public OWLIndividualList<?> getInstances(OWLClass c) {
        return this.getAllIndividuals((ExtendedIterator<? extends RDFNode>)this.ontModel.listSubjectsWithProperty(RDF.type, (RDFNode)((Resource)c.getImplementation())), c.getOntology());
    }

    @Override
    public Set<OWLClass> getTypes(OWLIndividual ind) {
        return this.getAllClasses((ExtendedIterator<? extends RDFNode>)this.ontModel.listObjectsOfProperty((Resource)ind.getImplementation(), RDF.type), ind.getOntology());
    }

    @Override
    public OWLIndividual getProperty(OWLIndividual ind, OWLObjectProperty prop) {
        return this.getFirstIndividual((ExtendedIterator<? extends RDFNode>)this.ontModel.listObjectsOfProperty((Resource)ind.getImplementation(), (Property)prop.getImplementation()), ind.getOntology());
    }

    @Override
    public OWLIndividualList<?> getProperties(OWLIndividual ind, OWLObjectProperty prop) {
        return this.getAllIndividuals((ExtendedIterator<? extends RDFNode>)this.ontModel.listObjectsOfProperty((Resource)ind.getImplementation(), (Property)prop.getImplementation()), ind.getOntology());
    }

    private Map<OWLProperty, List<OWLValue>> getProperties(Resource resource, OWLOntology ontology) {
        HashMap<OWLProperty, List<OWLValue>> result = new HashMap<OWLProperty, List<OWLValue>>();
        StmtIterator i = this.ontModel.listStatements(resource, null, null);
        while (i.hasNext()) {
            List list;
            OWLProperty prop;
            Statement stmt = (Statement)i.next();
            Property pred = stmt.getPredicate();
            if (SKIP_PROPS.contains(pred)) continue;
            RDFNode value = stmt.getObject();
            if (value instanceof Resource) {
                prop = this.baseOntology.createObjectProperty(URI.create(pred.getURI()));
                list = (List)result.get(prop);
                if (list == null) {
                    list = OWLFactory.createValueList();
                    result.put(prop, list);
                }
                list.add(this.wrapIndividual(stmt.getResource(), ontology));
                continue;
            }
            prop = this.baseOntology.createDataProperty(URI.create(pred.getURI()));
            list = (List)result.get(prop);
            if (list == null) {
                list = OWLFactory.createValueList();
                result.put(prop, list);
            }
            list.add(this.wrapDataValue(stmt.getLiteral(), ontology));
        }
        return result;
    }

    @Override
    public List<OWLProperty> getDeclaredProperties(OWLClass claz, boolean direct) {
        ArrayList<OWLProperty> result = new ArrayList<OWLProperty>();
        OntResource ontRes = this.ontModel.getOntResource((Resource)claz.getImplementation());
        OntClass ontClaz = ontRes.asClass();
        ExtendedIterator i = ontClaz.listDeclaredProperties(direct);
        while (i.hasNext()) {
            OWLProperty prop;
            OntProperty ontProp = (OntProperty)i.next();
            if (SKIP_PROPS.contains(ontProp)) continue;
            if (ontProp.isDatatypeProperty()) {
                prop = this.baseOntology.createDataProperty(URI.create(ontProp.getURI()));
                result.add(prop);
                continue;
            }
            prop = this.baseOntology.createObjectProperty(URI.create(ontProp.getURI()));
            result.add(prop);
        }
        return result;
    }

    @Override
    public Map<OWLProperty, List<OWLValue>> getProperties(OWLClass claz) {
        return this.getProperties((Resource)claz.getImplementation(), claz.getOntology());
    }

    @Override
    public Map<OWLProperty, List<OWLValue>> getProperties(OWLIndividual ind) {
        return this.getProperties((Resource)ind.getImplementation(), ind.getOntology());
    }

    @Override
    public OWLDataValue getProperty(OWLIndividual ind, OWLDataProperty prop) {
        OWLDataValue result = null;
        int maxPriority = -1;
        List<OWLDataValue> list = this.getAllDataValues((Iterator<? extends RDFNode>)this.ontModel.listObjectsOfProperty((Resource)ind.getImplementation(), (Property)prop.getImplementation()), ind.getOntology());
        int i = 0;
        while (i < list.size()) {
            OWLDataValue value = list.get(i);
            int priority = OWLConfig.getDefaultLanguages().indexOf(value.getLanguage());
            if (priority == 0) {
                return value;
            }
            if (priority > maxPriority) {
                result = value;
                maxPriority = priority;
            }
            ++i;
        }
        return result;
    }

    @Override
    public OWLDataValue getProperty(OWLIndividual ind, OWLDataProperty prop, String lang) {
        List<OWLDataValue> list = this.getAllDataValues((Iterator<? extends RDFNode>)this.ontModel.listObjectsOfProperty((Resource)ind.getImplementation(), (Property)prop.getImplementation()), ind.getOntology());
        int i = 0;
        while (i < list.size()) {
            OWLDataValue value = list.get(i);
            if (lang == null || value.getLanguage().equals(lang)) {
                return value;
            }
            ++i;
        }
        return null;
    }

    @Override
    public List<OWLDataValue> getProperties(OWLIndividual ind, OWLDataProperty prop) {
        return this.getAllDataValues((Iterator<? extends RDFNode>)this.ontModel.listObjectsOfProperty((Resource)ind.getImplementation(), (Property)prop.getImplementation()), ind.getOntology());
    }

    @Override
    public OWLIndividual getIncomingProperty(OWLObjectProperty prop, OWLIndividual ind) {
        return this.getFirstIndividual((ExtendedIterator<? extends RDFNode>)this.ontModel.listSubjectsWithProperty((Property)prop.getImplementation(), (RDFNode)((Resource)ind.getImplementation())), ind.getOntology());
    }

    @Override
    public OWLIndividualList<?> getIncomingProperties(OWLObjectProperty prop, OWLIndividual ind) {
        return this.getAllIndividuals((ExtendedIterator<? extends RDFNode>)this.ontModel.listSubjectsWithProperty((Property)prop.getImplementation(), (RDFNode)((Resource)ind.getImplementation())), ind.getOntology());
    }

    @Override
    public OWLIndividualList<?> getIncomingProperties(OWLIndividual ind) {
        return this.getAllIndividuals((ExtendedIterator<? extends RDFNode>)this.ontModel.listStatements(null, null, (RDFNode)((Resource)ind.getImplementation())).mapWith((Map1)new Map1<Statement, Resource>(){

            public Resource map1(Statement s) {
                return s.getSubject();
            }
        }), ind.getOntology());
    }

    @Override
    public OWLIndividual getIncomingProperty(OWLDataProperty prop, OWLDataValue value) {
        return this.getFirstIndividual((ExtendedIterator<? extends RDFNode>)this.ontModel.listSubjectsWithProperty((Property)prop.getImplementation(), (RDFNode)((Literal)value.getImplementation())), prop.getOntology());
    }

    @Override
    public OWLIndividualList<?> getIncomingProperties(OWLDataProperty prop, OWLDataValue value) {
        return this.getAllIndividuals((ExtendedIterator<? extends RDFNode>)this.ontModel.listSubjectsWithProperty((Property)prop.getImplementation(), (RDFNode)((Literal)value.getImplementation())), prop.getOntology());
    }

    @Override
    public boolean hasProperty(OWLIndividual ind, OWLProperty prop) {
        return this.ontModel.contains((Resource)ind.getImplementation(), (Property)prop.getImplementation(), null);
    }

    @Override
    public boolean hasProperty(OWLIndividual ind, OWLProperty prop, OWLValue value) {
        return this.ontModel.contains((Resource)ind.getImplementation(), (Property)prop.getImplementation(), (RDFNode)value.getImplementation());
    }

    @Override
    public OWLClass getType(OWLIndividual ind) {
        Resource res = (Resource)ind.getImplementation();
        OntResource ontR = (OntResource)(res = (Resource)res.inModel((Model)this.ontModel)).as(OntResource.class);
        Resource type = ontR.getRDFType(true);
        return type == null ? null : this.wrapClass(type, ind.getOntology());
    }

    @Override
    public boolean isType(OWLIndividual ind, OWLClass c) {
        return this.ontModel.contains((Resource)ind.getImplementation(), RDF.type, (RDFNode)((Resource)c.getImplementation()));
    }

    @Override
    public boolean isEnumerated(OWLClass c) {
        return this.ontModel.contains((Resource)c.getImplementation(), OWL.oneOf, null);
    }

    @Override
    public OWLIndividualList<?> getEnumerations(OWLClass c) {
        Statement stmt = this.ontModel.getProperty((Resource)c.getImplementation(), OWL.oneOf);
        if (stmt == null) {
            return null;
        }
        RDFList oneOf = (RDFList)stmt.getResource().as(RDFList.class);
        return this.getAllIndividuals((ExtendedIterator<? extends RDFNode>)oneOf.iterator(), c.getOntology());
    }

    private Set<OWLProperty> getAllObjectProperties(ExtendedIterator<? extends RDFNode> i, OWLOntology ont) {
        HashSet<OWLProperty> set = new HashSet<OWLProperty>();
        while (i.hasNext()) {
            set.add(this.wrapObjectProperty((Property)((RDFNode)i.next()).as(Property.class), ont));
        }
        return set;
    }

    private Set<OWLProperty> getAllDataProperties(ExtendedIterator<? extends RDFNode> i, OWLOntology ont) {
        HashSet<OWLProperty> set = new HashSet<OWLProperty>();
        while (i.hasNext()) {
            set.add(this.wrapDataProperty((Property)((RDFNode)i.next()).as(Property.class), ont));
        }
        return set;
    }

    protected Set<OWLClass> getAllClasses(ExtendedIterator<? extends RDFNode> i, OWLOntology ont) {
        HashSet<OWLClass> set = new HashSet<OWLClass>();
        while (i.hasNext()) {
            set.add(this.wrapClass((Resource)((RDFNode)i.next()).as(OntClass.class), ont));
        }
        return set;
    }

    private OWLIndividualList<?> getAllIndividuals(ExtendedIterator<? extends RDFNode> i, OWLOntology ont) {
        OWLIndividualList list = OWLFactory.createIndividualList();
        while (i.hasNext()) {
            RDFNode node = (RDFNode)i.next();
            if (!node.isResource()) continue;
            list.add(this.wrapIndividual((Resource)node.as(Resource.class), ont));
        }
        return list;
    }

    private OWLIndividual getFirstIndividual(ExtendedIterator<? extends RDFNode> i, OWLOntology ont) {
        while (i.hasNext()) {
            RDFNode node = (RDFNode)i.next();
            if (!node.isResource()) continue;
            return this.wrapIndividual((Resource)node.as(Resource.class), ont);
        }
        return null;
    }

    private List<OWLDataValue> getAllDataValues(Iterator<? extends RDFNode> i, OWLOntology ont) {
        List<OWLDataValue> list = OWLFactory.createValueList();
        while (i.hasNext()) {
            RDFNode node = i.next();
            if (!node.isLiteral()) continue;
            list.add(this.wrapDataValue((Literal)node.as(Literal.class), ont));
        }
        return list;
    }

    protected abstract OWLDataValue wrapDataValue(Literal var1, OWLOntology var2);

    protected abstract OWLIndividual wrapIndividual(Resource var1, OWLOntology var2);

    protected abstract OWLClass wrapClass(Resource var1, OWLOntology var2);

    protected abstract OWLObjectProperty wrapObjectProperty(Property var1, OWLOntology var2);

    protected abstract OWLDataProperty wrapDataProperty(Property var1, OWLOntology var2);

    @Override
    public void applyGround(AtomList atoms) {
        this.apply(atoms, true);
    }

    @Override
    public void apply(AtomList atoms) throws UnboundVariableException {
        this.apply(atoms, false);
    }

    private void apply(AtomList atoms, boolean skipUnground) {
        AtomList list = atoms;
        while (!list.isEmpty()) {
            block12: {
                OWLValue obj;
                SWRLIndividualObject subj;
                OWLProperty pred;
                Atom atom = list.getFirst();
                int i = 0;
                while (i < atom.getArgumentCount()) {
                    SWRLObject arg = atom.getArgument(i);
                    if (arg.isVariable()) {
                        if (!skipUnground) {
                            throw new UnboundVariableException((Variable)((Object)arg));
                        }
                        break block12;
                    }
                    ++i;
                }
                if (atom instanceof ClassAtom) {
                    ClassAtom classAtom = (ClassAtom)atom;
                    OWLClass c = classAtom.getClassPredicate();
                    SWRLIndividualObject ind = classAtom.getArgument1();
                    this.addType(ind, c);
                } else if (atom instanceof IndividualPropertyAtom) {
                    IndividualPropertyAtom propAtom = (IndividualPropertyAtom)atom;
                    pred = propAtom.getPropertyPredicate();
                    subj = propAtom.getArgument1();
                    obj = propAtom.getArgument2();
                    this.addProperty((OWLIndividual)subj, (OWLObjectProperty)pred, (OWLIndividual)obj);
                } else if (atom instanceof DataPropertyAtom) {
                    DataPropertyAtom propAtom = (DataPropertyAtom)atom;
                    pred = propAtom.getPropertyPredicate();
                    subj = propAtom.getArgument1();
                    obj = (OWLDataValue)((Object)propAtom.getArgument2());
                    this.addProperty((OWLIndividual)subj, (OWLDataProperty)pred, (OWLDataValue)obj);
                } else {
                    if (atom instanceof SameIndividualAtom) {
                        throw new NotImplementedException();
                    }
                    if (atom instanceof DifferentIndividualsAtom) {
                        throw new NotImplementedException();
                    }
                    throw new RuntimeException("Unknown atom type: " + atom);
                }
            }
            list = list.getRest();
        }
    }

    @Override
    public boolean isTrue(ABoxQuery query) {
        return !this.query(query).isEmpty();
    }

    @Override
    public boolean isTrue(Condition condition) {
        return this.isTrue(condition.getBody().toQuery());
    }

    @Override
    public boolean isTrue(Condition condition, ValueMap values) {
        AtomList atoms = condition.getBody();
        if (atoms == null) {
            return true;
        }
        atoms = atoms.apply(values);
        return this.isTrue(atoms.toQuery());
    }

    private Node makeNode(OWLObject term) {
        if (term instanceof Variable) {
            String varName = ((Variable)term).getLocalName();
            if (varName == null || varName.equals("")) {
                throw new IllegalArgumentException("There is no local name for the variable URI " + ((Variable)term).getURI());
            }
            return Var.alloc((Node)Node.createVariable((String)varName));
        }
        return ((RDFNode)term.getImplementation()).asNode();
    }

    private Node makeNode(NodeValue nodeVal) {
        if (nodeVal.isBoolean()) {
            return Node.createLiteral((String)(nodeVal.getBoolean() ? Boolean.TRUE.toString() : Boolean.FALSE.toString()), null, (RDFDatatype)XSDDatatype.XSDboolean);
        }
        if (nodeVal.isDate()) {
            return Node.createLiteral((String)Utils.calendarToXSDDateTimeString((Calendar)nodeVal.getDate().asCalendar()), null, (RDFDatatype)XSDDatatype.XSDdateTime);
        }
        if (nodeVal.isInteger()) {
            return Node.createLiteral((String)nodeVal.getInteger().toString(), null, (RDFDatatype)XSDDatatype.XSDinteger);
        }
        if (nodeVal.isDouble()) {
            return Node.createLiteral((String)Double.toString(nodeVal.getDouble()), null, (RDFDatatype)XSDDatatype.XSDdouble);
        }
        if (nodeVal.isString()) {
            return Node.createLiteral((String)nodeVal.getString());
        }
        throw new RuntimeException("Unrecognized node type");
    }

    /*
     * WARNING - void declaration
     */
    public QueryExecution makeJenaQuery(AtomList body) {
        void var5_6;
        QuerySolutionMap initialBinding = new QuerySolutionMap();
        initialBinding.add("test", (RDFNode)OWL.Thing);
        ElementGroup group = new ElementGroup();
        ArrayList<E_NotEquals> constraints = new ArrayList<E_NotEquals>();
        AtomList atomList = body;
        while (!var5_6.isEmpty()) {
            Atom atom = var5_6.getFirst();
            int argCount = atom.getArgumentCount();
            Node s = null;
            Node p = null;
            Node o = null;
            s = this.makeNode(atom.getArgument(0));
            if (argCount > 1) {
                o = this.makeNode(atom.getArgument(1));
            }
            if (atom instanceof BuiltinAtom) {
                NodeValue result;
                E_Add expr;
                OWLIndividual builtin = ((BuiltinAtom)atom).getBuiltin();
                ExprVar arg1 = s.isVariable() ? new ExprVar(s.getName()) : NodeValue.makeNode((Node)s);
                ExprVar arg2 = o.isVariable() ? new ExprVar(o.getName()) : NodeValue.makeNode((Node)o);
                ExprVar arg3 = null;
                if (argCount > 2) {
                    Node node3 = this.makeNode(atom.getArgument(2));
                    arg3 = node3.isVariable() ? new ExprVar(node3.getName()) : NodeValue.makeNode((Node)node3);
                }
                E_NotEquals c = null;
                if (builtin.equals(SWRLB.equal)) {
                    if (arg1.isConstant()) {
                        if (arg2.isConstant()) {
                            c = new E_Equals((Expr)arg1, (Expr)arg2);
                        } else {
                            initialBinding.add(o.getName(), this.ontModel.asRDFNode(this.makeNode(arg1.getConstant())));
                        }
                    } else if (arg2.isConstant()) {
                        initialBinding.add(s.getName(), this.ontModel.asRDFNode(arg2.getConstant().asNode()));
                    } else {
                        c = new E_Equals((Expr)arg1, (Expr)arg2);
                    }
                } else if (builtin.equals(SWRLB.notEqual)) {
                    c = new E_NotEquals((Expr)arg1, (Expr)arg2);
                } else if (builtin.equals(SWRLB.greaterThan)) {
                    c = new E_GreaterThan((Expr)arg1, (Expr)arg2);
                } else if (builtin.equals(SWRLB.greaterThanOrEqual)) {
                    c = new E_GreaterThanOrEqual((Expr)arg1, (Expr)arg2);
                } else if (builtin.equals(SWRLB.lessThan)) {
                    c = new E_LessThan((Expr)arg1, (Expr)arg2);
                } else if (builtin.equals(SWRLB.lessThanOrEqual)) {
                    c = new E_GreaterThanOrEqual((Expr)arg1, (Expr)arg2);
                } else if (builtin.equals(SWRLB.add)) {
                    if (!arg1.isConstant() && arg2.isConstant() && arg3.isConstant()) {
                        expr = new E_Add((Expr)arg2, (Expr)arg3);
                        result = expr.eval((com.hp.hpl.jena.sparql.engine.binding.Binding)new Binding0(), FunctionEnvBase.createTest());
                        initialBinding.add(arg1.getVarName(), this.ontModel.asRDFNode(this.makeNode(result.getConstant())));
                    } else if (arg1.isConstant() && !arg2.isConstant() && arg3.isConstant()) {
                        expr = new E_Subtract((Expr)arg1, (Expr)arg3);
                        result = expr.eval((com.hp.hpl.jena.sparql.engine.binding.Binding)new Binding0(), FunctionEnvBase.createTest());
                        initialBinding.add(arg2.getVarName(), this.ontModel.asRDFNode(result.getConstant().asNode()));
                    } else if (arg1.isConstant() && arg2.isConstant() && !arg3.isConstant()) {
                        expr = new E_Subtract((Expr)arg1, (Expr)arg2);
                        result = expr.eval((com.hp.hpl.jena.sparql.engine.binding.Binding)new Binding0(), FunctionEnvBase.createTest());
                        initialBinding.add(arg3.getVarName(), this.ontModel.asRDFNode(result.getConstant().asNode()));
                    } else {
                        c = new E_Equals((Expr)arg1, (Expr)new E_Subtract((Expr)arg2, (Expr)arg3));
                    }
                } else if (builtin.equals(SWRLB.subtract)) {
                    if (!arg1.isConstant() && arg2.isConstant() && arg3.isConstant()) {
                        expr = new E_Subtract((Expr)arg2, (Expr)arg3);
                        result = expr.eval((com.hp.hpl.jena.sparql.engine.binding.Binding)new Binding0(), FunctionEnvBase.createTest());
                        initialBinding.add(arg1.getVarName(), this.ontModel.asRDFNode(this.makeNode(result.getConstant())));
                    } else if (arg1.isConstant() && !arg2.isConstant() && arg3.isConstant()) {
                        expr = new E_Add((Expr)arg1, (Expr)arg3);
                        result = expr.eval((com.hp.hpl.jena.sparql.engine.binding.Binding)new Binding0(), FunctionEnvBase.createTest());
                        initialBinding.add(arg2.getVarName(), this.ontModel.asRDFNode(result.getConstant().asNode()));
                    } else if (arg1.isConstant() && arg2.isConstant() && !arg3.isConstant()) {
                        expr = new E_Subtract((Expr)arg2, (Expr)arg1);
                        result = expr.eval((com.hp.hpl.jena.sparql.engine.binding.Binding)new Binding0(), FunctionEnvBase.createTest());
                        initialBinding.add(arg3.getVarName(), this.ontModel.asRDFNode(result.getConstant().asNode()));
                    } else {
                        c = new E_Equals((Expr)arg1, (Expr)new E_Subtract((Expr)arg2, (Expr)arg3));
                    }
                } else {
                    throw new NotImplementedException(builtin.toPrettyString());
                }
                if (c != null) {
                    constraints.add(c);
                }
            } else {
                if (atom instanceof ClassAtom) {
                    p = RDF.type.asNode();
                    o = this.makeNode(((ClassAtom)atom).getClassPredicate());
                } else if (atom instanceof IndividualPropertyAtom) {
                    p = this.makeNode(((IndividualPropertyAtom)atom).getPropertyPredicate());
                } else if (atom instanceof DataPropertyAtom) {
                    p = this.makeNode(((DataPropertyAtom)atom).getPropertyPredicate());
                } else if (atom instanceof SameIndividualAtom) {
                    p = OWL.sameAs.asNode();
                } else if (atom instanceof DifferentIndividualsAtom) {
                    p = OWL.differentFrom.asNode();
                } else {
                    throw new RuntimeException("Unknown atom type " + atom);
                }
                group.addTriplePattern(Triple.create((Node)s, (Node)p, (Node)o));
            }
            AtomList atomList2 = var5_6.getRest();
        }
        if (!constraints.isEmpty()) {
            for (Expr expr : constraints) {
                group.addElement((Element)new ElementFilter(expr));
            }
        }
        Query query = QueryFactory.make();
        query.setQueryType(111);
        query.setQueryPattern((Element)group);
        query.setQueryResultStar(true);
        return QueryExecutionFactory.create((Query)query, (Model)this.ontModel, (QuerySolution)initialBinding);
    }

    @Override
    public List<ValueMap> query(String rdql) {
        ABoxQuery query = OWLFactory.createRDQLParser(this).parse(rdql);
        return this.query(query);
    }

    @Override
    public List<ValueMap> query(ABoxQuery query, ValueMap values) {
        ABoxQuery q = query.apply(values);
        return this.query(q);
    }

    @Override
    public List<ValueMap> query(ABoxQuery query) {
        ArrayList<ValueMap> result = new ArrayList<ValueMap>();
        List<Variable> resultVars = query.getResultVars();
        AtomList atoms = query.getBody();
        QueryExecution qe = this.makeJenaQuery(atoms);
        ResultSet results = qe.execSelect();
        while (results.hasNext()) {
            QuerySolution binding = results.nextSolution();
            ValueMap<Variable, OWLDataValueImpl> map = new ValueMap<Variable, OWLDataValueImpl>();
            int i = 0;
            while (i < resultVars.size()) {
                Variable var = resultVars.get(i);
                RDFNode value = binding.get(var.getLocalName());
                if (value != null) {
                    OWLObjectImpl owlValue = null;
                    owlValue = value instanceof Literal ? new OWLDataValueImpl((Literal)value) : new OWLIndividualImpl(this.baseOntology, (Resource)value);
                    map.setValue(var, (OWLDataValueImpl)owlValue);
                }
                ++i;
            }
            result.add(map);
        }
        return result;
    }

    @Override
    public boolean isSubTypeOf(OWLDataType t1, OWLDataType t2) {
        return t1.equals(t2);
    }

    @Override
    public boolean isSubTypeOf(OWLType t1, OWLType t2) {
        if (t1 instanceof OWLClass && t2 instanceof OWLClass) {
            return this.isSubClassOf((OWLClass)t1, (OWLClass)t2);
        }
        if (t1 instanceof OWLDataType && t2 instanceof OWLDataType) {
            return this.isSubTypeOf((OWLDataType)t1, (OWLDataType)t2);
        }
        return false;
    }

    @Override
    public AnyOrder createAnyOrder() {
        return this.createAnyOrder(this.createInstance(OWLS_1_1.Process.AnyOrder));
    }

    @Override
    public AnyOrder createAnyOrder(URI uri) {
        return this.createAnyOrder(this.createInstance(OWLS_1_1.Process.AnyOrder, uri));
    }

    public AnyOrder createAnyOrder(OWLIndividual ind) {
        return new AnyOrderImpl(ind);
    }

    @Override
    public AtomicProcess createAtomicProcess() {
        return new AtomicProcessImpl(this.createInstance(OWLS_1_1.Process.AtomicProcess));
    }

    @Override
    public AtomicProcess createAtomicProcess(URI uri) {
        return new AtomicProcessImpl(this.createInstance(OWLS_1_1.Process.AtomicProcess, uri));
    }

    public AtomicProcess createAtomicProcess(OWLIndividual ind) {
        return new AtomicProcessImpl(ind);
    }

    @Override
    public Choice createChoice() {
        return this.createChoice(this.createInstance(OWLS_1_1.Process.Choice));
    }

    @Override
    public Choice createChoice(URI uri) {
        return this.createChoice(this.createInstance(OWLS_1_1.Process.Choice, uri));
    }

    public Choice createChoice(OWLIndividual ind) {
        return new ChoiceImpl(ind);
    }

    @Override
    public CompositeProcess createCompositeProcess() {
        return this.createCompositeProcess(this.createInstance(OWLS_1_1.Process.CompositeProcess));
    }

    @Override
    public CompositeProcess createCompositeProcess(URI uri) {
        return this.createCompositeProcess(this.createInstance(OWLS_1_1.Process.CompositeProcess, uri));
    }

    public CompositeProcess createCompositeProcess(OWLIndividual ind) {
        return new CompositeProcessImpl(ind);
    }

    @Override
    public Condition createSWRLCondition() {
        return new SWRLExpressionImpl(this.createInstance(OWLS_1_1.Expression.SWRL_Condition));
    }

    @Override
    public Condition createSWRLCondition(URI uri) {
        return new SWRLExpressionImpl(this.createInstance(OWLS_1_1.Expression.SWRL_Condition, uri));
    }

    public Condition createSWRLCondition(OWLIndividual ind) {
        return new SWRLExpressionImpl(ind);
    }

    @Override
    public Expression createSWRLExpression() {
        return new SWRLExpressionImpl(this.createInstance(OWLS_1_1.Expression.SWRL_Expression));
    }

    @Override
    public Expression createSWRLExpression(URI uri) {
        return new SWRLExpressionImpl(this.createInstance(OWLS_1_1.Expression.SWRL_Expression, uri));
    }

    public Expression createSWRLExpression(OWLIndividual ind) {
        return new SWRLExpressionImpl(ind);
    }

    @Override
    public ForEach createForEach() {
        return this.createForEach(this.createInstance(OWLS_1_1.Process.ForEach));
    }

    @Override
    public ForEach createForEach(URI uri) {
        return this.createForEach(this.createInstance(OWLS_1_1.Process.ForEach, uri));
    }

    public ForEach createForEach(OWLIndividual ind) {
        return new ForEachImpl(ind);
    }

    @Override
    public Grounding createGrounding() {
        return this.createGrounding(this.createInstance(OWLS_1_1.Grounding.WsdlGrounding));
    }

    @Override
    public Grounding createGrounding(URI uri) {
        return this.createGrounding(this.createInstance(OWLS_1_1.Grounding.WsdlGrounding, uri));
    }

    public Grounding createGrounding(OWLIndividual ind) {
        return new GroundingImpl(ind);
    }

    @Override
    public IfThenElse createIfThenElse() {
        return new IfThenElseImpl(this.createInstance(OWLS_1_1.Process.IfThenElse));
    }

    @Override
    public IfThenElse createIfThenElse(URI uri) {
        return new IfThenElseImpl(this.createInstance(OWLS_1_1.Process.IfThenElse, uri));
    }

    public IfThenElse createIfThenElse(OWLIndividual ind) {
        return new IfThenElseImpl(ind);
    }

    @Override
    public Input createInput() {
        return new InputImpl(this.createInstance(OWLS_1_1.Process.Input));
    }

    @Override
    public Input createInput(URI uri) {
        return new InputImpl(this.createInstance(OWLS_1_1.Process.Input, uri));
    }

    public Input createInput(OWLIndividual ind) {
        return new InputImpl(ind);
    }

    @Override
    public InputBinding createInputBinding() {
        return new InputBindingImpl(this.createInstance(OWLS_1_1.Process.InputBinding));
    }

    @Override
    public InputBinding createInputBinding(URI uri) {
        return new InputBindingImpl(this.createInstance(OWLS_1_1.Process.InputBinding, uri));
    }

    public InputBinding createInputBinding(OWLIndividual ind) {
        return new InputBindingImpl(ind);
    }

    @Override
    public Local createLocal() {
        return this.createLocal(this.createInstance(OWLS_1_1.Process.Local));
    }

    @Override
    public Local createLocal(URI uri) {
        return this.createLocal(this.createInstance(OWLS_1_1.Process.Local, uri));
    }

    public Local createLocal(OWLIndividual ind) {
        return new LocalImpl(ind);
    }

    public MessageMap<String> createWSDLMessageMap(OWLIndividual ind) {
        return new WSDLMessageMapImpl(ind);
    }

    @Override
    public MessageMap<String> createWSDLInputMessageMap() {
        return this.createWSDLMessageMap(this.createInstance(OWLS_1_1.Grounding.WsdlInputMessageMap));
    }

    @Override
    public MessageMap<String> createWSDLInputMessageMap(URI uri) {
        return this.createWSDLMessageMap(this.createInstance(OWLS_1_1.Grounding.WsdlInputMessageMap, uri));
    }

    @Override
    public MessageMap<String> createWSDLOutputMessageMap() {
        return this.createWSDLMessageMap(this.createInstance(OWLS_1_1.Grounding.WsdlOutputMessageMap));
    }

    @Override
    public MessageMap<String> createWSDLOutputMessageMap(URI uri) {
        return this.createWSDLMessageMap(this.createInstance(OWLS_1_1.Grounding.WsdlOutputMessageMap, uri));
    }

    @Override
    public MessageMap<String> createUPnPMessageMap() {
        return this.createUPnPMessageMap(this.createInstance(FLAServiceOnt.UPnPMap));
    }

    @Override
    public MessageMap<String> createUPnPMessageMap(URI uri) {
        return this.createUPnPMessageMap(this.createInstance(FLAServiceOnt.UPnPMap, uri));
    }

    public MessageMap<String> createUPnPMessageMap(OWLIndividual ind) {
        return new UPnPMessageMapImpl(ind);
    }

    @Override
    public Output createOutput() {
        return new OutputImpl(this.createInstance(OWLS_1_1.Process.Output));
    }

    @Override
    public Output createOutput(URI uri) {
        return new OutputImpl(this.createInstance(OWLS_1_1.Process.Output, uri));
    }

    public Output createOutput(OWLIndividual ind) {
        return new OutputImpl(ind);
    }

    @Override
    public OutputBinding createOutputBinding() {
        return new OutputBindingImpl(this.createInstance(OWLS_1_1.Process.OutputBinding));
    }

    @Override
    public OutputBinding createOutputBinding(URI uri) {
        return new OutputBindingImpl(this.createInstance(OWLS_1_1.Process.OutputBinding, uri));
    }

    public OutputBinding createOutputBinding(OWLIndividual ind) {
        return new OutputBindingImpl(ind);
    }

    @Override
    public Perform createPerform() {
        return new PerformImpl(this.createInstance(OWLS_1_1.Process.Perform));
    }

    @Override
    public Perform createPerform(URI uri) {
        return new PerformImpl(this.createInstance(OWLS_1_1.Process.Perform, uri));
    }

    @Override
    public Perform createPerform(OWLIndividual ind) {
        return new PerformImpl(ind);
    }

    @Override
    public Produce createProduce() {
        return this.createProduce(this.createInstance(OWLS_1_1.Process.Produce));
    }

    @Override
    public Produce createProduce(URI uri) {
        return this.createProduce(this.createInstance(OWLS_1_1.Process.Produce, uri));
    }

    public Produce createProduce(OWLIndividual ind) {
        return new ProduceImpl(ind);
    }

    @Override
    public Profile createProfile() {
        return this.createProfile(this.createInstance(OWLS_1_1.Profile.Profile));
    }

    @Override
    public Profile createProfile(URI uri) {
        return this.createProfile(this.createInstance(OWLS_1_1.Profile.Profile, uri));
    }

    public Profile createProfile(OWLIndividual ind) {
        return new ProfileImpl(ind);
    }

    @Override
    public RepeatUntil createRepeatUntil() {
        return new RepeatUntilImpl(this.createInstance(OWLS_1_1.Process.RepeatUntil));
    }

    @Override
    public RepeatUntil createRepeatUntil(URI uri) {
        return new RepeatUntilImpl(this.createInstance(OWLS_1_1.Process.RepeatUntil, uri));
    }

    public RepeatUntil createRepeatUntil(OWLIndividual ind) {
        return new RepeatUntilImpl(ind);
    }

    @Override
    public RepeatWhile createRepeatWhile() {
        return new RepeatWhileImpl(this.createInstance(OWLS_1_1.Process.RepeatWhile));
    }

    @Override
    public RepeatWhile createRepeatWhile(URI uri) {
        return new RepeatWhileImpl(this.createInstance(OWLS_1_1.Process.RepeatWhile, uri));
    }

    public RepeatWhile createRepeatWhile(OWLIndividual ind) {
        return new RepeatWhileImpl(ind);
    }

    @Override
    public Result createResult() {
        return new ResultImpl(this.createInstance(OWLS_1_1.Process.Result));
    }

    @Override
    public Result createResult(URI uri) {
        return new ResultImpl(this.createInstance(OWLS_1_1.Process.Result, uri));
    }

    public Result createResult(OWLIndividual ind) {
        return new ResultImpl(ind);
    }

    @Override
    public Sequence createSequence() {
        return this.createSequence(this.createInstance(OWLS_1_1.Process.Sequence));
    }

    @Override
    public Sequence createSequence(URI uri) {
        return this.createSequence(this.createInstance(OWLS_1_1.Process.Sequence, uri));
    }

    public Sequence createSequence(OWLIndividual ind) {
        return new SequenceImpl(ind);
    }

    @Override
    public Service createService() {
        return this.createService(this.createInstance(OWLS_1_1.Service.Service));
    }

    @Override
    public Service createService(URI uri) {
        return this.createService(this.createInstance(OWLS_1_1.Service.Service, uri));
    }

    public Service createService(OWLIndividual ind) {
        return new ServiceImpl(ind);
    }

    @Override
    public ServiceParameter createServiceParameter() {
        return this.createServiceParameter(this.createInstance(OWLS_1_1.Profile.ServiceParameter));
    }

    @Override
    public ServiceParameter createServiceParameter(URI uri) {
        return this.createServiceParameter(this.createInstance(OWLS_1_1.Profile.ServiceParameter, uri));
    }

    public ServiceParameter createServiceParameter(OWLIndividual ind) {
        return new ServiceParameterImpl(ind);
    }

    @Override
    public Split createSplit() {
        return this.createSplit(this.createInstance(OWLS_1_1.Process.Split));
    }

    @Override
    public Split createSplit(URI uri) {
        return this.createSplit(this.createInstance(OWLS_1_1.Process.Split, uri));
    }

    public Split createSplit(OWLIndividual ind) {
        return new SplitImpl(ind);
    }

    @Override
    public SplitJoin createSplitJoin() {
        return this.createSplitJoin(this.createInstance(OWLS_1_1.Process.SplitJoin));
    }

    @Override
    public SplitJoin createSplitJoin(URI uri) {
        return this.createSplitJoin(this.createInstance(OWLS_1_1.Process.SplitJoin, uri));
    }

    public SplitJoin createSplitJoin(OWLIndividual ind) {
        return new SplitJoinImpl(ind);
    }

    @Override
    public UPnPAtomicGrounding createUPnPAtomicGrounding() {
        return this.createUPnPAtomicGrounding(this.createInstance(FLAServiceOnt.UPnPAtomicProcessGrounding));
    }

    @Override
    public UPnPAtomicGrounding createUPnPAtomicGrounding(URI uri) {
        return this.createUPnPAtomicGrounding(this.createInstance(FLAServiceOnt.UPnPAtomicProcessGrounding, uri));
    }

    public UPnPAtomicGrounding createUPnPAtomicGrounding(OWLIndividual ind) {
        return new UPnPAtomicGroundingImpl(ind);
    }

    @Override
    public JavaAtomicGrounding createJavaAtomicGrounding() {
        return this.createJavaAtomicGrounding(this.createInstance(MoreGroundings.JavaAtomicProcessGrounding));
    }

    @Override
    public JavaAtomicGrounding createJavaAtomicGrounding(URI uri) {
        return this.createJavaAtomicGrounding(this.createInstance(MoreGroundings.JavaAtomicProcessGrounding, uri));
    }

    public JavaAtomicGrounding createJavaAtomicGrounding(OWLIndividual ind) {
        return new JavaAtomicGroundingImpl(ind);
    }

    @Override
    public Grounding createJavaGrounding() {
        return this.createJavaGrounding(this.createInstance(MoreGroundings.JavaGrounding));
    }

    @Override
    public Grounding createJavaGrounding(URI uri) {
        return this.createJavaGrounding(this.createInstance(MoreGroundings.JavaGrounding, uri));
    }

    public Grounding createJavaGrounding(OWLIndividual ind) {
        return new GroundingImpl(ind);
    }

    @Override
    public ValueOf createValueOf() {
        return new ValueOfImpl(this.createInstance(OWLS_1_1.Process.ValueOf));
    }

    @Override
    public ValueOf createValueOf(URI uri) {
        return new ValueOfImpl(this.createInstance(OWLS_1_1.Process.ValueOf, uri));
    }

    public ValueOf createValueOf(OWLIndividual ind) {
        return new ValueOfImpl(ind);
    }

    @Override
    public ValueData createValueData(OWLValue dataValue, Binding enclosingBinding) {
        return new ValueDataImpl(dataValue, enclosingBinding);
    }

    @Override
    public WSDLAtomicGrounding createWSDLAtomicGrounding() {
        return this.createWSDLAtomicGrounding(this.createInstance(OWLS_1_1.Grounding.WsdlAtomicProcessGrounding));
    }

    @Override
    public WSDLAtomicGrounding createWSDLAtomicGrounding(URI uri) {
        return this.createWSDLAtomicGrounding(this.createInstance(OWLS_1_1.Grounding.WsdlAtomicProcessGrounding, uri));
    }

    public WSDLAtomicGrounding createWSDLAtomicGrounding(OWLIndividual ind) {
        return new WSDLAtomicGroundingImpl(ind);
    }

    @Override
    public WSDLOperationRef createWSDLOperationRef() {
        return new WSDLOperationRefImpl(this.createInstance(OWLS_1_1.Grounding.WsdlOperationRef));
    }

    @Override
    public WSDLOperationRef createWSDLOperationRef(URI uri) {
        return new WSDLOperationRefImpl(this.createInstance(OWLS_1_1.Grounding.WsdlOperationRef, uri));
    }

    @Override
    public Service getService() {
        List<Service> list = this.getServices();
        return list.isEmpty() ? null : list.get(0);
    }

    @Override
    public List<Service> getServices() {
        return OWLFactory.wrapList(this.getInstances(OWLS_1_1.Service.Service), Service.class);
    }

    @Override
    public Service getService(URI serviceURI) {
        OWLIndividual ind = this.getIndividual(serviceURI);
        return ind == null ? null : ind.castTo(Service.class);
    }

    @Override
    public List<Profile> getProfiles() {
        return OWLFactory.wrapList(this.getInstances(OWLS_1_1.Profile.Profile), Profile.class);
    }

    @Override
    public Profile getProfile(URI profileURI) {
        OWLIndividual ind = this.getIndividual(profileURI);
        return ind == null ? null : ind.castTo(Profile.class);
    }

    @Override
    public List<Process> getProcesses() {
        return OWLFactory.wrapList(this.getInstances(OWLS_1_1.Process.Process), Process.class);
    }

    @Override
    public List<? extends Process> getProcesses(int type) {
        switch (type) {
            case 7: {
                return OWLFactory.wrapList(this.getInstances(OWLS_1_1.Process.Process), Process.class);
            }
            case 1: {
                return OWLFactory.wrapList(this.getInstances(OWLS_1_1.Process.AtomicProcess), AtomicProcess.class);
            }
            case 2: {
                return OWLFactory.wrapList(this.getInstances(OWLS_1_1.Process.CompositeProcess), CompositeProcess.class);
            }
            case 4: {
                return OWLFactory.wrapList(this.getInstances(OWLS_1_1.Process.SimpleProcess), SimpleProcess.class);
            }
        }
        return null;
    }

    @Override
    public Process getProcess(URI processURI) {
        OWLIndividual ind = this.getIndividual(processURI);
        return ind == null ? null : ind.castTo(Process.class);
    }

    @Override
    public ControlConstructList createControlConstructList(ControlConstruct cc) {
        OWLList list = this.createList(OWLS_1_1.CCList, cc);
        return list.castTo(ControlConstructList.class);
    }

    @Override
    public ControlConstructBag createControlConstructBag(ControlConstruct cc) {
        OWLList list = this.createList(OWLS_1_1.CCBag, cc);
        return list.castTo(ControlConstructBag.class);
    }

    @Override
    public boolean isLockSupported() {
        return true;
    }

    @Override
    public void lockForRead() {
        this.ontModel.enterCriticalSection(true);
    }

    @Override
    public void lockForWrite() {
        this.ontModel.enterCriticalSection(false);
    }

    @Override
    public void releaseLock() {
        this.ontModel.leaveCriticalSection();
    }

    @Override
    public OWLWriter getWriter() {
        if (this.writer == null) {
            this.writer = OWLFactory.createWriter();
            this.writer.setNsPrefix("service", "http://www.daml.org/services/owl-s/1.1/Service.owl#");
            this.writer.setNsPrefix("profile", "http://www.daml.org/services/owl-s/1.1/Profile.owl#");
            this.writer.setNsPrefix("process", "http://www.daml.org/services/owl-s/1.1/Process.owl#");
            this.writer.setNsPrefix("grounding", "http://www.daml.org/services/owl-s/1.1/Grounding.owl#");
            this.writer.setNsPrefix("expression", "http://www.daml.org/services/owl-s/1.1/generic/Expression.owl#");
            this.writer.setNsPrefix("swrl", "http://www.w3.org/2003/11/swrl#");
            this.writer.setNsPrefix("list", URIUtils.getNameSpace(OWLS_1_1.ObjList.List().getURI().toString()));
            this.writer.addPrettyType(OWLS_1_1.Service.Service);
            this.writer.addPrettyType(OWLS_1_1.Service.ServiceGrounding);
            this.writer.addPrettyType(OWLS_1_1.Profile.Profile);
            this.writer.addPrettyType(OWLS_1_1.Process.Process);
            this.writer.addPrettyType(OWLS_1_1.Process.AtomicProcess);
            this.writer.addPrettyType(OWLS_1_1.Process.CompositeProcess);
            this.writer.addPrettyType(OWLS_1_1.Process.SimpleProcess);
            this.writer.addPrettyType(OWLS_1_1.Process.Perform);
            this.writer.addPrettyType(OWLS_1_1.Grounding.WsdlGrounding);
            this.writer.addPrettyType(OWLS_1_1.Grounding.WsdlAtomicProcessGrounding);
        }
        return this.writer;
    }

    @Override
    public void write(Writer out) {
        this.getWriter().write((OWLModel)this, out);
    }

    @Override
    public void write(Writer out, URI baseURI) {
        this.getWriter().write((OWLModel)this, out, baseURI);
    }

    @Override
    public void write(OutputStream out) {
        this.getWriter().write((OWLModel)this, out);
    }

    @Override
    public void write(OutputStream out, URI baseURI) {
        this.getWriter().write((OWLModel)this, out, baseURI);
    }
}

