/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFSyntax;
import impl.jena.OWLKnowledgeBaseImpl;
import impl.jena.OWLModelImpl;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLModel;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLWriter;

public class OWLWriterImpl
implements OWLWriter {
    private static final Charset defaultCharset = Charset.forName("UTF8");
    private final List<Object> prettyTypes = new ArrayList<Object>();
    private final Map<String, String> prefixMap = new HashMap<String, String>();
    private boolean showXmlDeclaration = true;

    public boolean isShowXmlDeclaration() {
        return this.showXmlDeclaration;
    }

    public void setShowXmlDeclaration(boolean showXmlDeclaration) {
        this.showXmlDeclaration = showXmlDeclaration;
    }

    private void writeInternal(OWLModel theOntology, Writer out, URI baseURI) {
        String baseURIasString;
        OntModel model = null;
        String string = baseURIasString = baseURI != null ? baseURI.toString() : null;
        if (theOntology instanceof OWLKnowledgeBaseImpl) {
            model = ModelFactory.createOntologyModel();
            OWLKnowledgeBaseImpl kb = (OWLKnowledgeBaseImpl)theOntology;
            Ontology aOntNode = null;
            if (baseURIasString == null) {
                Resource resource = model.createResource();
                resource.addProperty(RDF.type, (RDFNode)OWL.Ontology);
                aOntNode = (Ontology)resource.as(Ontology.class);
            } else {
                aOntNode = model.getOntology(baseURIasString);
            }
            for (OWLOntology oWLOntology : kb.getOntologies(true)) {
                if (kb.notImported.contains(oWLOntology) || kb.getBaseOntology().equals(oWLOntology)) {
                    model.add((Model)oWLOntology.getImplementation());
                    continue;
                }
                aOntNode.addImport(model.getResource(oWLOntology.getURI().toString()));
            }
        } else {
            model = ((OWLModelImpl)theOntology).getImplementation();
        }
        OntModel aOutModel = ModelFactory.createOntologyModel();
        aOutModel.add(model.getBaseModel());
        RDFWriter writer = aOutModel.getWriter("RDF/XML-ABBREV");
        writer.setProperty("blockRules", (Object)new Resource[]{RDFSyntax.propertyAttr, RDFSyntax.sectionListExpand});
        writer.setProperty("showXmlDeclaration", (Object)this.showXmlDeclaration);
        writer.setProperty("allowBadURIs", (Object)Boolean.TRUE);
        writer.setProperty("prettyTypes", (Object)this.prettyTypes.toArray(new Resource[this.prettyTypes.size()]));
        for (Map.Entry entry : this.prefixMap.entrySet()) {
            aOutModel.setNsPrefix((String)entry.getKey(), (String)entry.getValue());
        }
        if (baseURIasString != null) {
            writer.setProperty("xmlbase", (Object)baseURIasString);
            aOutModel.setNsPrefix("", baseURIasString);
        }
        if (theOntology instanceof OWLOntology) {
            this.handleImports((OWLOntology)theOntology, aOutModel, baseURIasString);
        }
        writer.write(aOutModel.getBaseModel(), out, baseURIasString);
    }

    private void handleImports(OWLOntology theOntology, OntModel theModel, String baseURIasString) {
        Ontology aOntNode = null;
        Ontology aBlankOnt = theModel.getOntology("");
        if (theOntology.getURI() != null) {
            Ontology aNamedOnt = null;
            if (baseURIasString != null) {
                aNamedOnt = theModel.getOntology(baseURIasString);
            } else {
                theModel.getOntology(theOntology.getURI().toString());
            }
            if (aNamedOnt != null) {
                aOntNode = aNamedOnt;
            }
        }
        if (aOntNode == null && theOntology.getImports(true).size() > 0) {
            ResIterator ontRes = theModel.listSubjectsWithProperty(RDF.type, (RDFNode)OWL.Ontology);
            aOntNode = ontRes.hasNext() ? (Ontology)ontRes.nextResource().as(Ontology.class) : (baseURIasString != null ? theModel.createOntology(baseURIasString) : (theOntology.getURI() == null ? theModel.createOntology(null) : theModel.createOntology(theOntology.getURI().toString())));
        }
        for (OWLOntology aOnt : theOntology.getImports(true)) {
            if (aOnt.getURI() == null) continue;
            aOntNode.addImport(theModel.getResource(aOnt.getURI().toString()));
        }
    }

    public void setNsPrefix(String prefix, String uri) {
        this.prefixMap.put(prefix, uri.toString());
    }

    public void addPrettyType(OWLClass c) {
        this.prettyTypes.add(c.getImplementation());
    }

    public void write(OWLModel ont, Writer writer) {
        this.writeInternal(ont, writer, null);
    }

    public void write(OWLModel ont, Writer writer, URI baseURI) {
        this.writeInternal(ont, writer, baseURI);
    }

    public void write(OWLModel ont, OutputStream out) {
        this.writeInternal(ont, new OutputStreamWriter(out, defaultCharset), null);
    }

    public void write(OWLModel ont, OutputStream out, URI baseURI) {
        this.writeInternal(ont, new OutputStreamWriter(out, defaultCharset), baseURI);
    }
}

