/*
 * Decompiled with CFR 0.152.
 */
package impl.owl;

import java.util.LinkedHashSet;
import org.mindswap.exceptions.CastingException;
import org.mindswap.exceptions.ConversionException;
import org.mindswap.owl.OWLConfig;
import org.mindswap.owl.OWLObject;
import org.mindswap.owl.OWLObjectConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinedOWLConverter<T extends OWLObject, U extends T>
implements OWLObjectConverter<T> {
    private final LinkedHashSet<OWLObjectConverter<? extends T>> converters;
    private final Class<U> javaClass;

    public CombinedOWLConverter(Class<U> javaClass, LinkedHashSet<OWLObjectConverter<? extends T>> converters) {
        assert (javaClass != null && converters != null) : "Illegal: Either Java class and/or converter list was null.";
        this.converters = converters;
        this.javaClass = javaClass;
    }

    @Override
    public boolean canCast(OWLObject object) {
        boolean strict = OWLConfig.setStrictConversion(true);
        for (OWLObjectConverter oWLObjectConverter : this.converters) {
            if (!oWLObjectConverter.canCast(object)) continue;
            OWLConfig.setStrictConversion(strict);
            return true;
        }
        OWLConfig.setStrictConversion(strict);
        return false;
    }

    @Override
    public T cast(OWLObject object) {
        boolean strict = OWLConfig.setStrictConversion(true);
        for (OWLObjectConverter oWLObjectConverter : this.converters) {
            if (!oWLObjectConverter.canCast(object)) continue;
            OWLConfig.setStrictConversion(strict);
            return oWLObjectConverter.cast(object);
        }
        OWLConfig.setStrictConversion(strict);
        throw new CastingException("OWLObject " + object + " cannot be cast to " + this.javaClass);
    }

    @Override
    public T convert(OWLObject object) {
        if (!this.canCast(object)) {
            throw new ConversionException("Cannot convert " + object + " to abstract class " + this.javaClass);
        }
        return this.cast(object);
    }
}

