/*
 * Decompiled with CFR 0.152.
 */
package impl.owl;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Set;
import org.mindswap.exceptions.CastingException;
import org.mindswap.exceptions.ConversionException;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLConfig;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLObject;
import org.mindswap.owl.OWLObjectConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOWLConverter<T extends OWLObject>
implements OWLObjectConverter<T> {
    private final Class<? extends T> target;
    private final OWLClass source;
    private final Set<? extends OWLObject> individuals;
    private final Constructor<? extends T> constructor;

    public GenericOWLConverter(Class<? extends T> target, OWLClass source) {
        this(target, source, Collections.EMPTY_SET);
    }

    public GenericOWLConverter(Class<? extends T> target, OWLClass source, Set<T> individuals) {
        this.target = target;
        this.source = source;
        this.individuals = individuals;
        try {
            this.constructor = this.target.getConstructor(OWLIndividual.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean canCast(OWLObject object) {
        return object instanceof OWLIndividual && (!OWLConfig.getStrictConversion() || ((OWLIndividual)object).isType(this.source) || this.individuals.contains(object));
    }

    @Override
    public T cast(OWLObject object) {
        if (!this.canCast(object)) {
            throw new ConversionException("OWLObject " + object + " cannot be cast to " + this.source);
        }
        try {
            return (T)((OWLObject)this.constructor.newInstance((OWLIndividual)object));
        }
        catch (Exception e) {
            throw new CastingException("OWLObject " + object + " cannot be cast to " + this.target);
        }
    }

    @Override
    public T convert(OWLObject object) {
        if (!this.canCast(object)) {
            ((OWLIndividual)object).addType(this.source);
        }
        return this.cast(object);
    }

    public String toString() {
        return "Converter " + this.source + " -> " + this.target;
    }
}

