/*
 * Decompiled with CFR 0.152.
 */
package impl.owl;

import org.mindswap.exceptions.ConversionException;
import org.mindswap.owl.OWLConfig;
import org.mindswap.owl.OWLObject;
import org.mindswap.owl.OWLObjectConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OWLObjectImpl
implements OWLObject {
    private OWLObject next = this;

    @Override
    public OWLObject getNextView() {
        return this.next;
    }

    @Override
    public void setNextView(OWLObject nextView) {
        this.next = nextView;
    }

    private void addView(OWLObject newView) {
        newView.setNextView(this.next);
        this.next = newView;
    }

    private <T extends OWLObject> T findView(Class<T> javaClass) {
        OWLObject obj = this;
        do {
            if (!javaClass.isInstance(obj)) continue;
            return (T)((OWLObject)javaClass.cast(obj));
        } while ((obj = obj.getNextView()) != this);
        return null;
    }

    @Override
    public <T extends OWLObject> T castTo(Class<T> javaClass) {
        T view = this.findView(javaClass);
        if (view == null) {
            OWLObjectConverter<T> converter = OWLConfig.getConverter(javaClass);
            if (converter == null) {
                throw new ConversionException("No converter found for " + javaClass);
            }
            view = converter.cast(this);
            this.addView((OWLObject)view);
        }
        return view;
    }

    @Override
    public boolean canCastTo(Class<? extends OWLObject> javaClass) {
        OWLObjectConverter<? extends OWLObject> converter = OWLConfig.getConverter(javaClass);
        return converter != null && converter.canCast(this);
    }

    public String toString() {
        return this.getImplementation().toString();
    }

    public boolean equals(Object object) {
        if (object instanceof OWLObjectImpl) {
            return this.getImplementation().equals(((OWLObjectImpl)object).getImplementation());
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getImplementation().hashCode();
        return hash;
    }
}

