/*
 * Decompiled with CFR 0.152.
 */
package impl.owl.list;

import impl.owl.WrappedIndividual;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.mindswap.exceptions.InvalidListException;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.list.ListVocabulary;
import org.mindswap.owl.list.OWLList;
import org.mindswap.owl.vocabulary.RDF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLListImpl
extends WrappedIndividual
implements OWLList {
    protected ListVocabulary vocabulary;

    public OWLListImpl(OWLIndividual ind) {
        super(ind);
        this.setVocabulary(RDF.ListVocabulary);
    }

    @Override
    public OWLList getRest() {
        return this.getProperty(this.vocabulary.rest()).castTo(OWLList.class);
    }

    @Override
    public void setRest(OWLList rest) {
        this.setProperty(this.vocabulary.rest(), rest);
    }

    public void setRestToNil() {
        this.setProperty(this.vocabulary.rest(), this.vocabulary.nil());
    }

    @Override
    public OWLValue getFirst() {
        OWLIndividual value = this.getProperty(this.vocabulary.first());
        if (value != null) {
            return value;
        }
        return this.getProperty(this.vocabulary.firstD());
    }

    @Override
    public void setFirst(OWLValue value) {
        if (value == null) {
            this.setProperty(this.vocabulary.firstD(), (Object)this.vocabulary.nil());
        } else if (value instanceof OWLDataValue) {
            this.setProperty(this.vocabulary.firstD(), (OWLDataValue)value);
        } else {
            this.setProperty(this.vocabulary.first(), (OWLIndividual)value);
        }
    }

    @Override
    public List<OWLValue> getAllValues() {
        ArrayList<OWLValue> result = new ArrayList<OWLValue>();
        OWLList list = this;
        while (!list.isEmpty()) {
            result.add(list.getFirst());
            list = list.getRest();
        }
        return result;
    }

    @Override
    public OWLValue get(int index) {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException();
        }
        return index == 0 ? this.getFirst() : this.getRest().get(index - 1);
    }

    @Override
    public OWLList add(OWLValue item) {
        if (this.isEmpty()) {
            return this.insert(item);
        }
        OWLList rest = this.getRest();
        if (rest.isEmpty()) {
            this.setRest(rest.insert(item));
        } else {
            rest.add(item);
        }
        return this;
    }

    @Override
    public OWLList insert(OWLValue first) {
        OWLListImpl list = new OWLListImpl(this.getOntology().createInstance((OWLClass)this.vocabulary.List()));
        list.setVocabulary(this.vocabulary);
        list.setFirst(first);
        list.setRest(this);
        return list;
    }

    @Override
    public OWLList insertAt(int index, OWLValue value) {
        if (index == 0) {
            return this.insert(value);
        }
        if (index < 0 || this.isEmpty()) {
            throw new IndexOutOfBoundsException();
        }
        OWLList rest = this.getRest();
        return rest.insertAt(index - 1, value);
    }

    @Override
    public OWLList remove(OWLValue value) {
        if (value == null || this.size() == 0) {
            return this;
        }
        if (this.size() == 1 && this.getFirst().equals(value)) {
            return this.remove();
        }
        OWLList rest = this;
        int i = 0;
        while (!rest.isEmpty()) {
            if (rest.getFirst().equals(value)) {
                return this.removeAt(i);
            }
            ++i;
            rest = rest.getRest();
        }
        return this;
    }

    @Override
    public OWLList removeAt(int index) {
        if (index == 0) {
            return this.remove();
        }
        if (index < 0 || this.isEmpty()) {
            throw new IndexOutOfBoundsException();
        }
        this.setRest(this.getRest().removeAt(index - 1));
        return this;
    }

    @Override
    public OWLList remove() {
        OWLList list = this.getRest();
        if (this.size() > 1) {
            list.setFirst(this.getRest().getFirst());
            list.setRest(this.getRest().getRest());
        } else {
            list = this.vocabulary.nil().castTo(OWLList.class);
        }
        if (this.hasProperty(this.vocabulary.first())) {
            this.removeProperties(this.vocabulary.first());
        }
        if (this.hasProperty(this.vocabulary.rest())) {
            this.removeProperties(this.vocabulary.rest());
        }
        this.individual.delete();
        return list;
    }

    @Override
    public OWLList removeAll() {
        OWLList list = this;
        while (list.size() > 0) {
            list = list.remove();
        }
        return list;
    }

    @Override
    public void delete() {
        this.removeAll();
        this.individual.delete();
    }

    @Override
    public void set(int index, OWLValue value) {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("Cannot modify empty list (list:nil)");
        }
        int size = this.size();
        if (index > size) {
            throw new IndexOutOfBoundsException();
        }
        if (index == size) {
            this.add(value);
        } else {
            OWLList list = this;
            int i = 0;
            while (i < index) {
                list = list.getRest();
                ++i;
            }
            list.setFirst(value);
        }
    }

    @Override
    public Iterator<OWLValue> iterator() {
        return new RDFListIterator(this);
    }

    @Override
    public int size() {
        return this.isEmpty() ? 0 : 1 + this.getRest().size();
    }

    @Override
    public boolean isEmpty() {
        return this.equals(this.vocabulary.nil()) || this.getFirst() != null && this.getFirst().equals(this.vocabulary.nil());
    }

    @Override
    public ListVocabulary getVocabulary() {
        return this.vocabulary;
    }

    public void setVocabulary(ListVocabulary vocabulary) {
        this.vocabulary = vocabulary;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RDFListIterator
    implements Iterator<OWLValue> {
        private OWLList list;

        RDFListIterator(OWLList list) {
            this.list = list;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove from ObjList iterator");
        }

        @Override
        public boolean hasNext() {
            return !this.list.isEmpty();
        }

        @Override
        public OWLValue next() {
            if (this.list.isEmpty()) {
                throw new NoSuchElementException();
            }
            OWLValue result = this.list.getFirst();
            this.list = this.list.getRest();
            if (result == null || this.list == null) {
                throw new InvalidListException();
            }
            return result;
        }
    }
}

