/*
 * Decompiled with CFR 0.152.
 */
package impl.owls;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLDataProperty;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLObjectProperty;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLProperty;
import org.mindswap.owl.OWLType;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.list.OWLList;
import org.mindswap.owl.vocabulary.RDFS;
import org.mindswap.owls.OWLSVersionTranslator;
import org.mindswap.owls.generic.list.OWLSObjList;
import org.mindswap.owls.grounding.AtomicGrounding;
import org.mindswap.owls.grounding.Grounding;
import org.mindswap.owls.grounding.UPnPAtomicGrounding;
import org.mindswap.owls.grounding.WSDLAtomicGrounding;
import org.mindswap.owls.process.AnyOrder;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.Choice;
import org.mindswap.owls.process.CompositeProcess;
import org.mindswap.owls.process.Condition;
import org.mindswap.owls.process.Conditional;
import org.mindswap.owls.process.ControlConstruct;
import org.mindswap.owls.process.IfThenElse;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.Iterate;
import org.mindswap.owls.process.MultiConditional;
import org.mindswap.owls.process.Output;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.process.Perform;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.RepeatUntil;
import org.mindswap.owls.process.RepeatWhile;
import org.mindswap.owls.process.Result;
import org.mindswap.owls.process.Sequence;
import org.mindswap.owls.process.SimpleProcess;
import org.mindswap.owls.process.Split;
import org.mindswap.owls.process.SplitJoin;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.service.Service;
import org.mindswap.owls.vocabulary.FLAServiceOnt;
import org.mindswap.owls.vocabulary.OWLS_1_0;
import org.mindswap.owls.vocabulary.OWLS_1_1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLSTranslator_1_0
implements OWLSVersionTranslator {
    private static final Logger logger = LoggerFactory.getLogger(OWLSTranslator_1_0.class);
    private OWLKnowledgeBase kb;
    private OWLOntology inputOnt;
    private OWLOntology outputOnt;
    private final List<URI> profileInputURIs = new ArrayList<URI>();
    private Map<OWLIndividual, OWLIndividual> translation;

    @Override
    public String getVersion() {
        return "1.0";
    }

    @Override
    public boolean canTranslate(OWLOntology ontology) {
        return ontology.getInstances(OWLS_1_0.Service.Service).size() > 0;
    }

    @Override
    public OWLOntology translate(OWLOntology ont) {
        this.kb = OWLFactory.createKB();
        this.inputOnt = this.kb.load(ont, true);
        this.outputOnt = OWLFactory.createOntology(ont.getURI(), false);
        this.translation = new HashMap<OWLIndividual, OWLIndividual>();
        this.translateServices();
        this.translateProfiles();
        this.translateProcesses();
        this.translateGroundings();
        this.translateAtomicGroundings();
        Iterator<OWLOntology> iterator = ont.getImports(true).iterator();
        while (iterator.hasNext()) {
            OWLOntology element;
            OWLOntology imported = element = iterator.next();
            this.outputOnt.addImport(imported);
        }
        this.outputOnt.setTranslationSource(this.inputOnt);
        if (this.canTranslate(ont)) {
            this.outputOnt.addType((OWLIndividual)ont.getInstances(OWLS_1_0.Service.Service).get(0), OWLS_1_0.Service.Service);
        }
        return this.outputOnt;
    }

    private void translateServices() {
        OWLIndividualList<?> list = this.inputOnt.getInstances(OWLS_1_0.Service.Service);
        for (OWLIndividual serviceInfo : list) {
            this.createService(serviceInfo);
        }
    }

    private void translateProfiles() {
        OWLIndividualList<?> list = this.inputOnt.getInstances(OWLS_1_0.Profile.Profile);
        for (OWLIndividual profileInfo : list) {
            this.createProfile(profileInfo);
        }
    }

    private void translateProcesses() {
        OWLClass[] processClass;
        OWLClass[] oWLClassArray = processClass = new OWLClass[]{OWLS_1_0.Process.AtomicProcess, OWLS_1_0.Process.CompositeProcess, OWLS_1_0.Process.SimpleProcess};
        int n = processClass.length;
        int n2 = 0;
        while (n2 < n) {
            OWLClass element = oWLClassArray[n2];
            OWLIndividualList<?> list = this.inputOnt.getInstances(element);
            for (OWLIndividual processInfo : list) {
                this.createProcess(processInfo);
            }
            ++n2;
        }
    }

    private void translateGroundings() {
        OWLClass[] groundingClass;
        OWLClass[] oWLClassArray = groundingClass = new OWLClass[]{OWLS_1_0.Grounding.WsdlGrounding, FLAServiceOnt.UPnPGrounding};
        int n = groundingClass.length;
        int n2 = 0;
        while (n2 < n) {
            OWLClass element = oWLClassArray[n2];
            OWLIndividualList<?> list = this.inputOnt.getInstances(element);
            for (OWLIndividual groundingInfo : list) {
                this.createGrounding(groundingInfo);
            }
            ++n2;
        }
    }

    private void translateAtomicGroundings() {
        OWLClass[] groundingClass;
        OWLClass[] oWLClassArray = groundingClass = new OWLClass[]{OWLS_1_0.Grounding.WsdlAtomicProcessGrounding, FLAServiceOnt.UPnPAtomicProcessGrounding};
        int n = groundingClass.length;
        int n2 = 0;
        while (n2 < n) {
            OWLClass element = oWLClassArray[n2];
            OWLIndividualList<?> list = this.inputOnt.getInstances(element);
            for (OWLIndividual groundingInfo : list) {
                this.createAPGrounding(groundingInfo);
            }
            ++n2;
        }
    }

    private Perform getCachedPerform(Process process, OWLIndividual ind) {
        List<ControlConstruct> components = ((CompositeProcess)process).getComposedOf().getConstructs();
        for (ControlConstruct cc : components) {
            if (!(cc instanceof Perform) || !((Perform)cc).getProcess().equals(ind)) continue;
            return (Perform)cc;
        }
        return null;
    }

    private OWLIndividual translate(OWLIndividual ind, OWLClass owlClass) {
        OWLIndividual translated = this.translation.get(ind);
        if (translated == null) {
            translated = ind.isAnon() ? this.outputOnt.createInstance(owlClass) : this.outputOnt.createInstance(owlClass, ind.getURI());
            if (owlClass != null) {
                translated.addType(owlClass);
            }
            this.translation.put(ind, translated);
        }
        return translated;
    }

    private <T extends OWLIndividual> T translate(OWLIndividual ind, Class<T> javaClass, OWLClass owlClass) {
        OWLIndividual translated = this.translation.get(ind);
        if (translated == null) {
            OWLIndividual newInd = ind.isAnon() ? this.outputOnt.createInstance(owlClass) : this.outputOnt.createInstance(owlClass, ind.getURI());
            translated = (OWLIndividual)newInd.castTo(javaClass);
            this.translation.put(ind, translated);
        }
        return (T)translated;
    }

    private Service createService(OWLIndividual serviceInfo) {
        try {
            OWLIndividual translated = this.translation.get(serviceInfo);
            if (translated != null) {
                return translated.castTo(Service.class);
            }
            Service service = this.translate(serviceInfo, Service.class, OWLS_1_1.Service.Service);
            OWLIndividual profileInfo = this.inputOnt.getProperty(serviceInfo, OWLS_1_0.Service.presents);
            OWLIndividual processModelInfo = this.inputOnt.getProperty(serviceInfo, OWLS_1_0.Service.describedBy);
            OWLIndividual groundingInfo = this.inputOnt.getProperty(serviceInfo, OWLS_1_0.Service.supports);
            Process process = this.createProcessModel(processModelInfo);
            Profile profile = this.createProfile(profileInfo);
            Grounding grounding = this.createGrounding(groundingInfo);
            service.setProcess(process);
            service.setProfile(profile);
            service.setGrounding(grounding);
            this.translateAll(serviceInfo);
            return service;
        }
        catch (RuntimeException e) {
            logger.error("Invalid service description");
            return null;
        }
    }

    private Process createProcessModel(OWLIndividual processModelInfo) {
        OWLIndividual processInfo = this.inputOnt.getProperty(processModelInfo, OWLS_1_0.Process.hasProcess);
        return this.createProcess(processInfo);
    }

    private Process createProcess(OWLIndividual processInfo) {
        Process process;
        block7: {
            try {
                OWLIndividual translated = this.translation.get(processInfo);
                if (translated != null) {
                    return translated.castTo(Process.class);
                }
                process = null;
                if (this.inputOnt.isType(processInfo, OWLS_1_0.Process.AtomicProcess)) {
                    process = this.createAtomicProcess(processInfo);
                    break block7;
                }
                if (this.inputOnt.isType(processInfo, OWLS_1_0.Process.CompositeProcess)) {
                    process = this.createCompositeProcess(processInfo);
                    break block7;
                }
                if (this.inputOnt.isType(processInfo, OWLS_1_0.Process.SimpleProcess)) {
                    process = this.createSimpleProcess(processInfo);
                    break block7;
                }
                logger.error("Unknown process type {}", (Object)processInfo);
                return null;
            }
            catch (RuntimeException e) {
                logger.error("Invalid process description");
                return null;
            }
        }
        this.copyPropertyValues(processInfo, OWLS_1_0.Process.name, (OWLIndividual)process, OWLS_1_1.Process.name);
        this.createProcessParams(process, true, processInfo);
        this.createProcessParams(process, false, processInfo);
        this.createCondition(process, this.inputOnt.getProperties(processInfo, OWLS_1_0.Profile.hasPrecondition));
        this.createDataFlow(process, processInfo);
        return process;
    }

    private AtomicProcess createAtomicProcess(OWLIndividual processInfo) {
        AtomicProcess process = this.translate(processInfo, AtomicProcess.class, OWLS_1_1.Process.AtomicProcess);
        return process;
    }

    private SimpleProcess createSimpleProcess(OWLIndividual processInfo) {
        SimpleProcess process = this.translate(processInfo, SimpleProcess.class, OWLS_1_1.Process.SimpleProcess);
        return process;
    }

    private CompositeProcess createCompositeProcess(OWLIndividual processInfo) {
        CompositeProcess process = this.translate(processInfo, CompositeProcess.class, OWLS_1_1.Process.CompositeProcess);
        OWLIndividual composedInfo = this.inputOnt.getProperty(processInfo, OWLS_1_0.Process.composedOf);
        if (composedInfo == null) {
            logger.error("Cannot find the components for composite process (process: {})", (Object)processInfo);
        } else {
            ControlConstruct controlConstruct = this.createControlConstruct(composedInfo);
            process.setComposedOf(controlConstruct);
        }
        return process;
    }

    private boolean isProcess(OWLIndividual processInfo) {
        return this.inputOnt.isType(processInfo, OWLS_1_0.Process.AtomicProcess) || this.inputOnt.isType(processInfo, OWLS_1_0.Process.CompositeProcess) || this.inputOnt.isType(processInfo, OWLS_1_0.Process.SimpleProcess);
    }

    private ControlConstruct createControlConstruct(OWLIndividual ccInfo) {
        OWLClass ccType = ccInfo.getType();
        ControlConstruct cc = null;
        if (this.isProcess(ccInfo)) {
            cc = this.createPerform(ccInfo);
        } else if (this.inputOnt.isType(ccInfo, OWLS_1_0.Process.Sequence)) {
            cc = this.createSequence(ccInfo);
        } else if (this.inputOnt.isType(ccInfo, OWLS_1_0.Process.Split)) {
            cc = this.createSplit(ccInfo);
        } else if (this.inputOnt.isType(ccInfo, OWLS_1_0.Process.SplitJoin)) {
            cc = this.createSplitJoin(ccInfo);
        } else if (this.inputOnt.isType(ccInfo, OWLS_1_0.Process.Unordered)) {
            cc = this.createAnyOrder(ccInfo);
        } else if (this.inputOnt.isType(ccInfo, OWLS_1_0.Process.IfThenElse)) {
            cc = this.createIfThenElse(ccInfo);
        } else if (this.inputOnt.isType(ccInfo, OWLS_1_0.Process.Choice)) {
            cc = this.createChoice(ccInfo);
        } else if (this.inputOnt.isType(ccInfo, OWLS_1_0.Process.Iterate)) {
            cc = this.createIterate(ccInfo);
        } else if (this.inputOnt.isType(ccInfo, OWLS_1_0.Process.RepeatUntil)) {
            cc = this.createRepeatUntil(ccInfo);
        } else if (this.inputOnt.isType(ccInfo, OWLS_1_0.Process.RepeatWhile)) {
            cc = this.createRepeatWhile(ccInfo);
        } else {
            logger.error("Don't know how to translate the control construct {}", (Object)ccType);
        }
        return cc;
    }

    private Perform createPerform(OWLIndividual processInfo) {
        Perform perform = this.outputOnt.createPerform();
        Process process = this.createProcess(processInfo);
        perform.setProcess(process);
        return perform;
    }

    private Sequence createSequence(OWLIndividual sequenceInfo) {
        Sequence sequence = this.translate(sequenceInfo, Sequence.class, OWLS_1_1.Process.Sequence);
        this.createComponents(sequence, sequenceInfo);
        return sequence;
    }

    private IfThenElse createIfThenElse(OWLIndividual ifThenElseInfo) {
        IfThenElse ifThenElse = this.translate(ifThenElseInfo, IfThenElse.class, OWLS_1_1.Process.IfThenElse);
        if (this.inputOnt.hasProperty(ifThenElseInfo, OWLS_1_0.Process.ifCondition)) {
            this.createCondition(ifThenElse, this.inputOnt.getProperties(ifThenElseInfo, OWLS_1_0.Process.ifCondition));
        } else {
            logger.error("If-Then-Else does not have a process:ifCondition associated with it (ifThenElse: {})", (Object)ifThenElseInfo);
        }
        if (this.inputOnt.hasProperty(ifThenElseInfo, OWLS_1_0.Process.thenP)) {
            OWLIndividual thenComponentInfo = this.inputOnt.getProperty(ifThenElseInfo, OWLS_1_0.Process.thenP);
            ControlConstruct thenComponent = this.createControlConstruct(thenComponentInfo);
            if (thenComponent != null) {
                ifThenElse.setThen(thenComponent);
            } else {
                logger.error("If-Then-Else has an invalid process:then associated with it (ifThenElse: {})", (Object)ifThenElseInfo);
            }
        } else {
            logger.error("If-Then-Else does not have a process:then associated with it (ifThenElse: {}", (Object)ifThenElseInfo);
        }
        if (this.inputOnt.hasProperty(ifThenElseInfo, OWLS_1_0.Process.elseP)) {
            OWLIndividual elseComponentInfo = this.inputOnt.getProperty(ifThenElseInfo, OWLS_1_0.Process.elseP);
            ControlConstruct elseComponent = this.createControlConstruct(elseComponentInfo);
            if (elseComponent != null) {
                ifThenElse.setThen(elseComponent);
            } else {
                logger.error("If-Then-Else has an invalid process:else associated with it (ifThenElse: {}", (Object)ifThenElseInfo);
            }
        }
        return ifThenElse;
    }

    private Split createSplit(OWLIndividual splitInfo) {
        Split split = this.translate(splitInfo, Split.class, OWLS_1_1.Process.Split);
        this.createComponents(split, splitInfo);
        return split;
    }

    private SplitJoin createSplitJoin(OWLIndividual splitInfo) {
        SplitJoin split = this.translate(splitInfo, SplitJoin.class, OWLS_1_1.Process.SplitJoin);
        this.createComponents(split, splitInfo);
        return split;
    }

    private AnyOrder createAnyOrder(OWLIndividual anyOrderInfo) {
        AnyOrder unordered = this.translate(anyOrderInfo, AnyOrder.class, OWLS_1_1.Process.AnyOrder);
        this.createComponents(unordered, anyOrderInfo);
        return unordered;
    }

    private Iterate createIterate(OWLIndividual iterateInfo) {
        Iterate iterate = this.translate(iterateInfo, Iterate.class, OWLS_1_1.Process.Iterate);
        return iterate;
    }

    private RepeatUntil createRepeatUntil(OWLIndividual repeatInfo) {
        RepeatUntil repeat = this.translate(repeatInfo, RepeatUntil.class, OWLS_1_1.Process.RepeatUntil);
        if (this.inputOnt.hasProperty(repeatInfo, OWLS_1_0.Process.untilCondition)) {
            this.createCondition(repeat, this.inputOnt.getProperties(repeatInfo, OWLS_1_0.Process.untilCondition));
        } else {
            logger.error("RepeatUntil does not have a process:untilCondition associated with it (RepeatUntil: {})", (Object)repeat);
        }
        if (this.inputOnt.hasProperty(repeatInfo, OWLS_1_0.Process.components)) {
            logger.error("RepeatUntil cannot have a process:components property. Use process:untilProcess instead!");
        }
        if (this.inputOnt.hasProperty(repeatInfo, OWLS_1_0.Process.untilProcess)) {
            OWLIndividual untilComponentInfo = this.inputOnt.getProperty(repeatInfo, OWLS_1_0.Process.untilProcess);
            ControlConstruct untilComponent = this.createControlConstruct(untilComponentInfo);
            if (untilComponent != null) {
                repeat.setComponent(untilComponent);
            } else {
                logger.error("RepeatUntil has an invalid process:untilProcess associated with it (RepeatUntil: {})", (Object)repeatInfo);
            }
        } else {
            logger.error("RepeatUntil does not have a process:untilProcess associated with it (RepeatUntil: {})", (Object)repeat);
        }
        return repeat;
    }

    private RepeatWhile createRepeatWhile(OWLIndividual repeatInfo) {
        RepeatWhile repeat = this.translate(repeatInfo, RepeatWhile.class, OWLS_1_1.Process.RepeatWhile);
        if (this.inputOnt.hasProperty(repeatInfo, OWLS_1_0.Process.whileCondition)) {
            this.createCondition(repeat, this.inputOnt.getProperties(repeatInfo, OWLS_1_0.Process.whileCondition));
        } else {
            logger.error("RepeatUntil does not have a process:ifCondition associated with it (RepeatWhile: {})", (Object)repeat);
        }
        if (this.inputOnt.hasProperty(repeatInfo, OWLS_1_0.Process.components)) {
            logger.error("RepeatWhile cannot have a process:components property. Use process:untilProcess instead!");
        }
        if (this.inputOnt.hasProperty(repeatInfo, OWLS_1_0.Process.whileProcess)) {
            OWLIndividual whileComponentInfo = this.inputOnt.getProperty(repeatInfo, OWLS_1_0.Process.whileProcess);
            ControlConstruct whileComponent = this.createControlConstruct(whileComponentInfo);
            if (whileComponent != null) {
                repeat.setComponent(whileComponent);
            } else {
                logger.error("RepeatWhile has an invalid process:whileProcess associated with it (RepeatWhile: {})", (Object)repeatInfo);
            }
        } else {
            logger.error("RepeatWhile does not have a process:whileProcess associated with it (RepeatWhile: {})", (Object)repeat);
        }
        return repeat;
    }

    private Choice createChoice(OWLIndividual choiceInfo) {
        Choice choice = this.translate(choiceInfo, Choice.class, OWLS_1_1.Process.Choice);
        this.createComponents(choice, choiceInfo);
        return choice;
    }

    private void createComponents(ControlConstruct cc, OWLIndividual ccInfo) {
        OWLIndividual componentsInfo = this.inputOnt.getProperty(ccInfo, OWLS_1_0.Process.components);
        if (componentsInfo == null) {
            logger.error("{} construct does not have any components associated with it (Construct: {})", (Object)cc.getConstructName(), (Object)ccInfo);
            return;
        }
        OWLSObjList list = componentsInfo.castTo(OWLSObjList.class);
        for (OWLIndividual componentInfo : list) {
            ControlConstruct component = this.createControlConstruct(componentInfo);
            if (component == null) {
                logger.warn("There is an invalid component description for {}", (Object)cc);
                continue;
            }
            if (cc instanceof Sequence) {
                ((Sequence)cc).addComponent(component);
                continue;
            }
            if (cc instanceof AnyOrder) {
                ((AnyOrder)cc).addComponent(component);
                continue;
            }
            if (cc instanceof Choice) {
                ((Choice)cc).addComponent(component);
                continue;
            }
            if (cc instanceof Split) {
                ((Split)cc).addComponent(component);
                continue;
            }
            if (cc instanceof SplitJoin) {
                ((SplitJoin)cc).addComponent(component);
                continue;
            }
            throw new RuntimeException("Invalid control construct!");
        }
    }

    private void createDataFlow(Process process, OWLIndividual processComponentInfo) {
        try {
            OWLIndividualList<?> list = this.inputOnt.getProperties(processComponentInfo, OWLS_1_0.Process.sameValues);
            for (OWLIndividual ind : list) {
                Result result;
                Perform perform;
                OWLSObjList sameValuesList = ind.castTo(OWLSObjList.class);
                OWLIndividual value1 = sameValuesList.get(0);
                OWLIndividual value2 = sameValuesList.get(1);
                OWLIndividual p1 = this.inputOnt.getProperty(value1, OWLS_1_0.Process.theParameter);
                OWLIndividual p2 = this.inputOnt.getProperty(value2, OWLS_1_0.Process.theParameter);
                Parameter param1 = (Parameter)this.translation.get(p1);
                Parameter param2 = (Parameter)this.translation.get(p2);
                OWLIndividual process1 = this.inputOnt.getProperty(value1, OWLS_1_0.Process.atProcess);
                OWLIndividual process2 = this.inputOnt.getProperty(value2, OWLS_1_0.Process.atProcess);
                if (process1.equals(process) && process2.equals(process)) {
                    logger.error("Same process used twice in the ValueOf!");
                    continue;
                }
                if (process1.equals(process)) {
                    perform = this.getCachedPerform(process, process2);
                    if (param1 instanceof Input) {
                        perform.addBinding((Input)param1, OWLS_1_1.Process.TheParentPerform, (Input)param2);
                        continue;
                    }
                    result = process.getResult();
                    if (result == null) {
                        result = this.outputOnt.createResult();
                        process.setResult(result);
                    }
                    result.addBinding((Output)param1, perform, (Output)param2);
                    continue;
                }
                if (process2.equals(process)) {
                    perform = this.getCachedPerform(process, process1);
                    if (param2 instanceof Input) {
                        perform.addBinding((Input)param2, OWLS_1_1.Process.TheParentPerform, (Input)param1);
                        continue;
                    }
                    result = process.getResult();
                    if (result == null) {
                        result = this.outputOnt.createResult();
                        process.setResult(result);
                    }
                    result.addBinding((Output)param2, perform, (Output)param1);
                    continue;
                }
                Perform perform1 = this.getCachedPerform(process, process1);
                Perform perform2 = this.getCachedPerform(process, process2);
                if (param1 instanceof Input) {
                    perform1.addBinding((Input)param1, perform2, (Output)param2);
                    continue;
                }
                perform2.addBinding((Input)param2, perform1, (Output)param1);
            }
        }
        catch (Exception e) {
            logger.error("Invalid data flow specification. Details: ", (Object)e.toString());
        }
    }

    private Parameter createParam(OWLIndividual paramInfo) {
        OWLIndividual translated = this.translation.get(paramInfo);
        if (translated != null) {
            return translated.castTo(Parameter.class);
        }
        Parameter param = null;
        if (this.inputOnt.isType(paramInfo, OWLS_1_0.Process.Input)) {
            param = this.translate(paramInfo, Input.class, OWLS_1_1.Process.Input);
        } else if (this.inputOnt.isType(paramInfo, OWLS_1_0.Process.Output)) {
            param = this.translate(paramInfo, Output.class, OWLS_1_1.Process.Output);
        } else {
            logger.error("Unknown parameter type {}", (Object)paramInfo);
            return null;
        }
        if (this.inputOnt.hasProperty(paramInfo, OWLS_1_0.Process.parameterType)) {
            URI typeURI = this.inputOnt.getProperty(paramInfo, OWLS_1_0.Process.parameterType).getURI();
            if (typeURI != null) {
                OWLType type = this.inputOnt.getType(typeURI);
                if (type == null) {
                    type = this.outputOnt.createClass(typeURI);
                }
                param.setParamType(type);
            }
        } else {
            logger.error("Cannot find the type for the process parameter (parameter: {})", (Object)param);
        }
        this.keepFLAProperties(paramInfo);
        if (this.inputOnt.isType(paramInfo, OWLS_1_0.Process.Input)) {
            try {
                if (!this.profileInputURIs.contains(param.getURI()) && paramInfo.getProperties().size() <= 1) {
                    param.addProperty(FLAServiceOnt.useRandomInput, "true");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return param;
    }

    private void createProcessParams(Process process, boolean isInput, OWLIndividual processInfo) {
        OWLObjectProperty prop = isInput ? OWLS_1_0.Process.hasInput : OWLS_1_0.Process.hasOutput;
        OWLIndividualList<?> list = this.inputOnt.getProperties(processInfo, prop);
        for (OWLIndividual p : list) {
            Parameter param = null;
            if (isInput) {
                param = this.createParam(p);
                process.addInput((Input)param);
            } else {
                param = this.createParam(p);
                process.addOutput((Output)param);
            }
            this.copyPropertyValues(p, RDFS.label, (OWLIndividual)param, RDFS.label);
            logger.debug("Process {} {} {} Type {}", new Object[]{process.getURI(), isInput ? "Input" : "Output", param.getURI(), param.getParamType()});
        }
    }

    private Profile createProfile(OWLIndividual profileInfo) {
        try {
            OWLIndividual translated = this.translation.get(profileInfo);
            if (translated != null) {
                return translated.castTo(Profile.class);
            }
            Profile profile = this.translate(profileInfo, Profile.class, OWLS_1_1.Profile.Profile);
            this.copyPropertyValues(profileInfo, OWLS_1_0.Profile.serviceName, (OWLIndividual)profile, OWLS_1_1.Profile.serviceName);
            this.copyPropertyValues(profileInfo, RDFS.label, (OWLIndividual)profile, RDFS.label);
            this.copyPropertyValues(profileInfo, OWLS_1_0.Profile.textDescription, (OWLIndividual)profile, OWLS_1_1.Profile.textDescription);
            this.createProfileParams(profile, true, profileInfo);
            this.createProfileParams(profile, false, profileInfo);
            this.createCondition(profile, this.inputOnt.getProperties(profileInfo, OWLS_1_0.Profile.hasPrecondition));
            this.createServiceParameters(profile, profileInfo);
            this.translateAll(profileInfo);
            this.keepFLAProperties(profileInfo);
            return profile;
        }
        catch (RuntimeException e) {
            logger.error("Invalid profile description");
            return null;
        }
    }

    private void createServiceParameters(Profile profile, OWLIndividual profileInfo) {
        Set<OWLProperty> set = this.kb.getSubProperties(OWLS_1_0.Profile.serviceParameter);
        for (OWLObjectProperty oWLObjectProperty : set) {
            OWLIndividualList<?> list = profileInfo.getProperties(oWLObjectProperty);
            for (OWLIndividual serviceParamInfo : list) {
                OWLIndividual serviceParam = this.translate(serviceParamInfo, serviceParamInfo.getType());
                OWLIndividual serviceParamValue = serviceParamInfo.getProperty(OWLS_1_0.Profile.sParameter);
                serviceParamValue = this.translateAll(serviceParamValue);
                profile.addProperty(oWLObjectProperty, serviceParam);
                serviceParam.addProperty(OWLS_1_1.Profile.sParameter, serviceParamValue);
                this.copyPropertyValues(serviceParamInfo, OWLS_1_0.Profile.serviceParameterName, serviceParam, OWLS_1_1.Profile.serviceParameterName);
            }
        }
    }

    private OWLIndividual translateAll(OWLIndividual ind) {
        OWLIndividual translated = this.translation.get(ind);
        if (translated == null) {
            if (this.isProcess(ind)) {
                return this.createProcess(ind);
            }
            translated = this.translate(ind, ind.getType());
            Map<OWLProperty, List<OWLValue>> map = this.kb.getProperties(ind);
            for (OWLProperty prop : map.keySet()) {
                this.copyPropertyValues(ind, RDFS.label, translated, RDFS.label);
                if (prop instanceof OWLDataProperty) {
                    this.copyPropertyValues(ind, (OWLDataProperty)prop, translated, (OWLDataProperty)prop);
                    continue;
                }
                OWLObjectProperty objProp = (OWLObjectProperty)prop;
                OWLIndividualList<?> list = this.inputOnt.getProperties(ind, objProp);
                for (OWLIndividual value : list) {
                    value = this.translate(value, value.getType());
                    translated.addProperty(objProp, value);
                }
            }
        }
        return translated;
    }

    private void createProfileParams(Profile profile, boolean isInput, OWLIndividual profileInfo) {
        OWLObjectProperty prop = isInput ? OWLS_1_0.Profile.hasInput : OWLS_1_0.Profile.hasOutput;
        OWLIndividualList<?> list = this.inputOnt.getProperties(profileInfo, prop);
        for (OWLIndividual p : list) {
            Parameter refersTo = (Parameter)this.translation.get(p);
            if (refersTo == null) {
                logger.error("The parameter defined in profile does not exist in the process model (parameter: {}, in profile: {})", (Object)p, (Object)profile.getURI());
                continue;
            }
            if (isInput) {
                profile.addInput((Input)refersTo);
                if (refersTo.getURI() != null) {
                    this.profileInputURIs.add(refersTo.getURI());
                }
            } else {
                profile.addOutput((Output)refersTo);
            }
            logger.debug("Profile {} {} {} refers to {}", new Object[]{profile.getURI(), isInput ? "Input" : "Output", p.getURI(), refersTo});
        }
    }

    private void createCondition(Conditional conditional, OWLIndividualList<?> list) {
        if (list.size() == 0) {
            return;
        }
        OWLIndividual conditionInfo = (OWLIndividual)list.get(0);
        Condition condition = this.translate(conditionInfo, Condition.class, OWLS_1_1.Expression.Condition);
        conditional.setCondition(condition);
        if (list.size() > 1) {
            logger.error("Multiple conditions defined for {}", (Object)conditional);
        }
    }

    private void createCondition(MultiConditional conditional, OWLIndividualList<?> list) {
        for (OWLIndividual conditionInfo : list) {
            Condition condition = this.translate(conditionInfo, Condition.class, OWLS_1_1.Expression.Condition);
            conditional.addCondition(condition);
        }
    }

    private Grounding createGrounding(OWLIndividual groundingInfo) {
        AtomicGrounding apGrounding;
        OWLIndividual translated = this.translation.get(groundingInfo);
        if (translated != null) {
            return translated.castTo(Grounding.class);
        }
        Grounding grounding = this.translate(groundingInfo, Grounding.class, OWLS_1_1.Grounding.WsdlGrounding);
        OWLIndividualList<?> list = this.inputOnt.getProperties(groundingInfo, OWLS_1_0.Grounding.hasAtomicProcessGrounding);
        for (OWLIndividual apGroundingInfo : list) {
            apGrounding = this.createAPGrounding(apGroundingInfo);
            if (apGrounding != null) {
                grounding.addGrounding(apGrounding);
                continue;
            }
            logger.error("Invalid AtomicProcess grounding {}", (Object)apGroundingInfo);
        }
        list = this.inputOnt.getProperties(groundingInfo, FLAServiceOnt.hasUPnPAtomicProcessGrounding);
        for (OWLIndividual apGroundingInfo : list) {
            apGrounding = this.createAPGrounding(apGroundingInfo);
            if (apGrounding != null) {
                grounding.addGrounding(apGrounding);
                continue;
            }
            logger.error("Invalid AtomicProcess grounding {}", (Object)apGroundingInfo);
        }
        if (grounding.getAtomicGroundings().size() == 0) {
            logger.warn("The grounding of the service is empty (grounding {})", (Object)grounding.getURI());
        }
        return grounding;
    }

    private AtomicGrounding createAPGrounding(OWLIndividual groundingInfo) {
        try {
            OWLIndividual translated = this.translation.get(groundingInfo);
            if (translated != null) {
                return translated.castTo(AtomicGrounding.class);
            }
            AtomicGrounding grounding = null;
            if (this.inputOnt.isType(groundingInfo, OWLS_1_0.Grounding.WsdlAtomicProcessGrounding)) {
                grounding = this.createWSDLGrounding(groundingInfo);
            } else if (this.inputOnt.isType(groundingInfo, FLAServiceOnt.UPnPAtomicProcessGrounding)) {
                grounding = this.createUPnPGrounding(groundingInfo);
            }
            return grounding;
        }
        catch (RuntimeException e) {
            logger.error("Invalid profile description. Details: {}", (Object)e.toString());
            return null;
        }
    }

    private URI getGroundingURI(OWLIndividual groundingInfo, OWLDataProperty p) {
        OWLDataValue value = this.inputOnt.getProperty(groundingInfo, p);
        if (value == null) {
            logger.error("{} does not have a grounding: {} property", (Object)groundingInfo, (Object)p.getURI().getFragment());
        }
        try {
            return new URI(value.getLexicalValue().trim());
        }
        catch (Exception e) {
            logger.error("The value of grounding: {} (property {}) in {} is not a valid URI literal", new Object[]{p.getURI().getFragment(), value.getLexicalValue(), groundingInfo});
            return null;
        }
    }

    private AtomicProcess getGroundingProcess(OWLIndividual groundingInfo) {
        OWLIndividual processInfo = this.inputOnt.getProperty(groundingInfo, OWLS_1_0.Grounding.owlsProcess);
        if (!this.inputOnt.hasProperty(groundingInfo, OWLS_1_0.Grounding.owlsProcess)) {
            logger.error("{} does not have a grounding:owlsProcess property", (Object)groundingInfo);
            return null;
        }
        AtomicProcess process = (AtomicProcess)this.createProcess(processInfo);
        if (process == null) {
            logger.error("The process specified in the grounding cannot be found (grounding: {}, process: {})", (Object)groundingInfo, (Object)processInfo);
            return null;
        }
        return process;
    }

    private AtomicGrounding createWSDLGrounding(OWLIndividual groundingInfo) {
        AtomicProcess process = this.getGroundingProcess(groundingInfo);
        URI wsdlLoc = this.getGroundingURI(groundingInfo, OWLS_1_0.Grounding.wsdlDocument);
        OWLIndividual operationInfo = this.inputOnt.getProperty(groundingInfo, OWLS_1_0.Grounding.wsdlOperation);
        URI opName = this.getGroundingURI(operationInfo, OWLS_1_0.Grounding.operation);
        URI portType = this.getGroundingURI(operationInfo, OWLS_1_0.Grounding.portType);
        WSDLAtomicGrounding g = this.translate(groundingInfo, WSDLAtomicGrounding.class, OWLS_1_1.Grounding.WsdlAtomicProcessGrounding);
        g.setWSDL(wsdlLoc);
        g.setOperation(opName);
        g.setPortType(portType);
        if (this.inputOnt.hasProperty(groundingInfo, OWLS_1_0.Grounding.wsdlInputMessage)) {
            g.setInputMessage(this.getGroundingURI(groundingInfo, OWLS_1_0.Grounding.wsdlInputMessage));
        }
        if (process != null) {
            g.setProcess(process);
            this.createMessageMapList(g, groundingInfo, true);
            this.createMessageMapList(g, groundingInfo, false);
        } else {
            logger.error("No OWL-S parameter defined for AtomicProcessGrounding {}", (Object)groundingInfo);
        }
        logger.debug("Process {} WSDL file operation {}", new Object[]{process.getURI(), wsdlLoc, opName});
        return g;
    }

    private AtomicGrounding createUPnPGrounding(OWLIndividual groundingInfo) {
        OWLIndividual processInfo = this.inputOnt.getProperty(groundingInfo, OWLS_1_0.Grounding.owlsProcess);
        String upnpDevice = this.inputOnt.getProperty(groundingInfo, FLAServiceOnt.upnpDeviceURL).toString();
        String upnpService = this.inputOnt.getProperty(groundingInfo, FLAServiceOnt.upnpServiceID).toString();
        String upnpAction = this.inputOnt.getProperty(groundingInfo, FLAServiceOnt.upnpCommand).toString();
        AtomicProcess process = (AtomicProcess)this.createProcess(processInfo);
        UPnPAtomicGrounding g = this.translate(groundingInfo, UPnPAtomicGrounding.class, FLAServiceOnt.UPnPAtomicProcessGrounding);
        g.setProcess(process);
        g.setUPnPDescription(upnpDevice);
        g.setUPnPService(upnpService);
        g.setUPnPAction(upnpAction);
        this.createMessageMapList(g, groundingInfo, true);
        this.createMessageMapList(g, groundingInfo, false);
        logger.debug("Process {} Device {} Service {} Action {}", new Object[]{process.getURI(), upnpDevice, upnpService, upnpAction});
        return g;
    }

    private void createMessageMapList(AtomicGrounding g, OWLIndividual groundingInfo, boolean isInput) {
        AtomicProcess process = g.getProcess();
        OWLObjectProperty messageParts = null;
        OWLObjectProperty olderMessageParts = null;
        OWLDataProperty messagePart = null;
        if (g instanceof UPnPAtomicGrounding) {
            messageParts = isInput ? FLAServiceOnt.upnpInputMapping : FLAServiceOnt.upnpOutputMapping;
            messagePart = FLAServiceOnt.upnpParameter;
        } else if (g instanceof WSDLAtomicGrounding) {
            messageParts = isInput ? OWLS_1_0.Grounding.wsdlInputs : OWLS_1_0.Grounding.wsdlOutputs;
            olderMessageParts = isInput ? OWLS_1_0.Grounding.wsdlInputMessageParts : OWLS_1_0.Grounding.wsdlOutputMessageParts;
            messagePart = OWLS_1_0.Grounding.wsdlMessagePart;
        }
        OWLIndividual messageMaps = this.inputOnt.getProperty(groundingInfo, messageParts);
        if (messageMaps == null && olderMessageParts != null && (messageMaps = this.inputOnt.getProperty(groundingInfo, olderMessageParts)) != null) {
            logger.warn("Using deprecated property {} instead of {}", (Object)olderMessageParts, (Object)messageParts);
        }
        if (messageMaps == null) {
            OWLIndividualList<Parameter> params;
            OWLIndividualList<Parameter> oWLIndividualList = params = isInput ? process.getInputs() : process.getOutputs();
            if (!params.isEmpty()) {
                logger.warn("No mapping defined for parameters (parameters: {}, process: {})", params, (Object)process);
            }
            return;
        }
        OWLList messageMapList = messageMaps.castTo(OWLList.class);
        for (OWLIndividual messageMap : messageMapList) {
            URI owlsParameterInfo = this.inputOnt.getProperty(messageMap, OWLS_1_0.Grounding.owlsParameter).getURI();
            Parameter owlsParameter = isInput ? (Parameter)process.getInputs().getIndividual(owlsParameterInfo) : (Parameter)process.getOutputs().getIndividual(owlsParameterInfo);
            String wsdlMessagePartInfo = this.inputOnt.getProperty(messageMap, messagePart).toString().trim();
            String transformation = null;
            if (this.inputOnt.hasProperty(messageMap, OWLS_1_0.Grounding.xsltTransformation)) {
                transformation = this.inputOnt.getProperty(messageMap, OWLS_1_0.Grounding.xsltTransformation).toString();
            }
            if (owlsParameter == null) {
                logger.error("Cannot find the target of message map for {} parameter (WSDL parameter: {}, in process: {}, mapped to: {})", new Object[]{isInput ? "input" : "output", wsdlMessagePartInfo, process.getURI(), owlsParameterInfo});
            } else {
                g.addMessageMap(owlsParameter, wsdlMessagePartInfo, transformation);
            }
            logger.debug("Process {}, Param {}, Grounding {}, Transform {}", new Object[]{process.getURI(), owlsParameterInfo, transformation});
        }
    }

    private void copyPropertyValues(OWLIndividual src, OWLDataProperty srcProp, OWLIndividual target, OWLDataProperty targetProp) {
        List<OWLDataValue> list = this.inputOnt.getProperties(src, srcProp);
        for (OWLDataValue dataValue : list) {
            target.addProperty(targetProp, dataValue);
        }
    }

    private void copyPropertyValues(OWLIndividual src, URI srcProp, OWLIndividual target, URI targetProp) {
        List<OWLDataValue> list = src.getAnnotations(srcProp);
        for (OWLDataValue dataValue : list) {
            target.addAnnotation(targetProp, dataValue);
        }
    }

    private OWLIndividual keepFLAProperties(OWLIndividual ind) {
        OWLIndividual translated = this.translateAll(ind);
        if (translated != null) {
            Map<OWLProperty, List<OWLValue>> map = ind.getProperties();
            for (OWLProperty prop : map.keySet()) {
                OWLIndividualList<?> list;
                if (prop instanceof OWLDataProperty) {
                    if (!FLAServiceOnt.flaDataProperties.contains(prop)) continue;
                    this.copyPropertyValues(ind, (OWLDataProperty)prop, translated, (OWLDataProperty)prop);
                    continue;
                }
                OWLObjectProperty objProp = (OWLObjectProperty)prop;
                if (FLAServiceOnt.flaObjectPropertiesToDataProperties.containsKey(prop)) {
                    list = this.inputOnt.getProperties(ind, objProp);
                    for (OWLIndividual serviceParamInfo : list) {
                        translated.addProperty(FLAServiceOnt.flaObjectPropertiesToDataProperties.get(prop), (Object)serviceParamInfo);
                    }
                    continue;
                }
                if (!FLAServiceOnt.flaObjectProperties.containsKey(prop)) continue;
                list = this.inputOnt.getProperties(ind, objProp);
                for (OWLIndividual serviceParamInfo : list) {
                    OWLIndividual serviceParam = this.translate(serviceParamInfo, serviceParamInfo.getType());
                    OWLIndividual serviceParamValue = serviceParamInfo.getProperty(OWLS_1_0.Profile.sParameter);
                    serviceParamValue = this.translate(serviceParamValue, FLAServiceOnt.flaObjectProperties.get(objProp));
                    translated.addProperty(objProp, serviceParam);
                    serviceParam.addProperty(OWLS_1_1.Profile.sParameter, serviceParamValue);
                }
            }
        }
        return translated;
    }
}

