/*
 * Decompiled with CFR 0.152.
 */
package impl.owls.grounding;

import impl.owls.grounding.AtomicGroundingImpl;
import impl.owls.grounding.JavaClassTransformator;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import org.mindswap.exceptions.ExecutionException;
import org.mindswap.owl.EntityFactory;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.grounding.JavaAtomicGrounding;
import org.mindswap.owls.grounding.JavaParameter;
import org.mindswap.owls.grounding.JavaVariable;
import org.mindswap.owls.grounding.MessageMap;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.Output;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.vocabulary.MoreGroundings;
import org.mindswap.owls.vocabulary.OWLS_1_1;
import org.mindswap.query.ValueMap;
import org.mindswap.utils.ReflectionUtils;
import org.mindswap.utils.URIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaAtomicGroundingImpl
extends AtomicGroundingImpl<Object>
implements JavaAtomicGrounding {
    public JavaAtomicGroundingImpl(OWLIndividual ind) {
        super(ind);
    }

    @Override
    public void setClaz(String claz) {
        this.setProperty(MoreGroundings.javaClass, claz);
    }

    @Override
    public String getClaz() {
        return this.getPropertyAsString(MoreGroundings.javaClass);
    }

    @Override
    public void setMethod(String method) {
        this.setProperty(MoreGroundings.javaMethod, method);
    }

    @Override
    public String getMethod() {
        return this.getPropertyAsString(MoreGroundings.javaMethod);
    }

    @Override
    public URL getDescriptionURL() {
        return null;
    }

    @Override
    public void addMessageMap(Parameter owlsParameter, String groundingParameter, Object transformation) {
    }

    @Override
    public OWLIndividualList<MessageMap<Object>> getInputMap() {
        return null;
    }

    @Override
    public OWLIndividualList<MessageMap<Object>> getOutputMap() {
        return null;
    }

    @Override
    public ValueMap<Output, OWLValue> invoke(ValueMap<Input, OWLValue> values) throws ExecutionException {
        return this.invoke(values, OWLFactory.createKB());
    }

    @Override
    public ValueMap<Output, OWLValue> invoke(ValueMap<Input, OWLValue> values, OWLKnowledgeBase kb) throws ExecutionException {
        Class<?> claz = null;
        Method method = null;
        Class[] params = null;
        Object[] paramValues = null;
        ValueMap<Output, OWLValue> results = new ValueMap<Output, OWLValue>();
        Object result = null;
        String strClaz = this.getClaz();
        if (strClaz == null || strClaz.equals("")) {
            throw new ExecutionException("JavaAtomicGrounding: No Java Class defined in Grounding!");
        }
        String strMethod = this.getMethod();
        if (strMethod == null || strMethod.equals("")) {
            throw new ExecutionException("JavaAtomicGrounding: No Java Method defined in Grounding!");
        }
        int paramSize = this.getInputParameters().size();
        params = new Class[paramSize];
        int i = 0;
        while (i < paramSize) {
            params[i] = this.getJavaParameterTypeAt(i);
            ++i;
        }
        try {
            claz = Class.forName(strClaz);
            method = claz.getDeclaredMethod(strMethod, params);
        }
        catch (ClassNotFoundException e) {
            throw new ExecutionException("JavaAtomicGrounding: Class " + strClaz + " defined in Grounding not found.");
        }
        catch (NoSuchMethodException e) {
            throw new ExecutionException("JavaAtomicGrounding: Method " + strMethod + " defined in Grounding not found.");
        }
        catch (Exception e) {
            throw new ExecutionException("JavaAtomicGrounding: " + e.getClass().toString() + " ocurred: " + e.getMessage());
        }
        paramValues = new Object[paramSize];
        i = 0;
        while (i < params.length) {
            OWLValue owlValue = values.getValue(this.getOWLSParameterAt(i).castTo(Input.class));
            if (owlValue.isDataValue()) {
                paramValues[i] = ReflectionUtils.getCastedObjectFromStringValue(((OWLDataValue)owlValue).getLexicalValue(), params[i]);
            } else if (owlValue.isIndividual()) {
                paramValues[i] = this.getJavaParameterAt(i, (OWLIndividual)owlValue);
            }
            ++i;
        }
        try {
            Object obj = claz.newInstance();
            if (method.getReturnType().toString().equalsIgnoreCase("void")) {
                method.invoke(obj, paramValues);
            } else {
                result = method.invoke(obj, paramValues);
            }
        }
        catch (InvocationTargetException e) {
            throw new ExecutionException("JavaAtomicGrounding: Error in executed method\n" + e.getTargetException().toString() + " ocurred: ");
        }
        catch (Exception e) {
            throw new ExecutionException("JavaAtomicGrounding: Error while executing method\n" + e.getClass().toString() + " ocurred: ");
        }
        if (result != null) {
            Output param = this.getOWLSOutput().castTo(Output.class);
            if (param == null) {
                throw new ExecutionException("JavaAtomicGrounding: Output in Grounding not specified although method provides a return value.");
            }
            if (param.getParamType().isDataType()) {
                results.setValue(param, EntityFactory.createDataValue(result));
            } else {
                results.setValue(param, this.transformResult(result));
            }
        }
        return results;
    }

    private OWLValue transformResult(Object result) {
        JavaVariable output = this.getOutput();
        if (output == null) {
            return null;
        }
        String transformerName = output.getTransformator().trim();
        if (transformerName != null && !transformerName.trim().equals("")) {
            try {
                Class<?> transformerClass = Class.forName(transformerName);
                Constructor<?> constructor = transformerClass.getConstructor(OWLKnowledgeBase.class);
                JavaClassTransformator transformer = (JavaClassTransformator)constructor.newInstance(this.getKB());
                return transformer.transformToOWL(result);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private Parameter getOWLSOutput() {
        OWLIndividual owlsParam = this.getProperty(MoreGroundings.javaOutput).getProperty(MoreGroundings.owlsParameter);
        return owlsParam == null ? null : owlsParam.castTo(Parameter.class);
    }

    private Parameter getOWLSParameterAt(int index) {
        JavaParameter param = this.getInputParamter(index);
        if (param == null) {
            return null;
        }
        return param.getOWLSParameter();
    }

    private Class getJavaParameterTypeAt(int index) {
        JavaParameter param = this.getInputParamter(index);
        if (param == null) {
            return null;
        }
        String transformerName = param.getTransformator().trim();
        String javaType = param.getJavaType();
        if (transformerName != null && !transformerName.trim().equals("")) {
            try {
                Class<?> transformerClass = Class.forName(transformerName);
                Constructor<?> constructor = transformerClass.getConstructor(OWLKnowledgeBase.class);
                JavaClassTransformator transformer = (JavaClassTransformator)constructor.newInstance(this.getKB());
                return transformer.getJavaClass();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return null;
        }
        return ReflectionUtils.getClassFromString(javaType);
    }

    private Object getJavaParameterAt(int index, OWLIndividual owlValue) {
        JavaParameter param = this.getInputParamter(index);
        if (param == null) {
            return null;
        }
        String transformerName = param.getTransformator().trim();
        String javaType = param.getJavaType();
        if (transformerName != null && !transformerName.trim().equals("")) {
            try {
                Class<?> transformerClass = Class.forName(transformerName);
                Constructor<?> constructor = transformerClass.getConstructor(OWLKnowledgeBase.class);
                JavaClassTransformator transformer = (JavaClassTransformator)constructor.newInstance(this.getKB());
                return transformer.transformFromOWL(owlValue);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return null;
        }
        return ReflectionUtils.getClassFromString(javaType);
    }

    @Override
    public void setOutput(String name, String type, Output owlsParameter) {
        OWLIndividual ind = this.getOntology().createInstance(MoreGroundings.JavaVariable, URI.create(name));
        ind.setProperty(MoreGroundings.javaType, type);
        ind.setProperty(MoreGroundings.owlsParameter, owlsParameter);
        this.setProperty(MoreGroundings.javaOutput, ind);
    }

    @Override
    public void setInputParameter(String name, String type, int index, Input owlsParameter) {
        OWLIndividual ind = this.getOntology().createInstance(MoreGroundings.JavaParameter, URIUtils.createURI(name));
        ind.setProperty(MoreGroundings.javaType, type);
        ind.setProperty(MoreGroundings.owlsParameter, owlsParameter);
        ind.setProperty(MoreGroundings.paramIndex, Integer.toString(index));
        this.addProperty(MoreGroundings.hasJavaParameter, ind);
    }

    @Override
    public String getGroundingType() {
        return "Java";
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClaz()) + "." + this.getMethod();
    }

    private void removeAll() {
        if (this.hasProperty(MoreGroundings.javaClass)) {
            this.removeProperties(MoreGroundings.javaClass);
        }
        if (this.hasProperty(MoreGroundings.javaMethod)) {
            this.removeProperties(MoreGroundings.javaMethod);
        }
        if (this.hasProperty(MoreGroundings.hasJavaParameter)) {
            OWLIndividualList<?> indList = this.getProperties(MoreGroundings.hasJavaParameter);
            int i = 0;
            while (i < indList.size()) {
                OWLIndividual ind = (OWLIndividual)indList.get(i);
                if (ind.hasProperty(MoreGroundings.javaType)) {
                    ind.removeProperties(MoreGroundings.javaType);
                }
                if (ind.hasProperty(MoreGroundings.owlsParameter)) {
                    ind.removeProperties(MoreGroundings.owlsParameter);
                }
                if (ind.hasProperty(MoreGroundings.paramIndex)) {
                    ind.removeProperties(MoreGroundings.paramIndex);
                }
                this.removeProperty(MoreGroundings.hasJavaParameter, ind);
                ind.delete();
                ++i;
            }
        }
        if (this.hasProperty(MoreGroundings.javaOutput)) {
            OWLIndividual ind = this.getProperty(MoreGroundings.javaOutput);
            if (ind.hasProperty(MoreGroundings.javaType)) {
                ind.removeProperties(MoreGroundings.javaType);
            }
            if (ind.hasProperty(MoreGroundings.owlsParameter)) {
                ind.removeProperties(MoreGroundings.owlsParameter);
            }
            this.removeProperties(MoreGroundings.javaOutput);
            ind.delete();
        }
        if (this.hasProperty(MoreGroundings.owlsProcess)) {
            this.removeProperties(MoreGroundings.owlsProcess);
        }
        if (this.hasProperty(OWLS_1_1.Grounding.owlsProcess)) {
            this.removeProperties(OWLS_1_1.Grounding.owlsProcess);
        }
    }

    @Override
    public void delete() {
        this.removeAll();
        super.delete();
    }

    @Override
    public JavaParameter getInputParamter(Input input) {
        OWLIndividualList<JavaParameter> list = this.getPropertiesAs(MoreGroundings.hasJavaParameter, JavaParameter.class);
        int i = 0;
        while (i < list.size()) {
            OWLIndividual ind = ((OWLIndividual)list.get(i)).getProperty(MoreGroundings.owlsParameter);
            if (ind.getURI().equals(input.getURI())) {
                return (JavaParameter)list.get(i);
            }
            ++i;
        }
        return null;
    }

    public JavaParameter getInputParamter(int index) {
        OWLIndividualList<JavaParameter> list = this.getPropertiesAs(MoreGroundings.hasJavaParameter, JavaParameter.class);
        int i = 0;
        while (i < list.size()) {
            String curIndex = ((OWLIndividual)list.get(i)).getProperty(MoreGroundings.paramIndex).getLexicalValue();
            if (Integer.valueOf(curIndex) == index) {
                return (JavaParameter)list.get(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    public JavaVariable getOutput() {
        return this.getPropertyAs(MoreGroundings.javaOutput, JavaVariable.class);
    }

    @Override
    public OWLIndividualList getInputParameters() {
        OWLIndividualList<JavaParameter> list = this.getPropertiesAs(MoreGroundings.hasJavaParameter, JavaParameter.class);
        list.add((JavaParameter)EntityFactory.createIndividual());
        int i = 0;
        while (i < list.size() - 2) {
            int element = Integer.parseInt(((OWLIndividual)list.get(i)).getProperty(MoreGroundings.paramIndex).getLexicalValue());
            int min = Integer.MAX_VALUE;
            int pos = i;
            int j = i + 1;
            while (j < list.size() - 1) {
                int temp = Integer.parseInt(((OWLIndividual)list.get(j)).getProperty(MoreGroundings.paramIndex).getLexicalValue());
                if (temp < min) {
                    min = temp;
                    pos = j;
                }
                ++j;
            }
            if (min < element) {
                list.set(list.size() - 1, (JavaParameter)list.get(i));
                list.set(i, (JavaParameter)list.get(pos));
                list.set(pos, (JavaParameter)list.get(list.size() - 1));
            }
            ++i;
        }
        list.remove(list.size() - 1);
        return list;
    }

    public String getTransformator(JavaVariable variable) {
        return this.getPropertyAsString(MoreGroundings.transformatorClass);
    }

    public void setTransformator(String transformClass) {
        this.setProperty(MoreGroundings.transformatorClass, transformClass);
    }
}

