/*
 * Decompiled with CFR 0.152.
 */
package impl.owls.grounding;

import impl.owls.grounding.AtomicGroundingImpl;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.mindswap.exceptions.ExecutionException;
import org.mindswap.exceptions.ServiceNotAvailableException;
import org.mindswap.owl.EntityFactory;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLObjectProperty;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.grounding.MessageMap;
import org.mindswap.owls.grounding.WSDLAtomicGrounding;
import org.mindswap.owls.grounding.WSDLOperationRef;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.Output;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.vocabulary.OWLS_1_1;
import org.mindswap.query.ValueMap;
import org.mindswap.utils.URIUtils;
import org.mindswap.utils.Utils;
import org.mindswap.utils.XSLTEngine;
import org.mindswap.wsdl.WSDLOperation;
import org.mindswap.wsdl.WSDLParameter;
import org.mindswap.wsdl.WSDLService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLAtomicGroundingImpl
extends AtomicGroundingImpl<String>
implements WSDLAtomicGrounding {
    public WSDLAtomicGroundingImpl(OWLIndividual ind) {
        super(ind);
    }

    @Override
    public void setWSDL(URI wsdlLoc) {
        this.setProperty(OWLS_1_1.Grounding.wsdlDocument, wsdlLoc);
    }

    @Override
    public URI getWSDL() {
        return this.getPropertyAsURI(OWLS_1_1.Grounding.wsdlDocument);
    }

    @Override
    public void setOperation(URI operation) {
        WSDLOperationRef opRef = this.getOperationRef();
        if (opRef == null) {
            opRef = this.getOntology().createWSDLOperationRef();
            this.setOperationRef(opRef);
        }
        opRef.setOperation(operation);
    }

    @Override
    public URI getOperation() {
        return this.getOperationRef().getOperation();
    }

    @Override
    public void setPortType(URI port) {
        WSDLOperationRef opRef = this.getOperationRef();
        if (opRef == null) {
            opRef = this.getOntology().createWSDLOperationRef();
            this.setOperationRef(opRef);
        }
        opRef.setPortType(port);
    }

    @Override
    public URI getPortType() {
        return this.getOperationRef().getPortType();
    }

    @Override
    public ValueMap<Output, OWLValue> invoke(ValueMap<Input, OWLValue> values) throws ExecutionException {
        return this.invoke(values, OWLFactory.createKB());
    }

    @Override
    public ValueMap<Output, OWLValue> invoke(ValueMap<Input, OWLValue> values, OWLKnowledgeBase env) throws ExecutionException {
        String xslt;
        WSDLService s;
        String operation = this.getOperation().toString();
        try {
            s = WSDLService.createService(this.getWSDL());
        }
        catch (Exception e) {
            throw new ServiceNotAvailableException(this.getProcess(), e);
        }
        WSDLOperation op = s.getOperation(operation);
        if (op == null) {
            op = s.getOperation(URIUtils.getLocalName(operation));
        }
        if (op == null) {
            throw new ExecutionException("Operation " + operation + " cannot be found in the WSDL description");
        }
        OWLIndividualList<? extends MessageMap<String>> inputMapList = this.getInputMap();
        for (WSDLParameter in : op.getInputs()) {
            MessageMap mp = this.getMessageMap(inputMapList, in.getName());
            if (mp == null) continue;
            Input param = mp.getOWLSParameter().castTo(Input.class);
            OWLValue paramValue = values.getValue(param);
            if (paramValue == null) {
                paramValue = param.getConstantValue();
            }
            if (paramValue == null) {
                throw new ExecutionException("Value of input parameter '" + param + "' is not set!");
            }
            Object inputValue = paramValue;
            xslt = (String)mp.getTransformation();
            if (xslt != null) {
                if (paramValue instanceof OWLIndividual) {
                    String rdf = ((OWLIndividual)paramValue).toRDF(true, true);
                    String xsltResult = XSLTEngine.transform(rdf, xslt, values);
                    inputValue = Utils.getAsNode(xsltResult);
                    if (inputValue == null) {
                        inputValue = xsltResult.trim();
                    }
                } else {
                    throw new ExecutionException("Cannot apply XSLT transformation to data value '" + paramValue + "' for input parameter '" + param + "'");
                }
            }
            in.setValue(inputValue);
        }
        try {
            op.invoke();
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
        ValueMap<Output, OWLValue> results = new ValueMap<Output, OWLValue>();
        OWLIndividualList<? extends MessageMap<String>> outputMapList = this.getOutputMap();
        for (Output param : this.getProcess().getOutputs()) {
            MessageMap mp = this.getMessageMap(outputMapList, param);
            WSDLParameter out = op.getOutput(mp.getGroundingParameter());
            xslt = (String)mp.getTransformation();
            if (out == null) {
                throw new ExecutionException("Parameter '" + mp.getGroundingParameter() + "' is not found in the WSDL file!");
            }
            Object outputValue = out.getValue();
            if (outputValue == null) {
                throw new ExecutionException("Value of output parameter '" + out + "' is not set by the WSDL operation!");
            }
            if (xslt != null) {
                String xml = out.getTextValue();
                if (xml.startsWith("<dwmlOut")) {
                    xml = outputValue.toString();
                }
                if ((outputValue = XSLTEngine.transform(xml, xslt)) == null) {
                    throw new ExecutionException("An error occurred when applying xsltTransformtion to output parameter '" + param + "'");
                }
            }
            if (param.getParamType().isDataType()) {
                results.setValue(param, EntityFactory.createDataValue(outputValue));
                continue;
            }
            results.setValue(param, env.getBaseOntology().parseLiteral(outputValue.toString()));
        }
        return results;
    }

    @Override
    public URL getDescriptionURL() {
        try {
            return this.getWSDL().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public URI getInputMessage() {
        return this.getPropertyAsURI(OWLS_1_1.Grounding.wsdlInputMessage);
    }

    @Override
    public void setInputMessage(URI inputMessage) {
        this.setProperty(OWLS_1_1.Grounding.wsdlInputMessage, inputMessage);
    }

    @Override
    public URI getOutputMessage() {
        return this.getPropertyAsURI(OWLS_1_1.Grounding.wsdlOutputMessage);
    }

    @Override
    public void setOutputMessage(URI outputMessage) {
        this.setProperty(OWLS_1_1.Grounding.wsdlOutputMessage, outputMessage);
    }

    @Override
    public OWLIndividualList<? extends MessageMap<String>> getInputMap() {
        return OWLFactory.wrapList(this.getProperties(OWLS_1_1.Grounding.wsdlInput), MessageMap.StringMessageMap.class);
    }

    @Override
    public OWLIndividualList<? extends MessageMap<String>> getOutputMap() {
        return OWLFactory.wrapList(this.getProperties(OWLS_1_1.Grounding.wsdlOutput), MessageMap.StringMessageMap.class);
    }

    @Override
    public WSDLOperationRef getOperationRef() {
        return this.getPropertyAs(OWLS_1_1.Grounding.wsdlOperation, WSDLOperationRef.class);
    }

    @Override
    public void setOperationRef(WSDLOperationRef operationRef) {
        this.setProperty(OWLS_1_1.Grounding.wsdlOperation, operationRef);
    }

    @Override
    public void addMessageMap(Parameter owlsParameter, String groundingParameter, String xsltTransformation) {
        MessageMap<String> map = null;
        if (owlsParameter instanceof Input) {
            map = this.getOntology().createWSDLInputMessageMap();
        } else if (owlsParameter instanceof Output) {
            map = this.getOntology().createWSDLOutputMessageMap();
        } else {
            throw new IllegalArgumentException("OWL-S parameter is neither an Input nor Output!");
        }
        map.setOWLSParameter(owlsParameter);
        map.setGroundingParameter(groundingParameter);
        if (xsltTransformation != null && xsltTransformation.length() > 0) {
            map.setTransformation(xsltTransformation);
        }
        this.addMessageMap(map);
    }

    @Override
    public String getGroundingType() {
        return "WSDL";
    }

    public void removeOperationRef() {
        if (this.hasProperty(OWLS_1_1.Grounding.wsdlOperation)) {
            WSDLOperationRef opRef = this.getOperationRef();
            opRef.removeOperation();
            opRef.removePortType();
            this.removeProperties(OWLS_1_1.Grounding.wsdlOperation);
            opRef.delete();
        }
    }

    public void removeMessageMaps(OWLObjectProperty prop) {
        if (this.hasProperty(prop)) {
            OWLIndividualList<?> indList = this.getProperties(prop);
            int i = 0;
            while (i < indList.size()) {
                OWLIndividual ind = (OWLIndividual)indList.get(i);
                if (ind.hasProperty(OWLS_1_1.Grounding.owlsParameter)) {
                    ind.removeProperties(OWLS_1_1.Grounding.owlsParameter);
                }
                if (ind.hasProperty(OWLS_1_1.Grounding.wsdlMessagePart)) {
                    ind.removeProperties(OWLS_1_1.Grounding.wsdlMessagePart);
                }
                this.removeProperty(prop, ind);
                ind.delete();
                ++i;
            }
        }
    }

    private void removeAll() {
        if (this.hasProperty(OWLS_1_1.Grounding.wsdlDocument)) {
            this.removeProperties(OWLS_1_1.Grounding.wsdlDocument);
        }
        this.removeOperationRef();
        if (this.hasProperty(OWLS_1_1.Grounding.wsdlInputMessage)) {
            this.removeProperties(OWLS_1_1.Grounding.wsdlInputMessage);
        }
        this.removeMessageMaps(OWLS_1_1.Grounding.wsdlInput);
        this.removeMessageMaps(OWLS_1_1.Grounding.wsdlOutput);
        if (this.hasProperty(OWLS_1_1.Grounding.wsdlOutputMessage)) {
            this.removeProperties(OWLS_1_1.Grounding.wsdlOutputMessage);
        }
    }

    @Override
    public void delete() {
        this.removeAll();
        super.delete();
    }

    @Override
    public URI getWSDLParameter(Parameter parameter) {
        URI uri = this.getWSDLParameter(parameter, this.getInputMap());
        if (uri == null) {
            uri = this.getWSDLParameter(parameter, this.getOutputMap());
        }
        return uri;
    }

    private URI getWSDLParameter(Parameter parameter, OWLIndividualList<? extends MessageMap<String>> list) {
        for (MessageMap messageMap : list) {
            if (!messageMap.getOWLSParameter().equals(parameter)) continue;
            return messageMap.getGroundingParameterAsURI();
        }
        return null;
    }
}

