/*
 * Decompiled with CFR 0.152.
 */
package impl.owls.process.execution;

import java.util.List;
import org.mindswap.exceptions.ExecutionException;
import org.mindswap.exceptions.MultipleSatisfiedPreconditionException;
import org.mindswap.exceptions.UnsatisfiedPreconditionException;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.generic.expression.Expression;
import org.mindswap.owls.process.Condition;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.Local;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.Result;
import org.mindswap.owls.process.execution.ExecutionValidator;
import org.mindswap.query.ABoxQuery;
import org.mindswap.query.ValueMap;
import org.mindswap.swrl.AtomList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardExecutionValidator
implements ExecutionValidator {
    private static final Logger logger = LoggerFactory.getLogger(StandardExecutionValidator.class);
    private boolean allowMultipleSatisifedPreconditions = true;
    private boolean checkPreconditions = true;
    private boolean checkResults = false;

    @Override
    public void checkPreconditions(Process process, ValueMap<Input, OWLValue> values, OWLKnowledgeBase kb) throws ExecutionException {
        if (this.checkPreconditions) {
            OWLIndividualList<Local> locals = process.getLocals();
            for (Condition cond : process.getConditions()) {
                AtomList atoms = cond.getBody();
                logger.debug("Process precondition atoms = {}", (Object)atoms);
                if (atoms == null) continue;
                atoms = atoms.apply(values);
                logger.debug("Process precondition atoms with values applied = {}", (Object)atoms);
                ABoxQuery query = atoms.toQuery(locals);
                logger.debug("Process precondition query = {}", (Object)query);
                List<ValueMap> results = kb.query(query);
                logger.debug("Process precondition query results = {}" + results);
                if (results.isEmpty()) {
                    throw new UnsatisfiedPreconditionException(process, cond);
                }
                if (results.size() > 1 && !this.allowMultipleSatisifedPreconditions) {
                    throw new MultipleSatisfiedPreconditionException(process, cond);
                }
                ValueMap result = results.get(0);
                values.putMap(result);
            }
        }
    }

    @Override
    public void checkResults(Process process, ValueMap<Parameter, OWLValue> values, OWLKnowledgeBase kb) throws ExecutionException {
        if (this.checkResults) {
            OWLIndividualList<Result> resultList = process.getResults();
            ValueMap<Parameter, OWLValue> data = new ValueMap<Parameter, OWLValue>();
            data.putMap(values);
            for (Result result : resultList) {
                OWLIndividualList<Expression> effects = result.getEffects();
                for (Expression effect : effects) {
                    effect.getBody().evaluate(data);
                }
            }
            if (kb.isConsistent()) {
                return;
            }
            throw new ExecutionException("Invalid output produced by the process " + process, process);
        }
    }

    @Override
    public boolean isAllowMultipleSatisifedPreconditions() {
        return this.allowMultipleSatisifedPreconditions;
    }

    @Override
    public boolean isPreconditionCheck() {
        return this.checkPreconditions;
    }

    @Override
    public boolean isResultCheck() {
        return this.checkResults;
    }

    @Override
    public void setAllowMultipleSatisifedPreconditions(boolean allowMultipleSatisifedPreconditions) {
        this.allowMultipleSatisifedPreconditions = allowMultipleSatisifedPreconditions;
    }

    @Override
    public void setPreconditionCheck(boolean checkPreconditions) {
        this.checkPreconditions = checkPreconditions;
    }

    @Override
    public void setResultCheck(boolean checkResults) {
        this.checkResults = checkResults;
    }

    public String toString() {
        return "Precondition check: " + this.checkPreconditions + ", Result check: " + this.checkResults + ", Allow multiple satisfied preconditions: " + this.allowMultipleSatisifedPreconditions;
    }
}

