/*
 * Decompiled with CFR 0.152.
 */
package impl.swrl;

import impl.owl.list.OWLListImpl;
import java.util.ArrayList;
import java.util.List;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.list.OWLList;
import org.mindswap.owl.vocabulary.SWRL;
import org.mindswap.query.ABoxQuery;
import org.mindswap.query.ValueMap;
import org.mindswap.swrl.Atom;
import org.mindswap.swrl.AtomList;
import org.mindswap.swrl.SWRLFactory;
import org.mindswap.swrl.SWRLFactoryCreator;
import org.mindswap.swrl.SWRLObject;
import org.mindswap.swrl.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomListImpl
extends OWLListImpl
implements AtomList {
    public AtomListImpl(OWLIndividual ind) {
        super(ind);
        this.setVocabulary(SWRL.AtomListVocabulary);
    }

    @Override
    public AtomList add(Atom item) {
        return (AtomList)super.add(item);
    }

    @Override
    public AtomList insert(Atom first) {
        AtomListImpl list = new AtomListImpl(this.getOntology().createInstance((OWLClass)this.vocabulary.List()));
        list.setVocabulary(this.vocabulary);
        list.setFirst(first);
        list.setRest(this);
        return list;
    }

    @Override
    public AtomList insertAt(int index, Atom item) {
        return (AtomList)super.insertAt(index, item);
    }

    @Override
    public AtomList insert(OWLValue item) {
        Atom atom = item.castTo(Atom.class);
        return this.insert(atom);
    }

    @Override
    public Atom getFirst() {
        return this.getProperty(this.vocabulary.first()).castTo(Atom.class);
    }

    @Override
    public AtomList getRest() {
        return this.getProperty(this.vocabulary.rest()).castTo(AtomList.class);
    }

    @Override
    public Atom get(int index) {
        return (Atom)super.get(index);
    }

    @Override
    public ABoxQuery toQuery() {
        return new ABoxQuery(this);
    }

    @Override
    public ABoxQuery toQuery(List<? extends Variable> resultVars) {
        return new ABoxQuery(this, resultVars);
    }

    @Override
    public void evaluate(ValueMap values) {
        int i = 0;
        while (i < this.size()) {
            this.get(i).evaluate(values);
            ++i;
        }
    }

    @Override
    public AtomList apply(ValueMap binding) {
        OWLOntology ont = this.getOntology();
        SWRLFactory swrl = SWRLFactoryCreator.createFactory(ont);
        AtomList newList = swrl.createList();
        AtomList list = this;
        while (!list.isEmpty()) {
            Atom atom = list.getFirst();
            atom = atom.apply(binding);
            if (newList.isEmpty()) {
                newList = newList.insert(atom);
            } else {
                newList.add(atom);
            }
            list = list.getRest();
        }
        return newList;
    }

    @Override
    public List<Variable> getVars() {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        AtomList list = this;
        while (!list.isEmpty()) {
            Atom atom = list.getFirst();
            int j = 0;
            while (j < atom.getArgumentCount()) {
                SWRLObject term = atom.getArgument(j);
                if (term instanceof Variable) {
                    vars.add((Variable)((Object)term));
                }
                ++j;
            }
            list = list.getRest();
        }
        return vars;
    }

    @Override
    public String toString() {
        StringBuffer str = new StringBuffer("[");
        OWLList list = this;
        while (!list.isEmpty()) {
            if (list != this) {
                str.append(", ");
            }
            str.append(list.getFirst().toString());
            list = list.getRest();
        }
        str.append("]");
        return str.toString();
    }

    @Override
    public AtomList remove() {
        AtomList list = this.getRest();
        if (this.size() > 1) {
            list.setFirst(this.getRest().getFirst());
            list.setRest(this.getRest().getRest());
        } else {
            list = this.vocabulary.nil().castTo(AtomList.class);
        }
        if (this.hasProperty(this.vocabulary.first())) {
            this.removeProperties(this.vocabulary.first());
        }
        if (this.hasProperty(this.vocabulary.rest())) {
            this.removeProperties(this.vocabulary.rest());
        }
        this.individual.delete();
        return list;
    }

    @Override
    public AtomList remove(OWLValue value) {
        return (AtomList)super.remove(value);
    }

    @Override
    public AtomList removeAt(int index) {
        return (AtomList)super.removeAt(index);
    }

    @Override
    public AtomList removeAll() {
        AtomList list = this;
        while (list.size() > 0) {
            list = list.remove();
        }
        return list;
    }
}

