/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFactory {
    private static final Logger logger = LoggerFactory.getLogger(AbstractFactory.class);

    protected static final <T> T createFactory(Class<T> interfaze, String ... implementations) {
        T result = null;
        int i = 0;
        while (result == null && i < implementations.length) {
            try {
                Class<T> impl = Class.forName(implementations[i]).asSubclass(interfaze);
                result = impl.newInstance();
            }
            catch (Exception e) {
                logger.debug("Cannot create factory for interface {}. Details: {}", interfaze, (Object)e);
            }
            ++i;
        }
        return result;
    }
}

