/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLObject;
import org.mindswap.owl.OWLObjectConverter;
import org.mindswap.owl.OWLTransformator;
import org.mindswap.owls.OWLSFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLConfig {
    private static final Logger logger = LoggerFactory.getLogger(OWLConfig.class);
    public static final String[] DEFAULT_LANGS;
    private static final List<String> defaultLanguages;
    private static final Map<Class<? extends OWLObject>, OWLObjectConverter<?>> converters;
    private static final Map<OWLClass, OWLTransformator<?>> transformators;
    private static final AtomicBoolean strictConversion;

    static {
        String[] stringArray = new String[4];
        stringArray[0] = "en";
        stringArray[1] = "";
        stringArray[2] = "en";
        DEFAULT_LANGS = stringArray;
        converters = new ConcurrentHashMap();
        transformators = new ConcurrentHashMap();
        defaultLanguages = new CopyOnWriteArrayList<String>(Arrays.asList(DEFAULT_LANGS));
        strictConversion = new AtomicBoolean(true);
        OWLFactory.registerConverters();
        OWLSFactory.registerConverters();
    }

    public static final void setDefaultLanguage(String lang) {
        defaultLanguages.set(0, lang);
    }

    public static final <T extends OWLObject, U extends T> OWLObjectConverter<?> addConverter(Class<U> target, OWLObjectConverter<T> converter) {
        OWLObjectConverter<T> old = converters.put(target, converter);
        if (old != null) {
            logger.warn("OWL object converter for {} already registered. Existing converter {} was overridden by {}", new Object[]{target.getName(), old, converter});
        }
        return old;
    }

    public static final <T extends OWLObject> OWLObjectConverter<T> getConverter(Class<T> target) {
        return converters.get(target);
    }

    public static final boolean setStrictConversion(boolean strict) {
        return strictConversion.getAndSet(strict);
    }

    public static final boolean getStrictConversion() {
        return strictConversion.get();
    }

    public static final void addTransformator(OWLClass owlClass, OWLTransformator<?> oWLTransformator) {
        transformators.put(owlClass, oWLTransformator);
    }

    public static final OWLTransformator<?> getTransformator(OWLClass owlClass) {
        return transformators.get(owlClass);
    }

    public static final List<String> getDefaultLanguages() {
        return defaultLanguages;
    }
}

