/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owl;

import impl.owl.CastingList;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.mindswap.AbstractFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLModel;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLReader;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.OWLWriter;
import org.mindswap.query.ABoxQueryParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OWLFactory
extends AbstractFactory {
    private static final String[] implementations = new String[]{"impl.jena.JenaOWLFactory"};
    private static final Interface factory = OWLFactory.createFactory(Interface.class, implementations);
    private static OWLKnowledgeBase kb;
    private static OWLOntology owlsService;
    private static OWLOntology owlsProfile;
    private static OWLOntology owlsGrounding;
    private static OWLOntology owlsProcess;

    public static final OWLKnowledgeBase createKB() {
        return factory.createKB();
    }

    public static final OWLOntology createOntology(URI uri, boolean importOWLS) {
        OWLOntology ont = factory.createOntology(uri);
        if (importOWLS) {
            OWLFactory.addOWLSImports(ont);
        }
        return ont;
    }

    public static final void addOWLSImports(OWLOntology ont) {
        OWLFactory.loadOWLSOntologies();
        ont.addImport(owlsService);
        ont.addImport(owlsProfile);
        ont.addImport(owlsProcess);
        ont.addImport(owlsGrounding);
    }

    public static final OWLReader createReader() {
        return factory.createReader();
    }

    public static final OWLWriter createWriter() {
        return factory.createWriter();
    }

    public static final <T extends OWLValue> List<T> createValueList() {
        return factory.createValueList();
    }

    public static final <T extends OWLIndividual> OWLIndividualList<T> createIndividualList() {
        return factory.createIndividualList();
    }

    public static final Map<String, ? extends Object> getReasoners() {
        return factory.getReasoners();
    }

    public static final Object getReasoner(String reasonerName) {
        return factory.getReasoner(reasonerName);
    }

    public static final ABoxQueryParser createRDQLParser(OWLModel model) {
        return factory.createRDQLParser(model);
    }

    public static final <T extends OWLIndividual> OWLIndividualList<T> castList(OWLIndividualList<?> list, Class<T> castTarget) {
        return factory.castList(list, castTarget);
    }

    public static final <T extends OWLIndividual> CastingList<T> wrapList(OWLIndividualList<?> list, Class<T> castTarget) {
        return factory.wrapList(list, castTarget);
    }

    static final void registerConverters() {
        factory.registerConverters();
    }

    private static final void loadOWLSOntologies() {
        if (kb == null) {
            kb = OWLFactory.createKB();
            try {
                owlsService = kb.read("http://www.daml.org/services/owl-s/1.1/Service.owl#");
            }
            catch (Exception e) {
                owlsService = kb.createOntology(URI.create("http://www.daml.org/services/owl-s/1.1/Service.owl#"), null, true);
            }
            try {
                owlsProfile = kb.read("http://www.daml.org/services/owl-s/1.1/Profile.owl#");
            }
            catch (Exception e) {
                owlsProfile = kb.createOntology(URI.create("http://www.daml.org/services/owl-s/1.1/Profile.owl#"), null, true);
            }
            try {
                owlsProcess = kb.read("http://www.daml.org/services/owl-s/1.1/Process.owl#");
            }
            catch (Exception e) {
                owlsProcess = kb.createOntology(URI.create("http://www.daml.org/services/owl-s/1.1/Process.owl#"), null, true);
            }
            try {
                owlsGrounding = kb.read("http://www.daml.org/services/owl-s/1.1/Grounding.owl#");
            }
            catch (Exception e) {
                owlsGrounding = kb.createOntology(URI.create("http://www.daml.org/services/owl-s/1.1/Grounding.owl#"), null, true);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Interface {
        public Map<String, ? extends Object> getReasoners();

        public Object getReasoner(String var1);

        public OWLKnowledgeBase createKB();

        public OWLOntology createOntology(URI var1);

        public OWLReader createReader();

        public OWLWriter createWriter();

        public <T extends OWLValue> List<T> createValueList();

        public <T extends OWLIndividual> OWLIndividualList<T> createIndividualList();

        public ABoxQueryParser createRDQLParser(OWLModel var1);

        public void registerConverters();

        public <T extends OWLIndividual> OWLIndividualList<T> castList(OWLIndividualList<?> var1, Class<T> var2);

        public <T extends OWLIndividual> CastingList<T> wrapList(OWLIndividualList<?> var1, Class<T> var2);
    }
}

