/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.validator;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.exceptions.CastingException;
import org.mindswap.exceptions.ConversionException;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owls.generic.expression.Expression;
import org.mindswap.owls.grounding.AtomicGrounding;
import org.mindswap.owls.grounding.Grounding;
import org.mindswap.owls.grounding.JavaAtomicGrounding;
import org.mindswap.owls.grounding.MessageMap;
import org.mindswap.owls.grounding.WSDLAtomicGrounding;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.CompositeProcess;
import org.mindswap.owls.process.ControlConstruct;
import org.mindswap.owls.process.ControlConstructBag;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.InputBinding;
import org.mindswap.owls.process.Local;
import org.mindswap.owls.process.Output;
import org.mindswap.owls.process.OutputBinding;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.process.Perform;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.Result;
import org.mindswap.owls.process.SplitJoin;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.profile.ServiceCategory;
import org.mindswap.owls.profile.ServiceParameter;
import org.mindswap.owls.service.Service;
import org.mindswap.owls.validator.OWLSValidationException;
import org.mindswap.owls.validator.OWLSValidatorMessage;
import org.mindswap.owls.validator.OWLSValidatorReport;
import org.mindswap.owls.vocabulary.OWLS_1_1;

public class OWLSValidator {
    private static final int CODE_INVALID_VALUE = 0;
    private static final int CODE_MISSING_VALUE = 1;
    private Map<Service, Set<OWLSValidatorMessage>> mMessageMap = new HashMap<Service, Set<OWLSValidatorMessage>>();

    public OWLSValidatorReport validate(OWLOntology theOntology) throws OWLSValidationException {
        OWLKnowledgeBase aKb = OWLFactory.createKB();
        aKb.setReasoner("Pellet");
        aKb.load(theOntology, true);
        return this.validateKb(aKb);
    }

    public OWLSValidatorReport validate(URI theURI) throws OWLSValidationException {
        return this.validate(theURI.toString());
    }

    public OWLSValidatorReport validate(String theURI) throws OWLSValidationException {
        this.mMessageMap = new HashMap<Service, Set<OWLSValidatorMessage>>();
        OWLKnowledgeBase aKb = OWLFactory.createKB();
        aKb.setReasoner("Pellet");
        try {
            aKb.read(theURI);
        }
        catch (IOException ioe) {
            throw OWLSValidationException.createIOException("File at URI (" + theURI + ") not read, cannot validate");
        }
        catch (Exception ex) {
            throw OWLSValidationException.createParseException("Parse Exception: " + ex.getMessage());
        }
        return this.validateKb(aKb);
    }

    private OWLSValidatorReport validateKb(OWLKnowledgeBase theKb) {
        List<Service> aServiceList = theKb.getServices();
        for (Service aService : aServiceList) {
            this.validateService(aService);
        }
        return new OWLSValidatorReport(this.mMessageMap);
    }

    private void validateService(Service theService) {
        if (theService.getProperties(OWLS_1_1.Service.describedBy).size() > 1) {
            OWLSValidatorMessage msg = new OWLSValidatorMessage(0, "Cannot specify more than one describedBy for a service");
            this.addMessage(theService, msg);
        }
        this.validateProfileForService(theService);
        Process aProcess = null;
        try {
            aProcess = theService.getProcess();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.validateProcess(theService, aProcess);
        this.validateGroundingForService(theService);
    }

    private void validateProcess(Service theService, Process theProcess) {
        OWLSValidatorMessage msg;
        if (theProcess == null) {
            OWLSValidatorMessage msg2 = new OWLSValidatorMessage(1, "No process specified for service: " + theService.getLocalName());
            this.addMessage(theService, msg2);
            return;
        }
        try {
            if (theProcess.getProfile() == null) {
                msg = new OWLSValidatorMessage(1, "No profile specified for process: " + theProcess.getLocalName());
                this.addMessage(theService, msg);
            }
        }
        catch (ConversionException ce) {
            this.addMessage(theService, 0, ce.getMessage());
        }
        catch (CastingException ex) {
            this.addMessage(theService, 0, ex.getMessage());
        }
        if (theProcess.getNames().size() > 1) {
            msg = new OWLSValidatorMessage(1, "Process '" + theProcess.getLocalName() + "' can specify at most one name");
            this.addMessage(theService, msg);
        }
        OWLIndividualList<Result> aResultList = theProcess.getResults();
        int i = 0;
        while (i < aResultList.size()) {
            Result aResult = (Result)aResultList.get(i);
            this.validateResult(theService, aResult);
            ++i;
        }
        OWLIndividualList<Local> aParamList = theProcess.getLocals();
        int i2 = 0;
        while (i2 < aParamList.size()) {
            Local aLocal = (Local)aParamList.get(i2);
            this.validateLocal(theService, aLocal);
            ++i2;
        }
        OWLIndividualList<Input> aInputList = theProcess.getInputs();
        int i3 = 0;
        while (i3 < aParamList.size()) {
            Input aInput = (Input)aInputList.get(i3);
            this.validateInput(theService, aInput);
            ++i3;
        }
        OWLIndividualList<Output> aOutputList = theProcess.getOutputs();
        int i4 = 0;
        while (i4 < aOutputList.size()) {
            Output aOutput = (Output)aOutputList.get(i4);
            this.validateOutput(theService, aOutput);
            ++i4;
        }
        if (theProcess.canCastTo(CompositeProcess.class)) {
            this.validateCompositeProcess(theProcess.castTo(CompositeProcess.class));
        } else if (theProcess.canCastTo(AtomicProcess.class)) {
            this.validateAtomicProcess(theProcess.castTo(AtomicProcess.class));
        } else {
            System.err.println("WTF!");
        }
    }

    private void validateLocal(Service theService, Local theLocal) {
        this.validateParameter(theService, theLocal);
    }

    private void validateInput(Service theService, Input theInput) {
        this.validateParameter(theService, theInput);
    }

    private void validateOutput(Service theService, Output theOutput) {
        this.validateParameter(theService, theOutput);
    }

    private void validateParameter(Service theService, Parameter theParam) {
        OWLSValidatorMessage msg;
        if (theParam.getParamType() == null) {
            msg = new OWLSValidatorMessage(1, "A paramType must be specified for Parameter: " + theParam.getLocalName());
            this.addMessage(theService, msg);
        }
        if (!theParam.getParamType().isDataType()) {
            msg = new OWLSValidatorMessage(0, "The paramType for parameter: '" + theParam.getLocalName() + "' is not specified properly. " + "It is supposed to be a datatype property, but it is specifed as an object property. " + "Please change the declaration.");
            this.addMessage(theService, msg);
        }
    }

    private void validateAtomicProcess(AtomicProcess theAtomicProcess) {
    }

    private void validateCompositeProcess(CompositeProcess theCompositeProcess) {
        Service aService = theCompositeProcess.getService();
        if (theCompositeProcess.getComposedOf() == null) {
            OWLSValidatorMessage msg = new OWLSValidatorMessage(1, "");
            this.addMessage(theCompositeProcess.getService(), msg);
        }
        ControlConstruct aCC = theCompositeProcess.getComposedOf();
        List<ControlConstruct> aList = aCC.getConstructs();
        int i = 0;
        while (i < aList.size()) {
            ControlConstruct tempCC = aList.get(i);
            this.validateControlConstruct(aService, tempCC);
            ++i;
        }
        try {
            OWLIndividualList<Process> aProcessList = aCC.getAllProcesses(false);
            int i2 = 0;
            while (i2 < aProcessList.size()) {
                ++i2;
            }
        }
        catch (ConversionException ce) {
            this.addMessage(aService, 0, ce.getMessage());
        }
        catch (CastingException ex) {
            this.addMessage(aService, 0, ex.getMessage());
        }
    }

    private void validateGroundingForService(Service theService) {
        OWLSValidatorMessage msg;
        Grounding aGrounding = null;
        try {
            aGrounding = theService.getGrounding();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (aGrounding == null) {
            OWLSValidatorMessage msg2 = new OWLSValidatorMessage(1, "No grounding specified for service: " + theService.getLocalName());
            this.addMessage(theService, msg2);
            return;
        }
        if (aGrounding.getProperties(OWLS_1_1.Service.supportedBy).size() > 1) {
            msg = new OWLSValidatorMessage(0, "The grounding '" + aGrounding.getLocalName() + "' cannot have more than one supportedBy property");
            this.addMessage(theService, msg);
        }
        if (aGrounding.getService() == null) {
            msg = new OWLSValidatorMessage(1, "The grounding '" + aGrounding.getLocalName() + "' does not specify a service.");
            this.addMessage(theService, msg);
        }
        try {
            OWLIndividualList<AtomicGrounding> aGroundingList = aGrounding.getAtomicGroundings();
            for (AtomicGrounding aAtomicGrounding : aGroundingList) {
                if (aAtomicGrounding.getProcess() == null) {
                    OWLSValidatorMessage msg3 = new OWLSValidatorMessage(1, "The atomic grounding '" + aAtomicGrounding.getLocalName() + "' does not specify its process.");
                    this.addMessage(theService, msg3);
                }
                if (aAtomicGrounding.canCastTo(JavaAtomicGrounding.class) || !aAtomicGrounding.canCastTo(WSDLAtomicGrounding.class)) continue;
                this.validateWSDLAtomicGrounding(theService, aAtomicGrounding.castTo(WSDLAtomicGrounding.class));
            }
        }
        catch (ConversionException ce) {
            this.addMessage(theService, 0, ce.getMessage());
        }
        catch (CastingException ex) {
            this.addMessage(theService, 0, ex.getMessage());
        }
    }

    private void validateWSDLAtomicGrounding(Service theService, WSDLAtomicGrounding theWSDLAtomicGrounding) {
        if (theWSDLAtomicGrounding.getOperationRef() == null) {
            this.addMessage(theService, 0, "The grounding '" + theWSDLAtomicGrounding.getLocalName() + "' has a missing, or invalid operationRef.");
        } else {
            if (theWSDLAtomicGrounding.getOperationRef().getPortType() == null) {
                this.addMessage(theService, 1, "The grounding '" + theWSDLAtomicGrounding.getLocalName() + "' must specify a portType for its operationRef.");
            }
            if (theWSDLAtomicGrounding.getOperationRef().getOperation() == null) {
                this.addMessage(theService, 1, "The grounding '" + theWSDLAtomicGrounding.getLocalName() + "' must specify an operation for its operationRef");
            }
        }
        OWLIndividualList inputMap = theWSDLAtomicGrounding.getInputMap();
        for (MessageMap messageMap : inputMap) {
            if (messageMap.getGroundingParameter() == null) {
                this.addMessage(theService, 1, "The input map for grounding '" + theWSDLAtomicGrounding.getLocalName() + "' requires a grounding parameter (wsdlMessagePart).");
            }
            if (messageMap.getOWLSParameter() != null || messageMap.getTransformation() != null) continue;
            this.addMessage(theService, 1, "The input map for grounding '" + theWSDLAtomicGrounding.getLocalName() + "' must specify either an owlsParameter or an xlstTransformation.");
        }
        OWLIndividualList oWLIndividualList = theWSDLAtomicGrounding.getOutputMap();
        for (MessageMap messageMap : oWLIndividualList) {
            if (messageMap.getOWLSParameter() == null) {
                this.addMessage(theService, 1, "The output map for grounding '" + theWSDLAtomicGrounding.getLocalName() + "' requires an owlsParameter.");
            }
            if (messageMap.getGroundingParameter() != null || messageMap.getTransformation() != null) continue;
            this.addMessage(theService, 1, "The output map for grounding '" + theWSDLAtomicGrounding.getLocalName() + "' must specify either an grounding parameter (wsdlMessagePart) or an xlstTransformation.");
        }
    }

    private void validateSplitJoin(Service theService, SplitJoin theSplitJoin) {
        ControlConstructBag ccBag = theSplitJoin.getComponents();
        int i = 0;
        while (i < ccBag.size()) {
            ControlConstruct aCC = ccBag.get(i);
            this.validateControlConstruct(theService, aCC);
            ++i;
        }
    }

    private void validateControlConstruct(Service theService, ControlConstruct theControlConstruct) {
        if (theControlConstruct.canCastTo(Perform.class)) {
            this.validatePerform(theService, theControlConstruct.castTo(Perform.class));
        } else if (theControlConstruct.canCastTo(SplitJoin.class)) {
            this.validateSplitJoin(theService, theControlConstruct.castTo(SplitJoin.class));
        } else {
            System.err.println("unsupported CC? " + theControlConstruct.getClass());
        }
    }

    private void validateResult(Service theService, Result theResult) {
        OWLIndividualList<Parameter> aParamList = theResult.getParameters();
        int i = 0;
        while (i < aParamList.size()) {
            Parameter aParam = (Parameter)aParamList.get(i);
            this.validateParameter(theService, aParam);
            ++i;
        }
        OWLIndividualList<Expression> aList = theResult.getEffects();
        int i2 = 0;
        while (i2 < aList.size()) {
            ++i2;
        }
        OWLIndividualList<OutputBinding> aBindingList = theResult.getBindings();
        for (OutputBinding outputBinding : aBindingList) {
            if (outputBinding.getParameter() != null) continue;
            this.addMessage(theService, 1, "Result '" + theResult.getLocalName() + "' must specify an Output for its toParam property.");
        }
    }

    private void validatePerform(Service theService, Perform thePerform) {
        try {
            if (thePerform.getProcess() == null) {
                OWLSValidatorMessage msg = new OWLSValidatorMessage(1, "Perform '" + thePerform.getLocalName() + "' must specify a process");
                this.addMessage(theService, msg);
            }
        }
        catch (CastingException ex) {
            this.addMessage(theService, 0, ex.getMessage());
        }
        catch (ConversionException ce) {
            this.addMessage(theService, 0, ce.getMessage());
        }
        OWLIndividualList<InputBinding> aBindingList = thePerform.getBindings();
        for (InputBinding inputBinding : aBindingList) {
            try {
                if (inputBinding.getParameter() != null) continue;
                this.addMessage(theService, 1, "Perform '" + thePerform.getLocalName() + "' must specify an Input for the toParam property.");
            }
            catch (CastingException ex) {
                this.addMessage(theService, 0, ex.getMessage());
            }
            catch (ConversionException ex) {
                this.addMessage(theService, 0, ex.getMessage());
            }
        }
    }

    private void validateProfileForService(Service theService) {
        OWLSValidatorMessage msg;
        Profile aProfile = null;
        try {
            aProfile = theService.getProfile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (aProfile == null) {
            OWLSValidatorMessage msg2 = new OWLSValidatorMessage(1, "No profile specified for service: " + theService.getLocalName());
            this.addMessage(theService, msg2);
            return;
        }
        if (aProfile.getService() == null) {
            msg = new OWLSValidatorMessage(1, "No service specified for profile: " + aProfile.getLocalName() + "; double check the presentedBy property on the profile to make sure its correctly specified");
            this.addMessage(theService, msg);
        }
        if (aProfile.getProperties(OWLS_1_1.Profile.serviceName).size() != 1) {
            msg = new OWLSValidatorMessage(1, "The profile '" + aProfile.getLocalName() + "' must specify only one serviceName. ");
            this.addMessage(theService, msg);
        }
        if (aProfile.getProperties(OWLS_1_1.Profile.textDescription).size() != 1) {
            msg = new OWLSValidatorMessage(1, "The profile '" + aProfile.getLocalName() + "' must specify only one textDescription.");
            this.addMessage(theService, msg);
        }
        if (!aProfile.getInputs().equals(theService.getProcess().getInputs())) {
            msg = new OWLSValidatorMessage(0, "Profile inputs for service '" + theService.getLocalName() + "' do not match the process inputs!");
            this.addMessage(theService, msg);
        }
        if (!aProfile.getOutputs().equals(theService.getProcess().getOutputs())) {
            msg = new OWLSValidatorMessage(0, "Profile outputs for service '" + theService.getLocalName() + "' do not match the process outputs!");
            this.addMessage(theService, msg);
        }
        OWLIndividualList<OWLIndividual> aList = aProfile.getServiceParameters();
        int i = 0;
        while (i < aList.size()) {
            ServiceParameter aServParam = (ServiceParameter)aList.get(i);
            this.validateServiceParameter(theService, aServParam);
            ++i;
        }
        aList = aProfile.getCategories();
        i = 0;
        while (i < aList.size()) {
            ServiceCategory aServCategory = (ServiceCategory)aList.get(i);
            this.validateServiceCategory(theService, aServCategory);
            ++i;
        }
        try {
            if (aProfile.getProcess() == null) {
                OWLSValidatorMessage msg3 = new OWLSValidatorMessage(1, "Profile '" + aProfile.getLocalName() + "' do not specify a process!");
                this.addMessage(theService, msg3);
            }
        }
        catch (ConversionException ce) {
            this.addMessage(theService, 0, ce.getMessage());
        }
        catch (CastingException ex) {
            this.addMessage(theService, 0, ex.getMessage());
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        OWLIndividualList<Result> aResultList = aProfile.getResults();
        int i2 = 0;
        while (i2 < aResultList.size()) {
            this.validateResult(theService, (Result)aResultList.get(i2));
            ++i2;
        }
    }

    private void validateServiceParameter(Service theService, ServiceParameter theServiceParameter) {
        OWLSValidatorMessage msg;
        if (theServiceParameter.getName() == null) {
            msg = new OWLSValidatorMessage(1, "Must specify a name for serviceParameter: " + theServiceParameter.getLocalName());
            this.addMessage(theService, msg);
        }
        if (theServiceParameter.getParameter() == null) {
            msg = new OWLSValidatorMessage(1, "Must specify a parameter for serviceParameter: " + theServiceParameter.getLocalName());
            this.addMessage(theService, msg);
        }
    }

    private void validateServiceCategory(Service theService, ServiceCategory theServiceCategory) {
        OWLSValidatorMessage msg;
        if (theServiceCategory.getCode() == null) {
            msg = new OWLSValidatorMessage(1, "Must specify a code for serviceCategory: " + theServiceCategory.getLocalName());
            this.addMessage(theService, msg);
        }
        if (theServiceCategory.getValue() == null) {
            msg = new OWLSValidatorMessage(1, "Must specify a value for serviceCategory " + theServiceCategory.getLocalName());
            this.addMessage(theService, msg);
        }
        if (theServiceCategory.getTaxonomy() == null) {
            msg = new OWLSValidatorMessage(1, "Must specify a taxonomy for serviceCategory: " + theServiceCategory.getLocalName());
            this.addMessage(theService, msg);
        }
        if (theServiceCategory.getName() == null) {
            msg = new OWLSValidatorMessage(1, "Must specify a name for serviceCategory: " + theServiceCategory.getLocalName());
            this.addMessage(theService, msg);
        }
    }

    private void addMessage(Service theService, int theCode, String theMsg) {
        this.addMessage(theService, new OWLSValidatorMessage(theCode, theMsg));
    }

    private void addMessage(Service theService, OWLSValidatorMessage theMsg) {
        Set<OWLSValidatorMessage> aSet = this.mMessageMap.get(theService);
        if (aSet == null) {
            aSet = new HashSet<OWLSValidatorMessage>();
        }
        aSet.add(theMsg);
        this.mMessageMap.put(theService, aSet);
    }

    public static void main(String[] args) {
        System.err.println("validator main");
        try {
            new OWLSValidator().validate(new File("composite.owl").toURL().toExternalForm().replaceAll(" ", "%20")).print(System.err);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

