/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLType;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.process.Condition;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.Process;
import org.mindswap.query.ABoxQuery;
import org.mindswap.query.ValueMap;
import org.mindswap.swrl.AtomList;
import org.mindswap.swrl.ClassAtom;
import org.mindswap.swrl.SWRLFactory;
import org.mindswap.swrl.SWRLFactoryCreator;
import org.mindswap.swrl.SWRLIndividualObject;
import org.mindswap.swrl.Variable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessUtils {
    private static final Logger logger = LoggerFactory.getLogger(ProcessUtils.class);

    public static Map<Variable, Set<OWLValue>> getAllowedValues(Process process) {
        return ProcessUtils.getAllowedValues(process.getKB(), process, new ValueMap());
    }

    public static Map<Variable, Set<OWLValue>> getAllowedValues(Process process, ValueMap initialBinding) {
        return ProcessUtils.getAllowedValues(process.getKB(), process, initialBinding);
    }

    public static Map<Variable, Set<OWLValue>> getAllowedValues(OWLKnowledgeBase kb, Process process, ValueMap initialBinding) {
        SWRLFactory swrl = null;
        HashMap<Variable, Set<OWLValue>> allowedValues = new HashMap<Variable, Set<OWLValue>>();
        OWLIndividualList<Condition> conditions = process.getConditions();
        if (conditions.size() > 1) {
            logger.warn("getAllowedValues does not support multiple conditions, checking the first condition only!");
        }
        AtomList atoms = null;
        if (conditions.isEmpty()) {
            swrl = SWRLFactoryCreator.createFactory(kb.getBaseOntology());
            atoms = swrl.createList();
        } else {
            Condition condition = (Condition)conditions.get(0);
            atoms = condition.getBody().apply(initialBinding);
            swrl = SWRLFactoryCreator.createFactory(process.getOntology());
        }
        OWLIndividualList<Input> inputs = process.getInputs();
        int i = 0;
        while (i < inputs.size()) {
            Input input = (Input)inputs.get(i);
            OWLType inputType = input.getParamType();
            if (!initialBinding.hasValue(input)) {
                allowedValues.put(input, new HashSet());
                if (inputType.isClass()) {
                    ClassAtom typeAtom = swrl.createClassAtom((OWLClass)inputType, input.castTo(SWRLIndividualObject.class));
                    atoms = atoms.insert(typeAtom);
                }
            }
            ++i;
        }
        ABoxQuery query = new ABoxQuery(atoms);
        query.addResultVars(allowedValues.keySet());
        logger.info(query.toString());
        List<ValueMap> results = kb.query(query);
        for (ValueMap binding : results) {
            for (Variable v : allowedValues.keySet()) {
                Input input = (Input)v;
                Object value = binding.getValue(input);
                if (value == null) continue;
                Set set = (Set)allowedValues.get(input);
                set.add(value);
            }
        }
        return allowedValues;
    }
}

