/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.utils;

import java.net.URI;
import java.net.URISyntaxException;
import org.mindswap.exceptions.InvalidURIException;
import org.mindswap.utils.QNameProvider;

public class URIUtils {
    public static String getLocalName(URI uri) {
        return URIUtils.getLocalName(uri.toString());
    }

    public static String getLocalName(String uri) {
        int index = URIUtils.splitPos(uri);
        if (index == -1) {
            return null;
        }
        return uri.substring(index + 1);
    }

    public static String getNameSpace(URI uri) {
        return URIUtils.getNameSpace(uri.toString());
    }

    public static String getNameSpace(String uri) {
        int index = URIUtils.splitPos(uri);
        if (index == -1) {
            return null;
        }
        return uri.substring(0, index + 1);
    }

    private static int splitPos(String uri) {
        int pos = uri.indexOf("#");
        if (pos == -1) {
            pos = QNameProvider.findLastNameIndex(uri) - 1;
        }
        return pos;
    }

    public static URI createURI(String uri) throws InvalidURIException {
        try {
            return new URI(uri.replaceAll(" ", "%20"));
        }
        catch (URISyntaxException e) {
            throw new InvalidURIException(e);
        }
    }

    public static URI createURI(URI baseURI, String localName) throws InvalidURIException {
        try {
            return new URI(baseURI.getScheme(), baseURI.getSchemeSpecificPart(), localName);
        }
        catch (URISyntaxException e) {
            throw new InvalidURIException(e);
        }
    }

    public static URI createURI(String schemeSpecificPart, String localName, String fragment) throws InvalidURIException {
        try {
            return new URI(schemeSpecificPart, localName, fragment);
        }
        catch (URISyntaxException e) {
            throw new InvalidURIException(e);
        }
    }

    public static URI standardURI(URI uri) throws InvalidURIException {
        if (uri.getFragment() != null) {
            try {
                uri = new URI(uri.getScheme(), uri.getSchemeSpecificPart(), null);
            }
            catch (URISyntaxException e) {
                throw new InvalidURIException(e.getMessage());
            }
        }
        return uri;
    }

    public static boolean relaxedMatch(String uri1, String uri2) {
        if (uri1 == null || uri2 == null) {
            return false;
        }
        if (uri1.equals(uri2)) {
            return true;
        }
        String name1 = URIUtils.getLocalName(uri1);
        String name2 = URIUtils.getLocalName(uri2);
        if (name1 == null || name2 == null) {
            return false;
        }
        return name1.equals(name2);
    }

    public static boolean isValidURI(String uri) {
        try {
            URI.create(uri);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

