/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.wsdl;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.apache.axis.client.Call;
import org.apache.axis.wsdl.gen.Parser;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.symbolTable.SymTabEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.mindswap.wsdl.WSDLOperation;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLService {
    public static boolean DEBUG = false;
    private Parser wsdlParser = null;
    private URI uri = null;
    private final Map<String, WSDLOperation> operations = new HashMap<String, WSDLOperation>();

    public WSDLService(URI wsdlURL) throws Exception {
        this.uri = wsdlURL;
        this.wsdlParser = new Parser();
        if (DEBUG) {
            System.out.println("Reading WSDL document from '" + wsdlURL + "'");
        }
        this.wsdlParser.run(wsdlURL.toString());
        this.readOperations();
    }

    public static WSDLService createService(String wsdlLoc) throws Exception {
        return WSDLService.createService(URI.create(wsdlLoc));
    }

    public static WSDLService createService(URI wsdlLoc) throws Exception {
        WSDLService s = new WSDLService(wsdlLoc);
        return s;
    }

    private String createURI(QName qname) {
        return String.valueOf(qname.getNamespaceURI()) + "#" + qname.getLocalPart();
    }

    private String createURI(String localName) {
        return this.uri + "#" + localName;
    }

    private void readOperations() {
        try {
            String serviceNS = null;
            String serviceName = null;
            String operationName = null;
            String portName = null;
            Service service = this.selectService(serviceNS, serviceName);
            org.apache.axis.client.Service dpf = new org.apache.axis.client.Service(this.wsdlParser, service.getQName());
            Port port = this.selectPort(service.getPorts(), portName);
            if (portName == null) {
                portName = port.getName();
            }
            Binding binding = port.getBinding();
            SymbolTable symbolTable = this.wsdlParser.getSymbolTable();
            BindingEntry bEntry = symbolTable.getBindingEntry(binding.getQName());
            Parameters parameters = null;
            for (Operation o : bEntry.getParameters().keySet()) {
                Node doc;
                operationName = o.getName();
                Call call = (Call)dpf.createCall(QName.valueOf(portName), QName.valueOf(operationName));
                WSDLOperation op = new WSDLOperation(call);
                op.setService(this);
                this.operations.put(operationName, op);
                Message inputMessage = o.getInput().getMessage();
                Message outputMessage = o.getOutput().getMessage();
                op.setOperationName(this.createURI(operationName));
                op.setInputMessageName(this.createURI(inputMessage.getQName()));
                op.setOutputMessageName(this.createURI(outputMessage.getQName()));
                op.setPortName(this.createURI(port.getName()));
                if (DEBUG) {
                    System.out.println(" Operation : " + operationName);
                    System.out.println(" Port      : " + portName + " -> " + op.getPortName());
                    System.out.println(" Input Msg : " + inputMessage.getQName() + " -> " + op.getInputMessageName());
                    System.out.println(" Output Msg: " + outputMessage.getQName() + " -> " + op.getOutputMessageName());
                }
                if (o.getDocumentationElement() != null && (doc = o.getDocumentationElement().getFirstChild()) != null) {
                    op.setDocumentation(doc.getNodeValue());
                }
                parameters = (Parameters)bEntry.getParameters().get(o);
                int j = 0;
                while (j < parameters.list.size()) {
                    Parameter p = (Parameter)parameters.list.get(j);
                    String name = this.createURI(p.getName());
                    QName type = p.getType().getQName();
                    if (p.getMode() == 1) {
                        op.addInput(name, type);
                        if (DEBUG) {
                            System.out.println(" Input     : " + name + " " + type);
                        }
                    } else if (p.getMode() == 2) {
                        op.addOutput(name, type);
                        if (DEBUG) {
                            System.out.println(" Output    : " + name + " " + type);
                        }
                    } else if (p.getMode() == 3) {
                        op.addInput(name, type);
                        op.addOutput(name, type);
                        System.err.println("WARNING: A wsdl parameter is defined as INOUT is not tested yet");
                        System.err.println("         Parameter = " + name);
                        if (DEBUG) {
                            System.out.println(" InOut     : " + name + " " + type);
                        }
                    }
                    ++j;
                }
                if (parameters.returnParam != null) {
                    Parameter p = parameters.returnParam;
                    String name = this.createURI(p.getName());
                    QName type = p.getType().getQName();
                    op.addOutput(name, type);
                    if (DEBUG) {
                        System.out.println(" Return    : " + name + " " + type);
                    }
                }
                if (!DEBUG) continue;
                System.out.println(" Inputs    : " + op.getInputs().size());
                System.out.println(" Outputs   : " + op.getOutputs().size());
                System.out.println(" Document  : " + op.getDocumentation());
                System.out.println();
            }
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }

    private Service selectService(String serviceNS, String serviceName) throws Exception {
        QName serviceQName = serviceNS != null && serviceName != null ? new QName(serviceNS, serviceName) : null;
        ServiceEntry serviceEntry = (ServiceEntry)this.getSymTabEntry(serviceQName, ServiceEntry.class);
        return serviceEntry.getService();
    }

    private SymTabEntry getSymTabEntry(QName qname, Class cls) {
        HashMap map = this.wsdlParser.getSymbolTable().getHashMap();
        for (Map.Entry entry : map.entrySet()) {
            Vector v = (Vector)entry.getValue();
            if (qname != null && !qname.equals(qname)) continue;
            int i = 0;
            while (i < v.size()) {
                SymTabEntry symTabEntry = (SymTabEntry)v.elementAt(i);
                if (cls.isInstance(symTabEntry)) {
                    return symTabEntry;
                }
                ++i;
            }
        }
        return null;
    }

    private Port selectPort(Map ports, String portName) throws Exception {
        for (String name : ports.keySet()) {
            if (portName == null || portName.length() == 0) {
                Port port = (Port)ports.get(name);
                List list = port.getExtensibilityElements();
                int i = 0;
                while (list != null && i < list.size()) {
                    Object obj = list.get(i);
                    if (obj instanceof SOAPAddress) {
                        return port;
                    }
                    ++i;
                }
                continue;
            }
            if (name == null || !name.equals(portName)) continue;
            return (Port)ports.get(name);
        }
        return null;
    }

    public URI getFileURI() {
        return this.uri;
    }

    public List<WSDLOperation> getOperations() {
        return new ArrayList<WSDLOperation>(this.operations.values());
    }

    public WSDLOperation getOperation(String opName) {
        return this.operations.get(opName);
    }
}

