/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.lintpattern.axiom;

import com.clarkparsia.pellint.format.LintFormat;
import com.clarkparsia.pellint.format.SimpleLintFormat;
import com.clarkparsia.pellint.lintpattern.axiom.AxiomLintPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.util.OWLUtil;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;

public class GCIPattern
extends AxiomLintPattern {
    private static final LintFormat DEFAULT_LINT_FORMAT = new SimpleLintFormat();

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public String getDescription() {
        return "GCI axiom, or equivalence classes axiom with two or more complex concepts";
    }

    public boolean isFixable() {
        return false;
    }

    public LintFormat getDefaultLintFormat() {
        return DEFAULT_LINT_FORMAT;
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        int complexCount = 0;
        for (OWLDescription desc : axiom.getDescriptions()) {
            if (!OWLUtil.isComplex(desc)) continue;
            ++complexCount;
        }
        if (complexCount > 1) {
            Lint lint = this.makeLint();
            lint.addParticipatingAxiom((OWLClassAxiom)axiom);
            this.setLint(lint);
        }
    }

    public void visit(OWLSubClassAxiom axiom) {
        if (OWLUtil.isComplex(axiom.getSubClass())) {
            Lint lint = this.makeLint();
            lint.addParticipatingAxiom((OWLClassAxiom)axiom);
            this.setLint(lint);
        }
    }
}

