/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.explanation;

import com.clarkparsia.explanation.ReasonerFactory;
import com.clarkparsia.explanation.SingleExplanationGenerator;
import com.clarkparsia.explanation.util.DefinitionTracker;
import org.semanticweb.owl.inference.OWLClassReasoner;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyManager;

public abstract class SingleExplanationGeneratorImpl
implements SingleExplanationGenerator {
    protected OWLOntologyManager owlOntologyManager;
    protected OWLOntology ontology;
    protected OWLClassReasoner reasoner;
    protected ReasonerFactory reasonerFactory;
    protected DefinitionTracker definitionTracker;
    protected OWLClassReasoner altReasoner;
    private long fullOntSize = -1L;

    public SingleExplanationGeneratorImpl(OWLOntologyManager manager) {
        this.owlOntologyManager = manager;
        this.definitionTracker = new DefinitionTracker(manager);
    }

    public OWLOntologyManager getOntologyManager() {
        return this.owlOntologyManager;
    }

    public void setOntology(OWLOntology ontology) {
        this.ontology = ontology;
        this.altReasoner = null;
        this.fullOntSize = 0L;
        for (OWLOntology ont : this.owlOntologyManager.getImportsClosure(ontology)) {
            this.fullOntSize += (long)ont.getLogicalAxioms().size();
        }
        this.definitionTracker.setOntology(ontology);
    }

    public OWLClassReasoner getReasoner() {
        return this.reasoner;
    }

    public void setReasoner(OWLClassReasoner reasoner) {
        this.reasoner = reasoner;
        this.altReasoner = null;
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    public ReasonerFactory getReasonerFactory() {
        return this.reasonerFactory;
    }

    public void setReasonerFactory(ReasonerFactory reasonerFactory) {
        this.reasonerFactory = reasonerFactory;
        this.altReasoner = null;
    }

    public OWLClassReasoner getAltReasoner() {
        if (this.altReasoner == null) {
            this.altReasoner = this.reasonerFactory.createReasoner(this.owlOntologyManager);
        }
        return this.altReasoner;
    }

    protected boolean isFirstExplanation() {
        if (this.fullOntSize == -1L) {
            if (this.ontology == null) {
                throw new RuntimeException("No ontology specified");
            }
            throw new RuntimeException("Ontology size unknown");
        }
        int currentOntSize = 0;
        for (OWLOntology ont : this.owlOntologyManager.getImportsClosure(this.ontology)) {
            currentOntSize += ont.getLogicalAxioms().size();
        }
        return (long)currentOntSize == this.fullOntSize;
    }
}

