/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.explanation.util;

import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChangeException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.RemoveAxiom;
import org.semanticweb.owl.util.OWLEntityCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologyUtils {
    public static boolean containsUnreferencedEntity(OWLOntology ontology, OWLDescription desc) {
        OWLEntityCollector entityCollector = new OWLEntityCollector();
        desc.accept(entityCollector);
        for (OWLEntity entity : entityCollector.getObjects()) {
            if (ontology.containsEntityReference(entity) || entity instanceof OWLClass && (((OWLClass)entity).isOWLThing() || ((OWLClass)entity).isOWLNothing())) continue;
            return true;
        }
        return false;
    }

    public static Set<OWLOntology> removeAxiom(OWLAxiom axiom, Set<OWLOntology> ontologies, OWLOntologyManager manager) throws OWLOntologyChangeException {
        HashSet<OWLOntology> modifiedOnts = new HashSet<OWLOntology>();
        for (OWLOntology ont : ontologies) {
            if (!ont.getAxioms().contains(axiom)) continue;
            modifiedOnts.add(ont);
            manager.applyChange(new RemoveAxiom(ont, axiom));
        }
        return modifiedOnts;
    }

    public static void addAxiom(OWLAxiom axiom, Set<OWLOntology> ontologies, OWLOntologyManager manager) throws OWLOntologyChangeException {
        for (OWLOntology ont : ontologies) {
            manager.applyChange(new AddAxiom(ont, axiom));
        }
    }
}

