/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.functionalparser;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.coode.owl.functionalparser.OWLFunctionalSyntaxParserConstants;
import org.coode.owl.functionalparser.OWLFunctionalSyntaxParserTokenManager;
import org.coode.owl.functionalparser.ParseException;
import org.coode.owl.functionalparser.SimpleCharStream;
import org.coode.owl.functionalparser.Token;
import org.coode.string.EscapeUtils;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLAnnotation;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLIndividualAxiom;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyChangeException;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLPropertyAxiom;
import org.semanticweb.owl.model.OWLRuntimeException;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.model.SetOntologyURI;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;
import org.semanticweb.owl.vocab.OWLRestrictedDataRangeFacetVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLFunctionalSyntaxParser
implements OWLFunctionalSyntaxParserConstants {
    private OWLOntologyManager man;
    private OWLOntology ontology;
    private OWLDataFactory dataFactory;
    private Map<String, URI> string2URI;
    private Map<String, String> prefixMap;
    private URI ontologyURI;
    private boolean ignoreAnnotationsAndDeclarations = false;
    private Set<OWLAnnotation> currentAnnotations;
    public OWLFunctionalSyntaxParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[0];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private final JJCalls[] jj_2_rtns = new JJCalls[105];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public void setUp(OWLOntologyManager man, OWLOntology ontology) {
        this.man = man;
        this.ontology = ontology;
        this.dataFactory = man.getOWLDataFactory();
        this.currentAnnotations = new HashSet<OWLAnnotation>();
        this.prefixMap = new HashMap<String, String>();
        this.string2URI = new HashMap<String, URI>();
    }

    public URI getURI(String s) throws URISyntaxException {
        URI uri = this.string2URI.get(s);
        if (uri == null) {
            uri = s.charAt(0) == '<' ? new URI(s.substring(1, s.length() - 1)) : new URI(s);
            this.string2URI.put(s, uri);
        }
        return uri;
    }

    public void setIgnoreAnnotationsAndDeclarations(boolean b) {
        this.ignoreAnnotationsAndDeclarations = b;
    }

    protected void applyChange(OWLOntologyChange chg) {
        try {
            this.man.applyChange(chg);
        }
        catch (OWLOntologyChangeException e) {
            e.printStackTrace();
        }
    }

    protected void addAxiom(OWLAxiom ax) {
        AddAxiom addAxiom = new AddAxiom(this.ontology, ax);
        this.applyChange(addAxiom);
    }

    public final void parse() throws ParseException, OWLOntologyCreationException {
        while (this.jj_2_1(2)) {
            this.Namespace();
        }
        this.Ontology();
        this.jj_consume_token(0);
    }

    public final void Ontology() throws ParseException, OWLOntologyCreationException {
        OWLAxiom ax;
        boolean count = false;
        this.jj_consume_token(15);
        this.jj_consume_token(12);
        this.ontologyURI = this.URI();
        this.applyChange(new SetOntologyURI(this.ontology, this.ontologyURI));
        while (this.jj_2_2(2)) {
            OWLAnnotation anno = this.Annotation();
            ax = this.dataFactory.getOWLOntologyAnnotationAxiom(this.ontology, anno);
            this.addAxiom(ax);
            this.currentAnnotations.clear();
        }
        while (this.jj_2_3(2)) {
            ax = this.Axiom();
            this.addAxiom(ax);
            for (OWLAnnotation axAnno : this.currentAnnotations) {
                OWLAxiomAnnotationAxiom axAnnoAx = this.dataFactory.getOWLAxiomAnnotationAxiom(ax, axAnno);
                this.addAxiom(axAnnoAx);
            }
            this.currentAnnotations.clear();
            if (!(ax instanceof OWLImportsDeclaration)) continue;
            this.man.makeLoadImportRequest((OWLImportsDeclaration)ax);
        }
        this.jj_consume_token(13);
    }

    public final void Namespace() throws ParseException {
        Token t;
        String prefix = "";
        this.jj_consume_token(82);
        this.jj_consume_token(12);
        if (this.jj_2_4(2)) {
            t = this.jj_consume_token(96);
            prefix = t.image;
        }
        this.jj_consume_token(93);
        t = this.jj_consume_token(95);
        String ns = t.image;
        this.jj_consume_token(13);
        this.prefixMap.put(prefix, ns.substring(1, ns.length() - 1));
    }

    public final URI URI() throws ParseException {
        URI uri;
        if (this.jj_2_5(2)) {
            uri = this.QURI();
        } else if (this.jj_2_6(2)) {
            uri = this.QName();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return uri;
    }

    public final URI QURI() throws ParseException {
        Token t = this.jj_consume_token(95);
        try {
            String s = t.image;
            return this.getURI(s);
        }
        catch (URISyntaxException e) {
            throw new OWLRuntimeException(e);
        }
    }

    public final URI QName() throws ParseException {
        Token t;
        String prefix = "";
        String name = null;
        if (this.jj_2_7(2)) {
            t = this.jj_consume_token(96);
            prefix = t.image;
            this.jj_consume_token(14);
        }
        t = this.jj_consume_token(96);
        name = t.image;
        try {
            if (prefix != null) {
                String base = this.prefixMap.get(prefix);
                return this.getURI(base + name);
            }
            return this.getURI(this.ontologyURI.toString() + "#" + name);
        }
        catch (URISyntaxException e) {
            throw new OWLRuntimeException(e);
        }
    }

    public final OWLDescription Description() throws ParseException {
        OWLDescription desc;
        if (this.jj_2_8(2)) {
            desc = this.ClassURI();
        } else if (this.jj_2_9(2)) {
            desc = this.ObjectUnionOf();
        } else if (this.jj_2_10(2)) {
            desc = this.ObjectIntersectionOf();
        } else if (this.jj_2_11(2)) {
            desc = this.ObjectComplementOf();
        } else if (this.jj_2_12(2)) {
            desc = this.ObjectOneOf();
        } else if (this.jj_2_13(2)) {
            desc = this.ObjectSomeValuesFrom();
        } else if (this.jj_2_14(2)) {
            desc = this.ObjectAllValuesFrom();
        } else if (this.jj_2_15(2)) {
            desc = this.ObjectHasValue();
        } else if (this.jj_2_16(2)) {
            desc = this.ObjectSelf();
        } else if (this.jj_2_17(2)) {
            desc = this.ObjectMinCardinality();
        } else if (this.jj_2_18(2)) {
            desc = this.ObjectExactCardinality();
        } else if (this.jj_2_19(2)) {
            desc = this.ObjectMaxCardinality();
        } else if (this.jj_2_20(2)) {
            desc = this.DataSomeValuesFrom();
        } else if (this.jj_2_21(2)) {
            desc = this.DataAllValuesFrom();
        } else if (this.jj_2_22(2)) {
            desc = this.DataHasValue();
        } else if (this.jj_2_23(2)) {
            desc = this.DataMinCardinality();
        } else if (this.jj_2_24(2)) {
            desc = this.DataExactCardinality();
        } else if (this.jj_2_25(2)) {
            desc = this.DataMaxCardinality();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return desc;
    }

    public final OWLClass ClassURI() throws ParseException {
        URI uri = this.URI();
        return this.dataFactory.getOWLClass(uri);
    }

    public final Set<OWLDescription> DescriptionSet() throws ParseException {
        HashSet<OWLDescription> descriptions = new HashSet<OWLDescription>();
        OWLDescription desc = this.Description();
        descriptions.add(desc);
        desc = this.Description();
        descriptions.add(desc);
        while (this.jj_2_26(2)) {
            desc = this.Description();
            descriptions.add(desc);
        }
        return descriptions;
    }

    public final Set<OWLIndividual> IndividualMinOneSet() throws ParseException {
        HashSet<OWLIndividual> individuals = new HashSet<OWLIndividual>();
        OWLIndividual ind = this.IndividualURI();
        individuals.add(ind);
        while (this.jj_2_27(2)) {
            ind = this.IndividualURI();
            individuals.add(ind);
        }
        return individuals;
    }

    public final OWLDescription ObjectUnionOf() throws ParseException {
        this.jj_consume_token(35);
        this.jj_consume_token(12);
        Set<OWLDescription> descriptions = this.DescriptionSet();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLObjectUnionOf(descriptions);
    }

    public final OWLDescription ObjectIntersectionOf() throws ParseException {
        this.jj_consume_token(41);
        this.jj_consume_token(12);
        Set<OWLDescription> descriptions = this.DescriptionSet();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLObjectIntersectionOf(descriptions);
    }

    public final OWLDescription ObjectComplementOf() throws ParseException {
        this.jj_consume_token(42);
        this.jj_consume_token(12);
        OWLDescription operand = this.Description();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLObjectComplementOf(operand);
    }

    public final OWLDescription ObjectOneOf() throws ParseException {
        this.jj_consume_token(34);
        this.jj_consume_token(12);
        Set<OWLIndividual> individuals = this.IndividualMinOneSet();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLObjectOneOf(individuals);
    }

    public final OWLDescription ObjectAllValuesFrom() throws ParseException {
        this.jj_consume_token(43);
        this.jj_consume_token(12);
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        OWLDescription filler = this.Description();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLObjectAllRestriction(prop, filler);
    }

    public final OWLDescription ObjectSomeValuesFrom() throws ParseException {
        this.jj_consume_token(44);
        this.jj_consume_token(12);
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        OWLDescription filler = this.Description();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLObjectSomeRestriction(prop, filler);
    }

    public final OWLDescription ObjectHasValue() throws ParseException {
        this.jj_consume_token(36);
        this.jj_consume_token(12);
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        OWLIndividual ind = this.IndividualURI();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLObjectValueRestriction(prop, ind);
    }

    public final OWLDescription ObjectSelf() throws ParseException {
        this.jj_consume_token(45);
        this.jj_consume_token(12);
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLObjectSelfRestriction(prop);
    }

    public final OWLDescription ObjectMinCardinality() throws ParseException {
        int cardinality = 0;
        OWLObjectPropertyExpression prop = null;
        OWLDescription filler = null;
        this.jj_consume_token(46);
        this.jj_consume_token(12);
        cardinality = this.Cardinality();
        prop = this.ObjectPropertyExpression();
        if (this.jj_2_28(2)) {
            filler = this.Description();
        }
        this.jj_consume_token(13);
        if (filler == null) {
            return this.dataFactory.getOWLObjectMinCardinalityRestriction(prop, cardinality);
        }
        return this.dataFactory.getOWLObjectMinCardinalityRestriction(prop, cardinality, filler);
    }

    public final OWLDescription ObjectExactCardinality() throws ParseException {
        int cardinality = 0;
        OWLObjectPropertyExpression prop = null;
        OWLDescription filler = null;
        this.jj_consume_token(48);
        this.jj_consume_token(12);
        cardinality = this.Cardinality();
        prop = this.ObjectPropertyExpression();
        if (this.jj_2_29(2)) {
            filler = this.Description();
        }
        this.jj_consume_token(13);
        if (filler == null) {
            return this.dataFactory.getOWLObjectExactCardinalityRestriction(prop, cardinality);
        }
        return this.dataFactory.getOWLObjectExactCardinalityRestriction(prop, cardinality, filler);
    }

    public final OWLDescription ObjectMaxCardinality() throws ParseException {
        int cardinality = 0;
        OWLObjectPropertyExpression prop = null;
        OWLDescription filler = null;
        this.jj_consume_token(47);
        this.jj_consume_token(12);
        cardinality = this.Cardinality();
        prop = this.ObjectPropertyExpression();
        if (this.jj_2_30(2)) {
            filler = this.Description();
        }
        this.jj_consume_token(13);
        if (filler == null) {
            return this.dataFactory.getOWLObjectMaxCardinalityRestriction(prop, cardinality);
        }
        return this.dataFactory.getOWLObjectMaxCardinalityRestriction(prop, cardinality, filler);
    }

    public final OWLDescription DataAllValuesFrom() throws ParseException {
        OWLDataPropertyExpression prop = null;
        OWLDataRange dataRange = null;
        this.jj_consume_token(49);
        this.jj_consume_token(12);
        prop = this.DataPropertyExpression();
        dataRange = this.DataRange();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLDataAllRestriction(prop, dataRange);
    }

    public final OWLDescription DataSomeValuesFrom() throws ParseException {
        OWLDataPropertyExpression prop = null;
        OWLDataRange dataRange = null;
        this.jj_consume_token(50);
        this.jj_consume_token(12);
        prop = this.DataPropertyExpression();
        dataRange = this.DataRange();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLDataSomeRestriction(prop, dataRange);
    }

    public final OWLDescription DataHasValue() throws ParseException {
        OWLDataPropertyExpression prop = null;
        OWLTypedConstant typedConstant = null;
        this.jj_consume_token(51);
        this.jj_consume_token(12);
        prop = this.DataPropertyExpression();
        typedConstant = this.TypedConstant();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLDataValueRestriction(prop, typedConstant);
    }

    public final OWLDescription DataMinCardinality() throws ParseException {
        int cardinality = 0;
        OWLDataPropertyExpression prop = null;
        OWLDataRange rng = null;
        this.jj_consume_token(53);
        this.jj_consume_token(12);
        cardinality = this.Cardinality();
        prop = this.DataPropertyExpression();
        if (this.jj_2_31(2)) {
            rng = this.DataRange();
        }
        this.jj_consume_token(13);
        if (rng == null) {
            return this.dataFactory.getOWLDataMinCardinalityRestriction(prop, cardinality);
        }
        return this.dataFactory.getOWLDataMinCardinalityRestriction(prop, cardinality, rng);
    }

    public final OWLDescription DataExactCardinality() throws ParseException {
        int cardinality = 0;
        OWLDataPropertyExpression prop = null;
        OWLDataRange rng = null;
        this.jj_consume_token(55);
        this.jj_consume_token(12);
        cardinality = this.Cardinality();
        prop = this.DataPropertyExpression();
        if (this.jj_2_32(2)) {
            this.DataRange();
        }
        this.jj_consume_token(13);
        if (rng == null) {
            return this.dataFactory.getOWLDataExactCardinalityRestriction(prop, cardinality);
        }
        return this.dataFactory.getOWLDataExactCardinalityRestriction(prop, cardinality, rng);
    }

    public final OWLDescription DataMaxCardinality() throws ParseException {
        int cardinality = 0;
        OWLDataPropertyExpression prop = null;
        OWLDataRange rng = null;
        this.jj_consume_token(54);
        this.jj_consume_token(12);
        cardinality = this.Cardinality();
        prop = this.DataPropertyExpression();
        if (this.jj_2_33(2)) {
            this.DataRange();
        }
        this.jj_consume_token(13);
        if (rng == null) {
            return this.dataFactory.getOWLDataMaxCardinalityRestriction(prop, cardinality);
        }
        return this.dataFactory.getOWLDataMaxCardinalityRestriction(prop, cardinality, rng);
    }

    public final OWLClass Class() throws ParseException {
        this.jj_consume_token(28);
        this.jj_consume_token(12);
        OWLClass cls = this.ClassURI();
        this.jj_consume_token(13);
        return cls;
    }

    public final OWLObjectPropertyExpression ObjectPropertyExpression() throws ParseException {
        if (this.jj_2_34(2)) {
            OWLObjectPropertyExpression prop = this.InverseObjectProperty();
            return prop;
        }
        if (this.jj_2_35(2)) {
            OWLObjectProperty prop = this.ObjectPropertyURI();
            return prop;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final OWLObjectPropertyExpression InverseObjectProperty() throws ParseException {
        this.jj_consume_token(37);
        this.jj_consume_token(12);
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        this.jj_consume_token(13);
        return prop;
    }

    public final OWLObjectProperty ObjectProperty() throws ParseException {
        this.jj_consume_token(29);
        this.jj_consume_token(12);
        OWLObjectProperty prop = this.ObjectPropertyURI();
        this.jj_consume_token(13);
        return prop;
    }

    public final OWLDataPropertyExpression DataPropertyExpression() throws ParseException {
        OWLDataProperty prop = this.DataPropertyURI();
        return prop;
    }

    public final OWLDataProperty DataPropertyURI() throws ParseException {
        URI uri = this.URI();
        return this.dataFactory.getOWLDataProperty(uri);
    }

    public final OWLDataProperty DataProperty() throws ParseException {
        this.jj_consume_token(30);
        this.jj_consume_token(12);
        OWLDataProperty prop = this.DataPropertyURI();
        this.jj_consume_token(13);
        return prop;
    }

    public final OWLIndividual Individual() throws ParseException {
        this.jj_consume_token(31);
        this.jj_consume_token(12);
        OWLIndividual ind = this.IndividualURI();
        this.jj_consume_token(13);
        return ind;
    }

    public final OWLDataType DataType() throws ParseException {
        this.jj_consume_token(32);
        this.jj_consume_token(12);
        OWLDataType dt = this.DataTypeURI();
        this.jj_consume_token(13);
        return dt;
    }

    public final OWLDataType DataTypeURI() throws ParseException {
        URI uri = this.URI();
        return this.dataFactory.getOWLDataType(uri);
    }

    public final int Cardinality() throws ParseException {
        int card = 0;
        card = this.Integer();
        return card;
    }

    public final int Integer() throws ParseException {
        Token t = this.jj_consume_token(94);
        int i = Integer.parseInt(t.image);
        return i;
    }

    public final OWLDataRange DataRange() throws ParseException {
        OWLDataRange rng;
        if (this.jj_2_36(2)) {
            rng = this.DataTypeURI();
        } else if (this.jj_2_37(2)) {
            rng = this.DataOneOf();
        } else if (this.jj_2_38(2)) {
            rng = this.DataComplementOf();
        } else if (this.jj_2_39(2)) {
            rng = this.DataRangeRestriction();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return rng;
    }

    public final OWLDataRange DataComplementOf() throws ParseException {
        this.jj_consume_token(39);
        this.jj_consume_token(12);
        OWLDataRange rng = this.DataRange();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLDataComplementOf(rng);
    }

    public final OWLDataRange DataOneOf() throws ParseException {
        HashSet<OWLTypedConstant> values = new HashSet<OWLTypedConstant>();
        OWLTypedConstant con = null;
        Object rng = null;
        this.jj_consume_token(33);
        this.jj_consume_token(12);
        con = this.TypedConstant();
        values.add(con);
        while (this.jj_2_40(2)) {
            con = this.TypedConstant();
            values.add(con);
        }
        this.jj_consume_token(13);
        return this.dataFactory.getOWLDataOneOf(values);
    }

    public final OWLDataRange DataRangeRestriction() throws ParseException {
        HashSet<OWLDataRangeFacetRestriction> facetRestrictions = new HashSet<OWLDataRangeFacetRestriction>();
        this.jj_consume_token(40);
        this.jj_consume_token(12);
        OWLDataRange rng = this.DataRange();
        do {
            OWLDataRangeFacetRestriction facetRestriction = this.DataRangeFacetRestriction();
            facetRestrictions.add(facetRestriction);
        } while (this.jj_2_41(2));
        this.jj_consume_token(13);
        return this.dataFactory.getOWLDataRangeRestriction(rng, facetRestrictions);
    }

    public final OWLDataRangeFacetRestriction DataRangeFacetRestriction() throws ParseException {
        Token facet;
        if (this.jj_2_42(2)) {
            facet = this.jj_consume_token(83);
        } else if (this.jj_2_43(2)) {
            facet = this.jj_consume_token(84);
        } else if (this.jj_2_44(2)) {
            facet = this.jj_consume_token(85);
        } else if (this.jj_2_45(2)) {
            facet = this.jj_consume_token(87);
        } else if (this.jj_2_46(2)) {
            facet = this.jj_consume_token(88);
        } else if (this.jj_2_47(2)) {
            facet = this.jj_consume_token(89);
        } else if (this.jj_2_48(2)) {
            facet = this.jj_consume_token(90);
        } else if (this.jj_2_49(2)) {
            facet = this.jj_consume_token(86);
        } else if (this.jj_2_50(2)) {
            facet = this.jj_consume_token(91);
        } else if (this.jj_2_51(2)) {
            facet = this.jj_consume_token(92);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        OWLTypedConstant con = this.TypedConstant();
        OWLRestrictedDataRangeFacetVocabulary v = OWLRestrictedDataRangeFacetVocabulary.getFacetByShortName(facet.image);
        return this.dataFactory.getOWLDataRangeFacetRestriction(v, con);
    }

    public final OWLAxiom Axiom() throws ParseException {
        OWLAxiom ax = null;
        if (this.jj_2_52(2)) {
            ax = this.ImportsDeclaration();
        } else if (this.jj_2_53(2)) {
            ax = this.ClassAxiom();
        } else if (this.jj_2_54(2)) {
            ax = this.ObjectPropertyAxiom();
        } else if (this.jj_2_55(2)) {
            ax = this.DataPropertyAxiom();
        } else if (this.jj_2_56(2)) {
            ax = this.IndividualAxiom();
        } else if (this.jj_2_57(2)) {
            ax = this.Declaration();
        } else if (this.jj_2_58(2)) {
            ax = this.EntityAnnotation();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return ax;
    }

    public final OWLClassAxiom ClassAxiom() throws ParseException {
        OWLClassAxiom ax;
        if (this.jj_2_59(2)) {
            ax = this.SubClassOf();
        } else if (this.jj_2_60(2)) {
            ax = this.EquivalentClasses();
        } else if (this.jj_2_61(2)) {
            ax = this.DisjointClasses();
        } else if (this.jj_2_62(2)) {
            ax = this.DisjointUnion();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return ax;
    }

    public final OWLClassAxiom SubClassOf() throws ParseException {
        this.jj_consume_token(19);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        OWLDescription subClass = this.Description();
        OWLDescription superClass = this.Description();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLSubClassAxiom(subClass, superClass);
    }

    public final OWLClassAxiom EquivalentClasses() throws ParseException {
        this.jj_consume_token(21);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        Set<OWLDescription> descriptions = this.DescriptionSet();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLEquivalentClassesAxiom(descriptions);
    }

    public final OWLClassAxiom DisjointClasses() throws ParseException {
        this.jj_consume_token(22);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        Set<OWLDescription> descriptions = this.DescriptionSet();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLDisjointClassesAxiom(descriptions);
    }

    public final OWLClassAxiom DisjointUnion() throws ParseException {
        this.jj_consume_token(23);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        OWLClass cls = this.ClassURI();
        Set<OWLDescription> descriptions = this.DescriptionSet();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLDisjointUnionAxiom(cls, descriptions);
    }

    public final OWLPropertyAxiom ObjectPropertyAxiom() throws ParseException {
        OWLPropertyAxiom ax;
        if (this.jj_2_63(2)) {
            ax = this.SubObjectPropertyOf();
        } else if (this.jj_2_64(2)) {
            ax = this.EquivalentObjectProperties();
        } else if (this.jj_2_65(2)) {
            ax = this.DisjointObjectProperties();
        } else if (this.jj_2_66(2)) {
            ax = this.ObjectPropertyRange();
        } else if (this.jj_2_67(2)) {
            ax = this.ObjectPropertyDomain();
        } else if (this.jj_2_68(2)) {
            ax = this.FunctionalObjectProperty();
        } else if (this.jj_2_69(2)) {
            ax = this.InverseFunctionalObjectProperty();
        } else if (this.jj_2_70(2)) {
            ax = this.SymmetricObjectProperty();
        } else if (this.jj_2_71(2)) {
            ax = this.AntiSymmetricObjectProperty();
        } else if (this.jj_2_72(2)) {
            ax = this.ReflexiveObjectProperty();
        } else if (this.jj_2_73(2)) {
            ax = this.IrreflexiveObjectProperty();
        } else if (this.jj_2_74(2)) {
            ax = this.TransitiveObjectProperty();
        } else if (this.jj_2_75(2)) {
            ax = this.InverseObjectProperties();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return ax;
    }

    public final List<OWLObjectPropertyExpression> SubObjectPropertyChain() throws ParseException {
        ArrayList<OWLObjectPropertyExpression> props = new ArrayList<OWLObjectPropertyExpression>();
        this.jj_consume_token(56);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        props.add(prop);
        while (this.jj_2_76(2)) {
            prop = this.ObjectPropertyExpression();
            props.add(prop);
        }
        this.jj_consume_token(13);
        return props;
    }

    public final OWLPropertyAxiom SubObjectPropertyOf() throws ParseException {
        OWLObjectPropertyExpression subProperty = null;
        List<OWLObjectPropertyExpression> chain = null;
        OWLObjectPropertyExpression superProperty = null;
        this.jj_consume_token(57);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        if (this.jj_2_77(2)) {
            subProperty = this.ObjectPropertyExpression();
        } else if (this.jj_2_78(2)) {
            chain = this.SubObjectPropertyChain();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        superProperty = this.ObjectPropertyExpression();
        this.jj_consume_token(13);
        if (subProperty != null) {
            return this.dataFactory.getOWLSubObjectPropertyAxiom(subProperty, superProperty);
        }
        if (chain != null) {
            return this.dataFactory.getOWLObjectPropertyChainSubPropertyAxiom(chain, superProperty);
        }
        return null;
    }

    public final OWLPropertyAxiom EquivalentObjectProperties() throws ParseException {
        this.jj_consume_token(58);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        Set<OWLObjectPropertyExpression> props = this.ObjectPropertySet();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLEquivalentObjectPropertiesAxiom(props);
    }

    public final OWLPropertyAxiom DisjointObjectProperties() throws ParseException {
        this.jj_consume_token(59);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        Set<OWLObjectPropertyExpression> props = this.ObjectPropertySet();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLDisjointObjectPropertiesAxiom(props);
    }

    public final Set<OWLObjectPropertyExpression> ObjectPropertySet() throws ParseException {
        HashSet<OWLObjectPropertyExpression> props = new HashSet<OWLObjectPropertyExpression>();
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        props.add(prop);
        prop = this.ObjectPropertyExpression();
        props.add(prop);
        while (this.jj_2_79(2)) {
            prop = this.ObjectPropertyExpression();
            props.add(prop);
        }
        return props;
    }

    public final OWLPropertyAxiom ObjectPropertyRange() throws ParseException {
        this.jj_consume_token(61);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        OWLDescription range = this.Description();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLObjectPropertyRangeAxiom(prop, range);
    }

    public final OWLPropertyAxiom ObjectPropertyDomain() throws ParseException {
        this.jj_consume_token(60);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        OWLDescription desc = this.Description();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLObjectPropertyDomainAxiom(prop, desc);
    }

    public final OWLPropertyAxiom FunctionalObjectProperty() throws ParseException {
        this.jj_consume_token(62);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLFunctionalObjectPropertyAxiom(prop);
    }

    public final OWLPropertyAxiom InverseObjectProperties() throws ParseException {
        this.jj_consume_token(38);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        OWLObjectPropertyExpression propA = this.ObjectPropertyExpression();
        OWLObjectPropertyExpression propB = this.ObjectPropertyExpression();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLInverseObjectPropertiesAxiom(propA, propB);
    }

    public final OWLPropertyAxiom InverseFunctionalObjectProperty() throws ParseException {
        this.jj_consume_token(63);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLInverseFunctionalObjectPropertyAxiom(prop);
    }

    public final OWLPropertyAxiom SymmetricObjectProperty() throws ParseException {
        this.jj_consume_token(66);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLSymmetricObjectPropertyAxiom(prop);
    }

    public final OWLPropertyAxiom AntiSymmetricObjectProperty() throws ParseException {
        this.jj_consume_token(67);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLAntiSymmetricObjectPropertyAxiom(prop);
    }

    public final OWLPropertyAxiom ReflexiveObjectProperty() throws ParseException {
        this.jj_consume_token(64);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLReflexiveObjectPropertyAxiom(prop);
    }

    public final OWLPropertyAxiom IrreflexiveObjectProperty() throws ParseException {
        this.jj_consume_token(65);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLIrreflexiveObjectPropertyAxiom(prop);
    }

    public final OWLPropertyAxiom TransitiveObjectProperty() throws ParseException {
        this.jj_consume_token(68);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLTransitiveObjectPropertyAxiom(prop);
    }

    public final OWLPropertyAxiom DataPropertyAxiom() throws ParseException {
        OWLPropertyAxiom ax;
        if (this.jj_2_80(2)) {
            ax = this.SubDataPropertyOf();
        } else if (this.jj_2_81(2)) {
            ax = this.EquivalentDataProperties();
        } else if (this.jj_2_82(2)) {
            ax = this.DisjointDataProperties();
        } else if (this.jj_2_83(2)) {
            ax = this.DataPropertyRange();
        } else if (this.jj_2_84(2)) {
            ax = this.DataPropertyDomain();
        } else if (this.jj_2_85(2)) {
            ax = this.FunctionalDataProperty();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return ax;
    }

    public final OWLPropertyAxiom SubDataPropertyOf() throws ParseException {
        this.jj_consume_token(69);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        OWLDataPropertyExpression subProperty = this.DataPropertyExpression();
        OWLDataPropertyExpression superProperty = this.DataPropertyExpression();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLSubDataPropertyAxiom(subProperty, superProperty);
    }

    public final OWLPropertyAxiom EquivalentDataProperties() throws ParseException {
        this.jj_consume_token(70);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        Set<OWLDataPropertyExpression> props = this.DataPropertySet();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLEquivalentDataPropertiesAxiom(props);
    }

    public final OWLPropertyAxiom DisjointDataProperties() throws ParseException {
        this.jj_consume_token(71);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        Set<OWLDataPropertyExpression> props = this.DataPropertySet();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLDisjointDataPropertiesAxiom(props);
    }

    public final Set<OWLDataPropertyExpression> DataPropertySet() throws ParseException {
        HashSet<OWLDataPropertyExpression> props = new HashSet<OWLDataPropertyExpression>();
        OWLDataPropertyExpression prop = this.DataPropertyExpression();
        props.add(prop);
        prop = this.DataPropertyExpression();
        props.add(prop);
        while (this.jj_2_86(2)) {
            prop = this.DataPropertyExpression();
            props.add(prop);
        }
        return props;
    }

    public final OWLPropertyAxiom DataPropertyDomain() throws ParseException {
        this.jj_consume_token(72);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        OWLDataPropertyExpression prop = this.DataPropertyExpression();
        OWLDescription domain = this.Description();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLDataPropertyDomainAxiom(prop, domain);
    }

    public final OWLPropertyAxiom DataPropertyRange() throws ParseException {
        this.jj_consume_token(73);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        OWLDataPropertyExpression prop = this.DataPropertyExpression();
        OWLDataRange rng = this.DataRange();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLDataPropertyRangeAxiom(prop, rng);
    }

    public final OWLPropertyAxiom FunctionalDataProperty() throws ParseException {
        this.jj_consume_token(74);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        OWLDataPropertyExpression prop = this.DataPropertyExpression();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLFunctionalDataPropertyAxiom(prop);
    }

    public final OWLIndividualAxiom IndividualAxiom() throws ParseException {
        OWLIndividualAxiom ax;
        if (this.jj_2_87(2)) {
            ax = this.SameIndividuals();
        } else if (this.jj_2_88(2)) {
            ax = this.DifferentIndividuals();
        } else if (this.jj_2_89(2)) {
            ax = this.ClassAssertion();
        } else if (this.jj_2_90(2)) {
            ax = this.ObjectPropertyAssertion();
        } else if (this.jj_2_91(2)) {
            ax = this.DataPropertyAssertion();
        } else if (this.jj_2_92(2)) {
            ax = this.NegativeObjectPropertyAssertion();
        } else if (this.jj_2_93(2)) {
            ax = this.NegativeDataPropertyAssertion();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return ax;
    }

    public final Set<OWLIndividual> IndividualSet() throws ParseException {
        HashSet<OWLIndividual> individuals = new HashSet<OWLIndividual>();
        OWLIndividual ind = this.IndividualURI();
        individuals.add(ind);
        ind = this.IndividualURI();
        individuals.add(ind);
        while (this.jj_2_94(2)) {
            ind = this.IndividualURI();
            individuals.add(ind);
        }
        return individuals;
    }

    public final OWLIndividualAxiom SameIndividuals() throws ParseException {
        this.jj_consume_token(75);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        Set<OWLIndividual> individuals = this.IndividualSet();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLSameIndividualsAxiom(individuals);
    }

    public final OWLIndividualAxiom DifferentIndividuals() throws ParseException {
        this.jj_consume_token(76);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        Set<OWLIndividual> individuals = this.IndividualSet();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLDifferentIndividualsAxiom(individuals);
    }

    public final OWLIndividualAxiom ClassAssertion() throws ParseException {
        this.jj_consume_token(77);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        OWLIndividual ind = this.IndividualURI();
        OWLDescription desc = this.Description();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLClassAssertionAxiom(ind, desc);
    }

    public final OWLIndividualAxiom ObjectPropertyAssertion() throws ParseException {
        this.jj_consume_token(78);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        OWLIndividual subj = this.IndividualURI();
        OWLIndividual obj = this.IndividualURI();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLObjectPropertyAssertionAxiom(subj, prop, obj);
    }

    public final OWLIndividualAxiom NegativeObjectPropertyAssertion() throws ParseException {
        this.jj_consume_token(79);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        OWLObjectPropertyExpression prop = this.ObjectPropertyExpression();
        OWLIndividual subj = this.IndividualURI();
        OWLIndividual obj = this.IndividualURI();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLNegativeObjectPropertyAssertionAxiom(subj, prop, obj);
    }

    public final OWLIndividualAxiom DataPropertyAssertion() throws ParseException {
        this.jj_consume_token(80);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        OWLDataPropertyExpression prop = this.DataPropertyExpression();
        OWLIndividual subj = this.IndividualURI();
        OWLConstant obj = this.Constant();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLDataPropertyAssertionAxiom(subj, prop, obj);
    }

    public final OWLIndividualAxiom NegativeDataPropertyAssertion() throws ParseException {
        this.jj_consume_token(81);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        OWLDataPropertyExpression prop = this.DataPropertyExpression();
        OWLIndividual subj = this.IndividualURI();
        OWLConstant obj = this.Constant();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLNegativeDataPropertyAssertionAxiom(subj, prop, obj);
    }

    public final OWLIndividual IndividualURI() throws ParseException {
        URI uri = this.URI();
        return this.dataFactory.getOWLIndividual(uri);
    }

    public final OWLObjectProperty ObjectPropertyURI() throws ParseException {
        URI uri = this.URI();
        return this.dataFactory.getOWLObjectProperty(uri);
    }

    public final OWLAnnotation Annotation() throws ParseException {
        if (this.jj_2_95(2)) {
            this.jj_consume_token(16);
            this.jj_consume_token(12);
            OWLConstant con = this.Constant();
            this.jj_consume_token(13);
            return this.dataFactory.getOWLConstantAnnotation(OWLRDFVocabulary.RDFS_LABEL.getURI(), con);
        }
        if (this.jj_2_96(2)) {
            this.jj_consume_token(18);
            this.jj_consume_token(12);
            OWLConstant con = this.Constant();
            this.jj_consume_token(13);
            return this.dataFactory.getOWLConstantAnnotation(OWLRDFVocabulary.RDFS_COMMENT.getURI(), con);
        }
        if (this.jj_2_97(2)) {
            this.jj_consume_token(24);
            this.jj_consume_token(12);
            URI uri = this.URI();
            OWLConstant con = this.Constant();
            this.jj_consume_token(13);
            return this.dataFactory.getOWLConstantAnnotation(uri, con);
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void AxiomAnnotationSet() throws ParseException {
        while (this.jj_2_98(2)) {
            OWLAnnotation anno = this.Annotation();
            this.currentAnnotations.add(anno);
        }
    }

    public final OWLImportsDeclaration ImportsDeclaration() throws ParseException {
        this.jj_consume_token(17);
        this.jj_consume_token(12);
        URI uri = this.URI();
        this.jj_consume_token(13);
        OWLImportsDeclaration importsDeclaration = this.dataFactory.getOWLImportsDeclarationAxiom(this.ontology, uri);
        return importsDeclaration;
    }

    public final void DocumentationAnnotation() throws ParseException {
        this.jj_consume_token(27);
        this.jj_consume_token(12);
        this.TypedConstant();
        this.jj_consume_token(13);
    }

    public final OWLEntityAnnotationAxiom EntityAnnotation() throws ParseException {
        this.jj_consume_token(25);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        OWLEntity entity = this.Entity();
        OWLAnnotation anno = this.Annotation();
        this.jj_consume_token(13);
        return this.dataFactory.getOWLEntityAnnotationAxiom(entity, anno);
    }

    public final OWLAxiom Declaration() throws ParseException {
        OWLEntity entity = null;
        Object uri = null;
        Object con = null;
        this.jj_consume_token(26);
        this.jj_consume_token(12);
        this.AxiomAnnotationSet();
        entity = this.Entity();
        this.jj_consume_token(13);
        if (this.ignoreAnnotationsAndDeclarations) {
            return null;
        }
        return this.dataFactory.getOWLDeclarationAxiom(entity);
    }

    public final OWLEntity Entity() throws ParseException {
        OWLEntity entity;
        if (this.jj_2_99(2)) {
            entity = this.Class();
        } else if (this.jj_2_100(2)) {
            entity = this.ObjectProperty();
        } else if (this.jj_2_101(2)) {
            entity = this.DataProperty();
        } else if (this.jj_2_102(2)) {
            entity = this.Individual();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return entity;
    }

    public final OWLConstant Constant() throws ParseException {
        OWLConstant con;
        if (this.jj_2_103(2)) {
            con = this.TypedConstant();
        } else if (this.jj_2_104(2)) {
            con = this.UntypedConstant();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return con;
    }

    public final OWLTypedConstant TypedConstant() throws ParseException {
        OWLDataType dataType = null;
        String literal = this.StringLiteral();
        this.jj_consume_token(100);
        dataType = this.DataTypeURI();
        return this.dataFactory.getOWLTypedConstant(literal, dataType);
    }

    public final OWLUntypedConstant UntypedConstant() throws ParseException {
        String lang = null;
        String literal = this.StringLiteral();
        if (this.jj_2_105(2)) {
            lang = this.LangTag();
        }
        if (lang == null) {
            return this.dataFactory.getOWLUntypedConstant(literal);
        }
        return this.dataFactory.getOWLUntypedConstant(literal, lang);
    }

    public final String StringLiteral() throws ParseException {
        Token t = this.jj_consume_token(10);
        String raw = t.image.substring(1, t.image.length() - 1);
        return EscapeUtils.unescapeString(raw);
    }

    public final String LangTag() throws ParseException {
        String lang = "";
        this.jj_consume_token(20);
        Token t = this.jj_consume_token(96);
        lang = lang + t.image;
        return lang;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_30(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_30();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(29, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_31(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_31();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(30, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_32(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_32();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(31, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_33(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_33();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(32, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_34(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_34();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(33, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_35(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_35();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(34, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_36(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_36();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(35, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_37(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_37();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(36, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_38(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_38();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(37, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_39(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_39();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(38, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_40(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_40();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(39, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_41(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_41();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(40, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_42(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_42();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(41, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_43(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_43();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(42, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_44(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_44();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(43, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_45(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_45();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(44, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_46(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_46();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(45, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_47(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_47();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(46, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_48(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_48();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(47, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_49(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_49();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(48, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_50(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_50();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(49, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_51(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_51();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(50, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_52(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_52();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(51, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_53(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_53();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(52, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_54(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_54();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(53, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_55(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_55();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(54, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_56(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_56();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(55, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_57(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_57();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(56, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_58(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_58();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(57, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_59(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_59();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(58, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_60(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_60();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(59, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_61(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_61();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(60, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_62(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_62();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(61, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_63(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_63();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(62, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_64(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_64();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(63, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_65(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_65();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(64, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_66(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_66();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(65, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_67(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_67();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(66, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_68(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_68();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(67, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_69(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_69();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(68, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_70(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_70();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(69, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_71(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_71();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(70, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_72(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_72();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(71, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_73(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_73();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(72, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_74(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_74();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(73, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_75(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_75();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(74, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_76(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_76();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(75, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_77(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_77();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(76, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_78(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_78();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(77, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_79(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_79();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(78, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_80(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_80();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(79, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_81(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_81();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(80, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_82(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_82();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(81, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_83(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_83();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(82, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_84(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_84();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(83, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_85(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_85();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(84, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_86(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_86();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(85, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_87(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_87();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(86, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_88(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_88();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(87, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_89(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_89();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(88, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_90(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_90();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(89, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_91(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_91();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(90, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_92(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_92();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(91, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_93(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_93();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(92, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_94(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_94();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(93, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_95(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_95();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(94, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_96(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_96();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(95, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_97(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_97();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(96, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_98(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_98();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(97, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_99(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_99();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(98, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_100(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_100();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(99, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_101(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_101();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(100, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_102(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_102();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(101, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_103(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_103();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(102, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_104(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_104();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(103, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_105(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_105();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(104, xla);
        }
    }

    private final boolean jj_3R_73() {
        if (this.jj_scan_token(69)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_41() {
        return this.jj_3R_93();
    }

    private final boolean jj_3_7() {
        if (this.jj_scan_token(96)) {
            return true;
        }
        return this.jj_scan_token(14);
    }

    private final boolean jj_3R_17() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_7()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(96);
    }

    private final boolean jj_3_80() {
        return this.jj_3R_73();
    }

    private final boolean jj_3_83() {
        return this.jj_3R_76();
    }

    private final boolean jj_3R_50() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_80()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_81()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_82()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_83()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_84()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_85()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_6() {
        return this.jj_3R_17();
    }

    private final boolean jj_3_33() {
        return this.jj_3R_38();
    }

    private final boolean jj_3R_92() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        return this.jj_scan_token(96);
    }

    private final boolean jj_3R_90() {
        if (this.jj_scan_token(31)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_69() {
        if (this.jj_scan_token(68)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_105() {
        return this.jj_3R_92();
    }

    private final boolean jj_3_79() {
        return this.jj_3R_71();
    }

    private final boolean jj_3R_16() {
        return this.jj_scan_token(95);
    }

    private final boolean jj_3_102() {
        return this.jj_3R_90();
    }

    private final boolean jj_3_4() {
        return this.jj_scan_token(96);
    }

    private final boolean jj_3R_89() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_68() {
        if (this.jj_scan_token(65)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_5() {
        return this.jj_3R_16();
    }

    private final boolean jj_3R_94() {
        return this.jj_scan_token(10);
    }

    private final boolean jj_3R_93() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_5()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_6()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_35() {
        return this.jj_3R_40();
    }

    private final boolean jj_3_32() {
        return this.jj_3R_38();
    }

    private final boolean jj_3R_95() {
        return this.jj_3R_93();
    }

    private final boolean jj_3R_67() {
        if (this.jj_scan_token(64)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_91() {
        if (this.jj_3R_94()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_105()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3_101() {
        return this.jj_3R_89();
    }

    private final boolean jj_3R_13() {
        if (this.jj_scan_token(82)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_79() {
        return this.jj_3R_95();
    }

    private final boolean jj_3R_66() {
        if (this.jj_scan_token(67)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_104() {
        return this.jj_3R_91();
    }

    private final boolean jj_3_31() {
        return this.jj_3R_38();
    }

    private final boolean jj_3R_88() {
        if (this.jj_scan_token(29)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_65() {
        if (this.jj_scan_token(66)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_45() {
        if (this.jj_3R_94()) {
            return true;
        }
        return this.jj_scan_token(100);
    }

    private final boolean jj_3_3() {
        return this.jj_3R_15();
    }

    private final boolean jj_3R_39() {
        if (this.jj_scan_token(37)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_76() {
        return this.jj_3R_71();
    }

    private final boolean jj_3R_64() {
        if (this.jj_scan_token(63)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_78() {
        return this.jj_3R_72();
    }

    private final boolean jj_3_100() {
        return this.jj_3R_88();
    }

    private final boolean jj_3_103() {
        return this.jj_3R_45();
    }

    private final boolean jj_3_2() {
        return this.jj_3R_14();
    }

    private final boolean jj_3R_71() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_34()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_35()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_34() {
        return this.jj_3R_39();
    }

    private final boolean jj_3R_70() {
        if (this.jj_scan_token(38)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_87() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_1() {
        return this.jj_3R_13();
    }

    private final boolean jj_3_75() {
        return this.jj_3R_70();
    }

    private final boolean jj_3_99() {
        return this.jj_3R_87();
    }

    private final boolean jj_3R_63() {
        if (this.jj_scan_token(62)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_30() {
        return this.jj_3R_36();
    }

    private final boolean jj_3R_62() {
        if (this.jj_scan_token(60)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_35() {
        if (this.jj_scan_token(54)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_52() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_77() {
        return this.jj_3R_71();
    }

    private final boolean jj_3R_61() {
        if (this.jj_scan_token(61)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_29() {
        return this.jj_3R_36();
    }

    private final boolean jj_3_71() {
        return this.jj_3R_66();
    }

    private final boolean jj_3R_53() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_34() {
        if (this.jj_scan_token(55)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_74() {
        return this.jj_3R_69();
    }

    private final boolean jj_3_65() {
        return this.jj_3R_60();
    }

    private final boolean jj_3_28() {
        return this.jj_3R_36();
    }

    private final boolean jj_3_68() {
        return this.jj_3R_63();
    }

    private final boolean jj_3R_60() {
        if (this.jj_scan_token(59)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_33() {
        if (this.jj_scan_token(53)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_47() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_59() {
        if (this.jj_scan_token(58)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_70() {
        return this.jj_3R_65();
    }

    private final boolean jj_3_98() {
        return this.jj_3R_14();
    }

    private final boolean jj_3R_32() {
        if (this.jj_scan_token(51)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_73() {
        return this.jj_3R_68();
    }

    private final boolean jj_3_97() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_30() {
        if (this.jj_scan_token(50)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_67() {
        return this.jj_3R_62();
    }

    private final boolean jj_3_64() {
        return this.jj_3R_59();
    }

    private final boolean jj_3R_58() {
        if (this.jj_scan_token(57)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_96() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_95() {
        if (this.jj_scan_token(16)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_14() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_95()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_96()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_97()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_31() {
        if (this.jj_scan_token(49)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_72() {
        if (this.jj_scan_token(56)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_62() {
        return this.jj_3R_57();
    }

    private final boolean jj_3R_40() {
        return this.jj_3R_93();
    }

    private final boolean jj_3_72() {
        return this.jj_3R_67();
    }

    private final boolean jj_3R_29() {
        if (this.jj_scan_token(47)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_69() {
        return this.jj_3R_64();
    }

    private final boolean jj_3_66() {
        return this.jj_3R_61();
    }

    private final boolean jj_3_63() {
        return this.jj_3R_58();
    }

    private final boolean jj_3R_49() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_63()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_64()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_65()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_66()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_67()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_68()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_69()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3_70()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3_71()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3_72()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3_73()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3_74()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3_75()) {
                                                            return true;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_37() {
        return this.jj_3R_93();
    }

    private final boolean jj_3_94() {
        return this.jj_3R_37();
    }

    private final boolean jj_3R_86() {
        if (this.jj_scan_token(81)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_28() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_61() {
        return this.jj_3R_56();
    }

    private final boolean jj_3R_57() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_84() {
        if (this.jj_scan_token(80)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_56() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_90() {
        return this.jj_3R_83();
    }

    private final boolean jj_3R_27() {
        if (this.jj_scan_token(46)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_93() {
        return this.jj_3R_86();
    }

    private final boolean jj_3R_85() {
        if (this.jj_scan_token(79)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_55() {
        if (this.jj_scan_token(21)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_60() {
        return this.jj_3R_55();
    }

    private final boolean jj_3R_26() {
        if (this.jj_scan_token(45)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_54() {
        if (this.jj_scan_token(19)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_83() {
        if (this.jj_scan_token(78)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_89() {
        return this.jj_3R_82();
    }

    private final boolean jj_3R_25() {
        if (this.jj_scan_token(36)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_86() {
        return this.jj_3R_79();
    }

    private final boolean jj_3_59() {
        return this.jj_3R_54();
    }

    private final boolean jj_3R_48() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_59()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_60()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_61()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_62()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_82() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_23() {
        if (this.jj_scan_token(44)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_12() {
        return this.jj_3R_22();
    }

    private final boolean jj_3R_81() {
        if (this.jj_scan_token(76)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_58() {
        return this.jj_3R_53();
    }

    private final boolean jj_3_57() {
        return this.jj_3R_52();
    }

    private final boolean jj_3_56() {
        return this.jj_3R_51();
    }

    private final boolean jj_3_92() {
        return this.jj_3R_85();
    }

    private final boolean jj_3R_24() {
        if (this.jj_scan_token(43)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_55() {
        return this.jj_3R_50();
    }

    private final boolean jj_3_54() {
        return this.jj_3R_49();
    }

    private final boolean jj_3_53() {
        return this.jj_3R_48();
    }

    private final boolean jj_3_41() {
        return this.jj_3R_46();
    }

    private final boolean jj_3_40() {
        return this.jj_3R_45();
    }

    private final boolean jj_3_52() {
        return this.jj_3R_47();
    }

    private final boolean jj_3R_15() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_52()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_53()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_54()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_55()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_56()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_57()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_58()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_88() {
        return this.jj_3R_81();
    }

    private final boolean jj_3R_80() {
        if (this.jj_scan_token(75)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_16() {
        return this.jj_3R_26();
    }

    private final boolean jj_3_23() {
        return this.jj_3R_33();
    }

    private final boolean jj_3R_22() {
        if (this.jj_scan_token(34)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_11() {
        return this.jj_3R_21();
    }

    private final boolean jj_3_39() {
        return this.jj_3R_44();
    }

    private final boolean jj_3R_21() {
        if (this.jj_scan_token(42)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_51() {
        return this.jj_scan_token(92);
    }

    private final boolean jj_3_50() {
        return this.jj_scan_token(91);
    }

    private final boolean jj_3_19() {
        return this.jj_3R_29();
    }

    private final boolean jj_3_49() {
        return this.jj_scan_token(86);
    }

    private final boolean jj_3_48() {
        return this.jj_scan_token(90);
    }

    private final boolean jj_3_87() {
        return this.jj_3R_80();
    }

    private final boolean jj_3_91() {
        return this.jj_3R_84();
    }

    private final boolean jj_3R_51() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_87()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_88()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_89()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_90()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_91()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_92()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_93()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_47() {
        return this.jj_scan_token(89);
    }

    private final boolean jj_3_46() {
        return this.jj_scan_token(88);
    }

    private final boolean jj_3_15() {
        return this.jj_3R_25();
    }

    private final boolean jj_3R_20() {
        if (this.jj_scan_token(41)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_45() {
        return this.jj_scan_token(87);
    }

    private final boolean jj_3_44() {
        return this.jj_scan_token(85);
    }

    private final boolean jj_3_22() {
        return this.jj_3R_32();
    }

    private final boolean jj_3_43() {
        return this.jj_scan_token(84);
    }

    private final boolean jj_3_42() {
        return this.jj_scan_token(83);
    }

    private final boolean jj_3R_46() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_42()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_43()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_44()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_45()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_46()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_47()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_48()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3_49()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3_50()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3_51()) {
                                                return true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return this.jj_3R_45();
    }

    private final boolean jj_3R_19() {
        if (this.jj_scan_token(35)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_38() {
        return this.jj_3R_43();
    }

    private final boolean jj_3R_78() {
        if (this.jj_scan_token(74)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_10() {
        return this.jj_3R_20();
    }

    private final boolean jj_3R_44() {
        if (this.jj_scan_token(40)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_27() {
        return this.jj_3R_37();
    }

    private final boolean jj_3R_76() {
        if (this.jj_scan_token(73)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_25() {
        return this.jj_3R_35();
    }

    private final boolean jj_3_18() {
        return this.jj_3R_28();
    }

    private final boolean jj_3_14() {
        return this.jj_3R_24();
    }

    private final boolean jj_3_21() {
        return this.jj_3R_31();
    }

    private final boolean jj_3R_42() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_26() {
        return this.jj_3R_36();
    }

    private final boolean jj_3_37() {
        return this.jj_3R_42();
    }

    private final boolean jj_3_82() {
        return this.jj_3R_75();
    }

    private final boolean jj_3R_77() {
        if (this.jj_scan_token(72)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_85() {
        return this.jj_3R_78();
    }

    private final boolean jj_3_9() {
        return this.jj_3R_19();
    }

    private final boolean jj_3R_43() {
        if (this.jj_scan_token(39)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_18() {
        return this.jj_3R_93();
    }

    private final boolean jj_3_36() {
        return this.jj_3R_41();
    }

    private final boolean jj_3R_38() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_36()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_37()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_38()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_39()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_24() {
        return this.jj_3R_34();
    }

    private final boolean jj_3_20() {
        return this.jj_3R_30();
    }

    private final boolean jj_3_17() {
        return this.jj_3R_27();
    }

    private final boolean jj_3R_75() {
        if (this.jj_scan_token(71)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_13() {
        return this.jj_3R_23();
    }

    private final boolean jj_3_8() {
        return this.jj_3R_18();
    }

    private final boolean jj_3R_36() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_8()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_9()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_10()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_11()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_12()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_13()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_14()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3_15()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3_16()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3_17()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3_18()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3_19()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3_20()) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_3_21()) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_3_22()) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_3_23()) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_3_24()) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_3_25()) {
                                                                                return true;
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_81() {
        return this.jj_3R_74();
    }

    private final boolean jj_3_84() {
        return this.jj_3R_77();
    }

    private final boolean jj_3R_74() {
        if (this.jj_scan_token(70)) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[0];
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[0];
    }

    private static void jj_la1_2() {
        jj_la1_2 = new int[0];
    }

    private static void jj_la1_3() {
        jj_la1_3 = new int[0];
    }

    public OWLFunctionalSyntaxParser(InputStream stream) {
        this(stream, null);
    }

    public OWLFunctionalSyntaxParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new OWLFunctionalSyntaxParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public OWLFunctionalSyntaxParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new OWLFunctionalSyntaxParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public OWLFunctionalSyntaxParser(OWLFunctionalSyntaxParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(OWLFunctionalSyntaxParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[101];
        for (i = 0; i < 101; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 0; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) == 0) continue;
                la1tokens[96 + j] = true;
            }
        }
        for (i = 0; i < 101; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 105; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                            break;
                        }
                        case 26: {
                            this.jj_3_27();
                            break;
                        }
                        case 27: {
                            this.jj_3_28();
                            break;
                        }
                        case 28: {
                            this.jj_3_29();
                            break;
                        }
                        case 29: {
                            this.jj_3_30();
                            break;
                        }
                        case 30: {
                            this.jj_3_31();
                            break;
                        }
                        case 31: {
                            this.jj_3_32();
                            break;
                        }
                        case 32: {
                            this.jj_3_33();
                            break;
                        }
                        case 33: {
                            this.jj_3_34();
                            break;
                        }
                        case 34: {
                            this.jj_3_35();
                            break;
                        }
                        case 35: {
                            this.jj_3_36();
                            break;
                        }
                        case 36: {
                            this.jj_3_37();
                            break;
                        }
                        case 37: {
                            this.jj_3_38();
                            break;
                        }
                        case 38: {
                            this.jj_3_39();
                            break;
                        }
                        case 39: {
                            this.jj_3_40();
                            break;
                        }
                        case 40: {
                            this.jj_3_41();
                            break;
                        }
                        case 41: {
                            this.jj_3_42();
                            break;
                        }
                        case 42: {
                            this.jj_3_43();
                            break;
                        }
                        case 43: {
                            this.jj_3_44();
                            break;
                        }
                        case 44: {
                            this.jj_3_45();
                            break;
                        }
                        case 45: {
                            this.jj_3_46();
                            break;
                        }
                        case 46: {
                            this.jj_3_47();
                            break;
                        }
                        case 47: {
                            this.jj_3_48();
                            break;
                        }
                        case 48: {
                            this.jj_3_49();
                            break;
                        }
                        case 49: {
                            this.jj_3_50();
                            break;
                        }
                        case 50: {
                            this.jj_3_51();
                            break;
                        }
                        case 51: {
                            this.jj_3_52();
                            break;
                        }
                        case 52: {
                            this.jj_3_53();
                            break;
                        }
                        case 53: {
                            this.jj_3_54();
                            break;
                        }
                        case 54: {
                            this.jj_3_55();
                            break;
                        }
                        case 55: {
                            this.jj_3_56();
                            break;
                        }
                        case 56: {
                            this.jj_3_57();
                            break;
                        }
                        case 57: {
                            this.jj_3_58();
                            break;
                        }
                        case 58: {
                            this.jj_3_59();
                            break;
                        }
                        case 59: {
                            this.jj_3_60();
                            break;
                        }
                        case 60: {
                            this.jj_3_61();
                            break;
                        }
                        case 61: {
                            this.jj_3_62();
                            break;
                        }
                        case 62: {
                            this.jj_3_63();
                            break;
                        }
                        case 63: {
                            this.jj_3_64();
                            break;
                        }
                        case 64: {
                            this.jj_3_65();
                            break;
                        }
                        case 65: {
                            this.jj_3_66();
                            break;
                        }
                        case 66: {
                            this.jj_3_67();
                            break;
                        }
                        case 67: {
                            this.jj_3_68();
                            break;
                        }
                        case 68: {
                            this.jj_3_69();
                            break;
                        }
                        case 69: {
                            this.jj_3_70();
                            break;
                        }
                        case 70: {
                            this.jj_3_71();
                            break;
                        }
                        case 71: {
                            this.jj_3_72();
                            break;
                        }
                        case 72: {
                            this.jj_3_73();
                            break;
                        }
                        case 73: {
                            this.jj_3_74();
                            break;
                        }
                        case 74: {
                            this.jj_3_75();
                            break;
                        }
                        case 75: {
                            this.jj_3_76();
                            break;
                        }
                        case 76: {
                            this.jj_3_77();
                            break;
                        }
                        case 77: {
                            this.jj_3_78();
                            break;
                        }
                        case 78: {
                            this.jj_3_79();
                            break;
                        }
                        case 79: {
                            this.jj_3_80();
                            break;
                        }
                        case 80: {
                            this.jj_3_81();
                            break;
                        }
                        case 81: {
                            this.jj_3_82();
                            break;
                        }
                        case 82: {
                            this.jj_3_83();
                            break;
                        }
                        case 83: {
                            this.jj_3_84();
                            break;
                        }
                        case 84: {
                            this.jj_3_85();
                            break;
                        }
                        case 85: {
                            this.jj_3_86();
                            break;
                        }
                        case 86: {
                            this.jj_3_87();
                            break;
                        }
                        case 87: {
                            this.jj_3_88();
                            break;
                        }
                        case 88: {
                            this.jj_3_89();
                            break;
                        }
                        case 89: {
                            this.jj_3_90();
                            break;
                        }
                        case 90: {
                            this.jj_3_91();
                            break;
                        }
                        case 91: {
                            this.jj_3_92();
                            break;
                        }
                        case 92: {
                            this.jj_3_93();
                            break;
                        }
                        case 93: {
                            this.jj_3_94();
                            break;
                        }
                        case 94: {
                            this.jj_3_95();
                            break;
                        }
                        case 95: {
                            this.jj_3_96();
                            break;
                        }
                        case 96: {
                            this.jj_3_97();
                            break;
                        }
                        case 97: {
                            this.jj_3_98();
                            break;
                        }
                        case 98: {
                            this.jj_3_99();
                            break;
                        }
                        case 99: {
                            this.jj_3_100();
                            break;
                        }
                        case 100: {
                            this.jj_3_101();
                            break;
                        }
                        case 101: {
                            this.jj_3_102();
                            break;
                        }
                        case 102: {
                            this.jj_3_103();
                            break;
                        }
                        case 103: {
                            this.jj_3_104();
                            break;
                        }
                        case 104: {
                            this.jj_3_105();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        OWLFunctionalSyntaxParser.jj_la1_0();
        OWLFunctionalSyntaxParser.jj_la1_1();
        OWLFunctionalSyntaxParser.jj_la1_2();
        OWLFunctionalSyntaxParser.jj_la1_3();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

