/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.latex;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.coode.owl.latex.LatexBracketChecker;
import org.coode.owl.latex.LatexWriter;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLConstantAnnotation;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataComplementOf;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataOneOf;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataRangeRestriction;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectAnnotation;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.model.SWRLAtomConstantObject;
import org.semanticweb.owl.model.SWRLAtomDVariable;
import org.semanticweb.owl.model.SWRLAtomIVariable;
import org.semanticweb.owl.model.SWRLAtomIndividualObject;
import org.semanticweb.owl.model.SWRLBuiltInAtom;
import org.semanticweb.owl.model.SWRLClassAtom;
import org.semanticweb.owl.model.SWRLDataRangeAtom;
import org.semanticweb.owl.model.SWRLDataValuedPropertyAtom;
import org.semanticweb.owl.model.SWRLDifferentFromAtom;
import org.semanticweb.owl.model.SWRLObjectPropertyAtom;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.model.SWRLSameAsAtom;
import org.semanticweb.owl.util.CollectionFactory;
import org.semanticweb.owl.util.ShortFormProvider;
import org.semanticweb.owl.util.SimpleShortFormProvider;

public class LatexObjectVisitor
implements OWLObjectVisitor {
    public static final String AND = "\\ensuremath{\\sqcap}";
    public static final String OR = "\\ensuremath{\\sqcup}";
    public static final String NOT = "\\ensuremath{\\lnot}";
    public static final String ALL = "\\ensuremath{\\forall}";
    public static final String SOME = "\\ensuremath{\\exists}";
    public static final String MIN = "\\ensuremath{\\geq}";
    public static final String MAX = "\\ensuremath{\\leq}";
    public static final String EQUAL = "\\ensuremath{=}";
    public static final String SUBCLASS = "\\ensuremath{\\sqsubseteq}";
    public static final String EQUIV = "\\ensuremath{\\equiv}";
    public static final String NOT_EQUIV = "\\ensuremath{\\not\\equiv}";
    public static final String TOP = "\\ensuremath{\\top}";
    public static final String BOTTOM = "\\ensuremath{\\bot}";
    public static final String SELF = "\\ensuremath{\\Self}";
    public static final String CIRC = "\\ensuremath{\\circ}";
    private OWLObject subject;
    private LatexWriter writer;
    private boolean prettyPrint = true;
    private OWLDataFactory df;
    private ShortFormProvider shortFormProvider;

    public LatexObjectVisitor(LatexWriter writer, OWLDataFactory df) {
        this.writer = writer;
        this.df = df;
        this.shortFormProvider = new SimpleShortFormProvider();
        this.subject = df.getOWLThing();
    }

    public void setSubject(OWLObject subject) {
        this.subject = subject;
    }

    public void setShortFormProvider(ShortFormProvider shortFormProvder) {
        this.shortFormProvider = shortFormProvder;
    }

    private void writeSpace() {
        this.writer.writeSpace();
    }

    private void write(Object o) {
        this.writer.write(o);
    }

    private void writeOpenBrace() {
        this.writer.writeOpenBrace();
    }

    private void writeCloseBrace() {
        this.writer.writeCloseBrace();
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public void visit(OWLObjectIntersectionOf node) {
        Iterator<OWLDescription> it = node.getOperands().iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(AND);
            this.writeSpace();
        }
    }

    public void visit(OWLDataAllRestriction node) {
    }

    public void visit(OWLDataExactCardinalityRestriction desc) {
        this.write(EQUAL);
        this.writeSpace();
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
    }

    public void visit(OWLDataMaxCardinalityRestriction desc) {
        this.write(MAX);
        this.writeSpace();
        this.write(desc.getCardinality());
        this.writeSpace();
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
    }

    public void visit(OWLDataMinCardinalityRestriction desc) {
        this.write(MIN);
        this.writeSpace();
        this.write(desc.getCardinality());
        this.writeSpace();
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
    }

    public void visit(OWLDataSomeRestriction node) {
        this.write(SOME);
        this.writeSpace();
        ((OWLDataPropertyExpression)node.getProperty()).accept(this);
        this.writeSpace();
        ((OWLDataRange)node.getFiller()).accept(this);
    }

    public void visit(OWLDataValueRestriction node) {
    }

    public void visit(OWLObjectAllRestriction node) {
        this.write(ALL);
        this.writeSpace();
        ((OWLObjectPropertyExpression)node.getProperty()).accept(this);
        this.writeSpace();
        this.writeNested((OWLDescription)node.getFiller());
    }

    public void visit(OWLObjectExactCardinalityRestriction desc) {
        this.write(EQUAL);
        this.writeSpace();
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        this.writeSpace();
        this.writeNested((OWLDescription)desc.getFiller());
    }

    public void visit(OWLObjectMaxCardinalityRestriction desc) {
        this.write(MAX);
        this.writeSpace();
        this.write(desc.getCardinality());
        this.writeSpace();
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        this.writeSpace();
        this.writeNested((OWLDescription)desc.getFiller());
    }

    public void visit(OWLObjectMinCardinalityRestriction desc) {
        this.write(MIN);
        this.writeSpace();
        this.write(desc.getCardinality());
        this.writeSpace();
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        this.writeSpace();
        this.writeNested((OWLDescription)desc.getFiller());
    }

    public void visit(OWLObjectSomeRestriction node) {
        this.write(SOME);
        this.writeSpace();
        ((OWLObjectPropertyExpression)node.getProperty()).accept(this);
        this.writeSpace();
        this.writeNested((OWLDescription)node.getFiller());
    }

    public void visit(OWLObjectValueRestriction node) {
        this.write(SOME);
        this.writeSpace();
        ((OWLObjectPropertyExpression)node.getProperty()).accept(this);
        this.writeSpace();
        this.writeOpenBrace();
        ((OWLIndividual)node.getValue()).accept(this);
        this.writeCloseBrace();
    }

    public void visit(OWLObjectComplementOf node) {
        this.write(NOT);
        this.writeNested(node.getOperand());
    }

    public void visit(OWLObjectUnionOf node) {
        Iterator<OWLDescription> it = node.getOperands().iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(OR);
            this.writeSpace();
        }
    }

    public void visit(OWLClass node) {
        this.write(this.escapeName(this.shortFormProvider.getShortForm(node)));
    }

    public void visit(OWLObjectOneOf node) {
        Iterator<OWLIndividual> it = node.getIndividuals().iterator();
        while (it.hasNext()) {
            this.writeOpenBrace();
            it.next().accept(this);
            this.writeCloseBrace();
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(OR);
            this.writeSpace();
        }
    }

    public void visit(OWLDataProperty entity) {
        this.write(this.escapeName(this.shortFormProvider.getShortForm(entity)));
    }

    public void visit(OWLObjectProperty entity) {
        this.write(this.escapeName(this.shortFormProvider.getShortForm(entity)));
    }

    public void visit(OWLIndividual entity) {
        this.write(this.escapeName(this.shortFormProvider.getShortForm(entity)));
    }

    public void visit(OWLObjectSelfRestriction desc) {
        this.write(SOME);
        this.writeSpace();
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        this.writeSpace();
        this.write(SELF);
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
        if (axiom.getDescriptions().size() != 2) {
            for (OWLDescription left : axiom.getDescriptions()) {
                for (OWLDescription right : axiom.getDescriptions()) {
                    if (left == right) continue;
                    if (left.equals(this.subject)) {
                        left.accept(this);
                        this.writeSpace();
                        this.write(SUBCLASS);
                        this.writeSpace();
                        this.write(NOT);
                        this.writeSpace();
                        right.accept(this);
                    } else {
                        right.accept(this);
                        this.writeSpace();
                        this.write(SUBCLASS);
                        this.writeSpace();
                        this.write(NOT);
                        this.writeSpace();
                        left.accept(this);
                    }
                    this.writer.writeNewLine();
                }
            }
        } else {
            OWLDescription rhs;
            OWLDescription lhs;
            Iterator<OWLDescription> it = axiom.getDescriptions().iterator();
            OWLDescription descA = it.next();
            OWLDescription descB = it.next();
            if (descA.equals(this.subject)) {
                lhs = descA;
                rhs = descB;
            } else {
                lhs = descB;
                rhs = descA;
            }
            lhs.accept(this);
            this.writeSpace();
            this.write(SUBCLASS);
            this.writeSpace();
            this.write(NOT);
            this.writeSpace();
            rhs.accept(this);
        }
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        if (axiom.getDescriptions().size() > 2) {
            HashSet<Set<OWLDescription>> rendered = new HashSet<Set<OWLDescription>>();
            for (OWLDescription left : axiom.getDescriptions()) {
                for (OWLDescription right : axiom.getDescriptions()) {
                    Set<OWLDescription> cur;
                    if (left == right || rendered.contains(cur = CollectionFactory.createSet(left, right))) continue;
                    rendered.add(cur);
                    left.accept(this);
                    this.writeSpace();
                    this.write(EQUIV);
                    this.writeSpace();
                    right.accept(this);
                }
            }
        } else if (axiom.getDescriptions().size() == 2) {
            OWLDescription rhs;
            OWLDescription lhs;
            Iterator<OWLDescription> it = axiom.getDescriptions().iterator();
            OWLDescription descA = it.next();
            OWLDescription descB = it.next();
            if (this.subject.equals(descA)) {
                lhs = descA;
                rhs = descB;
            } else {
                lhs = descB;
                rhs = descA;
            }
            lhs.accept(this);
            this.writeSpace();
            this.write(EQUIV);
            this.writeSpace();
            rhs.accept(this);
        }
    }

    public void visit(OWLSubClassAxiom axiom) {
        this.setPrettyPrint(false);
        axiom.getSubClass().accept(this);
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        axiom.getSuperClass().accept(this);
        this.writeSpace();
        this.setPrettyPrint(true);
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        axiom.getIndividual().accept(this);
        this.writeSpace();
        this.write(":");
        this.writeSpace();
        axiom.getDescription().accept(this);
    }

    public void visit(OWLAntiSymmetricObjectPropertyAxiom axiom) {
    }

    public void visit(OWLAxiomAnnotationAxiom axiom) {
    }

    public void visit(OWLDataPropertyAssertionAxiom axiom) {
    }

    public void visit(OWLDataPropertyDomainAxiom axiom) {
    }

    public void visit(OWLDataPropertyRangeAxiom axiom) {
    }

    public void visit(OWLDataSubPropertyAxiom axiom) {
    }

    public void visit(OWLDeclarationAxiom axiom) {
    }

    public void visit(OWLDifferentIndividualsAxiom axiom) {
        Iterator<OWLIndividual> it = axiom.getIndividuals().iterator();
        while (it.hasNext()) {
            this.write("\\{");
            it.next().accept(this);
            this.write("\\}");
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(NOT_EQUIV);
            this.writeSpace();
        }
    }

    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        Iterator it = axiom.getProperties().iterator();
        while (it.hasNext()) {
            ((OWLDataPropertyExpression)it.next()).accept(this);
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(NOT_EQUIV);
            this.writeSpace();
        }
    }

    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
    }

    public void visit(OWLDisjointUnionAxiom axiom) {
    }

    public void visit(OWLEntityAnnotationAxiom axiom) {
    }

    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        Iterator it = axiom.getProperties().iterator();
        while (it.hasNext()) {
            ((OWLDataPropertyExpression)it.next()).accept(this);
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(NOT_EQUIV);
            this.writeSpace();
        }
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        Iterator it = axiom.getProperties().iterator();
        while (it.hasNext()) {
            ((OWLObjectPropertyExpression)it.next()).accept(this);
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(EQUIV);
            this.writeSpace();
        }
    }

    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.write(TOP);
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        this.df.getOWLDataMaxCardinalityRestriction((OWLDataPropertyExpression)axiom.getProperty(), 1).accept(this);
    }

    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.write(TOP);
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        this.df.getOWLObjectMaxCardinalityRestriction((OWLObjectPropertyExpression)axiom.getProperty(), 1).accept(this);
    }

    public void visit(OWLImportsDeclaration axiom) {
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.write(TOP);
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        OWLObjectPropertyInverse prop = this.df.getOWLObjectPropertyInverse((OWLObjectPropertyExpression)axiom.getProperty());
        this.df.getOWLObjectMaxCardinalityRestriction(prop, 1).accept(this);
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.write(axiom.getFirstProperty());
        this.writeSpace();
        this.write(EQUIV);
        this.writeSpace();
        this.write(axiom.getSecondProperty());
        this.write("\\ensuremath{^-}");
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.write(NOT);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.write("(");
        axiom.getSubject().accept(this);
        this.write(", ");
        ((OWLConstant)axiom.getObject()).accept(this);
        this.write(")");
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.write(NOT);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.write("(");
        axiom.getSubject().accept(this);
        this.write(", ");
        ((OWLIndividual)axiom.getObject()).accept(this);
        this.write(")");
    }

    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.write("(");
        axiom.getSubject().accept(this);
        this.write(", ");
        ((OWLIndividual)axiom.getObject()).accept(this);
        this.write(")");
    }

    public void visit(OWLObjectPropertyChainSubPropertyAxiom axiom) {
        Iterator<OWLObjectPropertyExpression> it = axiom.getPropertyChain().iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(CIRC);
            this.writeSpace();
        }
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        axiom.getSuperProperty().accept(this);
    }

    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.df.getOWLObjectSomeRestriction((OWLObjectPropertyExpression)axiom.getProperty(), this.df.getOWLThing()).accept(this);
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        axiom.getDomain().accept(this);
    }

    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.write(TOP);
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        this.df.getOWLObjectAllRestriction((OWLObjectPropertyExpression)axiom.getProperty(), (OWLDescription)axiom.getRange()).accept(this);
    }

    public void visit(OWLObjectSubPropertyAxiom axiom) {
        axiom.getSubProperty();
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
    }

    public void visit(OWLOntologyAnnotationAxiom axiom) {
    }

    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
    }

    public void visit(OWLSameIndividualsAxiom axiom) {
        Iterator<OWLIndividual> it = axiom.getIndividuals().iterator();
        while (it.hasNext()) {
            this.write("\\{");
            it.next().accept(this);
            this.write("\\}");
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(EQUIV);
            this.writeSpace();
        }
    }

    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        this.write(EQUIV);
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.write("\\ensuremath{^-}");
    }

    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
    }

    public void visit(SWRLRule rule) {
    }

    private void writeNested(OWLDescription description) {
        this.openBracket(description);
        description.accept(this);
        this.closeBracket(description);
    }

    private void openBracket(OWLDescription description) {
        if (LatexBracketChecker.requiresBracket(description)) {
            this.write("(");
        }
    }

    private void closeBracket(OWLDescription description) {
        if (LatexBracketChecker.requiresBracket(description)) {
            this.write(")");
        }
    }

    private String escapeName(String name) {
        return name.replace("_", "\\_");
    }

    public void visit(OWLOntology ontology) {
    }

    public void visit(OWLObjectPropertyInverse property) {
        property.getInverse().accept(this);
        this.write("\\ensuremath{^-}");
    }

    public void visit(OWLConstantAnnotation annotation) {
    }

    public void visit(OWLObjectAnnotation annotation) {
    }

    public void visit(OWLDataComplementOf node) {
    }

    public void visit(OWLDataOneOf node) {
    }

    public void visit(OWLDataRangeFacetRestriction node) {
    }

    public void visit(OWLDataRangeRestriction node) {
    }

    public void visit(OWLDataType node) {
    }

    public void visit(OWLTypedConstant node) {
    }

    public void visit(OWLUntypedConstant node) {
    }

    public void visit(SWRLAtomConstantObject node) {
    }

    public void visit(SWRLAtomDVariable node) {
    }

    public void visit(SWRLAtomIndividualObject node) {
    }

    public void visit(SWRLAtomIVariable node) {
    }

    public void visit(SWRLBuiltInAtom node) {
    }

    public void visit(SWRLClassAtom node) {
    }

    public void visit(SWRLDataRangeAtom node) {
    }

    public void visit(SWRLDataValuedPropertyAtom node) {
    }

    public void visit(SWRLDifferentFromAtom node) {
    }

    public void visit(SWRLObjectPropertyAtom node) {
    }

    public void visit(SWRLSameAsAtom node) {
    }
}

