/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.owlxmlparser;

import java.net.URI;
import org.coode.owl.owlxmlparser.AbstractOWLAxiomElementHandler;
import org.coode.owl.owlxmlparser.AbstractOWLDataRangeHandler;
import org.coode.owl.owlxmlparser.AbstractOWLDescriptionElementHandler;
import org.coode.owl.owlxmlparser.AbstractOWLElementHandler;
import org.coode.owl.owlxmlparser.OWLAnnotationElementHandler;
import org.coode.owl.owlxmlparser.OWLElementHandler;
import org.coode.owl.owlxmlparser.OWLXMLParserElementNotFoundException;
import org.coode.owl.owlxmlparser.OWLXMLParserException;
import org.coode.owl.owlxmlparser.OWLXMLParserHandler;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLOntologyChangeException;
import org.semanticweb.owl.model.SetOntologyURI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLOntologyHandler
extends AbstractOWLElementHandler<OWLOntology> {
    public OWLOntologyHandler(OWLXMLParserHandler handler) {
        super(handler);
    }

    @Override
    public void startElement(String name) throws OWLXMLParserException {
    }

    @Override
    public void attribute(String name, String value) throws OWLXMLParserException {
        if (name.equals("URI")) {
            try {
                this.getOWLOntologyManager().applyChange(new SetOntologyURI(this.getOntology(), URI.create(value)));
            }
            catch (OWLOntologyChangeException e) {
                throw new OWLXMLParserException(this.getLineNumber(), (Throwable)e);
            }
        }
    }

    @Override
    public void handleChild(AbstractOWLAxiomElementHandler handler) throws OWLXMLParserException {
        try {
            this.getOWLOntologyManager().applyChange(new AddAxiom(this.getOntology(), handler.getOWLObject()));
        }
        catch (OWLOntologyChangeException e) {
            throw new OWLXMLParserException(this.getLineNumber(), (Throwable)e);
        }
    }

    @Override
    public void handleChild(AbstractOWLDataRangeHandler handler) throws OWLXMLParserException {
        throw new OWLXMLParserElementNotFoundException(this.getLineNumber(), "Encountered a data range, but was expecting an axiom.");
    }

    @Override
    public void handleChild(AbstractOWLDescriptionElementHandler handler) throws OWLXMLParserException {
        throw new OWLXMLParserElementNotFoundException(this.getLineNumber(), "Encountered a description, but was expecting an axiom.");
    }

    @Override
    public void handleChild(OWLAnnotationElementHandler handler) throws OWLXMLParserException {
        OWLOntologyAnnotationAxiom ax = this.getOWLDataFactory().getOWLOntologyAnnotationAxiom(this.getOntology(), handler.getOWLObject());
        try {
            this.getOWLOntologyManager().applyChange(new AddAxiom(this.getOntology(), ax));
        }
        catch (OWLOntologyChangeException e) {
            throw new OWLXMLParserException(this.getLineNumber(), (Throwable)e);
        }
    }

    @Override
    public void endElement() {
    }

    @Override
    public OWLOntology getOWLObject() {
        return this.getOntology();
    }

    @Override
    public void setParentHandler(OWLElementHandler handler) {
    }
}

