/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.owlxmlparser;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.coode.owl.owlxmlparser.AbstractElementHandlerFactory;
import org.coode.owl.owlxmlparser.OWLAnnotationElementHandler;
import org.coode.owl.owlxmlparser.OWLAntisymmetricObjectPropertyAxiomElementHandler;
import org.coode.owl.owlxmlparser.OWLClassAssertionAxiomElementHandler;
import org.coode.owl.owlxmlparser.OWLClassElementHandler;
import org.coode.owl.owlxmlparser.OWLConstantElementHandler;
import org.coode.owl.owlxmlparser.OWLDataAllValuesFromElementHandler;
import org.coode.owl.owlxmlparser.OWLDataComplementOfElementHandler;
import org.coode.owl.owlxmlparser.OWLDataExactCardinalityElementHandler;
import org.coode.owl.owlxmlparser.OWLDataHasValueElementHandler;
import org.coode.owl.owlxmlparser.OWLDataMaxCardinalityElementHandler;
import org.coode.owl.owlxmlparser.OWLDataMinCardinalityElementHandler;
import org.coode.owl.owlxmlparser.OWLDataOneOfElementHandler;
import org.coode.owl.owlxmlparser.OWLDataPropertyAssertionAxiomElementHandler;
import org.coode.owl.owlxmlparser.OWLDataPropertyDomainAxiomElementHandler;
import org.coode.owl.owlxmlparser.OWLDataPropertyElementHandler;
import org.coode.owl.owlxmlparser.OWLDataPropertyRangeAxiomElementHandler;
import org.coode.owl.owlxmlparser.OWLDataSomeValuesFromElementHandler;
import org.coode.owl.owlxmlparser.OWLDataTypeElementHandler;
import org.coode.owl.owlxmlparser.OWLDatatypeFacetRestrictionElementHandler;
import org.coode.owl.owlxmlparser.OWLDatatypeRestrictionElementHandler;
import org.coode.owl.owlxmlparser.OWLDeclarationAxiomElementHandler;
import org.coode.owl.owlxmlparser.OWLDifferentIndividualsAxiomElementHandler;
import org.coode.owl.owlxmlparser.OWLDisjointClassesAxiomElementHandler;
import org.coode.owl.owlxmlparser.OWLDisjointDataPropertiesAxiomElementHandler;
import org.coode.owl.owlxmlparser.OWLDisjointObjectPropertiesAxiomElementHandler;
import org.coode.owl.owlxmlparser.OWLDisjointUnionElementHandler;
import org.coode.owl.owlxmlparser.OWLElementHandler;
import org.coode.owl.owlxmlparser.OWLElementHandlerFactory;
import org.coode.owl.owlxmlparser.OWLEntityAnnotationElementHandler;
import org.coode.owl.owlxmlparser.OWLEquivalentClassesAxiomElementHandler;
import org.coode.owl.owlxmlparser.OWLEquivalentDataPropertiesAxiomElementHandler;
import org.coode.owl.owlxmlparser.OWLEquivalentObjectPropertiesAxiomElementHandler;
import org.coode.owl.owlxmlparser.OWLFunctionalDataPropertyAxiomElementHandler;
import org.coode.owl.owlxmlparser.OWLFunctionalObjectPropertyAxiomElementHandler;
import org.coode.owl.owlxmlparser.OWLImportsHandler;
import org.coode.owl.owlxmlparser.OWLIndividualElementHandler;
import org.coode.owl.owlxmlparser.OWLInverseFunctionalObjectPropertyAxiomElementHandler;
import org.coode.owl.owlxmlparser.OWLInverseObjectPropertiesAxiomElementHandler;
import org.coode.owl.owlxmlparser.OWLInverseObjectPropertyElementHandler;
import org.coode.owl.owlxmlparser.OWLIrreflexiveObjectPropertyAxiomElementHandler;
import org.coode.owl.owlxmlparser.OWLNegativeDataPropertyAssertionAxiomElementHandler;
import org.coode.owl.owlxmlparser.OWLNegativeObjectPropertyAssertionAxiomElementHandler;
import org.coode.owl.owlxmlparser.OWLObjectAllValuesFromElementHandler;
import org.coode.owl.owlxmlparser.OWLObjectComplementOfElementHandler;
import org.coode.owl.owlxmlparser.OWLObjectExactCardinalityElementHandler;
import org.coode.owl.owlxmlparser.OWLObjectExistsSelfElementHandler;
import org.coode.owl.owlxmlparser.OWLObjectHasValueElementHandler;
import org.coode.owl.owlxmlparser.OWLObjectIntersectionOfElementHandler;
import org.coode.owl.owlxmlparser.OWLObjectMaxCardinalityElementHandler;
import org.coode.owl.owlxmlparser.OWLObjectMinCardinalityElementHandler;
import org.coode.owl.owlxmlparser.OWLObjectOneOfElementHandler;
import org.coode.owl.owlxmlparser.OWLObjectPropertyAssertionAxiomElementHandler;
import org.coode.owl.owlxmlparser.OWLObjectPropertyDomainElementHandler;
import org.coode.owl.owlxmlparser.OWLObjectPropertyElementHandler;
import org.coode.owl.owlxmlparser.OWLObjectPropertyRangeAxiomElementHandler;
import org.coode.owl.owlxmlparser.OWLObjectSomeValuesFromElementHandler;
import org.coode.owl.owlxmlparser.OWLObjectUnionOfElementHandler;
import org.coode.owl.owlxmlparser.OWLOntologyHandler;
import org.coode.owl.owlxmlparser.OWLReflexiveObjectPropertyAxiomElementHandler;
import org.coode.owl.owlxmlparser.OWLSameIndividualsAxiomElementHandler;
import org.coode.owl.owlxmlparser.OWLSubClassAxiomElementHandler;
import org.coode.owl.owlxmlparser.OWLSubDataPropertyOfAxiomElementHandler;
import org.coode.owl.owlxmlparser.OWLSubObjectPropertyChainElementHandler;
import org.coode.owl.owlxmlparser.OWLSubObjectPropertyOfAxiomElementHandler;
import org.coode.owl.owlxmlparser.OWLSymmetricObjectPropertyAxiomElementHandler;
import org.coode.owl.owlxmlparser.OWLTransitiveObjectPropertyAxiomElementHandler;
import org.coode.owl.owlxmlparser.OWLUnionOfElementHandler;
import org.coode.owl.owlxmlparser.OWLXMLParserException;
import org.coode.owl.owlxmlparser.OWLXMLParserUnknownElementType;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.vocab.OWLXMLVocabulary;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLXMLParserHandler
extends DefaultHandler {
    private OWLOntologyManager owlOntologyManager;
    private OWLOntology ontology;
    private List<OWLElementHandler> handlerStack;
    private Map<String, OWLElementHandlerFactory> handlerMap;
    private Map<String, String> prefix2NamespaceMap;
    private Locator locator;
    private Map<String, URI> uriMap = new HashMap<String, URI>();

    public OWLXMLParserHandler(OWLOntologyManager owlOntologyManager, OWLOntology ontology) {
        this(owlOntologyManager, ontology, null);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
    }

    public OWLXMLParserHandler(OWLOntologyManager owlOntologyManager, OWLOntology ontology, OWLElementHandler topHandler) {
        this.owlOntologyManager = owlOntologyManager;
        this.ontology = ontology;
        this.handlerStack = new ArrayList<OWLElementHandler>();
        this.prefix2NamespaceMap = new HashMap<String, String>();
        if (topHandler != null) {
            this.handlerStack.add(0, topHandler);
        }
        this.handlerMap = new HashMap<String, OWLElementHandlerFactory>();
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.ONTOLOGY){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLOntologyHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.ANNOTATION){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLAnnotationElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.CONSTANT){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLConstantElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.IMPORTS){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLImportsHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.CLASS){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLClassElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_PROPERTY){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLObjectPropertyElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.INVERSE_OBJECT_PROPERTY){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLInverseObjectPropertyElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATA_PROPERTY){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLDataPropertyElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.INDIVIDUAL){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLIndividualElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATA_COMPLEMENT_OF){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLDataComplementOfElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATA_ONE_OF){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLDataOneOfElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATATYPE){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLDataTypeElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATATYPE_RESTRICTION){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLDatatypeRestrictionElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATATYPE_FACET_RESTRICTION){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLDatatypeFacetRestrictionElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_INTERSECTION_OF){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLObjectIntersectionOfElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_UNION_OF){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLObjectUnionOfElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_COMPLEMENT_OF){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLObjectComplementOfElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_ONE_OF){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLObjectOneOfElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_SOME_VALUES_FROM){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLObjectSomeValuesFromElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_ALL_VALUES_FROM){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLObjectAllValuesFromElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_EXISTS_SELF){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLObjectExistsSelfElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_HAS_VALUE){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLObjectHasValueElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_MIN_CARDINALITY){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLObjectMinCardinalityElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_EXACT_CARDINALITY){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLObjectExactCardinalityElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_MAX_CARDINALITY){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLObjectMaxCardinalityElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATA_SOME_VALUES_FROM){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLDataSomeValuesFromElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATA_ALL_VALUES_FROM){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLDataAllValuesFromElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATA_HAS_VALUE){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLDataHasValueElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATA_MIN_CARDINALITY){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLDataMinCardinalityElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATA_EXACT_CARDINALITY){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLDataExactCardinalityElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATA_MAX_CARDINALITY){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLDataMaxCardinalityElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.SUB_CLASS_OF){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLSubClassAxiomElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.EQUIVALENT_CLASSES){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLEquivalentClassesAxiomElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DISJOINT_CLASSES){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLDisjointClassesAxiomElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DISJOINT_UNION){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLDisjointUnionElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.UNION_OF){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLUnionOfElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.SUB_OBJECT_PROPERTY_OF){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLSubObjectPropertyOfAxiomElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.SUB_OBJECT_PROPERTY_CHAIN){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLSubObjectPropertyChainElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.EQUIVALENT_OBJECT_PROPERTIES){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLEquivalentObjectPropertiesAxiomElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DISJOINT_OBJECT_PROPERTIES){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLDisjointObjectPropertiesAxiomElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_PROPERTY_DOMAIN){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLObjectPropertyDomainElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_PROPERTY_RANGE){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLObjectPropertyRangeAxiomElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.INVERSE_OBJECT_PROPERTIES){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLInverseObjectPropertiesAxiomElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.FUNCTIONAL_OBJECT_PROPERTY){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLFunctionalObjectPropertyAxiomElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.INVERSE_FUNCTIONAL_OBJECT_PROPERTY){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLInverseFunctionalObjectPropertyAxiomElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.SYMMETRIC_OBJECT_PROPERTY){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLSymmetricObjectPropertyAxiomElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.ANTI_SYMMETRIC_OBJECT_PROPERTY){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLAntisymmetricObjectPropertyAxiomElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.REFLEXIVE_OBJECT_PROPERTY){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLReflexiveObjectPropertyAxiomElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.IRREFLEXIVE_OBJECT_PROPERTY){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLIrreflexiveObjectPropertyAxiomElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.TRANSITIVE_OBJECT_PROPERTY){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLTransitiveObjectPropertyAxiomElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.SUB_DATA_PROPERTY_OF){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLSubDataPropertyOfAxiomElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.EQUIVALENT_DATA_PROPERTIES){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLEquivalentDataPropertiesAxiomElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DISJOINT_DATA_PROPERTIES){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLDisjointDataPropertiesAxiomElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATA_PROPERTY_DOMAIN){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLDataPropertyDomainAxiomElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATA_PROPERTY_RANGE){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLDataPropertyRangeAxiomElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.FUNCTIONAL_DATA_PROPERTY){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLFunctionalDataPropertyAxiomElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.SAME_INDIVIDUALS){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLSameIndividualsAxiomElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DIFFERENT_INDIVIDUALS){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLDifferentIndividualsAxiomElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.CLASS_ASSERTION){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLClassAssertionAxiomElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_PROPERTY_ASSERTION){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLObjectPropertyAssertionAxiomElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.NEGATIVE_OBJECT_PROPERTY_ASSERTION){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLNegativeObjectPropertyAssertionAxiomElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.NEGATIVE_DATA_PROPERTY_ASSERTION){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLNegativeDataPropertyAssertionAxiomElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATA_PROPERTY_ASSERTION){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLDataPropertyAssertionAxiomElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.ENTITY_ANNOTATION){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLEntityAnnotationElementHandler(handler);
            }
        });
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DECLARATION){

            public OWLElementHandler createHandler(OWLXMLParserHandler handler) {
                return new OWLDeclarationAxiomElementHandler(handler);
            }
        });
    }

    public int getLineNumber() {
        if (this.locator != null) {
            return this.locator.getLineNumber();
        }
        return -1;
    }

    public URI getURI(String string) throws OWLXMLParserException {
        try {
            URI uri = this.uriMap.get(string);
            if (uri == null) {
                uri = new URI(string);
                this.uriMap.put(string, uri);
            }
            return uri;
        }
        catch (URISyntaxException e) {
            throw new OWLXMLParserException(this.getLineNumber(), (Throwable)e);
        }
    }

    public Map<String, String> getPrefix2NamespaceMap() {
        return this.prefix2NamespaceMap;
    }

    private void addFactory(OWLElementHandlerFactory factory) {
        this.handlerMap.put(factory.getElementName().getShortName(), factory);
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    public OWLDataFactory getDataFactory() {
        return this.getOWLOntologyManager().getOWLDataFactory();
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.handlerStack.isEmpty()) throw new SAXException("Unexpected text content: " + ch);
        try {
            OWLElementHandler handler = this.handlerStack.get(0);
            if (!handler.isTextContentPossible()) return;
            handler.handleChars(ch, start, length);
            return;
        }
        catch (OWLException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            OWLElementHandlerFactory handlerFactory = this.handlerMap.get(localName);
            if (handlerFactory == null) {
                throw new OWLXMLParserUnknownElementType(this.getLineNumber(), uri + localName);
            }
            OWLElementHandler handler = handlerFactory.createHandler(this);
            if (!this.handlerStack.isEmpty()) {
                OWLElementHandler topElement = this.handlerStack.get(0);
                handler.setParentHandler(topElement);
            }
            this.handlerStack.add(0, handler);
            for (int i = 0; i < attributes.getLength(); ++i) {
                handler.attribute(attributes.getLocalName(i), attributes.getValue(i));
            }
            handler.startElement(uri);
        }
        catch (OWLException e) {
            throw new SAXException("(Current element " + localName, e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            OWLElementHandler handler = this.handlerStack.remove(0);
            handler.endElement();
        }
        catch (OWLException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.prefix2NamespaceMap.put(prefix, uri);
    }

    public OWLOntologyManager getOWLOntologyManager() {
        return this.owlOntologyManager;
    }
}

