/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.rdfxml.parser;

import java.net.URI;
import org.coode.owl.rdfxml.parser.BuiltInTypeHandler;
import org.coode.owl.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

public class TypeFunctionalPropertyHandler
extends BuiltInTypeHandler {
    public TypeFunctionalPropertyHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.OWL_FUNCTIONAL_PROPERTY.getURI());
    }

    public boolean canHandleStreaming(URI subject, URI predicate, URI object) throws OWLException {
        return this.getConsumer().isObjectPropertyOnly(subject) || this.getConsumer().isDataPropertyOnly(subject);
    }

    public void handleTriple(URI subject, URI predicate, URI object) throws OWLException {
        if (this.getConsumer().isObjectPropertyOnly(subject)) {
            this.getConsumer().addOWLObjectProperty(subject);
            this.addAxiom(this.getDataFactory().getOWLFunctionalObjectPropertyAxiom(this.translateObjectProperty(subject)));
            this.consumeTriple(subject, predicate, object);
        } else if (this.getConsumer().isDataPropertyOnly(subject)) {
            this.getConsumer().addOWLDataProperty(subject);
            this.addAxiom(this.getDataFactory().getOWLFunctionalDataPropertyAxiom(this.translateDataProperty(subject)));
            this.consumeTriple(subject, predicate, object);
        } else {
            this.addAxiom(this.getDataFactory().getOWLFunctionalObjectPropertyAxiom(this.translateObjectProperty(subject)));
            this.consumeTriple(subject, predicate, object);
        }
    }
}

