/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.semanticweb.owl.model.OWLAnnotation;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologySetProvider;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.util.ShortFormProvider;
import org.semanticweb.owl.util.SimpleShortFormProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationValueShortFormProvider
implements ShortFormProvider {
    private List<URI> annotationURIs;
    private Map<URI, List<String>> preferredLanguageMap;
    private OWLOntologySetProvider ontologySetProvider;
    private ShortFormProvider alternateShortFormProvider;

    public AnnotationValueShortFormProvider(List<URI> annotationURIs, Map<URI, List<String>> preferredLanguageMap, OWLOntologySetProvider ontologySetProvider) {
        this(annotationURIs, preferredLanguageMap, ontologySetProvider, new SimpleShortFormProvider());
    }

    public AnnotationValueShortFormProvider(List<URI> annotationURIs, Map<URI, List<String>> preferredLanguageMap, OWLOntologySetProvider ontologySetProvider, ShortFormProvider alternateShortFormProvider) {
        this.annotationURIs = annotationURIs;
        this.preferredLanguageMap = preferredLanguageMap;
        this.ontologySetProvider = ontologySetProvider;
        this.alternateShortFormProvider = alternateShortFormProvider;
    }

    @Override
    public String getShortForm(OWLEntity entity) {
        int lastURIMatchIndex = Integer.MAX_VALUE;
        int lastLangMatchIndex = Integer.MAX_VALUE;
        OWLObject candidateValue = null;
        for (OWLOntology ontology : this.ontologySetProvider.getOntologies()) {
            for (OWLAnnotation anno : entity.getAnnotations(ontology)) {
                int index = this.annotationURIs.indexOf(anno.getAnnotationURI());
                if (index == -1) continue;
                if (index == lastURIMatchIndex) {
                    int langIndex;
                    List<String> langList;
                    OWLUntypedConstant untypedConstantVal;
                    Object annoVal = anno.getAnnotationValue();
                    if (!(annoVal instanceof OWLUntypedConstant) || !(untypedConstantVal = (OWLUntypedConstant)annoVal).hasLang() || (langList = this.preferredLanguageMap.get(anno.getAnnotationURI())) == null || (langIndex = langList.indexOf(untypedConstantVal.getLang())) == -1 || langIndex >= lastLangMatchIndex) continue;
                    lastLangMatchIndex = langIndex;
                    candidateValue = (OWLObject)anno.getAnnotationValue();
                    continue;
                }
                if (index >= lastURIMatchIndex) continue;
                lastURIMatchIndex = index;
                candidateValue = (OWLObject)anno.getAnnotationValue();
            }
        }
        if (candidateValue != null) {
            return this.getRendering(candidateValue);
        }
        return this.alternateShortFormProvider.getShortForm(entity);
    }

    private String getRendering(OWLObject object) {
        if (object instanceof OWLConstant) {
            return ((OWLConstant)object).getLiteral();
        }
        return this.alternateShortFormProvider.getShortForm((OWLEntity)object);
    }

    public List<URI> getAnnotationURIs() {
        return this.annotationURIs;
    }

    public Map<URI, List<String>> getPreferredLanguageMap() {
        return this.preferredLanguageMap;
    }

    @Override
    public void dispose() {
    }
}

