/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.util.ArrayList;
import java.util.List;
import org.semanticweb.owl.inference.OWLReasoner;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.inference.UnsupportedReasonerOperationException;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChangeException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.util.InferredAxiomGenerator;
import org.semanticweb.owl.util.InferredAxiomGeneratorException;
import org.semanticweb.owl.util.InferredClassAssertionAxiomGenerator;
import org.semanticweb.owl.util.InferredDataPropertyCharacteristicAxiomGenerator;
import org.semanticweb.owl.util.InferredEquivalentClassAxiomGenerator;
import org.semanticweb.owl.util.InferredEquivalentDataPropertiesAxiomGenerator;
import org.semanticweb.owl.util.InferredEquivalentObjectPropertyAxiomGenerator;
import org.semanticweb.owl.util.InferredInverseObjectPropertiesAxiomGenerator;
import org.semanticweb.owl.util.InferredObjectPropertyCharacteristicAxiomGenerator;
import org.semanticweb.owl.util.InferredPropertyAssertionGenerator;
import org.semanticweb.owl.util.InferredSubClassAxiomGenerator;
import org.semanticweb.owl.util.InferredSubDataPropertyAxiomGenerator;
import org.semanticweb.owl.util.InferredSubObjectPropertyAxiomGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InferredOntologyGenerator {
    private OWLReasoner reasoner;
    private List<InferredAxiomGenerator<? extends OWLAxiom>> axiomGenerators;

    public InferredOntologyGenerator(OWLReasoner reasoner, List<InferredAxiomGenerator<? extends OWLAxiom>> axiomGenerators) {
        this.reasoner = reasoner;
        this.axiomGenerators = axiomGenerators;
    }

    public InferredOntologyGenerator(OWLReasoner reasoner) {
        this.reasoner = reasoner;
        this.axiomGenerators = new ArrayList<InferredAxiomGenerator<? extends OWLAxiom>>();
        this.axiomGenerators.add(new InferredClassAssertionAxiomGenerator());
        this.axiomGenerators.add(new InferredDataPropertyCharacteristicAxiomGenerator());
        this.axiomGenerators.add(new InferredEquivalentClassAxiomGenerator());
        this.axiomGenerators.add(new InferredEquivalentDataPropertiesAxiomGenerator());
        this.axiomGenerators.add(new InferredEquivalentObjectPropertyAxiomGenerator());
        this.axiomGenerators.add(new InferredInverseObjectPropertiesAxiomGenerator());
        this.axiomGenerators.add(new InferredObjectPropertyCharacteristicAxiomGenerator());
        this.axiomGenerators.add(new InferredPropertyAssertionGenerator());
        this.axiomGenerators.add(new InferredSubClassAxiomGenerator());
        this.axiomGenerators.add(new InferredSubDataPropertyAxiomGenerator());
        this.axiomGenerators.add(new InferredSubObjectPropertyAxiomGenerator());
    }

    public List<InferredAxiomGenerator> getAxiomGenerators() {
        return new ArrayList<InferredAxiomGenerator>(this.axiomGenerators);
    }

    public void addGenerator(InferredAxiomGenerator generator) {
        if (!this.axiomGenerators.contains(generator)) {
            this.axiomGenerators.add(generator);
        }
    }

    public void removeGenerator(InferredAxiomGenerator generator) {
        this.axiomGenerators.remove(generator);
    }

    public void fillOntology(OWLOntologyManager manager, OWLOntology ontology) throws InferredAxiomGeneratorException, OWLOntologyChangeException, OWLReasonerException {
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (InferredAxiomGenerator<? extends OWLAxiom> axiomGenerator : this.axiomGenerators) {
            try {
                for (OWLAxiom oWLAxiom : axiomGenerator.createAxioms(manager, this.reasoner)) {
                    changes.add(new AddAxiom(ontology, oWLAxiom));
                }
            }
            catch (UnsupportedReasonerOperationException e) {
                throw new InferredAxiomGeneratorException(axiomGenerator, e);
            }
            catch (OWLReasonerException e) {
                throw new InferredAxiomGeneratorException(axiomGenerator, e);
            }
        }
        manager.applyChanges(changes);
    }
}

