/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.bhig.util;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import uk.ac.manchester.cs.bhig.util.Tree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableTree<N>
implements Tree<N> {
    private N userObject;
    private MutableTree<N> parent;
    private List<MutableTree<N>> children;

    public MutableTree(N userObject) {
        this.userObject = userObject;
        this.children = new ArrayList<MutableTree<N>>();
    }

    @Override
    public N getUserObject() {
        return this.userObject;
    }

    public void setParent(MutableTree<N> parent) {
        if (this.parent != null) {
            this.parent.children.remove(this);
        }
        this.parent = parent;
        this.parent.children.add(this);
    }

    public void addChild(MutableTree<N> child) {
        this.children.add(child);
        child.parent = this;
    }

    public void removeChild(MutableTree<N> child) {
        this.children.remove(child);
        child.parent = null;
    }

    @Override
    public void sortChildren(Comparator<Tree<N>> comparator) {
        Collections.sort(this.children, comparator);
    }

    public void clearChildren() {
        for (MutableTree<N> child : new ArrayList<MutableTree<N>>(this.children)) {
            this.removeChild(child);
        }
    }

    @Override
    public Tree<N> getParent() {
        return this.parent;
    }

    @Override
    public List<Tree<N>> getChildren() {
        return new ArrayList<Tree<N>>(this.children);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    @Override
    public Tree<N> getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    @Override
    public List<Tree<N>> getPathToRoot() {
        ArrayList<Tree<N>> path = new ArrayList<Tree<N>>();
        path.add(0, this);
        for (Tree<N> par = this.parent; par != null; par = par.getParent()) {
            path.add(0, par);
        }
        return path;
    }

    @Override
    public List<N> getUserObjectPathToRoot() {
        ArrayList path = new ArrayList();
        path.add(0, this.getUserObject());
        for (Tree<N> par = this.parent; par != null; par = par.getParent()) {
            path.add(0, par.getUserObject());
        }
        return path;
    }

    @Override
    public Set<N> getUserObjectClosure() {
        HashSet objects = new HashSet();
        this.getUserObjectClosure(this, objects);
        return objects;
    }

    private void getUserObjectClosure(Tree<N> tree, Set<N> bin) {
        bin.add(tree.getUserObject());
        for (Tree<N> child : tree.getChildren()) {
            this.getUserObjectClosure(child, bin);
        }
    }

    @Override
    public void dump(PrintWriter writer) {
        this.dump(writer, 0);
    }

    @Override
    public void dump(PrintWriter writer, int indent) {
        int depth = this.getPathToRoot().size();
        for (int i = 0; i < depth + indent; ++i) {
            writer.print("\t");
        }
        writer.println(this.toString());
        for (Tree<N> child : this.getChildren()) {
            child.dump(writer, indent);
        }
        writer.flush();
    }

    public void replace(MutableTree<N> tree) {
        this.parent.children.remove(this);
        this.parent.children.add(tree);
        this.parent = null;
        tree.children.clear();
        tree.children.addAll(this.children);
        this.children.clear();
    }

    public String toString() {
        return this.userObject.toString();
    }
}

