/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl;

import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.semanticweb.owl.io.ToStringRenderer;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.util.AxiomSubjectProvider;
import org.semanticweb.owl.util.HashCode;
import org.semanticweb.owl.util.OWLObjectTypeIndexProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OWLObjectImpl
implements OWLObject {
    private OWLDataFactory dataFactory;
    private int hashCode = 0;
    private static OWLObjectTypeIndexProvider typeIndexProvider = new OWLObjectTypeIndexProvider();
    private static AxiomSubjectProvider subjectProvider = new AxiomSubjectProvider();

    public OWLObjectImpl(OWLDataFactory dataFactory) {
        this.dataFactory = dataFactory;
    }

    public OWLDataFactory getOWLDataFactory() {
        return this.dataFactory;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return obj instanceof OWLObject;
    }

    public final int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = HashCode.hashCode(this);
        }
        return this.hashCode;
    }

    @Override
    public final int compareTo(OWLObject o) {
        int otherTypeIndex;
        int thisTypeIndex = typeIndexProvider.getTypeIndex(this);
        int diff = thisTypeIndex - (otherTypeIndex = typeIndexProvider.getTypeIndex(o));
        if (diff == 0) {
            return this.compareObjectOfSameType(o);
        }
        return diff;
    }

    protected abstract int compareObjectOfSameType(OWLObject var1);

    public String toString() {
        return ToStringRenderer.getInstance().getRendering(this);
    }

    protected static int compareSets(Set<? extends OWLObject> set1, Set<? extends OWLObject> set2) {
        TreeSet<? extends OWLObject> ss1 = set1 instanceof SortedSet ? (TreeSet<? extends OWLObject>)set1 : new TreeSet<OWLObject>(set1);
        TreeSet<? extends OWLObject> ss2 = set2 instanceof SortedSet ? (TreeSet<? extends OWLObject>)set2 : new TreeSet<OWLObject>(set2);
        Iterator thisIt = ss1.iterator();
        Iterator otherIt = ss2.iterator();
        for (int i = 0; i < ss1.size() && i < ss2.size(); ++i) {
            OWLObject o2;
            OWLObject o1 = (OWLObject)thisIt.next();
            int diff = o1.compareTo(o2 = (OWLObject)otherIt.next());
            if (diff == 0) continue;
            return diff;
        }
        return ss1.size() - ss2.size();
    }
}

