/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl;

import java.net.URI;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owl.model.AxiomType;
import org.semanticweb.owl.model.OWLAxiomVisitor;
import org.semanticweb.owl.model.OWLAxiomVisitorEx;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLObjectVisitorEx;
import org.semanticweb.owl.model.SWRLAtom;
import org.semanticweb.owl.model.SWRLObjectVisitor;
import org.semanticweb.owl.model.SWRLObjectVisitorEx;
import org.semanticweb.owl.model.SWRLRule;
import uk.ac.manchester.cs.owl.OWLAxiomImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLRuleImpl
extends OWLAxiomImpl
implements SWRLRule {
    private URI uri;
    private Set<SWRLAtom> consequent;
    private Set<SWRLAtom> antecedent;
    private boolean anon;

    public SWRLRuleImpl(OWLDataFactory dataFactory, URI uri, Set<? extends SWRLAtom> antecedent, Set<? extends SWRLAtom> consequent) {
        super(dataFactory);
        this.uri = uri;
        this.anon = false;
        this.consequent = new TreeSet<SWRLAtom>(consequent);
        this.antecedent = new TreeSet<SWRLAtom>(antecedent);
    }

    public SWRLRuleImpl(OWLDataFactory dataFactory, boolean anon, URI uri, Set<? extends SWRLAtom> antecedent, Set<? extends SWRLAtom> consequent) {
        super(dataFactory);
        this.anon = anon;
        this.uri = uri;
        this.antecedent = new TreeSet<SWRLAtom>(antecedent);
        this.consequent = new TreeSet<SWRLAtom>(consequent);
    }

    public SWRLRuleImpl(OWLDataFactory dataFactory, Set<? extends SWRLAtom> antecedent, Set<? extends SWRLAtom> consequent) {
        this(dataFactory, true, URI.create("http://www.semanticweb.org/swrl#" + System.nanoTime()), antecedent, consequent);
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(SWRLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(SWRLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean isAnonymous() {
        return this.anon;
    }

    @Override
    public Set<SWRLAtom> getBody() {
        return Collections.unmodifiableSet(this.antecedent);
    }

    @Override
    public Set<SWRLAtom> getHead() {
        return Collections.unmodifiableSet(this.consequent);
    }

    @Override
    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean isLogicalAxiom() {
        return true;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SWRLRule)) {
            return false;
        }
        SWRLRule other = (SWRLRule)obj;
        return (other.getURI().equals(this.uri) || this.isAnonymous() && other.isAnonymous()) && ((Object)other.getBody()).equals(this.antecedent) && ((Object)other.getHead()).equals(this.consequent);
    }

    @Override
    public AxiomType getAxiomType() {
        return AxiomType.SWRL_RULE;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        int diff;
        SWRLRule other = (SWRLRule)object;
        if (!this.isAnonymous()) {
            diff = !other.isAnonymous() ? this.getURI().compareTo(other.getURI()) : -1;
        } else if (!other.isAnonymous()) {
            diff = 1;
        } else {
            diff = SWRLRuleImpl.compareSets(this.getBody(), other.getBody());
            if (diff == 0) {
                diff = SWRLRuleImpl.compareSets(this.getHead(), other.getHead());
            }
        }
        return diff;
    }
}

