/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.dlsyntax.parser;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.util.CollectionFactory;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;
import uk.ac.manchester.cs.owl.dlsyntax.parser.DLSyntaxParserConstants;
import uk.ac.manchester.cs.owl.dlsyntax.parser.DLSyntaxParserTokenManager;
import uk.ac.manchester.cs.owl.dlsyntax.parser.ParseException;
import uk.ac.manchester.cs.owl.dlsyntax.parser.SimpleCharStream;
import uk.ac.manchester.cs.owl.dlsyntax.parser.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLSyntaxParser
implements DLSyntaxParserConstants {
    private String defaultNamespace = "http://www.sematicweb.org/ontologies/Ontology" + System.nanoTime();
    private Map<String, String> namespaceMap = new HashMap<String, String>();
    private OWLDataFactory factory;
    private Map<String, URI> uriMap = new HashMap<String, URI>();
    private Map<String, URI> qnameURIMap = new HashMap<String, URI>();
    public DLSyntaxParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[17];
    private static int[] jj_la1_0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public void setOWLDataFactory(OWLDataFactory factory) {
        this.factory = factory;
    }

    public void setPrefixMapping(String prefix, String namespace) {
        this.namespaceMap.put(prefix, namespace);
    }

    public void setDefaultNamespace(String ns) {
        this.defaultNamespace = ns;
    }

    public URI getURI(String val) {
        URI uri = this.uriMap.get(val);
        if (uri == null) {
            try {
                uri = new URI(val);
                this.uriMap.put(val, uri);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return uri;
    }

    public URI getURIFromId(String qname) {
        if (qname.equals("top") || qname.equals("\u22a4")) {
            return OWLRDFVocabulary.OWL_THING.getURI();
        }
        if (qname.equals("bottom") || qname.equals("\u22a5")) {
            return OWLRDFVocabulary.OWL_NOTHING.getURI();
        }
        URI uri = this.qnameURIMap.get(qname);
        if (uri == null) {
            uri = this.getURI(this.defaultNamespace + "#" + qname);
            this.qnameURIMap.put(qname, uri);
        }
        return uri;
    }

    public final OWLDescription parseDescription() throws ParseException {
        OWLDescription desc = this.parseClassDescription();
        this.jj_consume_token(0);
        return desc;
    }

    public final Set<OWLAxiom> parseAxioms() throws ParseException {
        LinkedHashSet<OWLAxiom> axioms = new LinkedHashSet<OWLAxiom>();
        OWLAxiom ax = this.parseAxiom();
        axioms.add(ax);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 27: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(27);
            ax = this.parseAxiom();
            axioms.add(ax);
        }
        this.jj_consume_token(0);
        return axioms;
    }

    public final OWLAxiom parseAxiom() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                OWLAxiom ax = this.parsePropertyAxiom();
                return ax;
            }
            case 8: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: {
                OWLAxiom ax = this.parseClassAxiom();
                return ax;
            }
        }
        this.jj_la1[1] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final OWLAxiom parseClassAxiom() throws ParseException {
        boolean subClassAxiom = false;
        OWLDescription lhs = this.parseClassDescription();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                OWLObjectSomeRestriction restriction;
                this.jj_consume_token(4);
                OWLDescription rhs = this.parseClassDescription();
                if (lhs.isOWLThing()) {
                    OWLObjectMaxCardinalityRestriction restriction2;
                    if (rhs instanceof OWLObjectAllRestriction) {
                        OWLObjectAllRestriction restriction3 = (OWLObjectAllRestriction)rhs;
                        return this.factory.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)restriction3.getProperty(), (OWLDescription)restriction3.getFiller());
                    }
                    if (rhs instanceof OWLObjectMaxCardinalityRestriction && (restriction2 = (OWLObjectMaxCardinalityRestriction)rhs).getCardinality() == 1 && ((OWLDescription)restriction2.getFiller()).isOWLThing()) {
                        return this.factory.getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)restriction2.getProperty());
                    }
                } else if (lhs instanceof OWLObjectSomeRestriction && ((OWLDescription)(restriction = (OWLObjectSomeRestriction)lhs).getFiller()).isOWLThing()) {
                    return this.factory.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)restriction.getProperty(), rhs);
                }
                if (rhs instanceof OWLObjectComplementOf && !rhs.isAnonymous()) {
                    return this.factory.getOWLDisjointClassesAxiom(lhs, ((OWLObjectComplementOf)rhs).getOperand());
                }
                return this.factory.getOWLSubClassAxiom(lhs, rhs);
            }
            case 5: {
                this.jj_consume_token(5);
                OWLDescription rhs = this.parseClassDescription();
                return this.factory.getOWLEquivalentClassesAxiom(lhs, rhs);
            }
        }
        this.jj_la1[2] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final OWLAxiom parsePropertyAxiom() throws ParseException {
        OWLObjectPropertyExpression lhs = this.parseObjectPropertyId();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                this.jj_consume_token(4);
                OWLObjectPropertyExpression rhs = this.parseObjectPropertyId();
                return this.factory.getOWLSubObjectPropertyAxiom(lhs, rhs);
            }
            case 5: {
                this.jj_consume_token(5);
                OWLObjectPropertyExpression rhs = this.parseObjectPropertyId();
                if (rhs instanceof OWLObjectPropertyInverse) {
                    OWLObjectPropertyInverse inv = (OWLObjectPropertyInverse)rhs;
                    return this.factory.getOWLInverseObjectPropertiesAxiom(lhs, inv.getInverse());
                }
                return this.factory.getOWLEquivalentObjectPropertiesAxiom(CollectionFactory.createSet(lhs, rhs));
            }
            case 23: {
                this.jj_consume_token(23);
                this.jj_consume_token(24);
                return this.factory.getOWLTransitiveObjectPropertyAxiom(lhs);
            }
        }
        this.jj_la1[3] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final OWLDescription parseClassDescription() throws ParseException {
        OWLDescription desc = this.Or();
        return desc;
    }

    public final OWLDescription Or() throws ParseException {
        HashSet<OWLDescription> operands = new HashSet<OWLDescription>();
        OWLDescription desc = this.And();
        operands.add(desc);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 16: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(16);
            desc = this.And();
            operands.add(desc);
        }
        if (operands.size() == 1) {
            return desc;
        }
        return this.factory.getOWLObjectUnionOf(operands);
    }

    public final OWLDescription And() throws ParseException {
        HashSet<OWLDescription> operands = new HashSet<OWLDescription>();
        OWLDescription desc = this.NonNaryBooleanDescription();
        operands.add(desc);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 15: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(15);
            desc = this.NonNaryBooleanDescription();
            operands.add(desc);
        }
        if (operands.size() == 1) {
            return desc;
        }
        return this.factory.getOWLObjectIntersectionOf(operands);
    }

    public final OWLDescription NonNaryBooleanDescription() throws ParseException {
        OWLDescription desc;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                desc = this.parseRestriction();
                break;
            }
            case 17: {
                desc = this.parseObjectComplementOf();
                break;
            }
            case 8: 
            case 12: 
            case 26: {
                desc = this.NamedClassOrNestedDescription();
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return desc;
    }

    public final OWLObjectPropertyExpression parseObjectPropertyId() throws ParseException {
        boolean inverse = false;
        URI uri = this.parseId();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                inverse = true;
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        if (inverse) {
            OWLObjectProperty prop = this.factory.getOWLObjectProperty(uri);
            return this.factory.getOWLObjectPropertyInverse(prop);
        }
        return this.factory.getOWLObjectProperty(uri);
    }

    public final OWLDescription parseRestriction() throws ParseException {
        OWLDescription desc;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                desc = this.parseSomeRestriction();
                break;
            }
            case 19: {
                desc = this.parseAllRestriction();
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                desc = this.parseCardinalityRestriction();
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return desc;
    }

    public final OWLDescription parseSomeRestriction() throws ParseException {
        this.jj_consume_token(18);
        OWLObjectPropertyExpression prop = this.parseObjectPropertyId();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.jj_consume_token(6);
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
            }
        }
        OWLDescription filler = this.NamedClassOrNestedDescription();
        return this.factory.getOWLObjectSomeRestriction(prop, filler);
    }

    public final OWLDescription parseAllRestriction() throws ParseException {
        this.jj_consume_token(19);
        OWLObjectPropertyExpression prop = this.parseObjectPropertyId();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.jj_consume_token(6);
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
            }
        }
        OWLDescription filler = this.NamedClassOrNestedDescription();
        return this.factory.getOWLObjectAllRestriction(prop, filler);
    }

    public final OWLDescription parseCardinalityRestriction() throws ParseException {
        OWLDescription filler = null;
        boolean min = false;
        boolean exactly = false;
        boolean max = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                this.jj_consume_token(20);
                min = true;
                break;
            }
            case 22: {
                this.jj_consume_token(22);
                exactly = true;
                break;
            }
            case 21: {
                this.jj_consume_token(21);
                max = true;
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Token t = this.jj_consume_token(25);
        OWLObjectPropertyExpression prop = this.parseObjectPropertyId();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 8: 
            case 12: 
            case 26: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: {
                        this.jj_consume_token(6);
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                    }
                }
                filler = this.NamedClassOrNestedDescription();
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        int card = Integer.parseInt(t.image);
        if (filler == null) {
            filler = this.factory.getOWLThing();
        }
        if (min) {
            return this.factory.getOWLObjectMinCardinalityRestriction(prop, card, filler);
        }
        if (exactly) {
            return this.factory.getOWLObjectExactCardinalityRestriction(prop, card, filler);
        }
        return this.factory.getOWLObjectMaxCardinalityRestriction(prop, card, filler);
    }

    public final OWLIndividual parseIndividualId() throws ParseException {
        URI uri = this.parseId();
        return this.factory.getOWLIndividual(uri);
    }

    public final OWLDescription parseObjectComplementOf() throws ParseException {
        this.jj_consume_token(17);
        OWLDescription op = this.NamedClassOrNestedDescription();
        return this.factory.getOWLObjectComplementOf(op);
    }

    public final OWLDescription parseObjectOneOf() throws ParseException {
        HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
        this.jj_consume_token(12);
        OWLIndividual ind = this.parseIndividualId();
        inds.add(ind);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 26: {
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    break block3;
                }
            }
            ind = this.parseIndividualId();
            inds.add(ind);
        }
        this.jj_consume_token(13);
        return this.factory.getOWLObjectOneOf(inds);
    }

    public final OWLDescription NamedClassOrNestedDescription() throws ParseException {
        OWLDescription desc;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 26: {
                desc = this.parseClassId();
                break;
            }
            case 8: 
            case 12: {
                desc = this.NestedClassDescription();
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return desc;
    }

    public final OWLClass parseClassId() throws ParseException {
        URI uri = this.parseId();
        return this.factory.getOWLClass(uri);
    }

    public final OWLDescription NestedClassDescription() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                OWLDescription desc = this.Or();
                this.jj_consume_token(9);
                return desc;
            }
            case 12: {
                OWLDescription desc = this.parseObjectOneOf();
                return desc;
            }
        }
        this.jj_la1[16] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final URI parseId() throws ParseException {
        Token t = this.jj_consume_token(26);
        String name = t.image;
        return this.getURIFromId(name);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{0x8000000, 75387136, 48, 0x800030, 65536, 32768, 75370752, 128, 0x7C0000, 64, 64, 0x700000, 64, 0x4001140, 0x4000000, 0x4001100, 4352};
    }

    public DLSyntaxParser(InputStream stream) {
        this(stream, null);
    }

    public DLSyntaxParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new DLSyntaxParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 17; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 17; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public DLSyntaxParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new DLSyntaxParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 17; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 17; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public DLSyntaxParser(DLSyntaxParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 17; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(DLSyntaxParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 17; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[28];
        for (i = 0; i < 28; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 17; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 28; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        DLSyntaxParser.jj_la1_0();
    }
}

