/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.inference.dig11;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import uk.ac.manchester.cs.owl.inference.dig11.DIGError;
import uk.ac.manchester.cs.owl.inference.dig11.DIGErrorException;
import uk.ac.manchester.cs.owl.inference.dig11.DIGReasonerException;
import uk.ac.manchester.cs.owl.inference.dig11.DIGReasonerIdentity;
import uk.ac.manchester.cs.owl.inference.dig11.DIGReasonerPreferences;
import uk.ac.manchester.cs.owl.inference.dig11.DIGTranslator;
import uk.ac.manchester.cs.owl.inference.dig11.DIGTranslatorImpl;
import uk.ac.manchester.cs.owl.inference.dig11.HTTPReasoner;

public class HTTPReasonerImpl
implements HTTPReasoner {
    private DIGTranslator translator;
    private URL reasonerURL;
    private DocumentBuilderFactory docBuilderFactory;
    private DocumentBuilder docBuilder;
    private XMLSerializer serializer;
    private OutputFormat format;
    public static boolean log = true;

    public HTTPReasonerImpl(OWLOntologyManager manager) {
        this.translator = new DIGTranslatorImpl(manager);
        try {
            this.reasonerURL = new URL("http://localhost:8080");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        this.format = new OutputFormat();
        this.format.setIndent(4);
        this.format.setIndenting(true);
        this.format.setPreserveSpace(false);
        this.serializer = new XMLSerializer(this.format);
        this.docBuilderFactory = DocumentBuilderFactory.newInstance();
        this.docBuilderFactory.setIgnoringElementContentWhitespace(true);
        try {
            this.docBuilder = this.docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public void setReasonerURL(URL url) {
        this.reasonerURL = url;
    }

    public String getReasonerURL() {
        return this.reasonerURL.toString();
    }

    public DIGReasonerIdentity getIdentity() throws DIGReasonerException {
        Document request = this.translator.createDIGDocument("getIdentifier");
        Document response = this.performRequest(request);
        DIGReasonerIdentity id = new DIGReasonerIdentity();
        id.parseIdentityDescrtiption(response);
        return id;
    }

    public String createKnowledgeBase() throws DIGReasonerException {
        Document request = this.translator.createDIGDocument("newKB");
        Document doc = this.performRequest(request);
        Element kbElement = (Element)doc.getDocumentElement().getElementsByTagName("kb").item(0);
        return kbElement.getAttribute("uri");
    }

    public void releaseKnowledgeBase(String kbURI) throws DIGReasonerException {
        Document doc = this.translator.createDIGDocument("releaseKB");
        doc.getDocumentElement().setAttribute("uri", kbURI);
        this.performRequest(doc);
    }

    public void clearKnowledgeBase(String kbURI) throws DIGReasonerException {
        Document doc = this.translator.createDIGDocument("tells", kbURI);
        Element element = doc.createElement("clearKB");
        doc.getDocumentElement().appendChild(element);
        this.performRequest(doc);
    }

    public Document performRequest(Document request) throws DIGReasonerException {
        if (DIGReasonerPreferences.getInstance().isLogDIG()) {
            this.log(request);
        }
        try {
            StringWriter writer = new StringWriter();
            this.serializer.setOutputCharStream(writer);
            this.serializer.serialize(request);
            HttpURLConnection conn = (HttpURLConnection)this.reasonerURL.openConnection();
            conn.setRequestProperty("Content-Type", "text/xml");
            conn.setRequestMethod("POST");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            StringBuffer buffer = writer.getBuffer();
            conn.setRequestProperty("Content-Length", "" + buffer.length());
            conn.connect();
            OutputStream os = conn.getOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter(os);
            osw.write(buffer.toString());
            osw.flush();
            osw.close();
            InputStreamReader reader = new InputStreamReader(conn.getInputStream());
            Document doc = this.docBuilder.parse(new InputSource(reader));
            ((Reader)reader).close();
            conn.disconnect();
            if (DIGReasonerPreferences.getInstance().isLogDIG()) {
                this.log(doc);
            }
            this.performErrorCheck(doc);
            return doc;
        }
        catch (IOException e) {
            throw new DIGReasonerException(e.getMessage(), e);
        }
        catch (SAXException saxEx) {
            throw new DIGReasonerException(saxEx.getMessage(), saxEx);
        }
        catch (DIGErrorException ex) {
            throw new DIGReasonerException(ex.getMessage(), ex);
        }
    }

    protected void performErrorCheck(Document doc) throws DIGErrorException {
        NodeList errors = doc.getDocumentElement().getElementsByTagName("error");
        if (errors.getLength() > 0) {
            ArrayList<DIGError> errorList = new ArrayList<DIGError>(errors.getLength());
            for (int i = 0; i < errors.getLength(); ++i) {
                Element element = (Element)errors.item(i);
                String message = element.getAttribute("message") + " [ID: " + element.getAttribute("id") + "]";
                String code = ((Element)errors.item(i)).getAttribute("code");
                DIGError error = new DIGError(element.getAttribute("id"), message, code);
                errorList.add(error);
            }
            if (!DIGReasonerPreferences.getInstance().isTreatErrorsAsWarnings()) {
                throw new DIGErrorException(errorList);
            }
        }
    }

    protected void log(Document doc) {
        StringWriter writer = new StringWriter();
        OutputFormat format = new OutputFormat();
        format.setIndent(4);
        format.setIndenting(true);
        XMLSerializer serializer = new XMLSerializer(writer, format);
        try {
            serializer.serialize(doc);
            System.out.println(writer.getBuffer().toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

