/*
 * Decompiled with CFR 0.152.
 */
package wlsvm;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import libsvm.svm;
import libsvm.svm_model;
import libsvm.svm_node;
import libsvm.svm_parameter;
import libsvm.svm_problem;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Normalize;

public class WLSVM
extends Classifier
implements WeightedInstancesHandler {
    protected static final long serialVersionUID = 14172L;
    protected svm_parameter param;
    protected int normalize;
    protected svm_problem prob;
    protected svm_model model;
    protected String error_msg;
    protected Filter filter = null;

    public WLSVM() {
        String[] dummy = new String[]{};
        try {
            this.setOptions(dummy);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String globalInfo() {
        return "An implementation of a custom Weka classifier that provides an access to LibSVM.Available at: http://www.cs.iastate.edu/~yasser/wlsvm";
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(13);
        newVector.addElement(new Option("\t set type of SVM (default 0)\n\t\t 0 = C-SVC\n\t\t 1 = nu-SVC\n\t\t 2 = one-class SVM\n\t\t 3 = epsilon-SVR\n\t\t 4 = nu-SVR", "S", 1, "-S <int>"));
        newVector.addElement(new Option("\t set type of kernel function (default 2)\n\t\t 0 = linear: u'*v\n\t\t 1 = polynomial: (gamma*u'*v + coef0)^degree\n\t\t 2 = radial basis function: exp(-gamma*|u-v|^2)\n\t\t 3 = sigmoid: tanh(gamma*u'*v + coef0)", "K", 1, "-K <int>"));
        newVector.addElement(new Option("\t set degree in kernel function (default 3)", "D", 1, "-D <int>"));
        newVector.addElement(new Option("\t set gamma in kernel function (default 1/k)", "G", 1, "-G <double>"));
        newVector.addElement(new Option("\t set coef0 in kernel function (default 0)", "R", 1, "-R <double>"));
        newVector.addElement(new Option("\t set the parameter C of C-SVC, epsilon-SVR, and nu-SVR (default 1)", "C", 1, "-C <double>"));
        newVector.addElement(new Option("\t set the parameter nu of nu-SVC, one-class SVM, and nu-SVR (default 0.5)", "N", 1, "-N <double>"));
        newVector.addElement(new Option("\t whether to normalize input data, 0 or 1 (default 0)", "Z", 1, "-Z"));
        newVector.addElement(new Option("\t set the epsilon in loss function of epsilon-SVR (default 0.1)", "P", 1, "-P <double>"));
        newVector.addElement(new Option("\t set cache memory size in MB (default 40)", "M", 1, "-M <double>"));
        newVector.addElement(new Option("\t set tolerance of termination criterion (default 0.001)", "E", 1, "-E <double>"));
        newVector.addElement(new Option("\t whether to use the shrinking heuristics, 0 or 1 (default 1)", "H", 1, "-H <int>"));
        newVector.addElement(new Option("\t whether to train a SVC or SVR model for probability estimates, 0 or 1 (default 0)", "B", 1, "-B <int>"));
        newVector.addElement(new Option("\t set the parameters C of class i to weight[i]*C, for C-SVC (default 1)", "W", 1, "-W <double>"));
        return newVector.elements();
    }

    public void setSVMType(int svm_type) {
        this.param.svm_type = svm_type;
    }

    public int getSVMType() {
        return this.param.svm_type;
    }

    public void setKernelType(int kernel_type) {
        this.param.kernel_type = kernel_type;
    }

    public int getKernelType() {
        return this.param.kernel_type;
    }

    public void setDegree(double degree) {
        this.param.degree = degree;
    }

    public double getDegree() {
        return this.param.degree;
    }

    public void setGamma(double gamma) {
        this.param.gamma = gamma;
    }

    public double getGamma() {
        return this.param.gamma;
    }

    public void setCoef0(double coef0) {
        this.param.coef0 = coef0;
    }

    public double getCoef0() {
        return this.param.coef0;
    }

    public void setNu(double nu) {
        this.param.nu = nu;
    }

    public double getNu() {
        return this.param.nu;
    }

    public void setCache(double cache_size) {
        this.param.cache_size = cache_size;
    }

    public double getCache() {
        return this.param.cache_size;
    }

    public void setCost(double cost) {
        this.param.C = cost;
    }

    public double getCost() {
        return this.param.C;
    }

    public void setEps(double eps) {
        this.param.eps = eps;
    }

    public double getEps() {
        return this.param.eps;
    }

    public void setLoss(double loss) {
        this.param.p = loss;
    }

    public double getLoss() {
        return this.param.p;
    }

    public void setShrinking(int shrink) {
        this.param.shrinking = shrink;
    }

    public double getShrinking() {
        return this.param.shrinking;
    }

    public int getProbability() {
        return this.param.probability;
    }

    public void setProbability(int prob) {
        this.param.probability = prob;
    }

    public void setNormalize(int norm) {
        this.normalize = norm;
    }

    public int getNormalize() {
        return this.normalize;
    }

    public void setWeights(double[] weights) {
        this.param.nr_weight = weights.length;
        if (this.param.nr_weight == 0) {
            System.out.println("Zero Weights processed. Default weights will be used");
        }
        this.param.weight_label[0] = -1;
        int i = 1;
        while (i < this.param.nr_weight) {
            this.param.weight_label[i] = i;
            ++i;
        }
    }

    public double[] getWeights() {
        return this.param.weight;
    }

    public void setOptions(String[] options) throws Exception {
        this.param = new svm_parameter();
        String svmtypeString = Utils.getOption((char)'S', (String[])options);
        this.param.svm_type = svmtypeString.length() != 0 ? Integer.parseInt(svmtypeString) : 0;
        String kerneltypeString = Utils.getOption((char)'K', (String[])options);
        this.param.kernel_type = kerneltypeString.length() != 0 ? Integer.parseInt(kerneltypeString) : 2;
        String degreeString = Utils.getOption((char)'D', (String[])options);
        this.param.degree = degreeString.length() != 0 ? new Double(degreeString) : 3.0;
        String gammaString = Utils.getOption((char)'G', (String[])options);
        this.param.gamma = gammaString.length() != 0 ? new Double(gammaString) : 0.0;
        String coef0String = Utils.getOption((char)'R', (String[])options);
        this.param.coef0 = coef0String.length() != 0 ? new Double(coef0String) : 0.0;
        String nuString = Utils.getOption((char)'N', (String[])options);
        this.param.nu = nuString.length() != 0 ? new Double(nuString) : 0.5;
        String cacheString = Utils.getOption((char)'M', (String[])options);
        this.param.cache_size = cacheString.length() != 0 ? new Double(cacheString) : 40.0;
        String costString = Utils.getOption((char)'C', (String[])options);
        this.param.C = costString.length() != 0 ? new Double(costString) : 1.0;
        String epsString = Utils.getOption((char)'E', (String[])options);
        this.param.eps = epsString.length() != 0 ? new Double(epsString) : 0.001;
        String normString = Utils.getOption((char)'Z', (String[])options);
        this.normalize = normString.length() != 0 ? Integer.parseInt(normString) : 0;
        String lossString = Utils.getOption((char)'P', (String[])options);
        this.param.p = lossString.length() != 0 ? new Double(lossString) : 0.1;
        String shrinkingString = Utils.getOption((char)'H', (String[])options);
        this.param.shrinking = shrinkingString.length() != 0 ? Integer.parseInt(shrinkingString) : 1;
        String probString = Utils.getOption((char)'B', (String[])options);
        this.param.probability = probString.length() != 0 ? Integer.parseInt(probString) : 0;
        String weightsString = Utils.getOption((char)'W', (String[])options);
        if (weightsString.length() != 0) {
            StringTokenizer st = new StringTokenizer(weightsString, " ");
            int n_classes = st.countTokens();
            this.param.weight_label = new int[n_classes];
            this.param.weight = new double[n_classes];
            int count = 0;
            while (st.hasMoreTokens()) {
                this.param.weight[count++] = WLSVM.atof(st.nextToken());
            }
            this.param.nr_weight = count;
            this.param.weight_label[0] = -1;
            int i = 1;
            while (i < count) {
                this.param.weight_label[i] = i;
                ++i;
            }
        } else {
            this.param.nr_weight = 0;
            this.param.weight_label = new int[0];
            this.param.weight = new double[0];
        }
    }

    public String[] getOptions() {
        if (this.param == null) {
            String[] dummy = new String[]{};
            try {
                this.setOptions(dummy);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String[] options = new String[40];
        int current = 0;
        options[current++] = "-S";
        options[current++] = "" + this.param.svm_type;
        options[current++] = "-K";
        options[current++] = "" + this.param.kernel_type;
        options[current++] = "-D";
        options[current++] = "" + this.param.degree;
        options[current++] = "-G";
        options[current++] = "" + this.param.gamma;
        options[current++] = "-R";
        options[current++] = "" + this.param.coef0;
        options[current++] = "-N";
        options[current++] = "" + this.param.nu;
        options[current++] = "-M";
        options[current++] = "" + this.param.cache_size;
        options[current++] = "-C";
        options[current++] = "" + this.param.C;
        options[current++] = "-E";
        options[current++] = "" + this.param.eps;
        options[current++] = "-P";
        options[current++] = "" + this.param.p;
        options[current++] = "-H";
        options[current++] = "" + this.param.shrinking;
        options[current++] = "-B";
        options[current++] = "" + this.param.probability;
        options[current++] = "-Z";
        options[current++] = "" + this.normalize;
        if (this.param.nr_weight > 0) {
            options[current++] = "-W";
            String weights = new String();
            int i = 0;
            while (i < this.param.nr_weight) {
                weights = String.valueOf(weights) + " " + this.param.weight[i];
                ++i;
            }
            options[current++] = weights.trim();
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    protected static double atof(String s) {
        return Double.valueOf(s);
    }

    protected static int atoi(String s) {
        return Integer.parseInt(s);
    }

    protected String InstanceToSparse(Instance instance) {
        String line = new String();
        int c = (int)instance.classValue();
        if (c == 0) {
            c = -1;
        }
        line = String.valueOf(c) + " ";
        int j = 1;
        while (j < instance.numAttributes()) {
            if (j - 1 != instance.classIndex() && !instance.isMissing(j - 1) && instance.value(j - 1) != 0.0) {
                line = String.valueOf(line) + " " + j + ":" + instance.value(j - 1);
            }
            ++j;
        }
        return String.valueOf(line) + "\n";
    }

    protected Vector DataToSparse(Instances data) {
        Vector<String> sparse = new Vector<String>(data.numInstances() + 1);
        int i = 0;
        while (i < data.numInstances()) {
            sparse.add(this.InstanceToSparse(data.instance(i)));
            ++i;
        }
        return sparse;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        int svm_type = svm.svm_get_svm_type((svm_model)this.model);
        int nr_class = svm.svm_get_nr_class((svm_model)this.model);
        int[] labels = new int[nr_class];
        double[] prob_estimates = null;
        if (this.param.probability == 1) {
            if (svm_type == 3 || svm_type == 4) {
                System.err.println("Do not use distributionForInstance for regression models!");
                return null;
            }
            svm.svm_get_labels((svm_model)this.model, (int[])labels);
            prob_estimates = new double[nr_class];
        }
        if (this.filter != null) {
            this.filter.input(instance);
            this.filter.batchFinished();
            instance = this.filter.output();
        }
        String line = this.InstanceToSparse(instance);
        StringTokenizer st = new StringTokenizer(line, " \t\n\r\f:");
        double target = WLSVM.atof(st.nextToken());
        int m = st.countTokens() / 2;
        svm_node[] x = new svm_node[m];
        int j = 0;
        while (j < m) {
            x[j] = new svm_node();
            x[j].index = WLSVM.atoi(st.nextToken());
            x[j].value = WLSVM.atof(st.nextToken());
            ++j;
        }
        double[] weka_probs = new double[nr_class];
        if (this.param.probability == 1 && (svm_type == 0 || svm_type == 1)) {
            double v = svm.svm_predict_probability((svm_model)this.model, (svm_node[])x, (double[])prob_estimates);
            int k = 0;
            while (k < prob_estimates.length) {
                if (labels[k] == -1) {
                    labels[k] = 0;
                }
                weka_probs[labels[k]] = prob_estimates[k];
                ++k;
            }
        } else {
            double v = svm.svm_predict((svm_model)this.model, (svm_node[])x);
            if (v == -1.0) {
                v = 0.0;
            }
            weka_probs[(int)v] = 1.0;
        }
        return weka_probs;
    }

    public void buildClassifier(Instances insts) throws Exception {
        if (this.normalize == 1) {
            if (this.getDebug()) {
                System.err.println("Normalizing...");
            }
            this.filter = new Normalize();
            this.filter.setInputFormat(insts);
            insts = Filter.useFilter((Instances)insts, (Filter)this.filter);
        }
        if (this.getDebug()) {
            System.err.println("Converting to libsvm format...");
        }
        Vector sparseData = this.DataToSparse(insts);
        Vector<String> vy = new Vector<String>();
        Vector<svm_node[]> vx = new Vector<svm_node[]>();
        int max_index = 0;
        if (this.getDebug()) {
            System.err.println("Tokenizing libsvm data...");
        }
        int d = 0;
        while (d < sparseData.size()) {
            String line = (String)sparseData.get(d);
            StringTokenizer st = new StringTokenizer(line, " \t\n\r\f:");
            vy.addElement(st.nextToken());
            int m = st.countTokens() / 2;
            svm_node[] x = new svm_node[m];
            int j = 0;
            while (j < m) {
                x[j] = new svm_node();
                x[j].index = WLSVM.atoi(st.nextToken());
                x[j].value = WLSVM.atof(st.nextToken());
                ++j;
            }
            if (m > 0) {
                max_index = Math.max(max_index, x[m - 1].index);
            }
            vx.addElement(x);
            ++d;
        }
        this.prob = new svm_problem();
        this.prob.l = vy.size();
        this.prob.x = new svm_node[this.prob.l][];
        int i = 0;
        while (i < this.prob.l) {
            this.prob.x[i] = (svm_node[])vx.elementAt(i);
            ++i;
        }
        this.prob.y = new double[this.prob.l];
        i = 0;
        while (i < this.prob.l) {
            this.prob.y[i] = WLSVM.atof((String)vy.elementAt(i));
            ++i;
        }
        if (this.param.gamma == 0.0) {
            this.param.gamma = 1.0 / (double)max_index;
        }
        this.error_msg = svm.svm_check_parameter((svm_problem)this.prob, (svm_parameter)this.param);
        if (this.error_msg != null) {
            System.err.print("Error: " + this.error_msg + "\n");
            System.exit(1);
        }
        if (this.getDebug()) {
            System.err.println("Training model");
        }
        try {
            this.model = svm.svm_train((svm_problem)this.prob, (svm_parameter)this.param);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return "WLSVM Classifier By Yasser EL-Manzalawy";
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length < 1) {
            System.out.println("Usage: Test <arff file>");
            System.exit(1);
        }
        String dataFile = argv[0];
        WLSVM lib = new WLSVM();
        String[] ops = new String[]{new String("-t"), dataFile, new String("-x"), new String("5"), new String("-i"), new String("-S"), new String("0"), new String("-K"), new String("2"), new String("-G"), new String("1"), new String("-C"), new String("7"), new String("-M"), new String("100")};
        System.out.println(Evaluation.evaluateModel((Classifier)lib, (String[])ops));
    }
}

