/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.RoleTaxonomyBuilder;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Pair;
import org.mindswap.pellet.utils.fsm.State;
import org.mindswap.pellet.utils.fsm.Transition;
import org.mindswap.pellet.utils.fsm.TransitionGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RBox {
    public static Logger log = Logger.getLogger(RBox.class.getName());
    private Map<ATermAppl, Role> roles = new HashMap<ATermAppl, Role>();
    private Set<Role> reflexiveRoles = new HashSet<Role>();
    private Taxonomy<ATermAppl> taxonomy;

    public Role getRole(ATerm r) {
        return this.roles.get(r);
    }

    public Role getDefinedRole(ATerm r) {
        Role role = this.roles.get(r);
        if (role == null) {
            throw new RuntimeException(r + " is not defined as a property");
        }
        return role;
    }

    public Role addRole(ATermAppl r) {
        Role role = this.getRole((ATerm)r);
        if (role == null) {
            role = new Role(r, 0);
            this.roles.put(r, role);
        }
        return role;
    }

    public Role addObjectRole(ATermAppl r) {
        Role role = this.getRole((ATerm)r);
        int roleType = role == null ? 0 : role.getType();
        switch (roleType) {
            case 2: {
                role = null;
                break;
            }
            case 1: {
                break;
            }
            default: {
                if (role == null) {
                    role = new Role(r, 1);
                    this.roles.put(r, role);
                } else {
                    role.setType(1);
                }
                ATermAppl invR = ATermUtils.makeInv(r);
                Role invRole = new Role(invR, 1);
                this.roles.put(invR, invRole);
                role.setInverse(invRole);
                invRole.setInverse(role);
            }
        }
        return role;
    }

    public Role addDatatypeRole(ATermAppl r) {
        Role role = this.getRole((ATerm)r);
        if (role == null) {
            role = new Role(r, 2);
            this.roles.put(r, role);
        } else {
            switch (role.getType()) {
                case 2: {
                    break;
                }
                case 1: {
                    role = null;
                    break;
                }
                default: {
                    role.setType(2);
                }
            }
        }
        return role;
    }

    public Role addAnnotationRole(ATermAppl r) {
        Role role = this.getRole((ATerm)r);
        if (role == null) {
            role = new Role(r, 3);
            this.roles.put(r, role);
        } else if (role.getType() == 0) {
            role.setType(3);
        } else if (role.getType() != 3) {
            role = null;
        }
        return role;
    }

    public Role addOntologyRole(ATermAppl r) {
        Role role = this.getRole((ATerm)r);
        if (role == null) {
            role = new Role(r, 4);
            this.roles.put(r, role);
        } else if (role.getType() == 0) {
            role.setType(4);
        } else if (role.getType() != 4) {
            role = null;
        }
        return role;
    }

    public boolean addSubRole(ATerm sub, ATerm sup) {
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeSubProp(sub, sup)) : DependencySet.INDEPENDENT;
        return this.addSubRole(sub, sup, ds);
    }

    public boolean addSubRole(ATerm sub, ATerm sup, DependencySet ds) {
        Role roleSup = this.getRole(sup);
        Role roleSub = this.getRole(sub);
        if (roleSup == null) {
            return false;
        }
        if (sub.getType() == 4) {
            roleSup.addSubRoleChain((ATermList)sub, ds);
        } else {
            if (roleSub == null) {
                return false;
            }
            roleSup.addSubRole(roleSub, ds);
            roleSub.addSuperRole(roleSup, ds);
        }
        return true;
    }

    public boolean addEquivalentRole(ATerm s, ATerm r) {
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeEqProp(r, s)) : DependencySet.INDEPENDENT;
        return this.addEquivalentRole(r, s, ds);
    }

    public boolean addEquivalentRole(ATerm s, ATerm r, DependencySet ds) {
        Role roleS = this.getRole(s);
        Role roleR = this.getRole(r);
        if (roleS == null || roleR == null) {
            return false;
        }
        roleR.addSubRole(roleS, ds);
        roleR.addSuperRole(roleS, ds);
        roleS.addSubRole(roleR, ds);
        roleS.addSuperRole(roleR, ds);
        if (roleR.getInverse() != null) {
            roleR.getInverse().addSubRole(roleS.getInverse(), ds);
            roleR.getInverse().addSuperRole(roleS.getInverse(), ds);
            roleS.getInverse().addSubRole(roleR.getInverse(), ds);
            roleS.getInverse().addSuperRole(roleR.getInverse(), ds);
        }
        return true;
    }

    public boolean addDisjointRole(ATerm s, ATerm r, DependencySet ds) {
        Role roleS = this.getRole(s);
        Role roleR = this.getRole(r);
        if (roleS == null || roleR == null) {
            return false;
        }
        roleR.addDisjointRole(roleS, ds);
        roleS.addDisjointRole(roleR, ds);
        return true;
    }

    public boolean addInverseRole(ATerm s, ATerm r, DependencySet ds) {
        Role roleS = this.getRole(s);
        Role roleR = this.getRole(r);
        if (roleS == null || roleR == null || !roleS.isObjectRole() || !roleR.isObjectRole()) {
            return false;
        }
        this.addEquivalentRole((ATerm)roleS.getInverse().getName(), r, ds);
        return true;
    }

    public boolean isRole(ATerm r) {
        return this.roles.containsKey(r);
    }

    public void prepare() {
        for (Role role : this.roles.values()) {
            if (role.getType() != 1 && role.getType() != 2) continue;
            HashMap<ATerm, DependencySet> subExplain = new HashMap<ATerm, DependencySet>();
            HashSet<Role> subRoles = new HashSet<Role>();
            HashSet<ATermList> subRoleChains = new HashSet<ATermList>();
            this.computeSubRoles(role, subRoles, subRoleChains, subExplain, DependencySet.INDEPENDENT);
            role.setSubRolesAndChains(subRoles, subRoleChains, subExplain);
            boolean hasComplexSubRoles = false;
            for (ATermList chain : subRoleChains) {
                if (chain.getLength() == 2 && chain.getFirst().equals(chain.getLast()) && subRoles.contains(this.getRole(chain.getFirst()))) continue;
                hasComplexSubRoles = true;
                break;
            }
            role.setHasComplexSubRole(hasComplexSubRoles);
            if (!hasComplexSubRoles) continue;
            this.buildDFA(role, new HashSet<Role>());
        }
        for (Role role : this.roles.values()) {
            Role invR = role.getInverse();
            if (invR != null) {
                if (invR.isTransitive() && !role.isTransitive()) {
                    role.setTransitive(true, invR.getExplainTransitive());
                } else if (role.isTransitive() && !invR.isTransitive()) {
                    invR.setTransitive(true, role.getExplainTransitive());
                }
                if (invR.isFunctional() && !role.isInverseFunctional()) {
                    role.setInverseFunctional(true, invR.getExplainFunctional());
                }
                if (role.isFunctional() && !invR.isInverseFunctional()) {
                    invR.setInverseFunctional(true, role.getExplainFunctional());
                }
                if (invR.isInverseFunctional() && !role.isFunctional()) {
                    role.setFunctional(true, invR.getExplainInverseFunctional());
                }
                if (invR.isAsymmetric() && !role.isAsymmetric()) {
                    role.setAsymmetric(true, invR.getExplainAsymmetric());
                }
                if (role.isAsymmetric() && !invR.isAsymmetric()) {
                    invR.setAsymmetric(true, role.getExplainAsymmetric());
                }
                if (invR.isReflexive() && !role.isReflexive()) {
                    role.setReflexive(true, invR.getExplainReflexive());
                }
                if (role.isReflexive() && !invR.isReflexive()) {
                    invR.setReflexive(true, role.getExplainReflexive());
                }
            }
            for (Role s : role.getSubRoles()) {
                DependencySet explainSub = role.getExplainSub((ATerm)s.getName());
                s.addSuperRole(role, explainSub);
                if (role.isForceSimple()) {
                    s.setForceSimple(true);
                }
                if (s.isSimple()) continue;
                role.setSimple(false);
            }
        }
        for (Role r : this.roles.values()) {
            if (r.isForceSimple()) {
                if (!r.isSimple()) {
                    this.ignoreTransitivity(r);
                }
            } else {
                boolean isTransitive = r.isTransitive();
                DependencySet transitiveDS = r.getExplainTransitive();
                for (Role s : r.getSubRoles()) {
                    if (!s.isTransitive()) continue;
                    if (r.isSubRoleOf(s) && r != s) {
                        isTransitive = true;
                        transitiveDS = r.getExplainSub((ATerm)s.getName()).union(s.getExplainTransitive(), true);
                    }
                    r.addTransitiveSubRole(s);
                }
                if (isTransitive != r.isTransitive()) {
                    r.setTransitive(isTransitive, transitiveDS);
                }
            }
            for (Role s : r.getSuperRoles()) {
                DependencySet ds;
                if (s.isFunctional()) {
                    ds = PelletOptions.USE_TRACING ? r.getExplainSuper((ATerm)s.getName()).union(s.getExplainFunctional(), true) : DependencySet.INDEPENDENT;
                    r.setFunctional(true, ds);
                    r.addFunctionalSuper(s);
                }
                if (!s.isIrreflexive() || r.isIrreflexive()) continue;
                ds = PelletOptions.USE_TRACING ? r.getExplainSuper((ATerm)s.getName()).union(s.getExplainIrreflexive(), true) : DependencySet.INDEPENDENT;
                r.setIrreflexive(true, ds);
            }
            if (r.isReflexive() && !r.isAnon()) {
                this.reflexiveRoles.add(r);
            }
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine(r.debugString());
        }
        this.taxonomy = null;
    }

    public void propagateDomainRange() {
        for (Role role : this.roles.values()) {
            Set<ATermAppl> domains = role.getDomains();
            Set<ATermAppl> ranges = role.getRanges();
            for (Role s : role.getSubRoles()) {
                DependencySet ds;
                DependencySet explainSub = role.getExplainSub((ATerm)s.getName());
                for (ATermAppl domain : domains.toArray(new ATermAppl[0])) {
                    if (s.getDomains().contains(domain)) continue;
                    ds = explainSub.union(role.getExplainDomain(domain), true);
                    s.addDomain(domain, ds);
                }
                for (ATermAppl range : ranges.toArray(new ATermAppl[0])) {
                    if (s.getRanges().contains(range)) continue;
                    ds = explainSub.union(role.getExplainRange(range), true);
                    s.addRange(range, ds);
                }
            }
        }
    }

    private void ignoreTransitivity(Role role) {
        Role namedRole = role.isAnon() ? role.getInverse() : role;
        String msg = "Unsupported axiom: Ignoring transitivity and/or complex subproperty axioms for " + namedRole;
        if (!PelletOptions.IGNORE_UNSUPPORTED_AXIOMS) {
            throw new UnsupportedFeatureException(msg);
        }
        log.warning(msg);
        role.removeSubRoleChains();
        role.setHasComplexSubRole(false);
        role.setSimple(true);
        role.setFSM(null);
        role.getInverse().removeSubRoleChains();
        role.getInverse().setHasComplexSubRole(false);
        role.getInverse().setSimple(true);
        role.getInverse().setFSM(null);
    }

    private void computeImmediateSubRoles(Role r, Map<ATerm, DependencySet> subs) {
        DependencySet subDS;
        Role invR = r.getInverse();
        if (invR != null && invR != r) {
            for (Role invSubR : invR.getSubRoles()) {
                Role subR = invSubR.getInverse();
                if (subR == null) {
                    System.err.println("Property " + invSubR + " was supposed to be an ObjectProperty but it is not!");
                    continue;
                }
                if (subR == r) continue;
                DependencySet subDS2 = invR.getExplainSub((ATerm)invSubR.getName());
                subs.put((ATerm)subR.getName(), subDS2);
            }
            for (ATermList roleChain : invR.getSubRoleChains()) {
                subDS = invR.getExplainSub((ATerm)roleChain);
                ATermList subChain = this.inverse(roleChain);
                subs.put((ATerm)subChain, subDS);
            }
        }
        for (Role sub : r.getSubRoles()) {
            subDS = r.getExplainSub((ATerm)sub.getName());
            subs.put((ATerm)sub.getName(), subDS);
        }
        for (ATermList subChain : r.getSubRoleChains()) {
            subDS = r.getExplainSub((ATerm)subChain);
            subs.put((ATerm)subChain, subDS);
        }
    }

    private void computeSubRoles(Role r, Set<Role> subRoles, Set<ATermList> subRoleChains, Map<ATerm, DependencySet> dependencies, DependencySet ds) {
        if (subRoles.contains(r)) {
            return;
        }
        subRoles.add(r);
        dependencies.put((ATerm)r.getName(), ds);
        HashMap<ATerm, DependencySet> immSubs = new HashMap<ATerm, DependencySet>();
        this.computeImmediateSubRoles(r, immSubs);
        for (Map.Entry entry : immSubs.entrySet()) {
            DependencySet subDS;
            ATerm sub = (ATerm)entry.getKey();
            DependencySet dependencySet = subDS = PelletOptions.USE_TRACING ? ds.union((DependencySet)entry.getValue(), true) : DependencySet.INDEPENDENT;
            if (sub instanceof ATermAppl) {
                Role subRole = this.getRole(sub);
                this.computeSubRoles(subRole, subRoles, subRoleChains, dependencies, subDS);
                continue;
            }
            subRoleChains.add((ATermList)sub);
            dependencies.put(sub, subDS);
        }
    }

    private TransitionGraph buildDFA(Role s, Set<Role> visited) {
        if (!visited.add(s)) {
            return null;
        }
        TransitionGraph tg = s.getFSM();
        if (tg == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Building NFA for " + s);
            }
            if ((tg = this.buildNFA(s, visited)) == null) {
                log.warning("Cycle detected in the complex suproperty chain involving " + s);
                s.setForceSimple(true);
                this.ignoreTransitivity(s);
                return null;
            }
            assert (tg.isConnected());
            if (log.isLoggable(Level.FINE)) {
                log.fine("Determinize " + s + ": " + tg.size());
            }
            tg = this.handleSymmetry(s, tg);
            assert (tg.isConnected());
            tg.determinize();
            assert (tg.isConnected());
            assert (tg.isDeterministic());
            if (log.isLoggable(Level.FINE)) {
                log.fine("Minimize NFA for " + s + ": " + tg);
            }
            tg.minimize();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Minimized NFA for " + s + ": " + tg);
            }
            assert (tg.isConnected());
            tg.renumber();
            assert (tg.isConnected());
            this.setFSM(s, tg);
            this.setFSM(s.getInverse(), this.mirror(tg).determinize().renumber());
        }
        visited.remove(s);
        return tg;
    }

    private void setFSM(Role s, TransitionGraph tg) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("NFA for " + s + ":\n" + tg);
        }
        s.setFSM(tg);
        Set<Role> eqRoles = s.getEquivalentProperties();
        eqRoles.remove(s);
        for (Role eqRole : eqRoles) {
            eqRole.setFSM(tg);
        }
    }

    private TransitionGraph buildNFA(Role s, Set<Role> visited) {
        TransitionGraph tg = new TransitionGraph();
        State i = tg.newState();
        State f = tg.newState();
        tg.setInitialState(i);
        tg.addFinalState(f);
        tg.addTransition(i, s, f);
        for (Role sub : s.getProperSubRoles()) {
            tg.addTransition(i, sub, f);
        }
        for (Role invSub : s.getInverse().getProperSubRoles()) {
            tg.addTransition(i, invSub.getInverse(), f);
        }
        for (ATermList subChain : s.getSubRoleChains()) {
            this.addTransition(tg, s, subChain);
        }
        for (ATermList invSubChain : s.getInverse().getSubRoleChains()) {
            this.addTransition(tg, s, this.inverse(invSubChain));
        }
        HashSet alphabet = new HashSet(tg.getAlpahabet());
        for (Role r : alphabet) {
            if (s.getSubRoles().contains(r) && s.getSuperRoles().contains(r)) continue;
            for (Pair<State, State> pair : tg.findTransitions(r)) {
                TransitionGraph newGraph = this.buildDFA(r, visited);
                if (newGraph == null) {
                    return null;
                }
                tg.insert(newGraph, (State)pair.first, (State)pair.second);
            }
        }
        return tg;
    }

    private TransitionGraph handleSymmetry(Role r, TransitionGraph tg) {
        if (!r.getSubRoles().contains(r.getInverse())) {
            return tg;
        }
        return tg.choice(this.mirror(tg));
    }

    private TransitionGraph mirror(TransitionGraph tg) {
        HashMap<State, State> newStates = new HashMap<State, State>();
        TransitionGraph mirror = new TransitionGraph();
        State oldInitialState = tg.getInitialState();
        State newFinalState = this.copyState(oldInitialState, mirror, newStates);
        mirror.addFinalState(newFinalState);
        Set<State> oldFinalStates = tg.getFinalStates();
        State newInitialState = null;
        if (oldFinalStates.size() == 1) {
            State oldFinalState = oldFinalStates.iterator().next();
            newInitialState = (State)newStates.get(oldFinalState);
        } else {
            newInitialState = mirror.newState();
            for (State oldFinalState : oldFinalStates) {
                mirror.addTransition(newInitialState, (State)newStates.get(oldFinalState));
            }
        }
        mirror.setInitialState(newInitialState);
        return mirror;
    }

    private State copyState(State oldState, TransitionGraph newTG, Map<State, State> newStates) {
        State newState = newStates.get(oldState);
        if (newState == null) {
            newState = newTG.newState();
            newStates.put(oldState, newState);
            for (Transition t : oldState.getTransitions()) {
                State oldTo = t.getTo();
                State newFrom = this.copyState(oldTo, newTG, newStates);
                if (t.getName() == Transition.EPSILON) {
                    newTG.addTransition(newFrom, newState);
                    continue;
                }
                newTG.addTransition(newFrom, ((Role)t.getName()).getInverse(), newState);
            }
        }
        return newState;
    }

    private void addTransition(TransitionGraph tg, Role s, ATermList chain) {
        State next;
        Role role = this.getRole(chain.getFirst());
        State prev = next = tg.newState();
        if (s.isEquivalent(role)) {
            tg.addTransition(tg.getFinalState(), next);
            chain = chain.getNext();
        } else {
            tg.addTransition(tg.getInitialState(), next);
        }
        while (!chain.getNext().isEmpty()) {
            next = tg.newState();
            role = this.getRole(chain.getFirst());
            tg.addTransition(prev, role, next);
            chain = chain.getNext();
            prev = next;
        }
        role = this.getRole(chain.getFirst());
        if (s.isEquivalent(role)) {
            tg.addTransition(prev, tg.getInitialState());
        } else {
            tg.addTransition(prev, role, tg.getFinalState());
        }
    }

    public String toString() {
        return "[RBox " + this.roles.values() + "]";
    }

    public ATermList inverse(ATermList roles) {
        ATermList invList = ATermUtils.EMPTY_LIST;
        ATermList list = roles;
        while (!list.isEmpty()) {
            ATermAppl r = (ATermAppl)list.getFirst();
            Role role = this.getRole((ATerm)r);
            Role invR = role.getInverse();
            if (invR == null) {
                System.err.println("Property " + r + " was supposed to be an ObjectProperty but it is not!");
            } else {
                invList = invList.insert((ATerm)invR.getName());
            }
            list = list.getNext();
        }
        return invList;
    }

    public Set<ATermAppl> getRoleNames() {
        return this.roles.keySet();
    }

    public Set<Role> getReflexiveRoles() {
        return this.reflexiveRoles;
    }

    public Collection<Role> getRoles() {
        return this.roles.values();
    }

    public Taxonomy<ATermAppl> getTaxonomy() {
        if (this.taxonomy == null) {
            RoleTaxonomyBuilder builder = new RoleTaxonomyBuilder(this);
            this.taxonomy = builder.classify();
        }
        return this.taxonomy;
    }
}

