/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.output;

import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import org.mindswap.pellet.output.ATermBaseRenderer;

public class ATermManchesterSyntaxRenderer
extends ATermBaseRenderer {
    public void visitAll(ATermAppl term) {
        this.out.print("(");
        this.visit((ATermAppl)term.getArgument(0));
        this.out.print(" only ");
        this.visit((ATermAppl)term.getArgument(1));
        this.out.print(")");
    }

    public void visitAnd(ATermAppl term) {
        this.out.print("(");
        this.visitList((ATermList)term.getArgument(0), "and");
        this.out.print(")");
    }

    public void visitCard(ATermAppl term) {
        this.out.print("(");
        this.visit((ATermAppl)term.getArgument(0));
        this.out.print(" exactly " + ((ATermInt)term.getArgument(1)).getInt());
        this.out.print(")");
    }

    public void visitHasValue(ATermAppl term) {
        this.out.print("(");
        this.visit((ATermAppl)term.getArgument(0));
        this.out.print(" value ");
        ATermAppl value = (ATermAppl)((ATermAppl)term.getArgument(1)).getArgument(0);
        if (value.getArity() == 0) {
            this.visitTerm(value);
        } else {
            this.visitLiteral(value);
        }
        this.out.print(")");
    }

    public void visitInverse(ATermAppl p) {
        this.out.print("inverse ");
        this.visit((ATermAppl)p.getArgument(0));
    }

    public void visitLiteral(ATermAppl term) {
        String lexicalValue = ((ATermAppl)term.getArgument(0)).getName();
        String lang = ((ATermAppl)term.getArgument(1)).getName();
        String datatypeURI = ((ATermAppl)term.getArgument(2)).getName();
        this.out.print("\"" + lexicalValue + "\"");
        if (!lang.equals("")) {
            this.out.print("@" + lang);
        } else if (!datatypeURI.equals("")) {
            this.out.print("^^");
            this.out.print(datatypeURI);
        }
    }

    public void visitMax(ATermAppl term) {
        this.out.print("(");
        this.visit((ATermAppl)term.getArgument(0));
        this.out.print(" max " + ((ATermInt)term.getArgument(1)).getInt() + " ");
        this.visit((ATermAppl)term.getArgument(2));
        this.out.print(")");
    }

    public void visitMin(ATermAppl term) {
        this.out.print("(");
        this.visit((ATermAppl)term.getArgument(0));
        this.out.print(" min " + ((ATermInt)term.getArgument(1)).getInt() + " ");
        this.visit((ATermAppl)term.getArgument(2));
        this.out.print(")");
    }

    public void visitNot(ATermAppl term) {
        this.out.print("not ");
        this.visit((ATermAppl)term.getArgument(0));
    }

    public void visitOneOf(ATermAppl term) {
        this.out.print("{");
        ATermList list = (ATermList)term.getArgument(0);
        while (!list.isEmpty()) {
            ATermAppl value = (ATermAppl)list.getFirst();
            this.visit((ATermAppl)value.getArgument(0));
            if ((list = list.getNext()).isEmpty()) continue;
            this.out.print(" ");
        }
        this.out.print("}");
    }

    public void visitOr(ATermAppl term) {
        this.out.print("(");
        this.visitList((ATermList)term.getArgument(0), "or");
        this.out.print(")");
    }

    public void visitSelf(ATermAppl term) {
        this.out.print("(");
        this.visit((ATermAppl)term.getArgument(0));
        this.out.print(" Self)");
    }

    public void visitSome(ATermAppl term) {
        this.out.print("(");
        this.visit((ATermAppl)term.getArgument(0));
        this.out.print(" some ");
        this.visit((ATermAppl)term.getArgument(1));
        this.out.print(")");
    }

    public void visitValue(ATermAppl term) {
        this.out.print("(");
        this.visit((ATermAppl)term.getArgument(0));
        this.out.print(")");
    }

    public void visitList(ATermList list, String op) {
        while (!list.isEmpty()) {
            ATermAppl term = (ATermAppl)list.getFirst();
            this.visit(term);
            if ((list = list.getNext()).isEmpty()) continue;
            this.out.print(" " + op + " ");
        }
    }
}

