/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.branch;

import aterm.ATerm;
import java.util.logging.Level;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.tableau.branch.IndividualBranch;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.utils.ATermUtils;

public class GuessBranch
extends IndividualBranch {
    private Role r;
    private int minGuess;

    public GuessBranch(ABox abox, CompletionStrategy strategy, Individual x, Role r, int minGuess, int maxGuess, DependencySet ds) {
        super(abox, strategy, x, ds, maxGuess - minGuess + 1);
        this.r = r;
        this.minGuess = minGuess;
    }

    public IndividualBranch copyTo(ABox abox) {
        Individual x = abox.getIndividual((ATerm)this.ind.getName());
        GuessBranch b = new GuessBranch(abox, null, x, this.r, this.minGuess, this.minGuess + this.getTryCount() - 1, this.getTermDepends());
        b.setAnonCount(this.getAnonCount());
        b.setNodeCount(this.nodeCount);
        b.setBranch(this.branch);
        b.setStrategy(this.strategy);
        b.setTryNext(this.tryNext);
        return b;
    }

    protected void tryBranch() {
        this.abox.incrementBranch();
        DependencySet ds = this.getTermDepends();
        while (this.getTryNext() < this.getTryCount()) {
            DependencySet clashDepends;
            int n = this.minGuess + this.getTryCount() - this.getTryNext() - 1;
            if (log.isLoggable(Level.FINE)) {
                log.fine("GUES: (" + (this.getTryNext() + 1) + "/" + this.getTryCount() + ") at branch (" + this.getBranch() + ") to  " + this.ind + " -> " + this.r + " -> anon" + (n == 1 ? "" : this.abox.getAnonCount() + 1 + " - anon") + (this.abox.getAnonCount() + n) + " " + ds);
            }
            ds = ds.union(new DependencySet(this.getBranch()), this.abox.doExplanation());
            this.strategy.addType(this.ind, ATermUtils.makeNormalizedMax(this.r.getName(), n, ATermUtils.TOP), ds);
            Individual[] y = new Individual[n];
            for (int c1 = 0; c1 < n; ++c1) {
                y[c1] = this.strategy.createFreshIndividual(null);
                this.strategy.addEdge(this.ind, this.r, y[c1], ds);
                for (int c2 = 0; c2 < c1; ++c2) {
                    y[c1].setDifferent(y[c2], ds);
                }
            }
            this.strategy.addType(this.ind, ATermUtils.makeMin((ATerm)this.r.getName(), n, (ATerm)ATermUtils.TOP), ds);
            boolean earlyClash = this.abox.isClosed();
            if (earlyClash) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("CLASH: Branch " + this.getBranch() + " " + this.abox.getClash() + "!");
                }
                if (!(clashDepends = this.abox.getClash().getDepends()).contains(this.getBranch())) {
                    return;
                }
            } else {
                return;
            }
            this.strategy.restore(this);
            this.abox.incrementBranch();
            this.setLastClash(clashDepends);
            ++this.tryNext;
        }
        ds = this.getCombinedClash();
        if (!PelletOptions.USE_INCREMENTAL_DELETION) {
            ds.remove(this.getBranch());
        }
        this.abox.setClash(Clash.unexplained(this.ind, ds));
    }

    public String toString() {
        if (this.getTryNext() < this.getTryCount()) {
            return "Branch " + this.getBranch() + " guess rule on " + this.ind + " for role  " + this.r;
        }
        return "Branch " + this.getBranch() + " guess rule on " + this.ind + " for role  " + this.r + " exhausted merge possibilities";
    }

    public void shiftTryNext(int openIndex) {
    }
}

