/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.branch;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.logging.Level;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.tableau.branch.Branch;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;

public class LiteralValueBranch
extends Branch {
    private Literal node;
    private int shuffle;
    private Datatype datatype;

    public LiteralValueBranch(ABox abox, CompletionStrategy strategy, Literal lit, Datatype datatype) {
        super(abox, strategy, DependencySet.INDEPENDENT, datatype.size() == -1 ? Integer.MAX_VALUE : datatype.size());
        this.node = lit;
        this.shuffle = abox.getBranch();
        this.datatype = datatype;
    }

    public Branch copyTo(ABox abox) {
        Literal x = abox.getLiteral((ATerm)this.node.getName());
        LiteralValueBranch b = new LiteralValueBranch(abox, null, x, this.datatype);
        b.shuffle = this.shuffle;
        b.setAnonCount(this.getAnonCount());
        b.setNodeCount(this.nodeCount);
        b.setBranch(this.branch);
        b.setStrategy(this.strategy);
        b.setTryNext(this.tryNext);
        return b;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void tryBranch() {
        this.abox.incrementBranch();
        DependencySet ds = this.getTermDepends();
        while (this.getTryNext() < this.getTryCount()) {
            DependencySet clashDepends;
            int tryIndex = (this.getTryNext() + this.shuffle) % this.getTryCount();
            if (log.isLoggable(Level.FINE)) {
                log.fine("LIT : (" + (this.getTryNext() + 1) + "/" + this.getTryCount() + ") at branch (" + this.getBranch() + ") " + " for literal " + this.node);
            }
            ATermAppl value = this.datatype.getValue(tryIndex);
            if (log.isLoggable(Level.FINE)) {
                log.fine("LITM: (" + this.node + " merge " + value + " " + ds);
            }
            ds = ds.union(new DependencySet(this.getBranch()), this.abox.doExplanation());
            ds = ds.union(this.getCombinedClash(), this.abox.doExplanation());
            Literal y = this.node;
            Node z = this.abox.getNode((ATerm)value);
            if (z == null) {
                z = this.abox.addLiteral(value);
            }
            this.strategy.mergeTo(y, z, ds);
            boolean earlyClash = this.abox.isClosed();
            if (!earlyClash) return;
            if (log.isLoggable(Level.FINE)) {
                log.fine("CLASH: Branch " + this.getBranch() + " " + this.abox.getClash() + "!");
            }
            if (!(clashDepends = this.abox.getClash().getDepends()).contains(this.getBranch())) return;
            if (PelletOptions.USE_COMPLETION_QUEUE) {
                this.abox.getCompletionQueue().setAllowLiterals(false);
            }
            this.strategy.restore(this);
            this.abox.incrementBranch();
            this.setLastClash(clashDepends);
            ++this.tryNext;
        }
        ds = this.getCombinedClash();
        if (!PelletOptions.USE_INCREMENTAL_DELETION) {
            ds.remove(this.getBranch());
        }
        this.abox.setClash(Clash.unexplained(this.node, ds));
    }

    public String toString() {
        if (this.getTryNext() < this.getTryCount()) {
            return "Branch " + this.getBranch() + " literal rule on " + this.node + " datatype  " + this.datatype.getName();
        }
        return "Branch " + this.getBranch() + " literal rule on " + this.node + " exhausted merge possibilities";
    }

    public void shiftTryNext(int openIndex) {
        this.setTryNext(this.getTryNext() - 1);
    }

    public Node getNode() {
        return this.node;
    }
}

