/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.incremental;

import aterm.ATermAppl;
import java.util.HashSet;
import java.util.Set;
import org.mindswap.pellet.DefaultEdge;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.tableau.branch.Branch;
import org.mindswap.pellet.tableau.completion.incremental.BranchAddDependency;
import org.mindswap.pellet.tableau.completion.incremental.BranchDependency;
import org.mindswap.pellet.tableau.completion.incremental.ClashDependency;
import org.mindswap.pellet.tableau.completion.incremental.CloseBranchDependency;
import org.mindswap.pellet.tableau.completion.incremental.MergeDependency;
import org.mindswap.pellet.tableau.completion.incremental.TypeDependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyEntry {
    private Set<TypeDependency> types = new HashSet<TypeDependency>();
    private Set<MergeDependency> merges;
    private Set<Edge> edges = new HashSet<Edge>();
    private Set<BranchAddDependency> branchAdds;
    private Set<CloseBranchDependency> branchCloses;
    private ClashDependency clash = null;

    public DependencyEntry() {
        this.merges = new HashSet<MergeDependency>();
        this.branchAdds = new HashSet<BranchAddDependency>();
        this.branchCloses = new HashSet<CloseBranchDependency>();
    }

    public DependencyEntry copy() {
        DependencyEntry newEntry = new DependencyEntry();
        newEntry.types = new HashSet<TypeDependency>(this.types);
        newEntry.merges = new HashSet<MergeDependency>(this.merges);
        for (Edge next : this.edges) {
            DefaultEdge newEdge = new DefaultEdge(next.getRole(), next.getFrom(), next.getTo(), next.getDepends());
            newEntry.edges.add(newEdge);
        }
        newEntry.branchAdds = new HashSet<BranchAddDependency>(this.branchAdds);
        newEntry.branchCloses = new HashSet<CloseBranchDependency>(this.branchCloses);
        newEntry.clash = this.clash;
        return newEntry;
    }

    protected void addTypeDependency(ATermAppl ind, ATermAppl type) {
        this.types.add(new TypeDependency(ind, type));
    }

    protected void addEdgeDependency(Edge edge) {
        this.edges.add(edge);
    }

    protected void addMergeDependency(ATermAppl ind, ATermAppl mergedTo) {
        this.merges.add(new MergeDependency(ind, mergedTo));
    }

    protected BranchDependency addBranchAddDependency(ATermAppl assertion, int branchId, Branch branch) {
        BranchAddDependency b = new BranchAddDependency(assertion, branchId, branch);
        this.branchAdds.add(b);
        return b;
    }

    protected BranchDependency addCloseBranchDependency(ATermAppl assertion, Branch theBranch) {
        CloseBranchDependency b = new CloseBranchDependency(assertion, theBranch.getTryNext(), theBranch);
        if (this.branchCloses.contains(b)) {
            this.branchCloses.remove(b);
        }
        this.branchCloses.add(b);
        return b;
    }

    public void print() {
        System.out.println("  Edge Dependencies:");
        for (Edge e : this.edges) {
            System.out.println("    " + e.toString());
        }
        System.out.println("  Type Dependencies:");
        for (TypeDependency t : this.types) {
            System.out.println("    " + t.toString());
        }
        System.out.println("  Merge Dependencies:");
        for (MergeDependency m : this.merges) {
            System.out.println("    " + m.toString());
        }
    }

    public Set<Edge> getEdges() {
        return this.edges;
    }

    public Set<MergeDependency> getMerges() {
        return this.merges;
    }

    public Set<TypeDependency> getTypes() {
        return this.types;
    }

    public Set<BranchAddDependency> getBranchAdds() {
        return this.branchAdds;
    }

    public Set<CloseBranchDependency> getCloseBranches() {
        return this.branchCloses;
    }

    public ClashDependency getClash() {
        return this.clash;
    }

    protected void setClash(ClashDependency clash) {
        this.clash = clash;
    }
}

