/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tbox.impl;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.tbox.impl.TBoxBase;
import org.mindswap.pellet.tbox.impl.TBoxExpImpl;
import org.mindswap.pellet.tbox.impl.TermDefinition;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TgBox
extends TBoxBase {
    public static Logger log = Logger.getLogger(TgBox.class.getName());
    private Set<ATermAppl> explanation;
    private List<Pair<ATermAppl, DependencySet>> UC = null;

    public TgBox(TBoxExpImpl tbox) {
        super(tbox);
    }

    public void internalize() {
        this.UC = new ArrayList<Pair<ATermAppl, DependencySet>>();
        for (TermDefinition termDef : this.termhash.values()) {
            ATermAppl notC1;
            ATermAppl c2;
            ATermAppl c1;
            for (ATermAppl subClassAxiom : termDef.getSubClassAxioms()) {
                c1 = (ATermAppl)subClassAxiom.getArgument(0);
                c2 = (ATermAppl)subClassAxiom.getArgument(1);
                notC1 = ATermUtils.makeNot((ATerm)c1);
                ATermAppl notC1orC2 = ATermUtils.makeOr(notC1, c2);
                ATermAppl norm = ATermUtils.normalize(notC1orC2);
                Set<Object> explanation = PelletOptions.USE_TRACING ? this.tbox.getAxiomExplanation(subClassAxiom) : Collections.emptySet();
                this.UC.add(Pair.create(norm, new DependencySet(explanation)));
            }
            for (ATermAppl eqClassAxiom : termDef.getEqClassAxioms()) {
                c1 = (ATermAppl)eqClassAxiom.getArgument(0);
                c2 = (ATermAppl)eqClassAxiom.getArgument(1);
                notC1 = ATermUtils.makeNot((ATerm)c1);
                ATermAppl notC2 = ATermUtils.makeNot((ATerm)c2);
                ATermAppl notC1orC2 = ATermUtils.makeOr(notC1, c2);
                ATermAppl notC2orC1 = ATermUtils.makeOr(notC2, c1);
                Set<Object> explanation = PelletOptions.USE_TRACING ? this.tbox.getAxiomExplanation(eqClassAxiom) : Collections.emptySet();
                this.UC.add(Pair.create(ATermUtils.normalize(notC1orC2), new DependencySet(explanation)));
                this.UC.add(Pair.create(ATermUtils.normalize(notC2orC1), new DependencySet(explanation)));
            }
        }
    }

    public void absorb() {
        log.fine("Absorption started");
        if (log.isLoggable(Level.FINE)) {
            log.fine("Tg.size was " + this.termhash.size() + " Tu.size was " + this.tbox.Tu.size());
        }
        Collection terms = this.termhash.values();
        this.termhash = new HashMap();
        for (TermDefinition def : terms) {
            ATermAppl c2;
            ATermAppl c1;
            this.kb.timers.checkTimer("preprocessing");
            for (ATermAppl subClassAxiom : def.getSubClassAxioms()) {
                c1 = (ATermAppl)subClassAxiom.getArgument(0);
                c2 = (ATermAppl)subClassAxiom.getArgument(1);
                this.absorbSubClass(c1, c2, this.tbox.getAxiomExplanation(subClassAxiom));
            }
            for (ATermAppl eqClassAxiom : def.getEqClassAxioms()) {
                c1 = (ATermAppl)eqClassAxiom.getArgument(0);
                c2 = (ATermAppl)eqClassAxiom.getArgument(1);
                this.absorbSubClass(c1, c2, this.tbox.getAxiomExplanation(eqClassAxiom));
                this.absorbSubClass(c2, c1, this.tbox.getAxiomExplanation(eqClassAxiom));
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Tg.size is " + this.termhash.size() + " Tu.size is " + this.tbox.Tu.size());
        }
        log.fine("Absorption finished");
    }

    private void absorbSubClass(ATermAppl sub, ATermAppl sup, Set<ATermAppl> axiomExplanation) {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        set.add(ATermUtils.nnf(sub));
        set.add(ATermUtils.nnf(ATermUtils.makeNot((ATerm)sup)));
        this.explanation = new HashSet<ATermAppl>();
        this.explanation.addAll(axiomExplanation);
        this.absorbTerm(set);
    }

    private boolean absorbTerm(Set<ATermAppl> set) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Absorbing term " + set);
        }
        while (true) {
            log.finer("Absorb nominal");
            if (!PelletOptions.USE_PSEUDO_NOMINALS && (PelletOptions.USE_NOMINAL_ABSORPTION || PelletOptions.USE_HASVALUE_ABSORPTION) && this.absorbNominal(set)) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Absorbed w/ Nominal: " + set);
                }
                return true;
            }
            log.finer("Absorb II");
            if (this.absorbII(set)) {
                log.finer("Absorbed");
                return true;
            }
            log.finer("Absorb III");
            if (this.absorbIII(set)) {
                log.finer("Absorb III");
                continue;
            }
            log.finer("Absorb V");
            if (!this.absorbV(set)) break;
            log.finer("Absorb V");
        }
        log.finer("Absorb VI");
        if (this.absorbVI(set)) {
            log.finer("Recursed on OR");
            return true;
        }
        log.finer("Absorb role");
        if (PelletOptions.USE_ROLE_ABSORPTION && this.absorbRole(set)) {
            log.finer("Absorbed w/ Role");
            return true;
        }
        log.finer("Absorb VII");
        this.absorbVII(set);
        log.finer("Finished absorbTerm");
        return false;
    }

    private boolean absorbNominal(Set<ATermAppl> set) {
        Iterator<ATermAppl> i = set.iterator();
        while (i.hasNext()) {
            ATermAppl p;
            ATermAppl name = i.next();
            if (PelletOptions.USE_NOMINAL_ABSORPTION && (ATermUtils.isOneOf(name) || ATermUtils.isNominal(name))) {
                i.remove();
                ATermList list = null;
                list = ATermUtils.isNominal(name) ? ATermUtils.makeList((ATerm)name) : (ATermList)name.getArgument(0);
                ATermAppl c = ATermUtils.makeNot((ATerm)ATermUtils.makeAnd(ATermUtils.makeList(set)));
                this.absorbOneOf(list, c, this.explanation);
                return true;
            }
            if (!PelletOptions.USE_HASVALUE_ABSORPTION || !ATermUtils.isHasValue(name) || !this.kb.isObjectProperty((ATerm)(p = (ATermAppl)name.getArgument(0)))) continue;
            i.remove();
            ATermAppl c = ATermUtils.makeNot((ATerm)ATermUtils.makeAnd(ATermUtils.makeList(set)));
            ATermAppl nominal = (ATermAppl)name.getArgument(1);
            ATermAppl ind = (ATermAppl)nominal.getArgument(0);
            ATermAppl invP = this.kb.getProperty((ATerm)p).getInverse().getName();
            ATermAppl allInvPC = ATermUtils.makeAllValues((ATerm)invP, (ATerm)c);
            if (log.isLoggable(Level.FINER)) {
                log.finer("Absorb into " + ind + " with inverse of " + p + " for " + c);
            }
            this.kb.addIndividual(ind);
            this.kb.addType(ind, allInvPC, new DependencySet(this.explanation));
            return true;
        }
        return false;
    }

    void absorbOneOf(ATermAppl oneOf, ATermAppl c, Set<ATermAppl> explain) {
        this.absorbOneOf((ATermList)oneOf.getArgument(0), c, explain);
    }

    private void absorbOneOf(ATermList list, ATermAppl c, Set<ATermAppl> explain) {
        if (PelletOptions.USE_PSEUDO_NOMINALS) {
            if (log.isLoggable(Level.WARNING)) {
                log.warning("Ignoring axiom involving nominals: " + explain);
            }
            return;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Absorb into " + list + " nominals (enumeration) " + c);
        }
        this.tbox.getAbsorbedAxioms().addAll(explain);
        DependencySet ds = new DependencySet(explain);
        while (!list.isEmpty()) {
            ATermAppl nominal = (ATermAppl)list.getFirst();
            ATermAppl ind = (ATermAppl)nominal.getArgument(0);
            this.kb.addIndividual(ind);
            this.kb.addType(ind, c, ds);
            list = list.getNext();
        }
    }

    private boolean absorbRole(Set<ATermAppl> set) {
        Iterator<ATermAppl> i = set.iterator();
        while (i.hasNext()) {
            int n;
            ATerm r;
            ATermAppl name = i.next();
            if (ATermUtils.isSomeValues(name)) {
                r = name.getArgument(0);
                if (this.kb.getRole(r).hasComplexSubRole()) continue;
                ATermAppl domain = ATermUtils.makeNot((ATerm)ATermUtils.makeAnd(ATermUtils.makeList(set)));
                this.kb.addDomain(r, domain, new DependencySet(this.explanation));
                this.tbox.getAbsorbedAxioms().addAll(this.explanation);
                return true;
            }
            if (!ATermUtils.isMin(name) || this.kb.getRole(r = name.getArgument(0)).hasComplexSubRole() || (n = ((ATermInt)name.getArgument(1)).getInt()) != 1) continue;
            i.remove();
            ATermAppl domain = ATermUtils.makeNot((ATerm)ATermUtils.makeAnd(ATermUtils.makeList(set)));
            this.kb.addDomain(r, domain, new DependencySet(this.explanation));
            this.tbox.getAbsorbedAxioms().addAll(this.explanation);
            return true;
        }
        return false;
    }

    private boolean absorbII(Set<ATermAppl> set) {
        for (ATermAppl term : set) {
            boolean canAbsorb;
            TermDefinition td = this.tbox.Tu.getTD((ATerm)term);
            if (td != null) {
                canAbsorb = td.getEqClassAxioms().isEmpty();
            } else {
                boolean bl = canAbsorb = term.getArity() == 0 && set.size() > 1;
            }
            if (!canAbsorb) continue;
            set.remove(term);
            ATermList setlist = ATermUtils.makeList(set);
            ATermAppl conjunct = ATermUtils.makeAnd(setlist);
            conjunct = ATermUtils.makeNot((ATerm)conjunct);
            ATermAppl sub = ATermUtils.makeSub((ATerm)term, (ATerm)ATermUtils.nnf(conjunct));
            this.tbox.Tu.addDef(sub);
            this.tbox.addAxiomExplanation(sub, this.explanation);
            return true;
        }
        return false;
    }

    private boolean absorbIII(Set<ATermAppl> set) {
        for (ATermAppl term : set) {
            List<ATermAppl> eqClassAxioms;
            ATermAppl negatedTerm = null;
            TermDefinition td = this.tbox.Tu.getTD((ATerm)term);
            if (td == null && ATermUtils.isNegatedPrimitive(term)) {
                negatedTerm = (ATermAppl)term.getArgument(0);
                td = this.tbox.Tu.getTD((ATerm)negatedTerm);
            }
            if (td == null || (eqClassAxioms = td.getEqClassAxioms()).isEmpty()) continue;
            ATermAppl eqClassAxiom = eqClassAxioms.get(0);
            ATermAppl eqClass = (ATermAppl)eqClassAxiom.getArgument(1);
            set.remove(term);
            if (negatedTerm == null) {
                set.add(eqClass);
            } else {
                set.add(ATermUtils.negate(eqClass));
            }
            this.explanation.addAll(this.tbox.getAxiomExplanation(eqClassAxiom));
            return true;
        }
        return false;
    }

    private boolean absorbV(Set<ATermAppl> set) {
        for (ATermAppl term : set) {
            ATermAppl nnfterm = ATermUtils.nnf(term);
            if (!nnfterm.getAFun().equals(ATermUtils.ANDFUN)) continue;
            set.remove(term);
            ATermList andlist = (ATermList)nnfterm.getArgument(0);
            while (!andlist.isEmpty()) {
                set.add((ATermAppl)andlist.getFirst());
                andlist = andlist.getNext();
            }
            return true;
        }
        return false;
    }

    private boolean absorbVI(Set<ATermAppl> set) {
        for (ATermAppl term : set) {
            ATermAppl nnfterm = ATermUtils.nnf(term);
            if (!nnfterm.getAFun().equals(ATermUtils.ORFUN)) continue;
            set.remove(term);
            ATermList orlist = (ATermList)nnfterm.getArgument(0);
            while (!orlist.isEmpty()) {
                HashSet<ATermAppl> cloned = new HashSet<ATermAppl>(set);
                cloned.add((ATermAppl)orlist.getFirst());
                this.absorbTerm(cloned);
                orlist = orlist.getNext();
            }
            return true;
        }
        return false;
    }

    private boolean absorbVII(Set<ATermAppl> set) {
        ATermList list = ATermUtils.makeList(set);
        ATermAppl sub = ATermUtils.nnf((ATermAppl)list.getFirst());
        ATermAppl sup = (list = list.getNext()).isEmpty() ? ATermUtils.makeNot((ATerm)sub) : ATermUtils.makeNot((ATerm)ATermUtils.makeAnd(list));
        sup = ATermUtils.nnf(sup);
        ATermAppl subClassAxiom = ATermUtils.makeSub((ATerm)sub, (ATerm)sup);
        if (log.isLoggable(Level.FINE)) {
            log.fine("GCI: " + subClassAxiom + "\nexplanation: " + this.explanation);
        }
        this.addDef(subClassAxiom);
        this.tbox.addAxiomExplanation(subClassAxiom, this.explanation);
        return true;
    }

    public List<Pair<ATermAppl, DependencySet>> getUC() {
        return this.UC;
    }

    @Override
    public int size() {
        return this.UC == null ? 0 : this.UC.size();
    }

    public void print(Appendable out) {
        try {
            out.append("Tg: [\n");
            if (this.UC != null) {
                for (Pair<ATermAppl, DependencySet> pair : this.UC) {
                    out.append(ATermUtils.toString((ATermAppl)pair.first));
                    out.append(", ");
                }
                out.append("\n");
            }
            out.append("]");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void print() {
        this.print(System.out);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.print(sb);
        return sb.toString();
    }
}

