/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.GraphWithPerform;
import com.hp.hpl.jena.util.IteratorCollection;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SimpleBulkUpdateHandler
implements BulkUpdateHandler {
    protected GraphWithPerform graph;
    protected GraphEventManager manager;

    public SimpleBulkUpdateHandler(GraphWithPerform graphWithPerform) {
        this.graph = graphWithPerform;
        this.manager = graphWithPerform.getEventManager();
    }

    public void add(Triple[] tripleArray) {
        for (int i = 0; i < tripleArray.length; ++i) {
            this.graph.performAdd(tripleArray[i]);
        }
        this.manager.notifyAddArray(this.graph, tripleArray);
    }

    public void add(List list) {
        this.add(list, true);
    }

    protected void add(List list, boolean bl) {
        for (int i = 0; i < list.size(); ++i) {
            this.graph.performAdd((Triple)list.get(i));
        }
        if (bl) {
            this.manager.notifyAddList(this.graph, list);
        }
    }

    public void add(Iterator iterator) {
        this.addIterator(iterator, true);
    }

    public void addIterator(Iterator iterator, boolean bl) {
        List list = IteratorCollection.iteratorToList(iterator);
        this.add(list, false);
        if (bl) {
            this.manager.notifyAddIterator((Graph)this.graph, list);
        }
    }

    public void add(Graph graph) {
        this.add(graph, false);
    }

    public void add(Graph graph, boolean bl) {
        this.addIterator(GraphUtil.findAll(graph), false);
        if (bl) {
            SimpleBulkUpdateHandler.addReifications(this.graph, graph);
        }
        this.manager.notifyAddGraph(this.graph, graph);
    }

    public static void addReifications(Graph graph, Graph graph2) {
        Reifier reifier = graph2.getReifier();
        ExtendedIterator extendedIterator = reifier.allNodes();
        while (extendedIterator.hasNext()) {
            Node node = (Node)extendedIterator.next();
            graph.getReifier().reifyAs(node, reifier.getTriple(node));
        }
    }

    public static void deleteReifications(Graph graph, Graph graph2) {
        Reifier reifier = graph2.getReifier();
        ExtendedIterator extendedIterator = reifier.allNodes();
        while (extendedIterator.hasNext()) {
            Node node = (Node)extendedIterator.next();
            graph.getReifier().remove(node, reifier.getTriple(node));
        }
    }

    public void delete(Triple[] tripleArray) {
        for (int i = 0; i < tripleArray.length; ++i) {
            this.graph.performDelete(tripleArray[i]);
        }
        this.manager.notifyDeleteArray(this.graph, tripleArray);
    }

    public void delete(List list) {
        this.delete(list, true);
    }

    protected void delete(List list, boolean bl) {
        for (int i = 0; i < list.size(); ++i) {
            this.graph.performDelete((Triple)list.get(i));
        }
        if (bl) {
            this.manager.notifyDeleteList(this.graph, list);
        }
    }

    public void delete(Iterator iterator) {
        this.deleteIterator(iterator, true);
    }

    public void deleteIterator(Iterator iterator, boolean bl) {
        List list = IteratorCollection.iteratorToList(iterator);
        this.delete(list, false);
        if (bl) {
            this.manager.notifyDeleteIterator((Graph)this.graph, list);
        }
    }

    private List triplesOf(Graph graph) {
        ArrayList arrayList = new ArrayList();
        ExtendedIterator extendedIterator = graph.find(Triple.ANY);
        while (extendedIterator.hasNext()) {
            arrayList.add(extendedIterator.next());
        }
        return arrayList;
    }

    public void delete(Graph graph) {
        this.delete(graph, false);
    }

    public void delete(Graph graph, boolean bl) {
        if (graph.dependsOn(this.graph)) {
            this.delete(this.triplesOf(graph));
        } else {
            this.deleteIterator(GraphUtil.findAll(graph), false);
        }
        if (bl) {
            SimpleBulkUpdateHandler.deleteReifications(this.graph, graph);
        }
        this.manager.notifyDeleteGraph(this.graph, graph);
    }

    public void removeAll() {
        SimpleBulkUpdateHandler.removeAll(this.graph);
        this.notifyRemoveAll();
    }

    protected void notifyRemoveAll() {
        this.manager.notifyEvent(this.graph, GraphEvents.removeAll);
    }

    public void remove(Node node, Node node2, Node node3) {
        SimpleBulkUpdateHandler.removeAll(this.graph, node, node2, node3);
        this.manager.notifyEvent(this.graph, GraphEvents.remove(node, node2, node3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAll(Graph graph, Node node, Node node2, Node node3) {
        ExtendedIterator extendedIterator = graph.find(node, node2, node3);
        try {
            while (extendedIterator.hasNext()) {
                extendedIterator.next();
                extendedIterator.remove();
            }
        }
        finally {
            extendedIterator.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAll(Graph graph) {
        ExtendedIterator extendedIterator = GraphUtil.findAll(graph);
        try {
            while (extendedIterator.hasNext()) {
                extendedIterator.next();
                extendedIterator.remove();
            }
        }
        finally {
            extendedIterator.close();
        }
    }
}

